<?php
/**
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 * @file
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'LintErrors' => [ 'LintErrors' ],
];

/** Azerbaijani (Azərbaycanca) */
$specialPageAliases['az'] = [
	'LintErrors' => [ 'SintaksisXətaları' ],
];

/* Čeština (Czech) */
$specialPageAliases['cs'] = [
	'LintErrors' => [ 'Chyby_nalezené_lintem' ],
];

/** Español (Spanish) */
$specialPageAliases['es'] = [
	'LintErrors' => [ 'Errores_de_sintaxis' ],
];

/** עברית (Hebrew) */
$specialPageAliases['he'] = [
	'LintErrors' => [ 'שגיאות_ניקיון' ],
];

/** 한국어 (Korean) */
$specialPageAliases['ko'] = [
	'LintErrors' => [ '린트오류' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'LintErrors' => [ 'Lint-feil' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = [
	'LintErrors' => [ 'Lint-feil' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'LintErrors' => [ 'Błędy_składniowe', 'Błędy_lintera' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = [
	'LintErrors' => [ 'Пречишћивање_грешака' ],
];

/** Serbian (Latin script) (srpski (latinica)‎) */
$specialPageAliases['sr-el'] = [
	'LintErrors' => [ 'Prečišćavanje_grešaka' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'LintErrors' => [ 'نحوی_نقائص' ],
];

/** Simplified Chinese (中文（简体）) */
$specialPageAliases['zh-hans'] = [
	'LintErrors' => [ 'Lint错误' ],
];

/** Traditional Chinese (中文（繁體）) */
$specialPageAliases['zh-hant'] = [
	'LintErrors' => [ 'Lint錯誤' ],
];
