/*
 * Decompiled with CFR 0.152.
 */
package spock.util.environment;

public class OperatingSystem {
    private final String name;
    private final String version;
    private final Family family;

    private OperatingSystem(String name, String version, Family family) {
        this.name = name;
        this.version = version;
        this.family = family;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Family getFamily() {
        return this.family;
    }

    public boolean isLinux() {
        return this.family == Family.LINUX;
    }

    public boolean isMacOs() {
        return this.family == Family.MAC_OS;
    }

    public boolean isWindows() {
        return this.family == Family.WINDOWS;
    }

    public boolean isSolaris() {
        return this.family == Family.SOLARIS;
    }

    public boolean isOther() {
        return this.family == Family.OTHER;
    }

    public static OperatingSystem getCurrent() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String lowerName = name.toLowerCase();
        if (lowerName.contains("linux")) {
            return new OperatingSystem(name, version, Family.LINUX);
        }
        if (lowerName.contains("mac os") || lowerName.contains("darwin")) {
            return new OperatingSystem(name, version, Family.MAC_OS);
        }
        if (lowerName.contains("windows")) {
            return new OperatingSystem(name, version, Family.WINDOWS);
        }
        if (lowerName.contains("sunos")) {
            return new OperatingSystem(name, version, Family.SOLARIS);
        }
        return new OperatingSystem(name, version, Family.OTHER);
    }

    public static enum Family {
        LINUX,
        MAC_OS,
        WINDOWS,
        SOLARIS,
        OTHER;

    }
}

