/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.report.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Map;
import org.spockframework.report.log.IReportLogListener;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.util.IStoppable;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.IoUtil;
import org.spockframework.util.JsonWriter;

public class ReportLogClient
implements IReportLogListener,
IStoppable {
    private final String reportServerAddress;
    private final int reportServerPort;
    private Socket socket;

    public ReportLogClient(String reportServerAddress, int reportServerPort) {
        this.reportServerAddress = reportServerAddress;
        this.reportServerPort = reportServerPort;
    }

    public void start() {
        try {
            this.socket = new Socket(this.reportServerAddress, this.reportServerPort);
        }
        catch (IOException e) {
            throw new ExtensionException(String.format("Error opening connection to report server. Server address: %s Server port: %d", this.reportServerAddress, this.reportServerPort), e);
        }
    }

    @Override
    public void stop() {
        IoUtil.closeQuietly(this.socket);
    }

    @Override
    public void emitted(Map<String, Object> log) {
        if (this.socket == null) {
            return;
        }
        ByteArrayOutputStream messageBuffer = new ByteArrayOutputStream(1024);
        OutputStreamWriter messageWriter = null;
        try {
            messageWriter = new OutputStreamWriter((OutputStream)messageBuffer, "utf-8");
            JsonWriter jsonWriter = new JsonWriter(messageWriter);
            jsonWriter.write(log);
            messageWriter.write("\n");
        }
        catch (IOException e) {
            try {
                throw new InternalSpockError(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(messageWriter);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(messageWriter);
        ByteArrayOutputStream sizeBuffer = new ByteArrayOutputStream();
        OutputStreamWriter sizeWriter = null;
        try {
            sizeWriter = new OutputStreamWriter((OutputStream)sizeBuffer, "utf-8");
            sizeWriter.write(String.valueOf(messageBuffer.size()));
            sizeWriter.write("\n");
        }
        catch (IOException e) {
            try {
                throw new InternalSpockError(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(sizeWriter);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(sizeWriter);
        try {
            this.socket.getOutputStream().write(sizeBuffer.toByteArray());
            this.socket.getOutputStream().write(messageBuffer.toByteArray());
            this.socket.getOutputStream().flush();
        }
        catch (Exception e) {
            IoUtil.closeQuietly(this.socket);
            this.socket = null;
            throw new ExtensionException("Error sending data to report server. Server address: $reportServerAddress Server port: $reportServerPort", e);
        }
    }
}

