/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.ISpecialMethodCall;
import org.spockframework.compiler.NoSpecialMethodCall;
import org.spockframework.compiler.SpecialMethodCall;
import org.spockframework.compiler.StatementReplacingVisitorSupport;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.ThenBlock;

public class AbstractDeepBlockRewriter
extends StatementReplacingVisitorSupport {
    protected Block block;
    protected Statement currTopLevelStat;
    protected ExpressionStatement currExprStat;
    protected BinaryExpression currBinaryExpr;
    protected MethodCallExpression currMethodCallExpr;
    protected ClosureExpression currClosure;
    protected ISpecialMethodCall currSpecialMethodCall = NoSpecialMethodCall.INSTANCE;
    protected Statement lastSpecialMethodCallStat;
    protected boolean conditionFound;
    protected boolean interactionFound;
    protected MethodCallExpression foundExceptionCondition;
    protected final List<Statement> thenBlockInteractionStats = new ArrayList<Statement>();

    public AbstractDeepBlockRewriter(Block block) {
        this.block = block;
    }

    public boolean isConditionFound() {
        return this.conditionFound;
    }

    public boolean isExceptionConditionFound() {
        return this.foundExceptionCondition != null;
    }

    public List<Statement> getThenBlockInteractionStats() {
        return this.thenBlockInteractionStats;
    }

    public MethodCallExpression getFoundExceptionCondition() {
        return this.foundExceptionCondition;
    }

    public void visit(Block block) {
        this.block = block;
        ListIterator<Statement> iterator = ((List)block.getAst()).listIterator();
        while (iterator.hasNext()) {
            Statement next;
            this.currTopLevelStat = next = (Statement)iterator.next();
            Statement replaced = this.replace(next);
            if (this.interactionFound && block instanceof ThenBlock) {
                iterator.remove();
                this.thenBlockInteractionStats.add(replaced);
                this.interactionFound = false;
                continue;
            }
            iterator.set(replaced);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitExpressionStatement(ExpressionStatement stat) {
        ExpressionStatement oldExpressionStatement = this.currExprStat;
        this.currExprStat = stat;
        try {
            this.doVisitExpressionStatement(stat);
        }
        finally {
            this.currExprStat = oldExpressionStatement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitBinaryExpression(BinaryExpression expr) {
        BinaryExpression oldBinaryExpression = this.currBinaryExpr;
        this.currBinaryExpr = expr;
        try {
            this.doVisitBinaryExpression(expr);
        }
        finally {
            this.currBinaryExpr = oldBinaryExpression;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitMethodCallExpression(MethodCallExpression expr) {
        MethodCallExpression oldMethodCallExpr = this.currMethodCallExpr;
        this.currMethodCallExpr = expr;
        ISpecialMethodCall oldSpecialMethodCall = this.currSpecialMethodCall;
        SpecialMethodCall newSpecialMethodCall = SpecialMethodCall.parse(this.currMethodCallExpr, this.currBinaryExpr);
        if (newSpecialMethodCall != null) {
            this.currSpecialMethodCall = newSpecialMethodCall;
            if (newSpecialMethodCall.isMatch((Statement)this.currExprStat)) {
                this.lastSpecialMethodCallStat = this.currExprStat;
            }
        }
        try {
            this.doVisitMethodCallExpression(expr);
        }
        finally {
            this.currMethodCallExpr = oldMethodCallExpr;
            this.currSpecialMethodCall = oldSpecialMethodCall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void visitClosureExpression(ClosureExpression expr) {
        ClosureExpression oldClosure = this.currClosure;
        this.currClosure = expr;
        boolean oldConditionFound = this.conditionFound;
        this.conditionFound = false;
        ISpecialMethodCall oldSpecialMethodCall = this.currSpecialMethodCall;
        if (!this.currSpecialMethodCall.isMatch(expr)) {
            this.currSpecialMethodCall = NoSpecialMethodCall.INSTANCE;
        }
        try {
            this.doVisitClosureExpression(expr);
        }
        finally {
            this.currClosure = oldClosure;
            this.conditionFound = oldConditionFound;
            this.currSpecialMethodCall = oldSpecialMethodCall;
        }
    }

    protected void doVisitExpressionStatement(ExpressionStatement stat) {
        super.visitExpressionStatement(stat);
    }

    protected void doVisitBinaryExpression(BinaryExpression expr) {
        super.visitBinaryExpression(expr);
    }

    protected void doVisitMethodCallExpression(MethodCallExpression expr) {
        super.visitMethodCallExpression(expr);
    }

    protected void doVisitClosureExpression(ClosureExpression expr) {
        super.visitClosureExpression(expr);
    }
}

