/* This file is part of OpenBubbles.
 *
 * OpenBubbles is an SDL clone of Bubbles.
 * Copyright (C) 2004  Benny Sperisen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * miscellaneous.h contains the declarations for miscellaneous things.
 *
 * Written by:
 *  Benny Sperisen
 *  lasindi@gmail.com
 *  www.freewebs.com/lasindi
 *****************************************************************************/

#ifndef MISCELLANEOUS_H
#define MISCELLANEOUS_H

#include <iostream>
#include "SDL.h"
#include <string>
#include <cmath>
#include <cstdlib>
#include <queue>
using namespace std;

#include "highscores.h"

// Settings
extern bool fadingOn;
extern bool soundOn;

/* numberToString() returns a string containing number. For example, passing 42
 * returns "42". */
const char* numberToString(int number);

// Generate random ints from 0 to max.
int random_int(int max);

// Generate random doubles from 0 to max.
double random_double(double max);

/* Saves sound and fading transition settings plus high scores to
 * ~/.openbubbles. */
void saveEverything();

// Load fading transitions and sound settings.
void loadSettings();

#endif
