/*
 * DVIlib - a library for handling DVI files
 * 
 * Copyright (c) 2000 Evgeny Stambulchik
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __DVILIB_H_
#define __DVILIB_H_

typedef unsigned char   DVI_U8;
typedef signed char     DVI_S8;

typedef unsigned int    DVI_U32;
typedef signed int      DVI_S32;

typedef struct _dvi_state {
    DVI_S32 h, v, w, x, y, z;
} dvi_state;

typedef struct _dvi_stack {
    dvi_state *states;
    int slength;
    int sp;
} dvi_stack;

typedef struct _DVI_finfo {
    DVI_S32 id;
    DVI_U32 chksum;
    DVI_U32 magsize;
    DVI_U32 dessize;
    char *area;
    char *name;
} DVI_finfo;

typedef struct _DVI {
    FILE *fp;
    
    int nfonts;
    DVI_finfo *fonts;
    
    dvi_stack *stack;

    dvi_state *state;
    DVI_S32 font_id;

    long nbread;
    long nops;
    
    DVI_U32 npages;
    DVI_U32 maxh;
    DVI_U32 maxw;

    int dvi_id;
    float resolution;
    DVI_U32 magnification;
    char *comments;

    int pre_parsed;
    int post_parsed;

    DVI_S32 post;
    DVI_S32 pbop;
    
    void *hooks;
} DVI;

DVI *DVI_new(FILE *fp);
    
void DVI_free(DVI *dvip);

void DVI_process(DVI *dvip);

DVI_finfo *DVI_get_finfo(DVI *dvip, int font_id);

typedef DVI_S32 (*DVI_write_char_hook)(DVI *dvip, int c, int advance); 
typedef void (*DVI_draw_rule_hook)(DVI *dvip, DVI_S32 a, DVI_S32 b); 

void DVI_add_hooks(DVI *dvip,
    DVI_write_char_hook write_char,
    DVI_draw_rule_hook draw_rule);
    
#endif /* __DVILIB_H_ */
