/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import net.sf.clipsrules.jni.examples.ide.CLIPSIDE;
import net.sf.clipsrules.jni.examples.ide.IDEPreferences;
import net.sf.clipsrules.jni.examples.ide.TextMenu;

public class TextFrame
extends JInternalFrame
implements DocumentListener,
CaretListener {
    private JTextArea textArea;
    private static int untitledCount = 1;
    private boolean changed = false;
    private TextUndoManager textAreaUndo;
    private File textFile;

    TextFrame(CLIPSIDE cLIPSIDE, File file, Font font) {
        super("", true, true, true, true);
        this.textFile = file;
        if (file == null) {
            this.setTitle("Untitled #" + untitledCount++);
        } else {
            this.setTitle(file.getName());
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setSize(600, 400);
        this.setMinimumSize(new Dimension(550, 250));
        this.setDefaultCloseOperation(2);
        JMenuBar jMenuBar = new JMenuBar();
        TextMenu textMenu = new TextMenu(cLIPSIDE, this);
        jMenuBar.add(textMenu);
        this.setJMenuBar(jMenuBar);
        try {
            this.textArea = new JTextArea();
            this.textAreaUndo = new TextUndoManager();
            this.textArea.setDocument(new TextUndoPlainDocument(this.textAreaUndo));
            this.textArea.setFont(font);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        this.textArea.addCaretListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setPreferredSize(new Dimension(600, 360));
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.getContentPane().add(jScrollPane);
        if (file != null) {
            this.readContent(file);
        }
        this.textArea.getDocument().addDocumentListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(88, 128);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(67, 128);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(86, 128);
        InputMap inputMap = this.textArea.getInputMap();
        inputMap.put(keyStroke, "none");
        inputMap.put(keyStroke2, "none");
        inputMap.put(keyStroke3, "none");
        this.pack();
    }

    public void assignFont(Font font) {
        this.textArea.setFont(font);
    }

    public void balanceParentheses() {
        int n = this.textArea.getSelectionStart();
        int n2 = this.textArea.getSelectionEnd();
        int n3 = Math.min(this.textArea.getCaret().getDot(), this.textArea.getCaret().getMark());
        if (n3 == 0) {
            return;
        }
        char c = this.textArea.getText().charAt(--n3);
        if (c != ')') {
            return;
        }
        int n4 = 0;
        while (n3-- != 0) {
            c = this.textArea.getText().charAt(n3);
            if (c == '(') {
                if (n4 == 0) {
                    this.textArea.getCaret().setVisible(false);
                    this.textArea.setSelectionStart(n3);
                    this.textArea.setSelectionEnd(n3 + 1);
                    this.textArea.update(this.textArea.getGraphics());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.textArea.setSelectionStart(n);
                    this.textArea.setSelectionEnd(n2);
                    this.textArea.getCaret().setVisible(true);
                    return;
                }
                --n4;
                continue;
            }
            if (c != ')') continue;
            ++n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readContent(File file) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            this.textArea.read(fileReader, null);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.getParent(), iOException.getMessage(), "ERROR", 0);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(File file) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            this.textArea.write(bufferedWriter);
            this.changed = false;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.getParent(), iOException.getMessage(), "ERROR", 0);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void closeTextFrame(IDEPreferences iDEPreferences) {
        if (!this.changed) {
            this.setDefaultCloseOperation(2);
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, "Do you want to save the changes made to the document \"" + this.getTitle() + "\"?", null, 1);
        if (n == 0) {
            this.saveTextFrame(iDEPreferences);
            this.setDefaultCloseOperation(2);
        } else if (n == 1) {
            this.setDefaultCloseOperation(2);
        } else if (n == 2) {
            this.setDefaultCloseOperation(0);
        } else if (n == -1) {
            this.setDefaultCloseOperation(0);
        }
    }

    public void saveAsTextFrame(IDEPreferences iDEPreferences) {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        File file = iDEPreferences.getCurrentDirectory();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (this.textFile != null) {
            jFileChooser.setSelectedFile(this.textFile);
        } else {
            jFileChooser.setSelectedFile(new File(this.getTitle() + ".clp"));
        }
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 != 0) {
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        if (file2 == null) {
            return;
        }
        if (file2.exists() && (n = JOptionPane.showConfirmDialog(this, "Replace existing file?")) != 0) {
            return;
        }
        this.setTitle(file2.getName());
        file = jFileChooser.getCurrentDirectory();
        iDEPreferences.setCurrentDirectory(file);
        this.textFile = file2;
        this.writeContent(this.textFile);
    }

    public void saveTextFrame(IDEPreferences iDEPreferences) {
        if (this.textFile == null) {
            this.saveAsTextFrame(iDEPreferences);
            return;
        }
        this.writeContent(this.textFile);
    }

    public boolean hasSelection() {
        int n;
        int n2 = Math.min(this.textArea.getCaret().getDot(), this.textArea.getCaret().getMark());
        return n2 != (n = Math.max(this.textArea.getCaret().getDot(), this.textArea.getCaret().getMark()));
    }

    public boolean canUndo() {
        return this.textAreaUndo.canUndo();
    }

    public boolean canRedo() {
        return this.textAreaUndo.canRedo();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean canSave() {
        if (this.textFile == null) {
            return true;
        }
        return this.changed;
    }

    public void undo() {
        if (!this.textAreaUndo.canUndo()) {
            return;
        }
        try {
            this.textAreaUndo.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            cannotUndoException.printStackTrace();
        }
    }

    public void redo() {
        if (!this.textAreaUndo.canRedo()) {
            return;
        }
        try {
            this.textAreaUndo.redo();
        }
        catch (CannotUndoException cannotUndoException) {
            cannotUndoException.printStackTrace();
        }
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public void cut() {
        this.textArea.cut();
    }

    public void copy() {
        this.textArea.copy();
    }

    public void paste() {
        this.textArea.paste();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changed = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changed = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.changed = true;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getDot() != caretEvent.getMark()) {
            return;
        }
        this.textArea.removeCaretListener(this);
        this.balanceParentheses();
        this.textArea.addCaretListener(this);
    }

    class TextUndoPlainDocument
    extends PlainDocument {
        private TextUndoManager undoManager;

        TextUndoPlainDocument(TextUndoManager textUndoManager) {
            this.undoManager = textUndoManager;
            this.addUndoableEditListener(this.undoManager);
        }

        @Override
        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (n2 == 0) {
                super.replace(n, n2, string, attributeSet);
            } else {
                this.undoManager.startEditGrouping();
                super.replace(n, n2, string, attributeSet);
                this.undoManager.stopEditGrouping();
            }
        }
    }

    class TextUndoManager
    extends AbstractUndoableEdit
    implements UndoableEditListener {
        private String lastEditName = null;
        private int lastStart = 0;
        private ArrayList<TextCompoundEdit> edits = new ArrayList();
        private TextCompoundEdit current;
        private int pointer = -1;
        private int groupIndex = 0;
        private String groupName = null;

        TextUndoManager() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            boolean bl = false;
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            if (!(undoableEdit instanceof AbstractDocument.DefaultDocumentEvent)) {
                return;
            }
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEdit;
            int n = defaultDocumentEvent.getOffset();
            String string = this.groupName != null ? this.groupName : defaultDocumentEvent.getType().toString();
            if (this.current == null) {
                bl = true;
            } else if (this.lastEditName == null || !this.lastEditName.equals(string)) {
                bl = true;
            } else if (this.groupName == null) {
                if (defaultDocumentEvent.getType() == DocumentEvent.EventType.INSERT && n != this.lastStart + 1) {
                    bl = true;
                } else if (defaultDocumentEvent.getType() == DocumentEvent.EventType.REMOVE && n != this.lastStart - 1) {
                    bl = true;
                }
            }
            while (this.pointer < this.edits.size() - 1) {
                this.edits.remove(this.edits.size() - 1);
                bl = true;
            }
            if (bl) {
                this.createCompoundEdit();
            }
            this.current.addEdit(undoableEdit);
            this.lastEditName = string;
            this.lastStart = n;
        }

        public void startEditGrouping() {
            this.groupName = "Group-" + this.groupIndex++;
        }

        public void stopEditGrouping() {
            this.groupName = null;
        }

        private void createCompoundEdit() {
            if (this.current == null) {
                this.current = new TextCompoundEdit();
            } else if (this.current.getLength() > 0) {
                this.current = new TextCompoundEdit();
            }
            this.edits.add(this.current);
            ++this.pointer;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (!this.canUndo()) {
                throw new CannotUndoException();
            }
            TextCompoundEdit textCompoundEdit = this.edits.get(this.pointer);
            textCompoundEdit.undo();
            --this.pointer;
        }

        @Override
        public void redo() throws CannotUndoException {
            if (!this.canRedo()) {
                throw new CannotUndoException();
            }
            ++this.pointer;
            TextCompoundEdit textCompoundEdit = this.edits.get(this.pointer);
            textCompoundEdit.redo();
        }

        @Override
        public boolean canUndo() {
            return this.pointer >= 0;
        }

        @Override
        public boolean canRedo() {
            return this.edits.size() > 0 && this.pointer < this.edits.size() - 1;
        }
    }

    class TextCompoundEdit
    extends CompoundEdit {
        private boolean isUnDone = false;

        TextCompoundEdit() {
        }

        public int getLength() {
            return this.edits.size();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.isUnDone = true;
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.isUnDone = false;
        }

        @Override
        public boolean canUndo() {
            return this.edits.size() > 0 && !this.isUnDone;
        }

        @Override
        public boolean canRedo() {
            return this.edits.size() > 0 && this.isUnDone;
        }
    }
}

