/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Font;
import java.io.File;
import java.util.prefs.Preferences;
import net.sf.clipsrules.jni.examples.ide.CLIPSIDE;

public class IDEPreferences {
    private Preferences prefs = Preferences.userNodeForPackage(CLIPSIDE.class);
    private File currentDirectory = null;
    private static final String CURRENT_DIRECTORY = "currentDirectory";
    private Font dialogFont = null;
    private static final String DIALOG_FONT_NAME = "dialogFontName";
    private static final String DIALOG_FONT_SIZE = "dialogFontSize";
    private static final String DIALOG_FONT_STYLE = "dialogFontStyle";
    private Font editorFont = null;
    private static final String EDITOR_FONT_NAME = "editorFontName";
    private static final String EDITOR_FONT_SIZE = "editorFontSize";
    private static final String EDITOR_FONT_STYLE = "editorFontStyle";
    private Font browserFont = null;
    private static final String BROWSER_FONT_NAME = "browserFontName";
    private static final String BROWSER_FONT_SIZE = "browserFontSize";
    private static final String BROWSER_FONT_STYLE = "browserFontStyle";

    IDEPreferences() {
        int n;
        int n2;
        File file;
        String string = this.prefs.get(CURRENT_DIRECTORY, null);
        if (string == null) {
            file = new File(System.getProperty("user.dir"));
        } else {
            file = new File(string);
            if (!file.exists()) {
                file = new File(System.getProperty("user.dir"));
            }
        }
        this.currentDirectory = file.getAbsoluteFile();
        String string2 = this.prefs.get(DIALOG_FONT_NAME, null);
        if (string2 == null) {
            this.dialogFont = new Font("monospaced", 0, 12);
        } else {
            n2 = this.prefs.getInt(DIALOG_FONT_SIZE, 12);
            n = this.prefs.getInt(DIALOG_FONT_STYLE, 0);
            this.dialogFont = new Font(string2, n, n2);
        }
        string2 = this.prefs.get(EDITOR_FONT_NAME, null);
        if (string2 == null) {
            this.editorFont = new Font("monospaced", 0, 12);
        } else {
            n2 = this.prefs.getInt(EDITOR_FONT_SIZE, 12);
            n = this.prefs.getInt(EDITOR_FONT_STYLE, 0);
            this.editorFont = new Font(string2, n, n2);
        }
        string2 = this.prefs.get(BROWSER_FONT_NAME, null);
        if (string2 == null) {
            this.browserFont = new Font("dialog", 0, 12);
        } else {
            n2 = this.prefs.getInt(DIALOG_FONT_SIZE, 12);
            n = this.prefs.getInt(DIALOG_FONT_STYLE, 0);
            this.browserFont = new Font(string2, n, n2);
        }
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public void saveCurrentDirectory(File file) {
        this.prefs.put(CURRENT_DIRECTORY, file.getAbsolutePath());
    }

    public Font getDialogFont() {
        return this.dialogFont;
    }

    public void setDialogFont(Font font) {
        this.dialogFont = font;
    }

    public void saveDialogFont(Font font) {
        this.prefs.put(DIALOG_FONT_NAME, font.getFamily());
        this.prefs.putInt(DIALOG_FONT_SIZE, font.getSize());
        this.prefs.putInt(DIALOG_FONT_STYLE, font.getStyle());
    }

    public Font getEditorFont() {
        return this.editorFont;
    }

    public void setEditorFont(Font font) {
        this.editorFont = font;
    }

    public void saveEditorFont(Font font) {
        this.prefs.put(EDITOR_FONT_NAME, font.getFamily());
        this.prefs.putInt(EDITOR_FONT_SIZE, font.getSize());
        this.prefs.putInt(EDITOR_FONT_STYLE, font.getStyle());
    }

    public Font getBrowserFont() {
        return this.browserFont;
    }

    public void setBrowserFont(Font font) {
        this.browserFont = font;
    }

    public void saveBrowserFont(Font font) {
        this.prefs.put(BROWSER_FONT_NAME, font.getFamily());
        this.prefs.putInt(BROWSER_FONT_SIZE, font.getSize());
        this.prefs.putInt(BROWSER_FONT_STYLE, font.getStyle());
    }
}

