/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.FloatValue;
import net.sf.clipsrules.jni.InstanceNameValue;
import net.sf.clipsrules.jni.IntegerValue;
import net.sf.clipsrules.jni.LexemeValue;
import net.sf.clipsrules.jni.MultifieldValue;
import net.sf.clipsrules.jni.NumberValue;
import net.sf.clipsrules.jni.PrimitiveValue;
import net.sf.clipsrules.jni.StringValue;
import net.sf.clipsrules.jni.SymbolValue;
import net.sf.clipsrules.jni.UserFunction;

public class UserFunctionExamples {
    public static void addUserFunctions(final Environment environment) {
        environment.removeUserFunction("upcase");
        environment.addUserFunction("upcase", "syn", 1, 1, "syn", new UserFunction(){

            @Override
            public PrimitiveValue evaluate(List<PrimitiveValue> list) {
                LexemeValue lexemeValue = (LexemeValue)list.get(0);
                String string = lexemeValue.getValue().toUpperCase();
                if (lexemeValue.isString()) {
                    return new StringValue(string);
                }
                if (lexemeValue.isSymbol()) {
                    return new SymbolValue(string);
                }
                if (lexemeValue.isInstanceName()) {
                    return new InstanceNameValue(string);
                }
                return null;
            }
        });
        environment.removeUserFunction("lowcase");
        environment.addUserFunction("lowcase", "syn", 1, 1, "syn", new UserFunction(){

            @Override
            public PrimitiveValue evaluate(List<PrimitiveValue> list) {
                LexemeValue lexemeValue = (LexemeValue)list.get(0);
                String string = lexemeValue.getValue().toLowerCase();
                if (lexemeValue.isString()) {
                    return new StringValue(string);
                }
                if (lexemeValue.isSymbol()) {
                    return new SymbolValue(string);
                }
                if (lexemeValue.isInstanceName()) {
                    return new InstanceNameValue(string);
                }
                return null;
            }
        });
        environment.addUserFunction("cbrt", "d", 1, 1, "ld", new UserFunction(){

            @Override
            public PrimitiveValue evaluate(List<PrimitiveValue> list) {
                NumberValue numberValue = (NumberValue)list.get(0);
                return new FloatValue(Math.cbrt(numberValue.doubleValue()));
            }
        });
        environment.addUserFunction("get-year", "v", 0, 0, null, new UserFunction(){

            @Override
            public PrimitiveValue evaluate(List<PrimitiveValue> list) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                return new IntegerValue(gregorianCalendar.get(1));
            }
        });
        environment.addUserFunction("get-properties", "m", 0, 0, null, new UserFunction(){

            @Override
            public PrimitiveValue evaluate(List<PrimitiveValue> list) {
                ArrayList<PrimitiveValue> arrayList = new ArrayList<PrimitiveValue>();
                Properties properties = System.getProperties();
                for (String string : properties.stringPropertyNames()) {
                    arrayList.add(new SymbolValue(string));
                }
                return new MultifieldValue(arrayList);
            }
        });
        environment.addUserFunction("hello", "v", 0, 0, null, new UserFunction(){

            @Override
            public PrimitiveValue evaluate(List<PrimitiveValue> list) {
                environment.println("Hello World!");
                return null;
            }
        });
        environment.addUserFunction("make-instoid", "bi", 0, 0, null, new UserFunction(){

            @Override
            public PrimitiveValue evaluate(List<PrimitiveValue> list) {
                try {
                    return environment.eval("(instance-address (make-instance [hello] of INITIAL-OBJECT))");
                }
                catch (Exception exception) {
                    return new SymbolValue("FALSE");
                }
            }
        });
        environment.addUserFunction("make-factoid", "bf", 0, 0, null, new UserFunction(){

            @Override
            public PrimitiveValue evaluate(List<PrimitiveValue> list) {
                try {
                    return environment.eval("(assert (hello world))");
                }
                catch (Exception exception) {
                    return new SymbolValue("FALSE");
                }
            }
        });
    }
}

