#include "translate.h"

static const t_unicode cp861_c1_chars[] = {
0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7, /* 0x80-0x87 */
0x00ea, 0x00eb, 0x00e8, 0x00d0, 0x00f0, 0x00de, 0x00c4, 0x00c5, /* 0x88-0x8F */
0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00fe, 0x00fb, 0x00dd, /* 0x90-0x97 */
0x00fd, 0x00d6, 0x00dc, 0x00f8, 0x00a3, 0x00d8, 0x20a7, 0x0192, /* 0x98-0x9F */
};
struct char_set cp861_c1 = {
	1,
	CHARS(cp861_c1_chars),
	0, "", 0, 32,
};

static const t_unicode cp861_g1_chars[] = {
0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00c1, 0x00cd, 0x00d3, 0x00da, /* 0xA0-0xA7 */
0x00bf, 0x2310, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb, /* 0xA8-0xAF */
0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556, /* 0xB0-0xB7 */
0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510, /* 0xB8-0xBF */
0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f, /* 0xC0-0xC7 */
0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567, /* 0xC8-0xCF */
0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b, /* 0xD0-0xD7 */
0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580, /* 0xD8-0xDF */
0x03b1, 0x00df, 0x0393, 0x03c0, 0x03a3, 0x03c3, 0x00b5, 0x03c4, /* 0xE0-0xE7 */
0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x03c6, 0x03b5, 0x2229, /* 0xE8-0xEF */
0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00f7, 0x2248, /* 0xF0-0xF7 */
0x00b0, 0x2219, 0x00b7, 0x221a, 0x207f, 0x00b2, 0x25a0, 0x00a0, /* 0xF8-0xFF */
};
struct char_set cp861_g1 = {
	1,
	CHARS(cp861_g1_chars),
	0, "", 0, 96,
};


struct char_set cp861 = {
	.c0 = &ibm_ascii_c0,
	.g0 = &ibm_ascii_g0,
	.c1 = &cp861_c1,
	.g1 = &cp861_g1,
	.names = { "cp861", 0 },
};

CONSTRUCTOR(static void init(void))
{
	register_charset(&cp861);
}
