// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Tutorial_h
#define Tutorial_h




#include "enums.h"
#include <vector>
#include <iostream>
#include <fstream>
#include <string>
#include <cstdlib>
#include <cassert>
#include "constants.h"
#include "Crystal.h"
#include "FS_gfx.h"
#include <tr1/memory>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;




namespace FS
{

class Tutorial
{
    public:
                    
        enum TaskType { READ_TASK, PLAY_TASK };
        static const int MAX_CRYSTALS = 5;
        static const int MAX_MSG_LINES = 3;
        
        static const int MSG_BOARD_WIDTH = 700;
        static const int MSG_BOARD_HEIGHT = 30;
        static const int MSG_BOARD_X = 100;
        static const int MSG_BOARD_Y = 560;
        static const int MSG_TEXT_Y_OFFSET = 4;
        
        struct Task
        {
            TaskType type;
            
            // PLAY_TASK
            RowDescription row_desc;
            LogColor lc;
            int num_required_crystals;
            Crystal::Color required_crystals[MAX_CRYSTALS];
            
            // READ_TASK
            bool do_once_only;
            bool done_once_already;
            
            // READ_ and PLAY_TASKs
            std::string msg;            
        }; // struct Task    

        Tutorial();
        ~Tutorial();

        void load_task_list(int level);
        
        // Sets 'current_task' to 0 and clears all 'done_once_already'
        // flags. No need to call this immediately after load_task_list
        // (- it's called for you).
        void reset_task_list();
        
        // If we're at the end of the 'task_list', this function returns
        // the null pointer, 0; else a pointer to 'current_task'.
        const Task* get_current_task() const;
        // Inform Tutorial class that current task has been completed and
        // that we're ready to move to the next one. As a convenience, it'll
        // also return pointer to new task.
        const Task* next_task();
        
        // Call this after level-restart while in TUTORIAL mode. It sets 
        // current_task back to the start (i.e. 0) while leaving undisturbed
        // 'done_once_already' flags in task_list.
        void restart();
        
        void print_task_list();
            
    private:
            
        // FIXME: if find we need to remove tasks during tutorial, maybe
        // switch to using a std::list instead.
        std::vector<Task*> task_list;
        unsigned int current_task;
        
        void delete_tasks();

}; // class Tutorial

// Non-member, non-friend functions related to Tutorial class.
void draw_task_message(const std::string& msg);

} // namespace FS




#endif
