// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Player_data_h
#define Player_data_h




#include "enums.h"
#include "constants.h"
#include "SDL.h"
#include <iostream>
#include <cstdlib>
#include <cstdio>
#include <list>
#include <algorithm>
#include "Crystal.h"
#include "FS_gfx.h"
#include <tr1/memory>
#include <boost/foreach.hpp>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;




namespace FS
{
    
//class Crystal;  // forward declaration
class Player_data
{
    public:
            
        Player_data();
        ~Player_data();
        
        void reset(int start_level);
        void set_max_crystals(int mc);
        void set_crystals_held(Crystal::Color* ccs, int n);
        
        void draw_crystals_held();
        
        // NEW!
        bool is_allowed_on_log(LogColor lc);
        Crystal::Color add_crystal(Crystal::Color cc);
        
        bool inc_level();
        int get_level() const { return level; }
        
        void inc_score(int pts) { score += pts; }
        int get_score() const { return score; }
        
        // returns number of lives left
        void dec_num_lives() { --num_lives; }
        int get_num_lives() const { return num_lives; }
        
        //const SDL_Rect & get_crystals_held_bounding_box() { return dirty_rect; }
        
        void draw_score();
        void draw_lives();
        void draw_level();
        
        bool check_crystals(const Crystal::Color* ccs, int n);
    private:
            
        int level;
        int num_lives;
        int score;
        
        std::list<Crystal::Color> crystals;
        std::list<Crystal::Color>::iterator crystals_iter;
        unsigned int max_crystals;
        
        bool check_crystals(Crystal::Color color_0, Crystal::Color color_1);
        
        //SDL_Rect dest_rect;
        //SDL_Rect erase_rect;
        //SDL_Rect dirty_rect;
        
        char score_str[7];
        SDL_Rect score_update_rect;
        SDL_Rect score_dest_rect;
        char lives_str[2];
        SDL_Rect lives_update_rect;
        SDL_Rect lives_dest_rect;
        char level_str[3];
        SDL_Rect level_update_rect;
        SDL_Rect level_dest_rect;
        
        void print_crystals_held() const;
        
}; // class Player_data

} // namespace FS




#endif
        
