// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Log_h
#define Log_h




#include "Scrolling_sprite.h"
#include "enums.h"
#include "FS_gfx.h"
#include <tr1/memory>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;




namespace FS
{
    
class Log : public Scrolling_sprite
{
    public:
            
        Log( int x_, int y_, int width_, int my_row_, LogColor color );
        ~Log();
        
        LogColor get_color() const { return current_color; }
        void set_color(LogColor c) { current_color = c; }
        
        int get_num_pixels_moved() const { return num_pixels_moved; }
        Direction get_direction() const { return my_direction; }
        
        // Provide an implementation of pure virtual function MapSprite::update
        void update( const ScrollingData& sd );
        
        void reset() { current_color = original_color; }
        
        // Override Sprite::get_coll_box.
        const SDL_Rect& get_coll_box();

    private:
            
        LogColor original_color;
        LogColor current_color;
        
        // Updated in calc_x_pos - holds screen coordinate for log (as opposed to its
        // place in the map).
        int virtual_x;
    
        // Store these when Log is updated, because they're needed by
        // Albert if he happens to be floating on this log.
        int num_pixels_moved;
        Direction my_direction;
        
        // Returns true if log is visible onscreen; otherwise false.
        bool calc_x_pos( const ScrollingData& sd );
        
        // Value for this is width / CELL_WIDTH (i.e. UNIT size) - 1. So for a log of width
        // 50, image_offset is 0 - you don't need to change from, e.g. LOG_RED_1. For a log
        // of width 100, image_offset is 1 - LOG_RED_1 + 1 = LOG_RED_2.
        int image_offset;
    
}; // class Log

} // namespace FS




#endif
    
