// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef High_scores_display_h
#define High_scores_display_h




#include <list>
#include <vector>
#include "SDL.h"
#include <string>
#include <fstream>
#include <cstdlib>
#include <iostream>
#include <iterator>
#include <cstring>
#include <cctype>   // for toupper()
#include "User_input.h"
#include "FS_gfx.h"
#include <tr1/memory>
#include <boost/lexical_cast.hpp>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;
extern std::tr1::shared_ptr<FS::User_input> input_ptr;




namespace FS
{

class High_scores_display
{
    public:
        
        High_scores_display();
        ~High_scores_display();
        
        // Returns true if sc would get a place on high-score table;
        // else false.
        bool check_candidate(int sc) const;
        
        // Add this name and score to the high-score table, removing
        // the lowest entry. Call this when check_candiate() returns
        // true.              
        void add_entry(const char* nm, int sc);
        
        // Console print-out for time being...
        void print_table();
        
        void show_high_scores();
        
        void init_input(int score);
        bool input();
        
        void write_high_scores();

    private:
            
        static const int NAME_MAX_LEN = 10;
        static const int SCORE_LEN = 6;
        static const int NUM_ENTRIES = 5;
        
        static const int TOP_Y = 125;
        static const int Y_GAP = 80;
        static const int NAME_X = 100;
        static const int SCORE_X = 500;
        
        struct High_score_entry
        {
            char name[NAME_MAX_LEN+1];
            char score_str[SCORE_LEN+1];
            int score;
        }; // struct High_score_entry
        
        std::vector<High_score_entry> my_entries;

        
        void read_high_scores();

        void populate_default_table();
        
        // These variables are used for controlling name-input.
        std::vector<High_score_entry>::iterator new_entry;
        int new_entry_y;
        std::string new_entry_name;
        int font_height;
        SDL_Rect erase_rect;
        SDL_Rect dest_rect;
                
}; // class High_scores_display

} // namespace FS




#endif
 
        
