// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Gfx_engine.h"




// *******************
// *** CONSTRUCTOR ***
// *******************

Mafferyew::Gfx_engine::Gfx_engine()
{
    // beaucoup de stuff
    
} // Mafferyew::Gfx_engine::Gfx_engine


// ******************
// *** DESTRUCTOR ***
// ******************

Mafferyew::Gfx_engine::~Gfx_engine()
{
    // clean up
    
} // Mafferyew::Gfx_engine::~Gfx_engine




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void Mafferyew::Gfx_engine::draw_background(int id) const
{
    my_backgrounds[id]->draw();
    
} // Mafferyew::Gfx_engine::draw_background

// **************************************************

void Mafferyew::Gfx_engine::draw_text(int id,  // id for font
                                      int x,   // this value ignored if center is true
                                      int y,
                                      const std::string& text,
                                      bool center,
                                      int screen_width) const
{
    if ( center )
    {
        my_fonts[id]->write_center(screen_width, y, text);
    }
    else
    {
        my_fonts[id]->write(x, y, text);
    } // if ... else
    
} // Mafferyew::Gfx_engine::draw_text

// **************************************************

void Mafferyew::Gfx_engine::draw_text_faded(int id,
                                            int x,
                                            int y,
                                            const std::string& text,
                                            float fade,
                                            bool center,
                                            int screen_width) const
{
    glColor4f(1.0, 1.0, 1.0, fade);
    draw_text(id, x, y, text, center, screen_width);
    glColor4f(1.0, 1.0, 1.0, 1.0);

} // Mafferyew::Gfx_engine::draw_text_faded

// **************************************************

int Mafferyew::Gfx_engine::get_text_width(int id, const std::string& text) const

{
    return my_fonts[id]->text_width(text);
    
} // Mafferyew::Gfx_engine::get_text_width

// **************************************************

int Mafferyew::Gfx_engine::get_text_height(int id) const
{
    return my_fonts[id]->text_height();

} // Mafferyew::Gfx_engine::get_text_height

// **************************************************

void Mafferyew::Gfx_engine::draw_texture( int id, int x, int y, bool rotate_me, float rotation, 
        bool fade_me, float fade ) const
{
    // FIXME: can first three function calls be called in program set-up?
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    glBindTexture( GL_TEXTURE_2D, my_textures[id].tex_handle );

    if ( rotate_me ) 
    { 
        glMatrixMode(GL_TEXTURE);
        glPushMatrix();
        glLoadIdentity();
        glTranslatef(x, y, 0.0);
        glRotatef(-rotation, 0.0, 0.0, 1.0); 
        glMatrixMode(GL_MODELVIEW);
    } // if

    if ( fade_me )   { glColor4f(1.0, 1.0, 1.0, fade); }

    glBegin(GL_QUADS);
        glTexCoord2i(0, 0);
        glVertex3f(x, y, 0.0);

        glTexCoord2i(1, 0);
        glVertex3f(x + my_textures[id].width, 
                   y, 
                   0.0);

        glTexCoord2i(1, 1);
        glVertex3f(x + my_textures[id].width, 
                   y + my_textures[id].height,
                   0.0); 

        glTexCoord2i(0, 1);
        glVertex3f(x,
                   y + my_textures[id].height,
                   0.0); 
    glEnd();

    if ( rotate_me ) 
    { 
        glMatrixMode(GL_TEXTURE);
        // Undo transformations.
        glPopMatrix();
        glMatrixMode(GL_MODELVIEW);
    } // if

    if ( fade_me )   { glColor4f(1.0, 1.0, 1.0, 1.0); }

} // Mafferyew::Gfx_engine::draw_texture

// **************************************************

