// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Albert_h
#define Albert_h




#include "Sprite.h"
#include "enums.h"
#include "constants.h"
#include "Log.h"
#include "Crystal.h"
#include "SDL.h"
#include "Fish.h"
#include "Collisions.h"
#include "Star_particle_system.h"
#include "User_input.h"
#include "FS_gfx.h"
#include <tr1/memory>




extern bool escape_pressed;
extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;
extern std::tr1::shared_ptr<FS::User_input> input_ptr;




namespace FS
{

// FIXME: ?!
static const int NUM_COLL_BOXES = 4;
static const int COLL_BOX_X_OFFSETS[] = { 57, 52, 59, 52 };
static const int COLL_BOX_Y_OFFSETS[] = { 52, 57, 52, 59 };
static const int COLL_BOX_WIDTHS[] = { 12, 24, 12, 24 };
static const int COLL_BOX_HEIGHTS[] = { 24, 12, 24, 12 };
    
class Albert : public Sprite
{
    public:
        Albert();
        ~Albert();
        
        void reset();
        void update(int t, bool is_running);
        
        int upper_y() const { return y + coll_box_y_offsets[my_orientation]; }
        int lower_y() const { return y + coll_box_y_offsets[my_orientation] + 
                my_coll_boxes[my_orientation].h; }
        
        bool is_airborne() const { return airborne; }
        bool is_on_log() const { return (test_action(FLOATING) > 0); }
        int is_in_water_or_being_zapped() const; 
        
        void set_new_host_log(Log* l);
        
        // If Albert is on a log, returns that log's row (see RowDescription enum
        // in "enums.h"); else returns -1 (an invalid row).
        int get_host_log_row() const; // { return host_log->get_row(); }
        const Log* get_host_log() const { return host_log; }
        
        void start_splash(int t);
        void start_zap(int t);
        
        void start_leave_with_fish(int t);
        void start_leave_in_a_huff(int t);
        
        bool is_splashed_zapped_out() const { return splashed_zapped_out; }
        
        bool has_left() const { return left; }
        
        // Redefinition of Sprite::get_coll_box(). No dynamic binding.
        const SDL_Rect& get_coll_box();
        
        // Redefinition of Sprite::get_bounding_box(). This is so we can make
        // Albert's bounding box a little bigger than image size.
        const SDL_Rect& get_bounding_box();
        
        void set_next_jump_double() { next_jump_double = true; }
        
        bool has_stars() const { return stars.is_active(); }
        
        void schedule_draw( /*PlayDisplay* pd*/ );

    private:
            
        Orientation my_orientation;
    
        int actions;
        
        bool airborne;
          
        int start_time; 
        int start_x;
        int start_y;

        int current_frame;
        //ImageIDs current_strip;
        FS_gfx::Image_name my_strip;
        
        Log* host_log;
        
        int coll_box_x_offsets[NUM_COLL_BOXES];
        int coll_box_y_offsets[NUM_COLL_BOXES];
        SDL_Rect my_coll_boxes[NUM_COLL_BOXES];
        
        void process_keypress(int t);
        void process_animation(int t);
        
        void calc_rects();
        void calc_strip();
        void check_host_log();
        
        //SDL_Rect image_section_rect;
        
        void turn_on_action(int a) { actions |= a; }
        void turn_off_action(int a) { actions &= ~a; }
        int test_action(int a) const { return (actions & a); }
        
        // Albert landed in the water/got zapped and splashing/zapping 
        // animation is over.
        bool splashed_zapped_out;
        
        bool left;
        
        bool next_jump_double;
        
        Star_particle_system stars;
        
}; // class Albert

} // namespace FS




#endif
