// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package recorder

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new recorder API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for recorder API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientService is the interface for Client methods
type ClientService interface {
	DeleteRecorderID(params *DeleteRecorderIDParams) (*DeleteRecorderIDOK, error)

	GetRecorder(params *GetRecorderParams) (*GetRecorderOK, error)

	GetRecorderID(params *GetRecorderIDParams) (*GetRecorderIDOK, error)

	GetRecorderMasks(params *GetRecorderMasksParams) (*GetRecorderMasksOK, error)

	PutRecorderID(params *PutRecorderIDParams) (*PutRecorderIDOK, *PutRecorderIDCreated, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
  DeleteRecorderID deletes a recorder
*/
func (a *Client) DeleteRecorderID(params *DeleteRecorderIDParams) (*DeleteRecorderIDOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteRecorderIDParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeleteRecorderID",
		Method:             "DELETE",
		PathPattern:        "/recorder/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteRecorderIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteRecorderIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteRecorderID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
  GetRecorder retrieves list of all recorders
*/
func (a *Client) GetRecorder(params *GetRecorderParams) (*GetRecorderOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRecorderParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetRecorder",
		Method:             "GET",
		PathPattern:        "/recorder",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetRecorderReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRecorderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetRecorder: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
  GetRecorderID retrieves configuration of a recorder
*/
func (a *Client) GetRecorderID(params *GetRecorderIDParams) (*GetRecorderIDOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRecorderIDParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetRecorderID",
		Method:             "GET",
		PathPattern:        "/recorder/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetRecorderIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRecorderIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetRecorderID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
  GetRecorderMasks retrieves list of all recorder masks
*/
func (a *Client) GetRecorderMasks(params *GetRecorderMasksParams) (*GetRecorderMasksOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRecorderMasksParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetRecorderMasks",
		Method:             "GET",
		PathPattern:        "/recorder/masks",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetRecorderMasksReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRecorderMasksOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetRecorderMasks: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
  PutRecorderID creates or update recorder
*/
func (a *Client) PutRecorderID(params *PutRecorderIDParams) (*PutRecorderIDOK, *PutRecorderIDCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPutRecorderIDParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "PutRecorderID",
		Method:             "PUT",
		PathPattern:        "/recorder/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PutRecorderIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *PutRecorderIDOK:
		return value, nil, nil
	case *PutRecorderIDCreated:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for recorder: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
