/*
	file automatically generated by make_test_files.pl
	Wed Mar 16 14:50:45 2022
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for DSTD
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_dstd_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */

int estimate_uerror( UNUR_DISTR *distr, double u_resolution, int samplesize );

double cdf_geom(int k, const UNUR_DISTR *distr);
int invcdf_geom(double u, const UNUR_DISTR *distr);

/* -- constants -- */

/* sample size */
static const int    UERROR_SAMPLESIZE = 100000;
static const double UERROR_RESOLUTION = 1.e-14;

#define COMPARE_SAMPLE_SIZE   (500)
#define VIOLATE_SAMPLE_SIZE   (20)

/* #define SEED   (298346) */




/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */




int
estimate_uerror( UNUR_DISTR *distr,     /* distribution object */
		 double u_resolution,   /* maximal tolerated u-error */
  		 int samplesize )       /* sample size for error experiment */
/* returns 0 if maxerror < u_resolution, errorcode otherwise */
{
  UNUR_PAR *par;
  UNUR_GEN *gen;
  int i, nfpar;
  const double *fpar;
  double score;

  /* print data about distribution */
  fprintf(TESTLOG,"> %s (",unur_distr_get_name(distr));
  nfpar = unur_distr_discr_get_pmfparams(distr,&fpar);
  for(i=0;i<nfpar;i++) fprintf(TESTLOG,"%s %g", (i?",":""), fpar[i]);
  fprintf(TESTLOG,")\n");

  /* create parameter object for inversion method */
  par = unur_dstd_new(distr);
  if (par==NULL || 
      unur_dstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) {
    fprintf(TESTLOG,"\t--> inversion method not implemented !!\n\n");
    printf("0"); fflush(stdout);
    if (par) unur_par_free(par);
    unur_distr_free(distr);
    return 0; 
  }

  /* initialize generator object */
  gen = unur_init(par);

  /* run test */
  score = run_validate_u_error( TESTLOG, gen, distr, u_resolution, samplesize );

  /* clear working space */
  unur_distr_free(distr);
  unur_free(gen);

  /* return */
  fprintf(TESTLOG,"\n");
  return score;

} /* end of estimate_uerror() */



double cdf_geom(int k, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
  const double p = 0.3;
  return ((k<0) ? 0. : (1. - pow(1. - p, k+1.)) );
}

int invcdf_geom(double u, const UNUR_DISTR *distr ATTRIBUTE__UNUSED)
{ 
  const double p = 0.3;
  return ((int) (log(u) / log(1.-p)));
}


/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_DISTR *distr = NULL;
   distr = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,39,(unur_dstd_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,39,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* invalid distribution type */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_cont_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,45,(unur_dstd_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,45,UNUR_ERR_DISTR_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}

{ /* not a standard distribution */
UNUR_DISTR *distr = NULL;
   distr = unur_distr_discr_new(); 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,51,(unur_dstd_new( distr )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,51,UNUR_ERR_DISTR_REQUIRED)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [set] */

void test_set (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[set "); fflush(stdout);
	fprintf(TESTLOG,"\n[set]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,61,(unur_dstd_set_variant(par,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,61,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}

{ /* invalid parameter object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[1] = {0.5};
   distr = unur_distr_geometric(fpar,1);
   par = unur_dgt_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,69,(unur_dstd_set_variant(par,1)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,69,UNUR_ERR_PAR_INVALID)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}

{ /* invalid parameters */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
   double fpar[1] = {0.5};
   distr = unur_distr_geometric(fpar,1);
   par = unur_dstd_new(distr); 


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,79,(unur_dstd_set_variant(par,9999)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,79,UNUR_ERR_PAR_VARIANT)==UNUR_SUCCESS)?0:1;
unur_par_free(par);
unur_distr_free(distr);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_set() */

/*---------------------------------------------------------------------------*/
/* [chg] */

void test_chg (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[chg "); fflush(stdout);
	fprintf(TESTLOG,"\n[chg]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid generator object */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {10,0.4};
   distr = unur_distr_binomial(fpar,2);
   par = unur_dgt_new(distr);
   unur_set_debug(par,0);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 95,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_setfailed(TESTLOG,99,(unur_dstd_chg_truncated(gen, 1, 5)))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,99,UNUR_ERR_GEN_INVALID)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_chg() */

/*---------------------------------------------------------------------------*/
/* [init] */

void test_init (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[init "); fflush(stdout);
	fprintf(TESTLOG,"\n[init]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* invalid NULL ptr */
UNUR_PAR   *par = NULL;
   par = NULL; 


unur_reset_errno();
n_tests_failed += (check_expected_NULL(TESTLOG,109,(unur_init( par )))==UNUR_SUCCESS)?0:1;
n_tests_failed += (check_errorcode(TESTLOG,109,UNUR_ERR_NULL)==UNUR_SUCCESS)?0:1;
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_init() */

/*---------------------------------------------------------------------------*/
/* [reinit] */

void test_reinit (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[reinit "); fflush(stdout);
	fprintf(TESTLOG,"\n[reinit]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* does not exist */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[2] = {10.,0.63};
   distr = unur_distr_binomial(fpar,2);
   par = unur_dstd_new(distr);
   gen = unur_init( par ); 
abort_if_NULL(TESTLOG, 119,    gen );


unur_reset_errno();
n_tests_failed += (check_expected_reinit(TESTLOG,123,(unur_reinit( gen )))==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_reinit() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* compare clone */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *clone;
   double fpar[] = {10,0.3}; 
   distr = unur_distr_binomial(fpar,2);
   par = NULL;
   gen = NULL; 


unur_reset_errno();
/* original generator object */
par = unur_dstd_new(distr);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,139,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
/* clone */
clone = unur_gen_clone(gen);
unur_free(gen);
gen = clone;
n_tests_failed += (compare_sequence_gen(TESTLOG,145,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}

{ /* compare stringparser */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[] = {3.};
   distr = NULL;
   par = NULL;
   gen = NULL; 


unur_reset_errno();
distr = unur_distr_poisson(fpar,1);
par = unur_dstd_new(distr);
unur_dstd_set_variant(par,2);
gen = unur_init(par);
n_tests_failed += (compare_sequence_gen_start(TESTLOG,159,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;

unur_reset_errno();
unur_free(gen); gen = NULL;
unur_distr_free(distr); distr = NULL;
gen = unur_str2gen( "poisson(3.) & method = dstd; variant = 2" );
n_tests_failed += (compare_sequence_gen(TESTLOG,164,gen,COMPARE_SAMPLE_SIZE)==UNUR_SUCCESS)?0:1;
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */

/*---------------------------------------------------------------------------*/
/* [validate] */

/*---------------------------------------------------------------------------*/

/* [validate] */

void test_validate (void)
{
	/* suppress GCC compiler warning */
GCC_DIAG_OFF(unused-variable)

	UNUR_DISTR *distr[30];
	UNUR_PAR *par;
	UNUR_GEN *gen;
	double *darray;
	double fpm[10];
	int n_tests_failed;
	int rcode;

	/* start test */
	printf("[validate "); fflush(stdout);
	fprintf(TESTLOG,"\n[validate]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);


/* distributions: 30 */
{
fpm[0] = 50.;
fpm[1] = 0.4;
distr[1] = unur_distr_binomial(fpm,2);
}

{
fpm[0] = 100.;
fpm[1] = 0.87;
distr[2] = unur_distr_binomial(fpm,2);
}

{
fpm[0] = 100.;
fpm[1] = 0.01;
distr[3] = unur_distr_binomial(fpm,2);
}

{
fpm[0] = 10000.;
fpm[1] = 0.7 ;
distr[4] = unur_distr_binomial(fpm,2);
}

{
fpm[0] = 0.5;
distr[0] = unur_distr_geometric(fpm,1);
}

{
fpm[0] = 0.001;
distr[11] = unur_distr_geometric(fpm,1);
}

{
fpm[0] = 0.999;
distr[12] = unur_distr_geometric(fpm,1);
}

{
fpm[0] = 10000.;
fpm[1] = 100. ;
fpm[2] = 50. ;
distr[5] = unur_distr_hypergeometric(fpm,3);
}

{
fpm[0] = 10000.;
fpm[1] = 9000. ;
fpm[2] = 50. ;
distr[6] = unur_distr_hypergeometric(fpm,3);
}

{
fpm[0] = 10000.;
fpm[1] = 80. ;
fpm[2] = 90. ;
distr[7] = unur_distr_hypergeometric(fpm,3);
}

{
fpm[0] = 10000.;
fpm[1] = 1000. ;
fpm[2] = 150. ;
distr[8] = unur_distr_hypergeometric(fpm,3);
}

{
fpm[0] = 10000.;
fpm[1] = 9000. ;
fpm[2] = 500. ;
distr[9] = unur_distr_hypergeometric(fpm,3);
}

{
fpm[0] = 10000.;
fpm[1] = 9000. ;
fpm[2] = 250. ;
distr[10] = unur_distr_hypergeometric(fpm,3);
}

{
fpm[0] = 0.001;
distr[25] = unur_distr_logarithmic(fpm,1);
}

{
fpm[0] = 0.01;
distr[13] = unur_distr_logarithmic(fpm,1);
}

{
fpm[0] = 0.1;
distr[14] = unur_distr_logarithmic(fpm,1);
}

{
fpm[0] = 0.5;
distr[15] = unur_distr_logarithmic(fpm,1);
}

{
fpm[0] = 0.9;
distr[16] = unur_distr_logarithmic(fpm,1);
}

{
fpm[0] = 0.999;
distr[17] = unur_distr_logarithmic(fpm,1);
}

{
fpm[0] = 0.001;
distr[18] = unur_distr_poisson(fpm,1);
}

{
fpm[0] = 0.1;
distr[19] = unur_distr_poisson(fpm,1);
}

{
fpm[0] = 0.5;
distr[20] = unur_distr_poisson(fpm,1);
}

{
fpm[0] = 1.;
distr[21] = unur_distr_poisson(fpm,1);
}

{
fpm[0] = 10.;
distr[22] = unur_distr_poisson(fpm,1);
}

{
fpm[0] = 1000.;
distr[23] = unur_distr_poisson(fpm,1);
}

{
fpm[0] = 2.;
fpm[1] = 3.;
distr[28] = unur_distr_zipf(fpm,2);
}

{
fpm[0] = 3.;
fpm[1] = 2.;
distr[29] = unur_distr_zipf(fpm,2);
}

{
fpm[0] = 0.5;
fpm[1] = 10.;
distr[24] = unur_distr_negativebinomial(fpm,2);
}

{
distr[26] = unur_distr_discr_new();
unur_distr_set_name( distr[26], "CDF_only" );
unur_distr_discr_set_domain( distr[26], 0, INT_MAX );
unur_distr_discr_set_cdf( distr[26], cdf_geom );
}

{
distr[27] = unur_distr_discr_new();
unur_distr_set_name( distr[27], "CDF&invCDF" );
unur_distr_discr_set_domain( distr[27], 0, INT_MAX );
unur_distr_discr_set_cdf( distr[27], cdf_geom );
unur_distr_discr_set_invcdf( distr[27], invcdf_geom );
}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>setup time = %.3f ms\n", stopwatch_lap(&watch));

	printf("\n(chi^2) "); fflush(stdout);

/* chi^2 tests: 210 */

	unur_set_default_debug(~UNUR_DEBUG_SAMPLE);
	fprintf( TESTLOG,"\nChi^2 Test:\n");

/* distribution [1] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[1]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 20;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[1],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [2] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[2]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 20;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[2],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [3] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[3]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 20;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[3],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [4] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[4]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 20;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[4],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [0] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[0]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[0],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [11] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[11]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[11],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [12] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[12]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[12],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [5] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[5]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 200;
fpm[1] = 50;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[5],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [6] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[6]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 200;
fpm[1] = 50;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[6],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [7] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[7]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 200;
fpm[1] = 50;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[7],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [8] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[8]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 200;
fpm[1] = 50;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[8],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [9] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[9]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 200;
fpm[1] = 50;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[9],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [10] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[10]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 200;
fpm[1] = 50;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[10],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

/* distribution [25] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[25]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[25],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [13] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[13]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[13],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [14] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[14]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[14],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [15] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[15]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[15],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [16] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[16]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[16],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [17] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[17]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[17],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [18] */

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,2)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[18]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 20;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[18],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(fullcheck) {
	printf("."); fflush(stdout);
	}

/* distribution [19] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,2)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[19]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 20;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[19],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [20] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,2)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[20]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 20;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[20],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [21] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,2)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[21]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 20;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[21],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [22] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,2)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[22]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 20;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[22],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [23] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,2)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 0.2;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[23]);
{ UNUR_DISTR *dg =NULL;
par = unur_dstd_new(distr_localcopy);
fpm[0] = 20;
fpm[1] = 0.5;
	gen = unur_init(par);
	if (gen) {
dg = unur_get_distr(gen);
unur_distr_discr_set_pmfparams(dg,fpm,2);
unur_reinit(gen); }
	}
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[23],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [28] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[28]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[28],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [29] */

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[29]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,1)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[29],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [26] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[26]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[26],'0');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

/* distribution [27] */

	if(TRUE) {
	unur_reset_errno();
	do {
	UNUR_DISTR *distr_localcopy = unur_distr_clone(distr[27]);
par = unur_dstd_new(distr_localcopy);
if (unur_dstd_set_variant(par,UNUR_STDGEN_INVERSION)!=UNUR_SUCCESS) { unur_par_free(par); par = NULL; }
	gen = unur_init(par);
	rcode = run_validate_chi2(TESTLOG,0,gen,distr[27],'+');
	n_tests_failed += (rcode==UNUR_SUCCESS)?0:1;
	n_tests_failed += (rcode==UNUR_FAILURE)?1000:0;
	unur_free(gen);
	unur_distr_free(distr_localcopy);
	} while (0);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	if(TRUE) {
	printf("."); fflush(stdout);
	}

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.0f ms\n", stopwatch_lap(&watch));


/* free distributions */
	unur_distr_free(distr[0]);
	unur_distr_free(distr[1]);
	unur_distr_free(distr[2]);
	unur_distr_free(distr[3]);
	unur_distr_free(distr[4]);
	unur_distr_free(distr[5]);
	unur_distr_free(distr[6]);
	unur_distr_free(distr[7]);
	unur_distr_free(distr[8]);
	unur_distr_free(distr[9]);
	unur_distr_free(distr[10]);
	unur_distr_free(distr[11]);
	unur_distr_free(distr[12]);
	unur_distr_free(distr[13]);
	unur_distr_free(distr[14]);
	unur_distr_free(distr[15]);
	unur_distr_free(distr[16]);
	unur_distr_free(distr[17]);
	unur_distr_free(distr[18]);
	unur_distr_free(distr[19]);
	unur_distr_free(distr[20]);
	unur_distr_free(distr[21]);
	unur_distr_free(distr[22]);
	unur_distr_free(distr[23]);
	unur_distr_free(distr[24]);
	unur_distr_free(distr[25]);
	unur_distr_free(distr[26]);
	unur_distr_free(distr[27]);
	unur_distr_free(distr[28]);
	unur_distr_free(distr[29]);

	/* test finished */
	test_ok &= (n_tests_failed>CHI2_FAILURES_TOLERATED) ? 0 : 1;
	/* we accept CHI2_FAILURES_TOLERATED failures */
	(n_tests_failed>CHI2_FAILURES_TOLERATED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_validate */

/* enable GCC compiler warning */
GCC_DIAG_ON(unused-variable)

/*---------------------------------------------------------------------------*/
/* [special] */

void test_special (void)
{
	/* set boolean to FALSE */
	int FAILED = 0;






  int samplesize = UERROR_SAMPLESIZE;
  double ures = UERROR_RESOLUTION;

  int errorsum = 0;
  double fpar[5];

  UNUR_DISTR *distr;

/* start test */
printf("[special "); fflush(stdout);
fprintf(TESTLOG,"\n[special]\n");

/* set stop watch */
stopwatch_lap(&watch);



  /* test for maximal u-error */
  printf("\n[test maximal u-error for inversion method]\n"); 
  fprintf(TESTLOG,"\n* Test maximal u-error for inversion method *\n"); 


  printf(" binomial");

  fpar[0] = 20;
  fpar[1] = 0.2;
  distr = unur_distr_binomial(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 10000;
  fpar[1] = 0.2;
  distr = unur_distr_binomial(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" geometric");

  fpar[0] = 0.1;
  distr = unur_distr_geometric(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" hypergeometric");

  fpar[0] = 10000;
  fpar[1] = 1000;
  fpar[2] = 150;
  distr = unur_distr_hypergeometric(fpar,3);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" negativebinomial");

  fpar[0] = 0.2;
  fpar[1] = 20;
  distr = unur_distr_negativebinomial(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 0.2;
  fpar[1] = 10000;
  distr = unur_distr_negativebinomial(fpar,2);
  errorsum += estimate_uerror(distr,ures,samplesize);


  printf(" poisson");

  fpar[0] = 0.1;
  distr = unur_distr_poisson(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);

  fpar[0] = 10;
  distr = unur_distr_poisson(fpar,1);
  errorsum += estimate_uerror(distr,ures,samplesize);


/*---------------------------------------------------------------------------*/

  /* test finished */
  FAILED = (errorsum < 2) ? 0 : 1;




	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (FAILED) ? 0 : 1;
	(FAILED) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_special() */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_dstd_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_dstd_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_dstd_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_dstd_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 434641;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 434641;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("dstd: ");

	/* run tests */
test_new();
test_set();
test_chg();
test_init();
test_reinit();
test_sample();
test_validate();
test_special();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

