/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.util;

import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.internal.tls.OkHostnameVerifier;

public class SSLUtil {
    public static void addInsecureSsl(OkHttpClient.Builder callFactory, int logging) {
        SSLUtil.addInsecureSSLTrustManager(callFactory, logging);
        SSLUtil.addInsecureSSLHostnameVerifier(callFactory, logging);
    }

    public static void addInsecureSSLTrustManager(OkHttpClient.Builder callFactory, int logging) {
        SSLSocketFactory sslSocketFactory;
        X509TrustManager trustManager;
        try {
            trustManager = SSLUtil.createInsecureSslTrustManager(logging);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        callFactory.sslSocketFactory(sslSocketFactory, trustManager);
    }

    public static void addInsecureSSLHostnameVerifier(OkHttpClient.Builder callFactory, int logging) {
        OkHostnameVerifier defaultVerifier = OkHostnameVerifier.INSTANCE;
        callFactory.hostnameVerifier((hostname, session) -> {
            if (defaultVerifier.verify(hostname, session)) {
                return true;
            }
            if (logging >= 2) {
                System.err.printf("INSECURE_SSL:hostnameVerifier: trust host: %s%n", hostname);
            }
            return true;
        });
    }

    public static void addAlternateSSLHostnameVerifier(OkHttpClient.Builder callFactory, int logging, List<String> alternateHostnames) {
        OkHostnameVerifier defaultVerifier = OkHostnameVerifier.INSTANCE;
        callFactory.hostnameVerifier((hostname, session) -> {
            boolean verify = defaultVerifier.verify(hostname, session);
            if (verify) {
                return true;
            }
            Optional<String> tested = alternateHostnames.stream().filter(h -> defaultVerifier.verify((String)h, session)).findAny();
            if (tested.isPresent() && logging >= 2) {
                System.err.printf("INSECURE_SSL:hostnameVerifier: trust host: %s: as %s%n", hostname, tested.get());
            }
            return tested.isPresent();
        });
    }

    private static X509TrustManager createInsecureSslTrustManager(final int logging) {
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (logging >= 2) {
                    System.err.printf("INSECURE_SSL:TrustManager:checkServerTrusted: %s: chain: %s%n", authType, Arrays.toString(chain));
                }
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        };
    }
}

