/*
  timemanip.c - functions that deal with time values

  Copyright 2003 Damien Gregory (dgregory@lightuniverse.no-ip.com)

    This file is part of pipeworks.

    pipeworks is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    pipeworks is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pipeworks; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include "timemanip.h"

tmanip_t timemultiplier (char type)
{
  switch (type) {
  case 'm':
    return minute(1);
  case 'h':
    return hour(1);
  case 'd':
    return day(1);
  case 'w':
    return week(1);
  case 'M':
    return month(1);
  case 'Y':
    return year(1);
  }
  return 1;
}
 
tmanip_t converttime (tmanip_t s, char source, char dest)
{
  return s * timemultiplier (source) / timemultiplier (dest);
}
 
char *formattime (tmanip_t s, char source, char dest, char *format)
{
  static char buf[1024], fmt[1024]="%.3Lf%c";
  char *f=fmt;
  tmanip_t bval;

  if ( format ) f=format;
  
  bval = converttime (s, source, 's');

  if ( ! dest ) {
    if ( bval >= minute(1) )
      dest='m';
    else if ( bval >= hour(1) )
      dest='h';
    else if ( bval >= hour(1) )
      dest='h';
    else if ( bval >= day(1) )
      dest='d';
    else if ( bval >= week(1) )
      dest='w';
    else if ( bval >= month(1) )
      dest='M';
    else if ( bval >= year(1) )
      dest='Y';
    else
      dest='s';
  }
  
  sprintf (buf, f, converttime (s, source, dest), dest);

  return buf;
}

tmanip_t parsetime (char *s, char dest)
{
  tmanip_t x;
  char t;
  
  sscanf (s, "%Lf%c", &x, &t);
  
  return converttime (x, t, dest);
  
}
