// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        (unknown)
// source: github.com.hashicorp.go.kms.wrapping.v2.types.proto

package wrapping

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// HmacType defines the hmac algorithm type
type HmacType int32

const (
	HmacType_Unknown_HmacType HmacType = 0
	HmacType_Sha224           HmacType = 1
	HmacType_Sha256           HmacType = 2
	HmacType_Sha384           HmacType = 3
	HmacType_Sha512           HmacType = 4
)

// Enum value maps for HmacType.
var (
	HmacType_name = map[int32]string{
		0: "Unknown_HmacType",
		1: "Sha224",
		2: "Sha256",
		3: "Sha384",
		4: "Sha512",
	}
	HmacType_value = map[string]int32{
		"Unknown_HmacType": 0,
		"Sha224":           1,
		"Sha256":           2,
		"Sha384":           3,
		"Sha512":           4,
	}
)

func (x HmacType) Enum() *HmacType {
	p := new(HmacType)
	*p = x
	return p
}

func (x HmacType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HmacType) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_enumTypes[0].Descriptor()
}

func (HmacType) Type() protoreflect.EnumType {
	return &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_enumTypes[0]
}

func (x HmacType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HmacType.Descriptor instead.
func (HmacType) EnumDescriptor() ([]byte, []int) {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP(), []int{0}
}

// KeyType defines the key's type
type KeyType int32

const (
	KeyType_Unknown_KeyType KeyType = 0
	KeyType_Rsa2048         KeyType = 1
	KeyType_Rsa3072         KeyType = 2
	KeyType_Rsa4096         KeyType = 3
	KeyType_Aes256          KeyType = 4
	KeyType_EdsaP256        KeyType = 5
	KeyType_EdsaP384        KeyType = 6
	KeyType_EdsaP521        KeyType = 7
	KeyType_HMAC            KeyType = 8
	KeyType_Ed25519         KeyType = 9
)

// Enum value maps for KeyType.
var (
	KeyType_name = map[int32]string{
		0: "Unknown_KeyType",
		1: "Rsa2048",
		2: "Rsa3072",
		3: "Rsa4096",
		4: "Aes256",
		5: "EdsaP256",
		6: "EdsaP384",
		7: "EdsaP521",
		8: "HMAC",
		9: "Ed25519",
	}
	KeyType_value = map[string]int32{
		"Unknown_KeyType": 0,
		"Rsa2048":         1,
		"Rsa3072":         2,
		"Rsa4096":         3,
		"Aes256":          4,
		"EdsaP256":        5,
		"EdsaP384":        6,
		"EdsaP521":        7,
		"HMAC":            8,
		"Ed25519":         9,
	}
)

func (x KeyType) Enum() *KeyType {
	p := new(KeyType)
	*p = x
	return p
}

func (x KeyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyType) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_enumTypes[1].Descriptor()
}

func (KeyType) Type() protoreflect.EnumType {
	return &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_enumTypes[1]
}

func (x KeyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyType.Descriptor instead.
func (KeyType) EnumDescriptor() ([]byte, []int) {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP(), []int{1}
}

type KeyEncoding int32

const (
	KeyEncoding_Unknown_KeyEncoding KeyEncoding = 0
	KeyEncoding_Pkix                KeyEncoding = 1
	KeyEncoding_Pkcs8               KeyEncoding = 2
	KeyEncoding_Bytes               KeyEncoding = 3
)

// Enum value maps for KeyEncoding.
var (
	KeyEncoding_name = map[int32]string{
		0: "Unknown_KeyEncoding",
		1: "Pkix",
		2: "Pkcs8",
		3: "Bytes",
	}
	KeyEncoding_value = map[string]int32{
		"Unknown_KeyEncoding": 0,
		"Pkix":                1,
		"Pkcs8":               2,
		"Bytes":               3,
	}
)

func (x KeyEncoding) Enum() *KeyEncoding {
	p := new(KeyEncoding)
	*p = x
	return p
}

func (x KeyEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_enumTypes[2].Descriptor()
}

func (KeyEncoding) Type() protoreflect.EnumType {
	return &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_enumTypes[2]
}

func (x KeyEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyEncoding.Descriptor instead.
func (KeyEncoding) EnumDescriptor() ([]byte, []int) {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP(), []int{2}
}

// KeyPurpose defines the cryptographic capabilities of a key.
type KeyPurpose int32

const (
	KeyPurpose_KeyPurpose_Unknown KeyPurpose = 0
	KeyPurpose_Encrypt            KeyPurpose = 1
	KeyPurpose_Decrypt            KeyPurpose = 2
	KeyPurpose_Sign               KeyPurpose = 3
	KeyPurpose_Verify             KeyPurpose = 4
	KeyPurpose_Wrap               KeyPurpose = 5
	KeyPurpose_Unwrap             KeyPurpose = 6
	KeyPurpose_MAC                KeyPurpose = 7
)

// Enum value maps for KeyPurpose.
var (
	KeyPurpose_name = map[int32]string{
		0: "KeyPurpose_Unknown",
		1: "Encrypt",
		2: "Decrypt",
		3: "Sign",
		4: "Verify",
		5: "Wrap",
		6: "Unwrap",
		7: "MAC",
	}
	KeyPurpose_value = map[string]int32{
		"KeyPurpose_Unknown": 0,
		"Encrypt":            1,
		"Decrypt":            2,
		"Sign":               3,
		"Verify":             4,
		"Wrap":               5,
		"Unwrap":             6,
		"MAC":                7,
	}
)

func (x KeyPurpose) Enum() *KeyPurpose {
	p := new(KeyPurpose)
	*p = x
	return p
}

func (x KeyPurpose) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyPurpose) Descriptor() protoreflect.EnumDescriptor {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_enumTypes[3].Descriptor()
}

func (KeyPurpose) Type() protoreflect.EnumType {
	return &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_enumTypes[3]
}

func (x KeyPurpose) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyPurpose.Descriptor instead.
func (KeyPurpose) EnumDescriptor() ([]byte, []int) {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP(), []int{3}
}

// WrapperConfig is the result of a call to SetConfig on a wrapper, returning
// relevant information about the wrapper and its updated configuration
type WrapperConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Metadata map[string]string `protobuf:"bytes,10,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *WrapperConfig) Reset() {
	*x = WrapperConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WrapperConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WrapperConfig) ProtoMessage() {}

func (x *WrapperConfig) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WrapperConfig.ProtoReflect.Descriptor instead.
func (*WrapperConfig) Descriptor() ([]byte, []int) {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP(), []int{0}
}

func (x *WrapperConfig) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// EnvelopeInfo contains the information necessary to perfom encryption or
// decryption in an envelope fashion
type EnvelopeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ciphertext is the ciphertext from the envelope
	// @gotags: class:"public"
	Ciphertext []byte `protobuf:"bytes,1,opt,name=ciphertext,proto3" json:"ciphertext,omitempty" class:"public"`
	// Key is the key used in the envelope
	// @gotags: class:"secret"
	Key []byte `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty" class:"secret"`
	// IV is the initialization value used during encryption in the envelope
	// @gotags: class:"secret"
	Iv []byte `protobuf:"bytes,3,opt,name=iv,proto3" json:"iv,omitempty" class:"secret"`
}

func (x *EnvelopeInfo) Reset() {
	*x = EnvelopeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvelopeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvelopeInfo) ProtoMessage() {}

func (x *EnvelopeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvelopeInfo.ProtoReflect.Descriptor instead.
func (*EnvelopeInfo) Descriptor() ([]byte, []int) {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP(), []int{1}
}

func (x *EnvelopeInfo) GetCiphertext() []byte {
	if x != nil {
		return x.Ciphertext
	}
	return nil
}

func (x *EnvelopeInfo) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *EnvelopeInfo) GetIv() []byte {
	if x != nil {
		return x.Iv
	}
	return nil
}

// BlobInfo contains information about the encrypted value along with
// information about the key used to encrypt it
type BlobInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ciphertext is the encrypted bytes
	// @gotags: class:"public"
	Ciphertext []byte `protobuf:"bytes,1,opt,name=ciphertext,proto3" json:"ciphertext,omitempty" class:"public"`
	// IV is the initialization value used during encryption
	// @gotags: class:"secret"
	Iv []byte `protobuf:"bytes,2,opt,name=iv,proto3" json:"iv,omitempty" class:"secret"`
	// HMAC is the bytes of the HMAC, if any
	// @gotags: class:"public"
	Hmac []byte `protobuf:"bytes,3,opt,name=hmac,proto3" json:"hmac,omitempty" class:"public"`
	// Wrapped can be used by the client to indicate whether Ciphertext actually
	// contains wrapped data or not. This can be useful if you want to reuse the
	// same struct to pass data along before and after wrapping. Deprecated in
	// favor of plaintext.
	//
	// Deprecated: Marked as deprecated in github.com.hashicorp.go.kms.wrapping.v2.types.proto.
	Wrapped bool `protobuf:"varint,4,opt,name=wrapped,proto3" json:"wrapped,omitempty"`
	// Plaintext can be used to allow the same struct to be used to pass data
	// along before and after (un)wrapping.
	// @gotags: class:"secret"
	Plaintext []byte `protobuf:"bytes,7,opt,name=plaintext,proto3" json:"plaintext,omitempty" class:"secret"`
	// KeyInfo contains information about the key that was used to create this value
	KeyInfo *KeyInfo `protobuf:"bytes,5,opt,name=key_info,json=keyInfo,proto3" json:"key_info,omitempty"`
	// ValuePath can be used by the client to store information about where the
	// value came from. Deprecated in favor of client_data.
	// @gotags: class:"public"
	//
	// Deprecated: Marked as deprecated in github.com.hashicorp.go.kms.wrapping.v2.types.proto.
	ValuePath string `protobuf:"bytes,6,opt,name=value_path,json=valuePath,proto3" json:"value_path,omitempty" class:"public"`
	// ClientData can be used by the client to store extra information, for
	// instance, the location/provenance of where an encrypted value came from
	// (useful for associating AAD to the encrypted value).
	ClientData *structpb.Struct `protobuf:"bytes,8,opt,name=client_data,json=clientData,proto3" json:"client_data,omitempty"`
}

func (x *BlobInfo) Reset() {
	*x = BlobInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BlobInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlobInfo) ProtoMessage() {}

func (x *BlobInfo) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlobInfo.ProtoReflect.Descriptor instead.
func (*BlobInfo) Descriptor() ([]byte, []int) {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP(), []int{2}
}

func (x *BlobInfo) GetCiphertext() []byte {
	if x != nil {
		return x.Ciphertext
	}
	return nil
}

func (x *BlobInfo) GetIv() []byte {
	if x != nil {
		return x.Iv
	}
	return nil
}

func (x *BlobInfo) GetHmac() []byte {
	if x != nil {
		return x.Hmac
	}
	return nil
}

// Deprecated: Marked as deprecated in github.com.hashicorp.go.kms.wrapping.v2.types.proto.
func (x *BlobInfo) GetWrapped() bool {
	if x != nil {
		return x.Wrapped
	}
	return false
}

func (x *BlobInfo) GetPlaintext() []byte {
	if x != nil {
		return x.Plaintext
	}
	return nil
}

func (x *BlobInfo) GetKeyInfo() *KeyInfo {
	if x != nil {
		return x.KeyInfo
	}
	return nil
}

// Deprecated: Marked as deprecated in github.com.hashicorp.go.kms.wrapping.v2.types.proto.
func (x *BlobInfo) GetValuePath() string {
	if x != nil {
		return x.ValuePath
	}
	return ""
}

func (x *BlobInfo) GetClientData() *structpb.Struct {
	if x != nil {
		return x.ClientData
	}
	return nil
}

// KeyInfo contains information regarding which Wrapper key was used to
// encrypt the entry
type KeyInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mechanism is the method used by the wrapper to encrypt and sign the
	// data as defined by the wrapper. (optional)
	Mechanism     uint64 `protobuf:"varint,1,opt,name=mechanism,proto3" json:"mechanism,omitempty"`
	HmacMechanism uint64 `protobuf:"varint,2,opt,name=hmac_mechanism,json=hmacMechanism,proto3" json:"hmac_mechanism,omitempty"`
	// This is an opaque ID used by the wrapper to identify the specific key to
	// use as defined by the wrapper. This could be a version, key label, or
	// something else. (optional)
	// @gotags: class:"public"
	KeyId string `protobuf:"bytes,3,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty" class:"public"`
	// @gotags: class:"public"
	HmacKeyId string `protobuf:"bytes,4,opt,name=hmac_key_id,json=hmacKeyId,proto3" json:"hmac_key_id,omitempty" class:"public"`
	// These value are used when generating our own data encryption keys
	// and encrypting them using the wrapper (optional)
	// @gotags: class:"secret"
	WrappedKey []byte `protobuf:"bytes,5,opt,name=wrapped_key,json=wrappedKey,proto3" json:"wrapped_key,omitempty" class:"secret"`
	// Mechanism specific flags (optional)
	Flags uint64 `protobuf:"varint,6,opt,name=flags,proto3" json:"flags,omitempty"`
	// The key type (optional)
	KeyType KeyType `protobuf:"varint,7,opt,name=key_type,json=keyType,proto3,enum=github.com.hashicorp.go.kms.wrapping.v2.types.KeyType" json:"key_type,omitempty"`
	// The key purposes (optional)
	KeyPurposes []KeyPurpose `protobuf:"varint,8,rep,packed,name=key_purposes,json=keyPurposes,proto3,enum=github.com.hashicorp.go.kms.wrapping.v2.types.KeyPurpose" json:"key_purposes,omitempty"`
	// plaintext key used when generating our own data encryption
	// keys (optional)
	// @gotags: class:"secret"
	Key []byte `protobuf:"bytes,9,opt,name=key,proto3" json:"key,omitempty" class:"secret"`
	// encoding of the key (optional)
	KeyEncoding KeyEncoding `protobuf:"varint,10,opt,name=key_encoding,json=keyEncoding,proto3,enum=github.com.hashicorp.go.kms.wrapping.v2.types.KeyEncoding" json:"key_encoding,omitempty"`
	// encoding of the wrapped_key (optional)
	WrappedKeyEncoding KeyEncoding `protobuf:"varint,11,opt,name=wrapped_key_encoding,json=wrappedKeyEncoding,proto3,enum=github.com.hashicorp.go.kms.wrapping.v2.types.KeyEncoding" json:"wrapped_key_encoding,omitempty"`
}

func (x *KeyInfo) Reset() {
	*x = KeyInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyInfo) ProtoMessage() {}

func (x *KeyInfo) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyInfo.ProtoReflect.Descriptor instead.
func (*KeyInfo) Descriptor() ([]byte, []int) {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP(), []int{3}
}

func (x *KeyInfo) GetMechanism() uint64 {
	if x != nil {
		return x.Mechanism
	}
	return 0
}

func (x *KeyInfo) GetHmacMechanism() uint64 {
	if x != nil {
		return x.HmacMechanism
	}
	return 0
}

func (x *KeyInfo) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

func (x *KeyInfo) GetHmacKeyId() string {
	if x != nil {
		return x.HmacKeyId
	}
	return ""
}

func (x *KeyInfo) GetWrappedKey() []byte {
	if x != nil {
		return x.WrappedKey
	}
	return nil
}

func (x *KeyInfo) GetFlags() uint64 {
	if x != nil {
		return x.Flags
	}
	return 0
}

func (x *KeyInfo) GetKeyType() KeyType {
	if x != nil {
		return x.KeyType
	}
	return KeyType_Unknown_KeyType
}

func (x *KeyInfo) GetKeyPurposes() []KeyPurpose {
	if x != nil {
		return x.KeyPurposes
	}
	return nil
}

func (x *KeyInfo) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *KeyInfo) GetKeyEncoding() KeyEncoding {
	if x != nil {
		return x.KeyEncoding
	}
	return KeyEncoding_Unknown_KeyEncoding
}

func (x *KeyInfo) GetWrappedKeyEncoding() KeyEncoding {
	if x != nil {
		return x.WrappedKeyEncoding
	}
	return KeyEncoding_Unknown_KeyEncoding
}

// Options holds options common to all wrappers
type Options struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key ID being specified
	// @gotags: class:"public"
	WithKeyId string `protobuf:"bytes,10,opt,name=with_key_id,json=withKeyId,proto3" json:"with_key_id,omitempty" class:"public"`
	// The AAD bytes, if any
	// @gotags: class:"secret"
	WithAad []byte `protobuf:"bytes,20,opt,name=with_aad,json=withAad,proto3" json:"with_aad,omitempty" class:"secret"`
	// @gotags: class:"secret"
	WithIv []byte `protobuf:"bytes,12,opt,name=with_iv,json=withIv,proto3" json:"with_iv,omitempty" class:"secret"`
	// Wrapper-specific configuration to pass along
	WithConfigMap map[string]string `protobuf:"bytes,30,rep,name=with_config_map,json=withConfigMap,proto3" json:"with_config_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The purposes of the key being specified
	WithKeyPurposes []KeyPurpose `protobuf:"varint,40,rep,packed,name=with_key_purposes,json=withKeyPurposes,proto3,enum=github.com.hashicorp.go.kms.wrapping.v2.types.KeyPurpose" json:"with_key_purposes,omitempty"`
	// The type of the key being specified
	WithKeyType KeyType `protobuf:"varint,50,opt,name=with_key_type,json=withKeyType,proto3,enum=github.com.hashicorp.go.kms.wrapping.v2.types.KeyType" json:"with_key_type,omitempty"`
	// optional bytes of entropy
	// @gotags: class:"secret"
	WithRandomBytes []byte `protobuf:"bytes,60,opt,name=with_random_bytes,json=withRandomBytes,proto3" json:"with_random_bytes,omitempty" class:"secret"`
	// encoding of the key
	WithKeyEncoding KeyEncoding `protobuf:"varint,70,opt,name=with_key_encoding,json=withKeyEncoding,proto3,enum=github.com.hashicorp.go.kms.wrapping.v2.types.KeyEncoding" json:"with_key_encoding,omitempty"`
	// encoding of the wrapped_key
	WithWrappedKeyEncoding KeyEncoding `protobuf:"varint,80,opt,name=with_wrapped_key_encoding,json=withWrappedKeyEncoding,proto3,enum=github.com.hashicorp.go.kms.wrapping.v2.types.KeyEncoding" json:"with_wrapped_key_encoding,omitempty"`
	WithDisallowEnvVars    bool        `protobuf:"varint,90,opt,name=with_disallow_env_vars,json=withDisallowEnvVars,proto3" json:"with_disallow_env_vars,omitempty"`
	// WithoutHmac specifies that an HMAC is not necessary for the mechanism, even if marked as "required"
	WithoutHmac bool `protobuf:"varint,100,opt,name=without_hmac,json=withoutHmac,proto3" json:"without_hmac,omitempty"`
}

func (x *Options) Reset() {
	*x = Options{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Options) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Options) ProtoMessage() {}

func (x *Options) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Options.ProtoReflect.Descriptor instead.
func (*Options) Descriptor() ([]byte, []int) {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP(), []int{4}
}

func (x *Options) GetWithKeyId() string {
	if x != nil {
		return x.WithKeyId
	}
	return ""
}

func (x *Options) GetWithAad() []byte {
	if x != nil {
		return x.WithAad
	}
	return nil
}

func (x *Options) GetWithIv() []byte {
	if x != nil {
		return x.WithIv
	}
	return nil
}

func (x *Options) GetWithConfigMap() map[string]string {
	if x != nil {
		return x.WithConfigMap
	}
	return nil
}

func (x *Options) GetWithKeyPurposes() []KeyPurpose {
	if x != nil {
		return x.WithKeyPurposes
	}
	return nil
}

func (x *Options) GetWithKeyType() KeyType {
	if x != nil {
		return x.WithKeyType
	}
	return KeyType_Unknown_KeyType
}

func (x *Options) GetWithRandomBytes() []byte {
	if x != nil {
		return x.WithRandomBytes
	}
	return nil
}

func (x *Options) GetWithKeyEncoding() KeyEncoding {
	if x != nil {
		return x.WithKeyEncoding
	}
	return KeyEncoding_Unknown_KeyEncoding
}

func (x *Options) GetWithWrappedKeyEncoding() KeyEncoding {
	if x != nil {
		return x.WithWrappedKeyEncoding
	}
	return KeyEncoding_Unknown_KeyEncoding
}

func (x *Options) GetWithDisallowEnvVars() bool {
	if x != nil {
		return x.WithDisallowEnvVars
	}
	return false
}

func (x *Options) GetWithoutHmac() bool {
	if x != nil {
		return x.WithoutHmac
	}
	return false
}

// SigInfo contains information about a cryptographic signature
type SigInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// KeyInfo contains information about the key that was used to create this value
	KeyInfo *KeyInfo `protobuf:"bytes,10,opt,name=key_info,json=keyInfo,proto3" json:"key_info,omitempty"`
	// Signature contains the bytes of the signature
	// @gotags: class:"public"
	Signature []byte `protobuf:"bytes,20,opt,name=signature,proto3" json:"signature,omitempty" class:"public"`
	// HmacType (optional) defines the hmac algorithm used
	HmacType *HmacType `protobuf:"varint,30,opt,name=hmac_type,json=hmacType,proto3,enum=github.com.hashicorp.go.kms.wrapping.v2.types.HmacType,oneof" json:"hmac_type,omitempty"`
}

func (x *SigInfo) Reset() {
	*x = SigInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SigInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SigInfo) ProtoMessage() {}

func (x *SigInfo) ProtoReflect() protoreflect.Message {
	mi := &file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SigInfo.ProtoReflect.Descriptor instead.
func (*SigInfo) Descriptor() ([]byte, []int) {
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP(), []int{5}
}

func (x *SigInfo) GetKeyInfo() *KeyInfo {
	if x != nil {
		return x.KeyInfo
	}
	return nil
}

func (x *SigInfo) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *SigInfo) GetHmacType() HmacType {
	if x != nil && x.HmacType != nil {
		return *x.HmacType
	}
	return HmacType_Unknown_HmacType
}

var File_github_com_hashicorp_go_kms_wrapping_v2_types_proto protoreflect.FileDescriptor

var file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x77, 0x72,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2d, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xb4, 0x01, 0x0a, 0x0d, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x66, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f,
	0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x3b, 0x0a, 0x0d,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x50, 0x0a, 0x0c, 0x45, 0x6e, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x69, 0x70,
	0x68, 0x65, 0x72, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x63,
	0x69, 0x70, 0x68, 0x65, 0x72, 0x74, 0x65, 0x78, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x76, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x69, 0x76, 0x22, 0xba, 0x02, 0x0a, 0x08,
	0x42, 0x6c, 0x6f, 0x62, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x69, 0x70, 0x68,
	0x65, 0x72, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x63, 0x69,
	0x70, 0x68, 0x65, 0x72, 0x74, 0x65, 0x78, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x76, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x69, 0x76, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6d, 0x61, 0x63,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x68, 0x6d, 0x61, 0x63, 0x12, 0x1c, 0x0a, 0x07,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x07, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x6c,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x70,
	0x6c, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x51, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x67, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x32, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0a, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x38,
	0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x22, 0xcc, 0x04, 0x0a, 0x07, 0x4b, 0x65, 0x79,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73,
	0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69,
	0x73, 0x6d, 0x12, 0x25, 0x0a, 0x0e, 0x68, 0x6d, 0x61, 0x63, 0x5f, 0x6d, 0x65, 0x63, 0x68, 0x61,
	0x6e, 0x69, 0x73, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0d, 0x68, 0x6d, 0x61, 0x63,
	0x4d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x12, 0x15, 0x0a, 0x06, 0x6b, 0x65, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6b, 0x65, 0x79, 0x49, 0x64,
	0x12, 0x1e, 0x0a, 0x0b, 0x68, 0x6d, 0x61, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x68, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x49, 0x64,
	0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x4b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x51, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x67, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x32, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5c, 0x0a, 0x0c, 0x6b, 0x65,
	0x79, 0x5f, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x39, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x77,
	0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4b, 0x65, 0x79, 0x50, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x52, 0x0b, 0x6b, 0x65, 0x79,
	0x50, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x5d, 0x0a, 0x0c, 0x6b, 0x65,
	0x79, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3a, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x77,
	0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x6b, 0x65,
	0x79, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x6c, 0x0a, 0x14, 0x77, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67,
	0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x32, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x12, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x45,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x22, 0xb8, 0x06, 0x0a, 0x07, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0b, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x77, 0x69, 0x74, 0x68, 0x4b, 0x65,
	0x79, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x61, 0x61, 0x64, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x77, 0x69, 0x74, 0x68, 0x41, 0x61, 0x64, 0x12, 0x17,
	0x0a, 0x07, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x69, 0x76, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x06, 0x77, 0x69, 0x74, 0x68, 0x49, 0x76, 0x12, 0x71, 0x0a, 0x0f, 0x77, 0x69, 0x74, 0x68, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x1e, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x49, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x77,
	0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x57, 0x69, 0x74, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x77, 0x69, 0x74,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x70, 0x12, 0x65, 0x0a, 0x11, 0x77, 0x69,
	0x74, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x73, 0x18,
	0x28, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x2e,
	0x6b, 0x6d, 0x73, 0x2e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x50, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65,
	0x52, 0x0f, 0x77, 0x69, 0x74, 0x68, 0x4b, 0x65, 0x79, 0x50, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65,
	0x73, 0x12, 0x5a, 0x0a, 0x0d, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x67, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x32, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0b, 0x77, 0x69, 0x74, 0x68, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a,
	0x11, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x77, 0x69, 0x74, 0x68, 0x52, 0x61,
	0x6e, 0x64, 0x6f, 0x6d, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x66, 0x0a, 0x11, 0x77, 0x69, 0x74,
	0x68, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x46,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x0f, 0x77, 0x69, 0x74, 0x68, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x12, 0x75, 0x0a, 0x19, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x50,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f,
	0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x16, 0x77, 0x69, 0x74, 0x68, 0x57, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x4b, 0x65, 0x79,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x33, 0x0a, 0x16, 0x77, 0x69, 0x74, 0x68,
	0x5f, 0x64, 0x69, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x65, 0x6e, 0x76, 0x5f, 0x76, 0x61,
	0x72, 0x73, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x77, 0x69, 0x74, 0x68, 0x44, 0x69,
	0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x77, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x77, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74, 0x48, 0x6d, 0x61, 0x63,
	0x1a, 0x40, 0x0a, 0x12, 0x57, 0x69, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61,
	0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xe3, 0x01, 0x0a, 0x07, 0x53, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x51,
	0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x77,
	0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x4b, 0x65, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x59, 0x0a, 0x09, 0x68, 0x6d, 0x61, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x1e, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x2e, 0x6b, 0x6d, 0x73,
	0x2e, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x32, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x2e, 0x48, 0x6d, 0x61, 0x63, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x08, 0x68,
	0x6d, 0x61, 0x63, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x68,
	0x6d, 0x61, 0x63, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2a, 0x50, 0x0a, 0x08, 0x48, 0x6d, 0x61, 0x63,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f,
	0x48, 0x6d, 0x61, 0x63, 0x54, 0x79, 0x70, 0x65, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x68,
	0x61, 0x32, 0x32, 0x34, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x68, 0x61, 0x32, 0x35, 0x36,
	0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x68, 0x61, 0x33, 0x38, 0x34, 0x10, 0x03, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x68, 0x61, 0x35, 0x31, 0x32, 0x10, 0x04, 0x2a, 0x92, 0x01, 0x0a, 0x07, 0x4b,
	0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77,
	0x6e, 0x5f, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x73, 0x61, 0x32, 0x30, 0x34, 0x38, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x73, 0x61, 0x33,
	0x30, 0x37, 0x32, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x73, 0x61, 0x34, 0x30, 0x39, 0x36,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x65, 0x73, 0x32, 0x35, 0x36, 0x10, 0x04, 0x12, 0x0c,
	0x0a, 0x08, 0x45, 0x64, 0x73, 0x61, 0x50, 0x32, 0x35, 0x36, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08,
	0x45, 0x64, 0x73, 0x61, 0x50, 0x33, 0x38, 0x34, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x64,
	0x73, 0x61, 0x50, 0x35, 0x32, 0x31, 0x10, 0x07, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x4d, 0x41, 0x43,
	0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x64, 0x32, 0x35, 0x35, 0x31, 0x39, 0x10, 0x09, 0x2a,
	0x46, 0x0a, 0x0b, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x17,
	0x0a, 0x13, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x4b, 0x65, 0x79, 0x45, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x6b, 0x69, 0x78, 0x10,
	0x01, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x6b, 0x63, 0x73, 0x38, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x10, 0x03, 0x2a, 0x73, 0x0a, 0x0a, 0x4b, 0x65, 0x79, 0x50, 0x75,
	0x72, 0x70, 0x6f, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x12, 0x4b, 0x65, 0x79, 0x50, 0x75, 0x72, 0x70,
	0x6f, 0x73, 0x65, 0x5f, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x65,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x69, 0x67, 0x6e, 0x10,
	0x03, 0x12, 0x0a, 0x0a, 0x06, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x10, 0x04, 0x12, 0x08, 0x0a,
	0x04, 0x57, 0x72, 0x61, 0x70, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x6e, 0x77, 0x72, 0x61,
	0x70, 0x10, 0x06, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x41, 0x43, 0x10, 0x07, 0x42, 0x32, 0x5a, 0x30,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2f, 0x67, 0x6f, 0x2d, 0x6b, 0x6d, 0x73, 0x2d, 0x77, 0x72, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x32, 0x3b, 0x77, 0x72, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescOnce sync.Once
	file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescData = file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDesc
)

func file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescGZIP() []byte {
	file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescOnce.Do(func() {
		file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescData = protoimpl.X.CompressGZIP(file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescData)
	})
	return file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDescData
}

var file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_goTypes = []interface{}{
	(HmacType)(0),           // 0: github.com.hashicorp.go.kms.wrapping.v2.types.HmacType
	(KeyType)(0),            // 1: github.com.hashicorp.go.kms.wrapping.v2.types.KeyType
	(KeyEncoding)(0),        // 2: github.com.hashicorp.go.kms.wrapping.v2.types.KeyEncoding
	(KeyPurpose)(0),         // 3: github.com.hashicorp.go.kms.wrapping.v2.types.KeyPurpose
	(*WrapperConfig)(nil),   // 4: github.com.hashicorp.go.kms.wrapping.v2.types.WrapperConfig
	(*EnvelopeInfo)(nil),    // 5: github.com.hashicorp.go.kms.wrapping.v2.types.EnvelopeInfo
	(*BlobInfo)(nil),        // 6: github.com.hashicorp.go.kms.wrapping.v2.types.BlobInfo
	(*KeyInfo)(nil),         // 7: github.com.hashicorp.go.kms.wrapping.v2.types.KeyInfo
	(*Options)(nil),         // 8: github.com.hashicorp.go.kms.wrapping.v2.types.Options
	(*SigInfo)(nil),         // 9: github.com.hashicorp.go.kms.wrapping.v2.types.SigInfo
	nil,                     // 10: github.com.hashicorp.go.kms.wrapping.v2.types.WrapperConfig.MetadataEntry
	nil,                     // 11: github.com.hashicorp.go.kms.wrapping.v2.types.Options.WithConfigMapEntry
	(*structpb.Struct)(nil), // 12: google.protobuf.Struct
}
var file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_depIdxs = []int32{
	10, // 0: github.com.hashicorp.go.kms.wrapping.v2.types.WrapperConfig.metadata:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.WrapperConfig.MetadataEntry
	7,  // 1: github.com.hashicorp.go.kms.wrapping.v2.types.BlobInfo.key_info:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.KeyInfo
	12, // 2: github.com.hashicorp.go.kms.wrapping.v2.types.BlobInfo.client_data:type_name -> google.protobuf.Struct
	1,  // 3: github.com.hashicorp.go.kms.wrapping.v2.types.KeyInfo.key_type:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.KeyType
	3,  // 4: github.com.hashicorp.go.kms.wrapping.v2.types.KeyInfo.key_purposes:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.KeyPurpose
	2,  // 5: github.com.hashicorp.go.kms.wrapping.v2.types.KeyInfo.key_encoding:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.KeyEncoding
	2,  // 6: github.com.hashicorp.go.kms.wrapping.v2.types.KeyInfo.wrapped_key_encoding:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.KeyEncoding
	11, // 7: github.com.hashicorp.go.kms.wrapping.v2.types.Options.with_config_map:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.Options.WithConfigMapEntry
	3,  // 8: github.com.hashicorp.go.kms.wrapping.v2.types.Options.with_key_purposes:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.KeyPurpose
	1,  // 9: github.com.hashicorp.go.kms.wrapping.v2.types.Options.with_key_type:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.KeyType
	2,  // 10: github.com.hashicorp.go.kms.wrapping.v2.types.Options.with_key_encoding:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.KeyEncoding
	2,  // 11: github.com.hashicorp.go.kms.wrapping.v2.types.Options.with_wrapped_key_encoding:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.KeyEncoding
	7,  // 12: github.com.hashicorp.go.kms.wrapping.v2.types.SigInfo.key_info:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.KeyInfo
	0,  // 13: github.com.hashicorp.go.kms.wrapping.v2.types.SigInfo.hmac_type:type_name -> github.com.hashicorp.go.kms.wrapping.v2.types.HmacType
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_init() }
func file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_init() {
	if File_github_com_hashicorp_go_kms_wrapping_v2_types_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WrapperConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnvelopeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BlobInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Options); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SigInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes[5].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_goTypes,
		DependencyIndexes: file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_depIdxs,
		EnumInfos:         file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_enumTypes,
		MessageInfos:      file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_msgTypes,
	}.Build()
	File_github_com_hashicorp_go_kms_wrapping_v2_types_proto = out.File
	file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_rawDesc = nil
	file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_goTypes = nil
	file_github_com_hashicorp_go_kms_wrapping_v2_types_proto_depIdxs = nil
}
