/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright CANON INC. 2010
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "combo.h"

void
on_combo_changed     (GtkComboBox		*combobox,
                                        gpointer         user_data)
{
	CombData *data;
	data = (CombData *)user_data;
	if(TRUE == SigDisable()){
		if(data != NULL){
			UpdateDataCombo(data->id, data->widget_name);
		}
	}
	SigEnable();
}

void ConnectComboSignal(GtkBuilder *xml, cngplpData* data, gpointer *widget)
{
	GtkWidget *combo;
	CombData *user_data;
	SignalInfo *signal;
	char *signal_name;
	WidgetInfo *widget_combo = (WidgetInfo *)widget;

	if((widget_combo != NULL) && (widget_combo->name != NULL)){
		combo = GetWidgetFromXml(xml, widget_combo->name);
		user_data = (CombData * )malloc(sizeof(CombData));
		widget_combo->data = user_data;
		if((combo != NULL) && (user_data != NULL)){
			memset(user_data, 0, sizeof(CombData));
			signal = widget_combo->signal_list;
			if(signal != NULL){
				user_data->id = GetModID(signal->id);
			}
			user_data->widget_name = widget_combo->name;
			while(signal != NULL){
				signal_name = signal->name;
				if(signal_name != NULL){
					if(strcmp(signal_name, "changed") == 0){
						g_signal_connect ((gpointer)(GTK_COMBO_BOX_TEXT(combo)), "changed", G_CALLBACK (on_combo_changed), user_data);
					}
				}
				signal = signal->next;
			}
		}
	}
}

void ComboSpecialFunction(cngplpData *data, const char *widget_name)
{
	char *opt = NULL, *opt1 = NULL;
	if(0 == strcmp(widget_name, "SaddleSetting_combo")){
		SetWidgetSensitive("TrimWidth_grid", FALSE);
		opt = GetCurrOpt(data, ID_CNADJUSTTRIM, NULL);
		if(opt != NULL){
			if(0 == strcasecmp(opt, "Manual")){
				opt1 = GetCurrOpt(data, ID_CNTRIMMING, NULL);
				if(opt1 != NULL){
					if(0 == strcmp(opt1, "True")){
						SetWidgetSensitive("TrimWidth_grid", TRUE);
					}
					memFree(opt1);
				}
			}
			memFree(opt);
		}

	}
}
