#pragma once

#include <string_view>
#include <string>
#include <cstddef>
#include <unordered_map>

namespace gamescope
{
    struct StringHash
    {
        using is_transparent = void;
        [[nodiscard]] size_t operator()( const char *string )        const { return std::hash<std::string_view>{}( string ); }
        [[nodiscard]] size_t operator()( std::string_view string )   const { return std::hash<std::string_view>{}( string ); }
        [[nodiscard]] size_t operator()( const std::string &string ) const { return std::hash<std::string>{}( string ); }
    };

    template <typename T>
    using Dict = std::unordered_map<std::string, T, StringHash, std::equal_to<>>;

    template <typename T>
    using MultiDict = std::unordered_multimap<std::string, T, StringHash, std::equal_to<>>;
}
