/* $Id: barnyard.h,v 1.33 2004/05/01 16:43:29 andrewbaker Exp $ */
/*
** Copyright (C) 2001-2002 Andrew R. Baker <andrewb@snort.org>
** Copyright (C) 2001 Martin Roesch <roesch@sourcefire.com>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

#ifndef __BARNYARD_H__
#define __BARNYARD_H__

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>

#include "config.h"
#include "event.h"
#include "ProgVars.h"

#define SNORT_MAGIC     0xa1b2c3d4
#define SNORT_VERSION_MAJOR   1
#define SNORT_VERSION_MINOR   2

#define PROGRAM_NAME "barnyard"
#define BUILD    "32"

extern ProgVars pv;

typedef struct _SnortPktHeader
{
    struct timeval ts;     /* packet timestamp */
    u_int32_t caplen;      /* packet capture length */
    u_int32_t pktlen;      /* packet "real" length */
} SnortPktHeader;

void CleanExit(int);
void CleanRestart();
int BarnyardSleep(unsigned int);

#endif  /* __BARNYARD_H__ */
