/*
 * qdbm.h - qdbm interface
 *
 *   Copyright (c) 2003 Kimura Fuyuki, All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *   3. Neither the name of the authors nor the names of its contributors
 *      may be used to endorse or promote products derived from this
 *      software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  $Id: qdbm.h,v 1.1.1.1 2003/10/22 05:35:35 fuyuki Exp $
 */

#include <gauche/extend.h>
#include <gauche/class.h>

#include <depot.h>
#include <stdlib.h>

typedef struct ScmQdbmDepotRec {
  SCM_HEADER;
  ScmObj name;
  DEPOT *depot; /* NULL if closed */
} ScmQdbmDepot;

SCM_CLASS_DECL(Scm_QdbmDepotClass);
#define SCM_CLASS_QDBM_DEPOT (&Scm_QdbmDepotClass)
#define SCM_QDBM_DEPOT(obj) ((ScmQdbmDepot*)(obj))
#define SCM_QDBM_DEPOT_P(obj) (SCM_XTYPEP(obj, SCM_CLASS_QDBM_DEPOT))

extern void Scm_Init_depot(ScmModule *module);
