/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.EagerPullEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;

public abstract class PullElaborator
extends Elaborator {
    @Override
    public abstract PullEvaluator elaborateForPull();

    @Override
    public SequenceEvaluator eagerly() {
        PullEvaluator pull = this.elaborateForPull();
        return new EagerPullEvaluator(pull);
    }

    @Override
    public PushEvaluator elaborateForPush() {
        PullEvaluator pull = this.elaborateForPull();
        return (out, context) -> {
            try {
                Item it;
                SequenceIterator iter = pull.iterate(context);
                while ((it = iter.next()) != null) {
                    out.append(it);
                }
                return null;
            }
            catch (UncheckedXPathException err) {
                throw err.getXPathException();
            }
        };
    }

    @Override
    public ItemEvaluator elaborateForItem() {
        PullEvaluator pull = this.elaborateForPull();
        return context -> {
            try {
                return pull.iterate(context).next();
            }
            catch (UncheckedXPathException err) {
                throw err.getXPathException();
            }
        };
    }

    @Override
    public BooleanEvaluator elaborateForBoolean() {
        PullEvaluator pull = this.elaborateForPull();
        return context -> {
            try {
                return ExpressionTool.effectiveBooleanValue(pull.iterate(context));
            }
            catch (UncheckedXPathException err) {
                throw err.getXPathException();
            }
        };
    }

    @Override
    public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
        ItemEvaluator ie = this.elaborateForItem();
        return context -> {
            Item item = ie.eval(context);
            return item == null ? this.handleNullUnicodeString(zeroLengthWhenAbsent) : item.getUnicodeStringValue();
        };
    }
}

