-- $Id: biosqldb-views-pg.sql 261 2008-02-22 01:12:19Z lapp $
--
-- Copyright 2002-2003 Christopher Mungall
-- Copyright 2008 Hilmar Lapp 
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--
-- ========================================================================
--
-- THIS FILE IS EXPERIMENTAL; SOME OR ALL OF THESE COULD CHANGE

CREATE VIEW seqfeature_key_v
 AS SELECT f.*, t.name AS key_name 
    FROM seqfeature f, term t 
    WHERE f.type_term_id = t.term_id;

CREATE OR REPLACE VIEW gff
 AS SELECT e.accession       AS fref, 
           fl.start_pos      AS fstart, 
           fl.end_pos        AS fend,
           k.name            AS type, 
           NULL::float       AS fscore,
           fl.strand         AS fstrand, 
           NULL::smallint    AS fphase,
           f.seqfeature_id   AS gid
    FROM seqfeature f, 
         term k, 
         location fl,
         bioentry e
    WHERE f.type_term_id = k.term_id  AND
          fl.seqfeature_id = f.seqfeature_id        AND
          f.bioentry_id    = e.bioentry_id;

--- basic fasta view; we may have others where we
--- cram more into header
CREATE VIEW fasta
  AS SELECT '>'                        ||
            e.name                     ||
            ' '                        ||
            e.description              AS header,
            s.seq                      AS residues
  FROM bioentry e,
       biosequence s
  WHERE e.bioentry_id = s.bioentry_id;

--- fasta with length of seq appended
CREATE VIEW fasta_withlen
  AS SELECT fasta.header               || 
            ' length:'                 ||
            length(residues)           AS header,
            residues
  FROM fasta;

---
CREATE VIEW embl_FT
 AS SELECT fl.start_pos      ||
           '..'              ||
           fl.end_pos        AS floc,
           k.name            AS ftype, 
           qt.name           AS qterm,
           q.value AS qval
    FROM seqfeature f, 
         term k, 
         term qt, 
         location fl,
         bioentry e,
         seqfeature_qualifier_value q
    WHERE k.term_id = f.type_term_id  AND
          qt.term_id = q.term_id AND
          fl.seqfeature_id = f.seqfeature_id        AND
          f.bioentry_id    = e.bioentry_id;


--- this should probably be autogenerated by
--- an ontology of mappings
CREATE VIEW embl
  AS SELECT e.name                     AS ID,
            e.accession                AS AC,
            e.accession || 
            ' '         || 
            e.version                  AS SV
  FROM bioentry e;

--DROP FUNCTION compl(text);
CREATE FUNCTION compl(text) RETURNS text AS
 'SELECT (translate($1, ''acgtukmryACGTUKMRY'', ''tgcaamkyrTGCAAMKYR'')) as RESULT;'
LANGUAGE 'sql';

-- DROP FUNCTION reverse(text);
CREATE FUNCTION reverse(text) RETURNS text AS
$$
DECLARE
        arr CHAR(1)[];
        ans CHAR(1)[];
        l INTEGER;
BEGIN
        l := length($1);
        arr := string_to_array(rtrim(regexp_replace($1,'(.)','\\1,','g'),
                                     ','),
                               ',');
        ans := arr;
        FOR i IN 1..l LOOP
                ans[l-i+1] := arr[i];
        END LOOP;
        RETURN array_to_string(ans,'');
END; 
$$ LANGUAGE 'plpgsql';

--- doesn't do reverse comp yet
--DROP FUNCTION get_subseq(text,int,int,int);
CREATE FUNCTION get_subseq (text, int, int, int)
  RETURNS text
  AS 'BEGIN
        IF $4 > 0 THEN
          return (select 
                   substring($1,
                      $2,
                     ($3 - $2)+1));
        ELSE
           return NULL;
        END IF;
     END;
     '
  LANGUAGE 'plpgsql';

CREATE OR REPLACE VIEW gffseq
 AS SELECT e.accession       AS fref, 
           fl.start_pos      AS fstart, 
           fl.end_pos        AS fend,
           k.name            AS type, 
           NULL::float       AS fscore,
           fl.strand         AS fstrand, 
           NULL::smallint    AS fphase,
           f.seqfeature_id   AS gid,
           get_subseq(s.seq,
                      fl.start_pos,
                      fl.end_pos,
                      fl.strand)
                             AS subseq
    FROM seqfeature f, 
         term k, 
         location fl,
         bioentry e,
         biosequence s
    WHERE f.type_term_id = k.term_id AND
          fl.seqfeature_id    = f.seqfeature_id        AND
          f.bioentry_id       = e.bioentry_id          AND
          f.bioentry_id       = s.bioentry_id;

--- these are autogenerated:

CREATE VIEW f_source AS
  SELECT * from seqfeature_key_v WHERE key_name = 'source';
CREATE VIEW f_misc_feature AS
  SELECT * from seqfeature_key_v WHERE key_name = 'misc_feature';
CREATE VIEW f_sig_peptide AS
  SELECT * from seqfeature_key_v WHERE key_name = 'sig_peptide';
CREATE VIEW f_CDS AS
  SELECT * from seqfeature_key_v WHERE key_name = 'CDS';
CREATE VIEW f_gene AS
  SELECT * from seqfeature_key_v WHERE key_name = 'gene';
CREATE VIEW f_mat_peptide AS
  SELECT * from seqfeature_key_v WHERE key_name = 'mat_peptide';
CREATE VIEW f_variation AS
  SELECT * from seqfeature_key_v WHERE key_name = 'variation';
CREATE VIEW f_exon AS
  SELECT * from seqfeature_key_v WHERE key_name = 'exon';
CREATE VIEW f_intron AS
  SELECT * from seqfeature_key_v WHERE key_name = 'intron';

