/* ------------------------------------------------------------------------
 *
 * server_tipc.c
 *
 * Short description: TIPC hello world demo (server side)
 * ------------------------------------------------------------------------
 *
 * Copyright (c) 2003, Ericsson Research Canada
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of Ericsson Research Canada nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * ------------------------------------------------------------------------
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <linux/tipc.h>

#ifndef TIPC_SERVICE_ADDR
#define TIPC_SERVICE_ADDR 2
#endif
#define SERVER_TYPE  18888
#define SERVER_INST  17
#define BUF_SIZE 40

int main(int argc, char *argv[])
{
	struct sockaddr_tipc server = {
		.family = AF_TIPC,
		.addrtype = TIPC_SERVICE_ADDR,
		.scope = TIPC_CLUSTER_SCOPE,
		.addr.name.name.type = SERVER_TYPE,
		.addr.name.name.instance = SERVER_INST
	};
	struct sockaddr_tipc client;
	socklen_t alen = sizeof(client);
	char inbuf[BUF_SIZE];
	char outbuf[BUF_SIZE] = "Uh ?";
	int sd;

	printf("****** TIPC hello world server started ******\n");

	sd = socket(AF_TIPC, SOCK_RDM, 0);

	if (0 != bind(sd, (void*)&server, sizeof(server))) {
		printf("Server: failed to bind port name\n");
		exit(1);
	}

	if (0 >= recvfrom(sd, inbuf, sizeof(inbuf), 0,
	                  (struct sockaddr *)&client, &alen)) {
		perror("Server: unexpected message");
	}
	printf("Server: Message received: %s \n", inbuf);

	if (0 > sendto(sd, outbuf, strlen(outbuf) + 1, 0, (void*)&client, sizeof(client))) {
		perror("Server: failed to send");
	}
	printf("Server: Sent response : %s \n", outbuf);
	printf("****** TIPC hello world server finished ******\n");

	exit(0);
}
