/***************************************************************************
    input.c  -  description
    -------------------
    begin                : Sun Feb 23 2003
    copyright            : (C) 2003 by Samuel E. Bray
    email                : aristoidaneel@yahoo.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* RCS: */
/* $Id: input.c,v 1.1 2003/03/03 03:16:24 root Exp root $ */
/* $Log: input.c,v $
 * Revision 1.1  2003/03/03 03:16:24  root
 * Initial revision
 * */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>

#include "joytest.h"
#include "input.h"
#include "init_quit.h"

void HandleKeyPress (SDL_keysym *keysym, SDL_Joystick *joystick)
{
  switch (keysym->sym)
    {
    case SDLK_q:
    case SDLK_ESCAPE:
      Quit (0);
      break;
    case SDLK_F1:
      SDL_WM_ToggleFullScreen(screen);
      SetGLWindow(screenWidth, screenHeight);
      break;
    case SDLK_1:
      axisPair = 0;
      break;
    case SDLK_2:
      if(SDL_JoystickNumAxes(joystick) > 2) /* check to make sure there are enough axies */
	  axisPair = 1;
      else
	  fprintf(stderr,"Not enough axies.\n");
      break;
    default:
      break;
    }
}
/*** End HandleKeyPress() ***/

void HandleJoyAxis(SDL_Event *event)
{
  /* use these 'if' statements to filter out
   * joystick noise (a deadzone) */

  if((event->jaxis.value > (-deadZone)) && (event->jaxis.value < deadZone))
    {
      if(event->jaxis.axis == 0)
	aimer.x = joyXCenter;
      if(event->jaxis.axis == 1)
	aimer.y = joyYCenter;
    }

  if((event->jaxis.value < (-deadZone)) || (event->jaxis.value > deadZone))
    {
      switch (event->jaxis.axis)
	{
	case 0:
	  if(axisPair == 0)
	    {
	      aimer.x = (event->jaxis.value / screenUnitX) + joyXCenter;
	      if(aimer.x > screenWidth+pad)
		aimer.x = 0;
	      if(aimer.x < 0-pad)
		aimer.x = screenWidth;
	    }
	  break;
	case 1:
	  if(axisPair == 0)
	    {
	      aimer.y = (event->jaxis.value / screenUnitY) + joyYCenter;
	      if(aimer.y > screenHeight+pad)
		aimer.y = 0;
	      if(aimer.y < 0-pad)
		aimer.y = screenHeight;
	    }
	  break;
	case 2:
	  /* ** ** ToDo: Add an animated slider to represent! ** ** */
	  if(axisPair == 1)
	    {
	      aimer.x = (event->jaxis.value / screenUnitX) + joyXCenter;
	      if(aimer.x > screenWidth+pad)
		aimer.x = 0;
	      if(aimer.x < 0-pad)
		aimer.x = screenWidth;
	    }
	  break;
	case 3:
	  /* ** ** ToDo: Same as above ** ** */
	  if(axisPair == 1)
	    {
	      aimer.y = (event->jaxis.value / screenUnitY) + joyYCenter;
	      if(aimer.y > screenHeight+pad)
		aimer.y = 0;
	      if(aimer.y < 0-pad)
		aimer.y = screenHeight;
	    }
	  break;
	default:
	  break;
	}
    }
}
