;;
;; test for cdb module
;;

(use gauche.test)
(use file.util)

(test-start "cdb")

(if (member "." *load-path*) ;; trick to allow in-place test
  (load "cdb"))
(import dbm.cdb)
(test-module 'dbm.cdb)

(define cdb-make (cdb-make-open "test.cdb"))
(test* "cdb-make-add" 0 (cdb-make-add cdb-make "alpha" "omega"))
(test* "cdb-make-add" 0 (cdb-make-add cdb-make "aleph" "tav"))
(test* "cdb-make-put" 0 (cdb-make-put cdb-make "alpha" "aiueo" CDB_PUT_ADD))
(test* "cdb-make-put" 1 (cdb-make-put cdb-make "aleph" "aiueo" CDB_PUT_INSERT))
(test* "cdb-closed?" #f (cdb-closed? cdb-make))
(cdb-close cdb-make)
(test* "cdb-closed?" #t (cdb-closed? cdb-make))

(define cdb (cdb-open "test.cdb"))
(test* "cdb-find" 1 (cdb-find cdb "alpha"))
(test* "cdb-read" "omega" (cdb-read cdb (cdb-datalen cdb) (cdb-datapos cdb)))
(test* "cdb-findinit" #t (integer? (cdb-findinit cdb "alpha")))
(test* "cdb-findnext" 1 (cdb-findnext cdb))
(test* "cdb-read" "omega" (cdb-read cdb (cdb-datalen cdb) (cdb-datapos cdb)))
(test* "cdb-findnext" 1 (cdb-findnext cdb))
(test* "cdb-read" "aiueo" (cdb-read cdb (cdb-datalen cdb) (cdb-datapos cdb)))
(test* "cdb-find" 1 (cdb-find cdb "aleph"))
(test* "cdb-read" "tav" (cdb-read cdb (cdb-datalen cdb) (cdb-datapos cdb)))
(test* "cdb-closed?" #f (cdb-closed? cdb))
(cdb-close cdb)
(test* "cdb-closed?" #t (cdb-closed? cdb))

(sys-unlink "test.cdb")

(define db (dbm-open <cdb> :path "test.cdb" :rw-mode :create :file-mode #o600))
(dbm-put! db "alpha" "omega")
(test* "dbm-exists?" #t (dbm-exists? db "alpha"))
(test* "dbm-exists?" #f (dbm-exists? db "aiueo"))
(dbm-put! db "aleph" "tav")
(test* "dbm-closed?" #f (dbm-closed? db))
(dbm-close db)
(test* "dbm-closed?" #t (dbm-closed? db))

(define db (dbm-open <cdb> :path "test.cdb" :rw-mode :read))
(test* "dbm-get" "omega" (dbm-get db "alpha"))
(test* "dbm-exists?" #t (dbm-exists? db "alpha"))
(test* "dbm-exists?" #f (dbm-exists? db "aiueo"))
(test* "dbm-fold" 2 (dbm-fold db (lambda (k v r) (+ r 1)) 0))
(test* "dbm-fold" '(("aleph" . "tav") ("alpha" . "omega")) (dbm-fold db acons '()))
(test* "dbm-closed?" #f (dbm-closed? db))
(dbm-close db)
(test* "dbm-closed?" #t (dbm-closed? db))

(sys-unlink "test.cdb")

(test-end)
