#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
#include <Imlib.h>
#include <stdlib.h>

    Display *disp;
    ImlibData *id;
    XSetWindowAttributes attr;
    ImlibImage *im;
    Pixmap p,m;
    Window root;
    int w,h;
    float x=0, y=0;
    GC gc;
    XGCValues gcv;
    Screen *scr;
    int screen;


void
refresh_bg(float radius, float speed) {
      XSetTSOrigin(disp, gc, (int)radius*sin(2*y),(int)radius*cos(x+1));
      XFillRectangle(disp, m, gc, 0, 0, scr->width, scr->height);
      XSetWindowBackgroundPixmap(disp, root, m);
      XClearWindow(disp, root);
      
      /* Synchronise with the Xserver */
      XSync(disp, False);
      y = y +(1/radius)*speed;
      x = x +(1/radius)*speed;

}

int init_bg_window ( char *imagename)
{

      
    /* Connect to the default Xserver */
    disp = XOpenDisplay(NULL);
    root = RootWindow(disp,0);
    screen = DefaultScreen(disp);
    scr = ScreenOfDisplay(disp, screen);

    /* init Imlib */
    id = Imlib_init(disp);

    /* Load the image specified as the first argument */
    im = Imlib_load_image(id,imagename);

    /* Suck the image's original width and height out of the Image structure */
    w = im->rgb_width;
    h = im->rgb_height;

    /* Render the original 24-bit Image data into a pixmap of size w * h */
    Imlib_render(id,im,w,h);
    
    /* Extract the Image and mask pixmaps from the Image */
    p = Imlib_move_image(id,im);
    m = XCreatePixmap(disp, root, scr->width, scr->height, DefaultDepth(disp, screen));
    gc = XCreateGC(disp, m, 0, &gcv);
    XSetTile(disp, gc, p);
    XSetFillStyle(disp, gc, FillTiled);
    return (1);
}







