import { Span, SpanTimeInput, StartSpanOptions } from '@sentry/types';
/**
 * Checks if a given value is a valid measurement value.
 */
export declare function isMeasurementValue(value: unknown): value is number;
/**
 * Helper function to start child on transactions. This function will make sure that the transaction will
 * use the start timestamp of the created child span if it is earlier than the transactions actual
 * start timestamp.
 */
export declare function startAndEndSpan(parentSpan: Span, startTimeInSeconds: number, endTime: SpanTimeInput, { ...ctx }: StartSpanOptions): Span | undefined;
/** Get the browser performance API. */
export declare function getBrowserPerformanceAPI(): Performance | undefined;
/**
 * Converts from milliseconds to seconds
 * @param time time in ms
 */
export declare function msToSec(time: number): number;
//# sourceMappingURL=utils.d.ts.map
