/*
 * Decompiled with CFR 0.152.
 */
package geny;

import geny.Generator$;
import geny.Generator$Continue$;
import geny.Generator$End$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public interface Generator<A> {
    public static <T> Generator<T> apply(Seq<T> seq) {
        return Generator$.MODULE$.apply(seq);
    }

    public static <M, T> Generator<T> from(Object object, Function1<Object, IterableOnce<T>> function1) {
        return Generator$.MODULE$.from(object, function1);
    }

    public static <T> Generator<T> selfClosing(Function0<Tuple2<Iterator<T>, Function0<BoxedUnit>>> function0) {
        return Generator$.MODULE$.selfClosing(function0);
    }

    public Action generate(Function1<A, Action> var1);

    public static void foreach$(Generator $this, Function1 f) {
        $this.foreach(f);
    }

    default public void foreach(Function1<A, BoxedUnit> f) {
        this.generate((Function1<Object, Action> & Serializable)x -> {
            f.apply(x);
            return Generator$Continue$.MODULE$;
        });
    }

    public static Option find$(Generator $this, Function1 f) {
        return $this.find(f);
    }

    default public Option<A> find(Function1<A, Object> f) {
        ObjectRef<None$> result = ObjectRef.create(None$.MODULE$);
        this.generate((Function1<Object, Action> & Serializable)t -> {
            if (!BoxesRunTime.unboxToBoolean(f.apply(t))) {
                return Generator$Continue$.MODULE$;
            }
            Some some = Some$.MODULE$.apply(t);
            result$1.elem = some;
            some = null;
            return Generator$End$.MODULE$;
        });
        return (Option)result.elem;
    }

    public static boolean exists$(Generator $this, Function1 f) {
        return $this.exists(f);
    }

    default public boolean exists(Function1<A, Object> f) {
        return this.find(f).isDefined();
    }

    public static boolean contains$(Generator $this, Object a) {
        return $this.contains(a);
    }

    default public boolean contains(Object a) {
        return this.exists((Function1<Object, boolean> & Serializable)_$2 -> BoxesRunTime.equals(_$2, a));
    }

    public static boolean forall$(Generator $this, Function1 f) {
        return $this.forall(f);
    }

    default public boolean forall(Function1<A, Object> f) {
        return !this.exists((Function1<Object, boolean> & Serializable)_$3 -> !BoxesRunTime.unboxToBoolean(f.apply(_$3)));
    }

    public static int count$(Generator $this, Function1 f) {
        return $this.count(f);
    }

    default public int count(Function1<A, Object> f) {
        IntRef result = IntRef.create(0);
        this.generate((Function1<Object, Action> & Serializable)t -> {
            if (BoxesRunTime.unboxToBoolean(f.apply(t))) {
                int n;
                result$2.elem = n = result$2.elem + 1;
            }
            return Generator$Continue$.MODULE$;
        });
        return result.elem;
    }

    public static Function1 count$default$1$(Generator $this) {
        return $this.count$default$1();
    }

    default public Function1<A, Object> count$default$1() {
        return (Function1<Object, boolean> & Serializable)_$4 -> true;
    }

    public static Object fold$(Generator $this, Object start, Function2 f) {
        return $this.fold(start, f);
    }

    default public <B> B fold(B start, Function2<B, A, B> f) {
        return this.foldLeft(start, f);
    }

    public static Object foldLeft$(Generator $this, Object start, Function2 f) {
        return $this.foldLeft(start, f);
    }

    default public <B> B foldLeft(B start, Function2<B, A, B> f) {
        ObjectRef<B> result = ObjectRef.create(start);
        this.generate((Function1<Object, Action> & Serializable)t -> {
            Object object = f.apply(result$3.elem, t);
            result$3.elem = object;
            object = null;
            return Generator$Continue$.MODULE$;
        });
        return (B)result.elem;
    }

    public static Object reduce$(Generator $this, Function2 f) {
        return $this.reduce(f);
    }

    default public <B> B reduce(Function2<B, A, B> f) {
        return this.reduceLeft(f);
    }

    public static Object reduceLeft$(Generator $this, Function2 f) {
        return $this.reduceLeft(f);
    }

    default public <B> B reduceLeft(Function2<B, A, B> f) {
        ObjectRef<None$> result = ObjectRef.create(None$.MODULE$);
        this.generate((Function1<Object, Action> & Serializable)t -> {
            Some some;
            Option option = (Option)result$4.elem;
            if (None$.MODULE$.equals(option)) {
                some = Some$.MODULE$.apply(t);
            } else if (option instanceof Some) {
                Object old = ((Some)option).value();
                some = Some$.MODULE$.apply(f.apply(old, t));
            } else {
                throw new MatchError(option);
            }
            Some some2 = some;
            result$4.elem = some2;
            some2 = null;
            return Generator$Continue$.MODULE$;
        });
        return ((Option)result.elem).getOrElse(Generator::reduceLeft$$anonfun$2);
    }

    public static Generator filter$(Generator $this, Function1 pred) {
        return $this.filter(pred);
    }

    default public Generator<A> filter(Function1<A, Object> pred) {
        return new Filtered<A>(this, pred);
    }

    public static Generator withFilter$(Generator $this, Function1 pred) {
        return $this.withFilter(pred);
    }

    default public Generator<A> withFilter(Function1<A, Object> pred) {
        return new Filtered<A>(this, pred);
    }

    public static Generator map$(Generator $this, Function1 func) {
        return $this.map(func);
    }

    default public <B> Generator<B> map(Function1<A, B> func) {
        return new Mapped<B, A>(this, func);
    }

    public static Generator flatMap$(Generator $this, Function1 func) {
        return $this.flatMap(func);
    }

    default public <B> Generator<B> flatMap(Function1<A, Generator<B>> func) {
        return new FlatMapped<B, A>(this, func);
    }

    public static Generator collect$(Generator $this, PartialFunction func) {
        return $this.collect(func);
    }

    default public <B> Generator<B> collect(PartialFunction<A, B> func) {
        return this.filter((Function1<Object, boolean> & Serializable)x -> func.isDefinedAt(x)).map(func);
    }

    public static Option collectFirst$(Generator $this, PartialFunction func) {
        return $this.collectFirst(func);
    }

    default public <B> Option<B> collectFirst(PartialFunction<A, B> func) {
        return this.filter((Function1<Object, boolean> & Serializable)x -> func.isDefinedAt(x)).map(func).headOption();
    }

    public static Generator flatten$(Generator $this, Function1 f) {
        return $this.flatten(f);
    }

    default public <V> Generator<V> flatten(Function1<A, Generator<V>> f) {
        return this.flatMap(f);
    }

    public static Generator slice$(Generator $this, int start, int end) {
        return $this.slice(start, end);
    }

    default public Generator<A> slice(int start, int end) {
        return new Sliced(this, start, end);
    }

    public static Generator grouped$(Generator $this, int size2) {
        return $this.grouped(size2);
    }

    default public Generator<Iterable<A>> grouped(int size2) {
        return this.sliding(size2, size2);
    }

    public static Generator sliding$(Generator $this, int size2, int step) {
        return $this.sliding(size2, step);
    }

    default public Generator<Iterable<A>> sliding(int size2, int step) {
        Predef$.MODULE$.require(size2 >= 1 && step >= 1, () -> Generator.sliding$$anonfun$1(size2, step));
        return new Sliding(this, size2, step);
    }

    public static Generator take$(Generator $this, int n) {
        return $this.take(n);
    }

    default public Generator<A> take(int n) {
        return this.slice(0, n);
    }

    public static Generator drop$(Generator $this, int n) {
        return $this.drop(n);
    }

    default public Generator<A> drop(int n) {
        return this.slice(n, Integer.MAX_VALUE);
    }

    public static Generator takeWhile$(Generator $this, Function1 pred) {
        return $this.takeWhile(pred);
    }

    default public Generator<A> takeWhile(Function1<A, Object> pred) {
        return new TakeWhile<A>(this, pred);
    }

    public static Generator dropWhile$(Generator $this, Function1 pred) {
        return $this.dropWhile(pred);
    }

    default public Generator<A> dropWhile(Function1<A, Object> pred) {
        return new DropWhile<A>(this, pred);
    }

    public static Generator zipWithIndex$(Generator $this) {
        return $this.zipWithIndex();
    }

    default public Generator<Tuple2<A, Object>> zipWithIndex() {
        return new ZipWithIndexed(this);
    }

    public static Generator zip$(Generator $this, Iterable other) {
        return $this.zip(other);
    }

    default public <B> Generator<Tuple2<A, B>> zip(Iterable<B> other) {
        return new Zipped(this, other);
    }

    public static Generator $plus$plus$(Generator $this, Generator other) {
        return $this.$plus$plus(other);
    }

    default public <B> Generator<B> $plus$plus(Generator<B> other) {
        return new Concat<B>(this, other);
    }

    public static Object head$(Generator $this) {
        return $this.head();
    }

    default public A head() {
        return this.take(1).toSeq().head();
    }

    public static Option headOption$(Generator $this) {
        return $this.headOption();
    }

    default public Option<A> headOption() {
        return this.take(1).toSeq().headOption();
    }

    public static Buffer toBuffer$(Generator $this) {
        return $this.toBuffer();
    }

    default public <B> Buffer<B> toBuffer() {
        Buffer arr = (Buffer)Buffer$.MODULE$.empty();
        this.foreach(_$5 -> arr.append(_$5));
        return arr;
    }

    public static Object toArray$(Generator $this, ClassTag evidence$1) {
        return $this.toArray(evidence$1);
    }

    default public <B> Object toArray(ClassTag<B> evidence$1) {
        return this.toBuffer().toArray(evidence$1);
    }

    public static Seq toSeq$(Generator $this) {
        return $this.toSeq();
    }

    default public Seq<A> toSeq() {
        return this.toVector();
    }

    public static List toList$(Generator $this) {
        return $this.toList();
    }

    default public List<A> toList() {
        return this.toBuffer().toList();
    }

    public static Set toSet$(Generator $this) {
        return $this.toSet();
    }

    default public <B> Set<B> toSet() {
        return this.toBuffer().toSet();
    }

    public static Vector toVector$(Generator $this) {
        return $this.toVector();
    }

    default public Vector<A> toVector() {
        return this.toBuffer().toVector();
    }

    public static String mkString$(Generator $this, String start, String sep, String end) {
        return $this.mkString(start, sep, end);
    }

    default public String mkString(String start, String sep, String end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        BooleanRef first = BooleanRef.create(true);
        this.foreach(x -> {
            boolean bl;
            if (!first$1.elem) {
                sb.append(sep);
            }
            sb.append(x);
            first$1.elem = bl = false;
        });
        sb.append(end);
        return sb.toString();
    }

    public static String mkString$(Generator $this, String sep) {
        return $this.mkString(sep);
    }

    default public String mkString(String sep) {
        return this.mkString("", sep, "");
    }

    public static String mkString$(Generator $this) {
        return $this.mkString();
    }

    default public String mkString() {
        return this.mkString("");
    }

    public static Object sum$(Generator $this, Numeric num) {
        return $this.sum(num);
    }

    default public <B> B sum(Numeric<B> num) {
        return this.foldLeft(num.zero(), (Function2<Object, Object, Object> & Serializable)(x, y) -> num.plus(x, y));
    }

    public static Object product$(Generator $this, Numeric num) {
        return $this.product(num);
    }

    default public <B> B product(Numeric<B> num) {
        return this.foldLeft(num.one(), (Function2<Object, Object, Object> & Serializable)(x, y) -> num.times(x, y));
    }

    public static Object min$(Generator $this, Ordering cmp) {
        return $this.min(cmp);
    }

    default public <B> A min(Ordering<B> cmp) {
        return (A)this.reduceLeft((Function2<Object, Object, Object> & Serializable)(x, y) -> {
            if (cmp.lteq(x, y)) {
                return x;
            }
            return y;
        });
    }

    public static Object max$(Generator $this, Ordering cmp) {
        return $this.max(cmp);
    }

    default public <B> A max(Ordering<B> cmp) {
        return (A)this.reduceLeft((Function2<Object, Object, Object> & Serializable)(x, y) -> {
            if (cmp.gteq(x, y)) {
                return x;
            }
            return y;
        });
    }

    public static Object maxBy$(Generator $this, Function1 f, Ordering cmp) {
        return $this.maxBy(f, cmp);
    }

    default public <B> A maxBy(Function1<A, B> f, Ordering<B> cmp) {
        ObjectRef<Object> maxF = ObjectRef.create(null);
        ObjectRef<Object> maxElem = ObjectRef.create(null);
        BooleanRef first = BooleanRef.create(true);
        this.foreach(elem -> {
            Object fx = f.apply(elem);
            if (first$2.elem || cmp.gt(fx, maxF$1.elem)) {
                boolean bl;
                Object object = elem;
                maxElem$1.elem = object;
                object = null;
                Object object2 = fx;
                maxF$1.elem = object2;
                object2 = null;
                first$2.elem = bl = false;
                return;
            }
        });
        return (A)maxElem.elem;
    }

    public static Object minBy$(Generator $this, Function1 f, Ordering cmp) {
        return $this.minBy(f, cmp);
    }

    default public <B> A minBy(Function1<A, B> f, Ordering<B> cmp) {
        ObjectRef<Object> minF = ObjectRef.create(null);
        ObjectRef<Object> minElem = ObjectRef.create(null);
        BooleanRef first = BooleanRef.create(true);
        this.foreach(elem -> {
            Object fx = f.apply(elem);
            if (first$3.elem || cmp.lt(fx, minF$1.elem)) {
                boolean bl;
                Object object = elem;
                minElem$1.elem = object;
                object = null;
                Object object2 = fx;
                minF$1.elem = object2;
                object2 = null;
                first$3.elem = bl = false;
                return;
            }
        });
        return (A)minElem.elem;
    }

    private static Object reduceLeft$$anonfun$2() {
        throw new UnsupportedOperationException("empty.reduceLeft");
    }

    private static Object sliding$$anonfun$1(int size$1, int step$1) {
        return StringOps$.MODULE$.format$extension("size=%d and step=%d, but both must be positive", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(size$1), BoxesRunTime.boxToInteger(step$1)}));
    }

    public static interface Action {
    }

    public static class Concat<T>
    implements Generator<T> {
        private final Generator<T> inner;
        private final Generator<T> other;

        public Concat(Generator<T> inner, Generator<T> other) {
            this.inner = inner;
            this.other = other;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            Action res1;
            Action action = res1 = this.inner.generate(f);
            Generator$End$ generator$End$ = Generator$End$.MODULE$;
            if (!(action != null ? !action.equals(generator$End$) : generator$End$ != null)) {
                return Generator$End$.MODULE$;
            }
            return this.other.generate(f);
        }

        public String toString() {
            return new java.lang.StringBuilder(4).append(this.inner).append(" ++ ").append(this.other).toString();
        }
    }

    public static class DropWhile<T>
    implements Generator<T> {
        private final Generator<T> inner;
        private final Function1<T, Object> pred;

        public DropWhile(Generator<T> inner, Function1<T, Object> pred) {
            this.inner = inner;
            this.pred = pred;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            BooleanRef started = BooleanRef.create(false);
            return this.inner.generate((Function1<Object, Action> & Serializable)(A t) -> {
                if (!started$1.elem) {
                    boolean bl;
                    if (BoxesRunTime.unboxToBoolean(this.pred.apply(t))) {
                        return Generator$Continue$.MODULE$;
                    }
                    started$1.elem = bl = true;
                    return (Action)f.apply(t);
                }
                return (Action)f.apply(t);
            });
        }

        public String toString() {
            return new java.lang.StringBuilder(12).append(this.inner).append(".dropWhile(").append(this.pred).append(")").toString();
        }
    }

    public static class Filtered<T>
    implements Generator<T> {
        private final Generator<T> inner;
        private final Function1<T, Object> pred;

        public Filtered(Generator<T> inner, Function1<T, Object> pred) {
            this.inner = inner;
            this.pred = pred;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            return this.inner.generate((Function1<Object, Action> & Serializable)(A t) -> {
                if (BoxesRunTime.unboxToBoolean(this.pred.apply(t))) {
                    return (Action)f.apply(t);
                }
                return Generator$Continue$.MODULE$;
            });
        }

        public String toString() {
            return new java.lang.StringBuilder(9).append(this.inner).append(".filter(").append(this.pred).append(")").toString();
        }
    }

    public static class FlatMapped<T, V>
    implements Generator<T> {
        private final Generator<V> inner;
        private final Function1<V, Generator<T>> func;

        public FlatMapped(Generator<V> inner, Function1<V, Generator<T>> func) {
            this.inner = inner;
            this.func = func;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            return this.inner.generate((Function1<Object, Action> & Serializable)(A outerT) -> this.func.apply(outerT).generate((Function1<Object, Action> & Serializable)(A innerT) -> (Action)f.apply(innerT)));
        }

        public String toString() {
            return new java.lang.StringBuilder(6).append(this.inner).append(".map(").append(this.func).append(")").toString();
        }
    }

    public static class Mapped<T, V>
    implements Generator<T> {
        private final Generator<V> inner;
        private final Function1<V, T> func;

        public Mapped(Generator<V> inner, Function1<V, T> func) {
            this.inner = inner;
            this.func = func;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            return this.inner.generate((Function1<Object, Action> & Serializable)(A t) -> (Action)f.apply(this.func.apply(t)));
        }

        public String toString() {
            return new java.lang.StringBuilder(6).append(this.inner).append(".map(").append(this.func).append(")").toString();
        }
    }

    public static class SelfClosing<T>
    implements Generator<T> {
        private final Function0<Tuple2<Iterator<T>, Function0<BoxedUnit>>> makeIterator;

        public SelfClosing(Function0<Tuple2<Iterator<T>, Function0<BoxedUnit>>> makeIterator) {
            this.makeIterator = makeIterator;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            Generator$Continue$ generator$Continue$;
            Action last = Generator$Continue$.MODULE$;
            Tuple2<Iterator<T>, Function0<BoxedUnit>> tuple2 = this.makeIterator.apply();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Iterator<T> iterator = tuple2._1();
            Function0<BoxedUnit> onComplete = tuple2._2();
            Tuple2<Iterator<T>, Function0<BoxedUnit>> tuple22 = Tuple2$.MODULE$.apply(iterator, onComplete);
            Iterator<T> iterator2 = tuple22._1();
            Function0<BoxedUnit> onComplete2 = tuple22._2();
            try {
                while (true) {
                    Generator$Continue$ generator$Continue$2 = last;
                    Generator$Continue$ generator$Continue$3 = Generator$Continue$.MODULE$;
                    if ((generator$Continue$2 != null ? !generator$Continue$2.equals(generator$Continue$3) : generator$Continue$3 != null) || !iterator2.hasNext()) break;
                    last = f.apply(iterator2.next());
                }
                generator$Continue$ = last;
            }
            finally {
                onComplete2.apply$mcV$sp();
            }
            return generator$Continue$;
        }

        public String toString() {
            return "Gen.SelfClosing(...)";
        }
    }

    public static class Sliced<T>
    implements Generator<T> {
        private final Generator<T> inner;
        private final int start;
        private final int end;

        public Sliced(Generator<T> inner, int start, int end) {
            this.inner = inner;
            this.start = start;
            this.end = end;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            IntRef count = IntRef.create(0);
            return this.inner.generate((Function1<Object, Action> & Serializable)(A t) -> {
                if (count$1.elem < this.start) {
                    int n;
                    count$1.elem = n = count$1.elem + 1;
                    return Generator$Continue$.MODULE$;
                }
                if (count$1.elem < this.end) {
                    int n;
                    count$1.elem = n = count$1.elem + 1;
                    if (count$1.elem != this.end) {
                        return (Action)f.apply(t);
                    }
                    f.apply(t);
                    return Generator$End$.MODULE$;
                }
                return Generator$End$.MODULE$;
            });
        }

        public String toString() {
            return new java.lang.StringBuilder(10).append(this.inner).append(".slice(").append(this.start).append(", ").append(this.end).append(")").toString();
        }
    }

    public static class Sliding<T>
    implements Generator<Iterable<T>> {
        private final Generator<T> inner;
        private final int size;
        private final int step;

        public Sliding(Generator<T> inner, int size2, int step) {
            this.inner = inner;
            this.size = size2;
            this.step = step;
        }

        @Override
        public Action generate(Function1<Iterable<T>, Action> f) {
            Builder builder = package$.MODULE$.Iterable().newBuilder();
            int capacity = Math.max(this.size, this.step);
            IntRef n = IntRef.create(0);
            builder.sizeHint(capacity);
            ObjectRef<Generator$Continue$> action = ObjectRef.create(Generator$Continue$.MODULE$);
            this.inner.generate((Function1<Object, Action> & Serializable)(A t) -> {
                int n;
                if (n$1.elem < capacity) {
                    int n2;
                    builder.$plus$eq(t);
                    n$1.elem = n2 = n$1.elem + 1;
                    return (Action)action$1.elem;
                }
                Action action = (Action)f.apply((Iterable<T>)((IterableOps)builder.result()).take(this.size));
                action$1.elem = action;
                action = null;
                Iterable remainder = (Iterable)((IterableOps)builder.result()).drop(this.step);
                builder.clear();
                builder.sizeHint(capacity);
                builder.$plus$plus$eq(remainder);
                builder.$plus$eq(t);
                n$1.elem = n = remainder.size() + 1;
                return (Action)action$1.elem;
            });
            if (n.elem > 0) {
                Action action2 = (Action)action.elem;
                Generator$Continue$ generator$Continue$ = Generator$Continue$.MODULE$;
                if (!(action2 != null ? !action2.equals(generator$Continue$) : generator$Continue$ != null)) {
                    return f.apply((Iterable<T>)((IterableOps)builder.result()).take(this.size));
                }
            }
            return (Action)action.elem;
        }
    }

    public static class TakeWhile<T>
    implements Generator<T> {
        private final Generator<T> inner;
        private final Function1<T, Object> pred;

        public TakeWhile(Generator<T> inner, Function1<T, Object> pred) {
            this.inner = inner;
            this.pred = pred;
        }

        @Override
        public Action generate(Function1<T, Action> f) {
            return this.inner.generate((Function1<Object, Action> & Serializable)(A t) -> {
                if (BoxesRunTime.unboxToBoolean(this.pred.apply(t))) {
                    return (Action)f.apply(t);
                }
                return Generator$End$.MODULE$;
            });
        }

        public String toString() {
            return new java.lang.StringBuilder(12).append(this.inner).append(".takeWhile(").append(this.pred).append(")").toString();
        }
    }

    public static class ZipWithIndexed<T>
    implements Generator<Tuple2<T, Object>> {
        private final Generator<T> inner;

        public ZipWithIndexed(Generator<T> inner) {
            this.inner = inner;
        }

        @Override
        public Action generate(Function1<Tuple2<T, Object>, Action> f) {
            IntRef i = IntRef.create(0);
            return this.inner.generate((Function1<Object, Action> & Serializable)(A t) -> {
                int n;
                Action res = (Action)f.apply(Tuple2$.MODULE$.apply(t, BoxesRunTime.boxToInteger(i$1.elem)));
                i$1.elem = n = i$1.elem + 1;
                return res;
            });
        }

        public String toString() {
            return new java.lang.StringBuilder(13).append(this.inner).append(".zipWithIndex").toString();
        }
    }

    public static class Zipped<T, V>
    implements Generator<Tuple2<T, V>> {
        private final Generator<T> inner;
        private final Iterable<V> other;

        public Zipped(Generator<T> inner, Iterable<V> other) {
            this.inner = inner;
            this.other = other;
        }

        @Override
        public Action generate(Function1<Tuple2<T, V>, Action> f) {
            Iterator iter = this.other.iterator();
            return this.inner.generate((Function1<Object, Action> & Serializable)(A t) -> {
                if (!iter.hasNext()) {
                    return Generator$End$.MODULE$;
                }
                return (Action)f.apply(Tuple2$.MODULE$.apply(t, iter.next()));
            });
        }

        public String toString() {
            return new java.lang.StringBuilder(6).append(this.inner).append(".zip(").append(this.other).append(")").toString();
        }
    }
}

