/******************************************************************************
 *
 * Copyright (C) 1997-2023 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby
 * granted. No representations are made about the suitability of this software
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * Documents produced by Doxygen are derivative works derived from the
 * input used in their production; they are not affected by this license.
 *
 */

#include "cmdmapper.h"

static const CommandMap<CommandType> g_cmdMap =
{
  { "a",             CommandType::CMD_EMPHASIS },
  { "addindex",      CommandType::CMD_ADDINDEX },
  { "anchor",        CommandType::CMD_ANCHOR },
  { "arg",           CommandType::CMD_LI },
  { "attention",     CommandType::CMD_ATTENTION },
  { "author",        CommandType::CMD_AUTHOR },
  { "authors",       CommandType::CMD_AUTHORS },
  { "b",             CommandType::CMD_BOLD },
  { "c",             CommandType::CMD_CODE },
  { "cite",          CommandType::CMD_CITE },
  { "icode",         CommandType::CMD_ISTARTCODE },
  { "code",          CommandType::CMD_STARTCODE },
  { "copydoc",       CommandType::CMD_COPYDOC },
  { "copybrief",     CommandType::CMD_COPYBRIEF },
  { "copydetails",   CommandType::CMD_COPYDETAILS },
  { "copyright",     CommandType::CMD_COPYRIGHT },
  { "date",          CommandType::CMD_DATE },
  { "showdate",      CommandType::CMD_SHOWDATE },
  { "dontinclude",   CommandType::CMD_DONTINCLUDE },
  { "dotfile",       CommandType::CMD_DOTFILE },
  { "doxyconfig",    CommandType::CMD_DOXYCONFIG },
  { "e",             CommandType::CMD_EMPHASIS },
  { "em",            CommandType::CMD_EMPHASIS },
  { "endicode",      CommandType::CMD_ENDICODE },
  { "endcode",       CommandType::CMD_ENDCODE },
  { "endhtmlonly",   CommandType::CMD_ENDHTMLONLY },
  { "endlatexonly",  CommandType::CMD_ENDLATEXONLY },
  { "endlink",       CommandType::CMD_ENDLINK },
  { "endsecreflist", CommandType::CMD_ENDSECREFLIST },
  { "endiverbatim",  CommandType::CMD_ENDIVERBATIM },
  { "endverbatim",   CommandType::CMD_ENDVERBATIM },
  { "endxmlonly",    CommandType::CMD_ENDXMLONLY },
  { "exception",     CommandType::CMD_EXCEPTION },
  { "_form",         CommandType::CMD_FORMULA },
  { "htmlinclude",   CommandType::CMD_HTMLINCLUDE },
  { "htmlonly",      CommandType::CMD_HTMLONLY },
  { "image",         CommandType::CMD_IMAGE },
  { "important",     CommandType::CMD_IMPORTANT },
  { "include",       CommandType::CMD_INCLUDE },
  { "internal",      CommandType::CMD_INTERNAL },
  { "invariant",     CommandType::CMD_INVARIANT },
  { "javalink",      CommandType::CMD_JAVALINK },
  { "javalinkplain", CommandType::CMD_JAVALINK },
  { "latexinclude",  CommandType::CMD_LATEXINCLUDE },
  { "latexonly",     CommandType::CMD_LATEXONLY },
  { "li",            CommandType::CMD_LI },
  { "line",          CommandType::CMD_LINE },
  { "link",          CommandType::CMD_LINK },
  { "n",             CommandType::CMD_LINEBREAK },
  { "note",          CommandType::CMD_NOTE },
  { "p",             CommandType::CMD_CODE },
  { "par",           CommandType::CMD_PAR },
  { "param",         CommandType::CMD_PARAM },
  { "post",          CommandType::CMD_POST },
  { "pre",           CommandType::CMD_PRE },
  { "ref",           CommandType::CMD_REF },
  { "refitem",       CommandType::CMD_SECREFITEM },
  { "remark",        CommandType::CMD_REMARK },
  { "remarks",       CommandType::CMD_REMARK },
  { "result",        CommandType::CMD_RETURN },
  { "return",        CommandType::CMD_RETURN },
  { "returns",       CommandType::CMD_RETURN },
  { "retval",        CommandType::CMD_RETVAL },
  { "sa",            CommandType::CMD_SA },
  { "secreflist",    CommandType::CMD_SECREFLIST },
  { "section",       CommandType::CMD_SECTION },
  { "snippet",       CommandType::CMD_SNIPPET },
  { "snippetlineno", CommandType::CMD_SNIPWITHLINES },
  { "subpage",       CommandType::CMD_SUBPAGE },
  { "subsection",    CommandType::CMD_SUBSECTION },
  { "subsubsection", CommandType::CMD_SUBSUBSECTION },
  { "paragraph",     CommandType::CMD_PARAGRAPH },
  { "subparagraph",  CommandType::CMD_SUBPARAGRAPH },
  { "subsubparagraph",  CommandType::CMD_SUBSUBPARAGRAPH },
  { "see",           CommandType::CMD_SA },
  { "since",         CommandType::CMD_SINCE },
  { "skip",          CommandType::CMD_SKIP },
  { "skipline",      CommandType::CMD_SKIPLINE },
  { "xmlonly",       CommandType::CMD_XMLONLY },
  { "xrefitem",      CommandType::CMD_XREFITEM },
  { "throw",         CommandType::CMD_EXCEPTION },
  { "until",         CommandType::CMD_UNTIL },
  { "iverbatim",     CommandType::CMD_IVERBATIM },
  { "verbatim",      CommandType::CMD_VERBATIM },
  { "verbinclude",   CommandType::CMD_VERBINCLUDE },
  { "version",       CommandType::CMD_VERSION },
  { "warning",       CommandType::CMD_WARNING },
  { "throws",        CommandType::CMD_EXCEPTION },
  { "tparam",        CommandType::CMD_TPARAM },
  { "\\",            CommandType::CMD_BSLASH },
  { "@",             CommandType::CMD_AT },
  { "<",             CommandType::CMD_LESS },
  { "=",             CommandType::CMD_EQUAL },
  { ">",             CommandType::CMD_GREATER },
  { "&",             CommandType::CMD_AMP },
  { "$",             CommandType::CMD_DOLLAR },
  { "#",             CommandType::CMD_HASH },
  { "%",             CommandType::CMD_PERCENT },
  { "|",             CommandType::CMD_PIPE },
  { ".",             CommandType::CMD_PUNT },
  { "+",             CommandType::CMD_PLUS },
  { "-",             CommandType::CMD_MINUS },
  { "::",            CommandType::CMD_DCOLON },
  { "\"",            CommandType::CMD_QUOTE },
  { "!",             CommandType::CMD_EXCLAMATION },
  { "?",             CommandType::CMD_QUESTION },
  { "_internalref",  CommandType::CMD_INTERNALREF },
  { "dot",           CommandType::CMD_DOT },
  { "msc",           CommandType::CMD_MSC },
  { "startuml",      CommandType::CMD_STARTUML },
  { "enddot",        CommandType::CMD_ENDDOT },
  { "endmsc",        CommandType::CMD_ENDMSC },
  { "enduml",        CommandType::CMD_ENDUML },
  { "plantumlfile",  CommandType::CMD_PLANTUMLFILE },
  { "manonly",       CommandType::CMD_MANONLY },
  { "endmanonly",    CommandType::CMD_ENDMANONLY },
  { "includelineno", CommandType::CMD_INCWITHLINES },
  { "inheritdoc",    CommandType::CMD_INHERITDOC },
  { "mscfile",       CommandType::CMD_MSCFILE },
  { "rtfonly",       CommandType::CMD_RTFONLY },
  { "endrtfonly",    CommandType::CMD_ENDRTFONLY },
  { "vhdlflow",      CommandType::CMD_VHDLFLOW },
  { "docbookonly",   CommandType::CMD_DBONLY },
  { "enddocbookonly",CommandType::CMD_ENDDBONLY },
  { "endinternal",   CommandType::CMD_ENDINTERNAL },
  { "parblock",      CommandType::CMD_PARBLOCK },
  { "endparblock",   CommandType::CMD_ENDPARBLOCK },
  { "diafile",       CommandType::CMD_DIAFILE },
  { "--",            CommandType::CMD_NDASH },
  { "---",           CommandType::CMD_MDASH },
  { "_setscope",     CommandType::CMD_SETSCOPE },
  { "emoji",         CommandType::CMD_EMOJI },
  { "rtfinclude",    CommandType::CMD_RTFINCLUDE },
  { "docbookinclude",CommandType::CMD_DOCBOOKINCLUDE },
  { "maninclude",    CommandType::CMD_MANINCLUDE },
  { "xmlinclude",    CommandType::CMD_XMLINCLUDE },
  { "iline",         CommandType::CMD_ILINE },
  { "ifile",         CommandType::CMD_IFILE },
  { "iliteral",      CommandType::CMD_ILITERAL },
  { "endiliteral",   CommandType::CMD_ENDILITERAL },
  { "ianchor" ,      CommandType::CMD_IANCHOR },
  { "iprefix" ,      CommandType::CMD_IPREFIX },
};

//----------------------------------------------------------------------------

static const CommandMap<HtmlTagType>  g_htmlTagMap =
{
  { "strong",     HtmlTagType::HTML_BOLD },
  { "center",     HtmlTagType::HTML_CENTER },
  { "table",      HtmlTagType::HTML_TABLE },
  { "caption",    HtmlTagType::HTML_CAPTION },
  { "small",      HtmlTagType::HTML_SMALL },
  { "cite",       HtmlTagType::HTML_CITE },
  { "code",       HtmlTagType::HTML_CODE },
  { "dfn",        HtmlTagType::HTML_CODE },
  { "var",        HtmlTagType::HTML_EMPHASIS },
  { "img",        HtmlTagType::HTML_IMG },
  { "pre",        HtmlTagType::HTML_PRE },
  { "sub",        HtmlTagType::HTML_SUB },
  { "sup",        HtmlTagType::HTML_SUP },
  { "tr",         HtmlTagType::HTML_TR },
  { "td",         HtmlTagType::HTML_TD },
  { "th",         HtmlTagType::HTML_TH },
  { "ol",         HtmlTagType::HTML_OL },
  { "ul",         HtmlTagType::HTML_UL },
  { "li",         HtmlTagType::HTML_LI },
  { "tt",         HtmlTagType::XML_C /*HtmlTagType::HTML_CODE*/ },
  { "kbd",        HtmlTagType::HTML_KBD },
  { "em",         HtmlTagType::HTML_EMPHASIS },
  { "hr",         HtmlTagType::HTML_HR },
  { "dl",         HtmlTagType::HTML_DL },
  { "dt",         HtmlTagType::HTML_DT },
  { "dd",         HtmlTagType::HTML_DD },
  { "br",         HtmlTagType::HTML_BR },
  { "i",          HtmlTagType::HTML_EMPHASIS },
  { "a",          HtmlTagType::HTML_A },
  { "b",          HtmlTagType::HTML_BOLD },
  { "p",          HtmlTagType::HTML_P },
  { "h1",         HtmlTagType::HTML_H1 },
  { "h2",         HtmlTagType::HTML_H2 },
  { "h3",         HtmlTagType::HTML_H3 },
  { "h4",         HtmlTagType::HTML_H4 },
  { "h5",         HtmlTagType::HTML_H5 },
  { "h6",         HtmlTagType::HTML_H6 },
  { "span",       HtmlTagType::HTML_SPAN },
  { "div",        HtmlTagType::HTML_DIV },
  { "blockquote", HtmlTagType::HTML_BLOCKQUOTE },
  { "strike",     HtmlTagType::HTML_STRIKE },
  { "s",          HtmlTagType::HTML_S },
  { "u",          HtmlTagType::HTML_UNDERLINE },
  { "ins",        HtmlTagType::HTML_INS },
  { "del",        HtmlTagType::HTML_DEL },
  { "thead",      HtmlTagType::HTML_THEAD },
  { "tbody",      HtmlTagType::HTML_TBODY },
  { "tfoot",      HtmlTagType::HTML_TFOOT },
  { "details",    HtmlTagType::HTML_DETAILS },

  { "c",            HtmlTagType::XML_C },
  // { "code",       HtmlTagType::XML_CODE },  <= ambiguous <code> is also a HTML tag
  { "description",  HtmlTagType::XML_DESCRIPTION },
  { "example",      HtmlTagType::XML_EXAMPLE },
  { "exception",    HtmlTagType::XML_EXCEPTION },
  { "include",      HtmlTagType::XML_INCLUDE },
  { "item",         HtmlTagType::XML_ITEM },
  { "list",         HtmlTagType::XML_LIST }, // type="table|bullet|number"
  { "listheader",   HtmlTagType::XML_LISTHEADER },
  { "para",         HtmlTagType::XML_PARA },
  { "param",        HtmlTagType::XML_PARAM },
  { "paramref",     HtmlTagType::XML_PARAMREF },
  { "typeparam",    HtmlTagType::XML_TYPEPARAM },
  { "typeparamref", HtmlTagType::XML_TYPEPARAMREF },
  { "permission",   HtmlTagType::XML_PERMISSION },
  { "remarks",      HtmlTagType::XML_REMARKS },
  { "returns",      HtmlTagType::XML_RETURNS },
  { "see",          HtmlTagType::XML_SEE },
  { "seealso",      HtmlTagType::XML_SEEALSO },
  { "summary",      HtmlTagType::XML_SUMMARY },
  { "term",         HtmlTagType::XML_TERM },
  { "value",        HtmlTagType::XML_VALUE },
  { "inheritdoc",   HtmlTagType::XML_INHERITDOC },
};

//----------------------------------------------------------------------------

static Mapper<CommandType> g_cmdMapper(g_cmdMap,true);
static Mapper<HtmlTagType> g_htmlTagMapper(g_htmlTagMap,false);

namespace Mappers
{
  const Mapper<CommandType> *cmdMapper     = &g_cmdMapper;
  const Mapper<HtmlTagType> *htmlTagMapper = &g_htmlTagMapper;
}


