;;; DO NOT MODIFY THIS FILE -*- coding: raw-text-unix -*-
;;;###coding system: raw-text-unix
(if (featurep 'tramp-custom-defines) (error "Feature tramp-custom-defines already loaded"))

;;;### (autoloads (tramp-adb-prompt tramp-adb-connect-if-not-connected tramp-adb-program) "tramp-adb" "lisp/tramp-adb.el")
(defconst custom-define-current-source-file "tramp-adb.el")

(defcustom tramp-adb-program "adb" "\
Name of the Android Debug Bridge program." :group 'tramp :version "24.4" :type 'string)

(defcustom tramp-adb-connect-if-not-connected nil "\
Try to run `adb connect' if provided device is not connected currently.
It is used for TCP/IP devices." :group 'tramp :version "25.1" :type 'boolean)

(defcustom tramp-adb-prompt "^\\(?:[[:digit:]]*|?\\)?\\(?:[[:alnum:];[]*@[[:alnum:]]*[^#\\$]*\\)?[#\\$][[:space:]]" "\
Regexp used as prompt in almquist shell." :type 'string :version "24.4" :group 'tramp)

;;;***

;;;### (autoloads (tramp-persistency-file-name tramp-connection-properties) "tramp-cache" "lisp/tramp-cache.el")
(defconst custom-define-current-source-file "tramp-cache.el")

(defcustom tramp-connection-properties nil "\
List of static connection properties.
Every entry has the form (REGEXP PROPERTY VALUE).  The regexp
matches remote file names.  It can be nil.  PROPERTY is a string,
and VALUE the corresponding value.  They are used, if there is no
matching entry for PROPERTY in `tramp-cache-data'.  For more
details see the info pages." :group 'tramp :version "24.4" :type '(repeat (list (choice :tag "File Name regexp" regexp (const nil)) (choice :tag "        Property" string) (choice :tag "           Value" sexp))))

(defcustom tramp-persistency-file-name (cond ((and (fboundp 'locate-user-emacs-file)) (expand-file-name (tramp-compat-funcall 'locate-user-emacs-file "tramp"))) ((and (boundp 'user-emacs-directory) (stringp (symbol-value 'user-emacs-directory)) (file-directory-p (symbol-value 'user-emacs-directory))) (expand-file-name "tramp" (symbol-value 'user-emacs-directory))) ((and (not (featurep 'xemacs)) (file-directory-p "~/.emacs.d/")) "~/.emacs.d/tramp") ((and (boundp 'user-init-directory) (stringp (symbol-value 'user-init-directory)) (file-directory-p (symbol-value 'user-init-directory))) (expand-file-name "tramp" (symbol-value 'user-init-directory))) ((and (featurep 'xemacs) (file-directory-p "~/.xemacs/")) "~/.xemacs/tramp") (t "~/.tramp")) "\
File which keeps connection history for Tramp connections." :group 'tramp :type 'file)

;;;***

;;;### (autoloads (tramp-sh-extra-args tramp-remote-process-environment tramp-remote-path tramp-use-ssh-controlmaster-options tramp-histfile-override tramp-terminal-type tramp-copy-size-limit tramp-inline-compress-start-size) "tramp-sh" "lisp/tramp-sh.el")
(defconst custom-define-current-source-file "tramp-sh.el")

(defcustom tramp-inline-compress-start-size 4096 "\
The minimum size of compressing where inline transfer.
When inline transfer, compress transferred data of file
whose size is this value or above (up to `tramp-copy-size-limit').
If it is nil, no compression at all will be applied." :group 'tramp :type '(choice (const nil) integer))

(defcustom tramp-copy-size-limit 10240 "\
The maximum file size where inline copying is preferred over an out-of-the-band copy.
If it is nil, out-of-the-band copy will be used without a check." :group 'tramp :type '(choice (const nil) integer))

(defcustom tramp-terminal-type "dumb" "\
Value of TERM environment variable for logging in to remote host.
Because Tramp wants to parse the output of the remote shell, it is easily
confused by ANSI color escape sequences and suchlike.  Often, shell init
files conditionalize this setup based on the TERM environment variable." :group 'tramp :type 'string)

(defcustom tramp-histfile-override ".tramp_history" "\
When invoking a shell, override the HISTFILE with this value.
When setting to a string, it redirects the shell history to that
file.  Be careful when setting to \"/dev/null\"; this might
result in undesired results when using \"bash\" as shell.

The value t, the default value, unsets any setting of HISTFILE,
and sets both HISTFILESIZE and HISTSIZE to 0.  If you set this
variable to nil, however, the *override* is disabled, so the
history will go to the default storage location,
e.g. \"$HOME/.sh_history\"." :group 'tramp :version "25.1" :type '(choice (const :tag "Do not override HISTFILE" nil) (const :tag "Unset HISTFILE" t) (string :tag "Redirect to a file")))

(defcustom tramp-use-ssh-controlmaster-options t "\
Whether to use `tramp-ssh-controlmaster-options'." :group 'tramp :version "24.4" :type 'boolean)

(defcustom tramp-remote-path '(tramp-default-remote-path "/bin" "/usr/bin" "/sbin" "/usr/sbin" "/usr/local/bin" "/usr/local/sbin" "/local/bin" "/local/freeware/bin" "/local/gnu/bin" "/usr/freeware/bin" "/usr/pkg/bin" "/usr/contrib/bin" "/opt/bin" "/opt/sbin" "/opt/local/bin") "\
List of directories to search for executables on remote host.
For every remote host, this variable will be set buffer local,
keeping the list of existing directories on that host.

You can use `~' in this list, but when searching for a shell which groks
tilde expansion, all directory names starting with `~' will be ignored.

`Default Directories' represent the list of directories given by
the command \"getconf PATH\".  It is recommended to use this
entry on top of this list, because these are the default
directories for POSIX compatible commands.  On remote hosts which
do not offer the getconf command (like cygwin), the value
\"/bin:/usr/bin\" is used instead of.

`Private Directories' are the settings of the $PATH environment,
as given in your `~/.profile'." :group 'tramp :type '(repeat (choice (const :tag "Default Directories" tramp-default-remote-path) (const :tag "Private Directories" tramp-own-remote-path) (string :tag "Directory"))))

(defcustom tramp-remote-process-environment (backquote ("TMOUT=0" "LC_CTYPE=''" (\, (format "TERM=%s" tramp-terminal-type)) (\, (format "INSIDE_EMACS='%s,tramp:%s'" emacs-version tramp-version)) "CDPATH=" "HISTORY=" "MAIL=" "MAILCHECK=" "MAILPATH=" "PAGER=cat" "autocorrect=" "correct=")) "\
List of environment variables to be set on the remote host.

Each element should be a string of the form ENVVARNAME=VALUE.  An
entry ENVVARNAME= disables the corresponding environment variable,
which might have been set in the init files like ~/.profile.

Special handling is applied to the PATH environment, which should
not be set here. Instead, it should be set via `tramp-remote-path'." :group 'tramp :version "24.4" :type '(repeat string))

(defcustom tramp-sh-extra-args '(("/bash\\'" . "-norc -noprofile")) "\
Alist specifying extra arguments to pass to the remote shell.
Entries are (REGEXP . ARGS) where REGEXP is a regular expression
matching the shell file name and ARGS is a string specifying the
arguments.

This variable is only used when Tramp needs to start up another shell
for tilde expansion.  The extra arguments should typically prevent the
shell from reading its init file." :group 'tramp :type (if (get 'alist 'widget-type) '(alist :key-type string :value-type string) '(repeat (cons string string))))

;;;***

;;;### (autoloads (tramp-smb-winexe-shell-command-switch tramp-smb-winexe-shell-command tramp-smb-winexe-program tramp-smb-conf tramp-smb-acl-program tramp-smb-program) "tramp-smb" "lisp/tramp-smb.el")
(defconst custom-define-current-source-file "tramp-smb.el")

(defcustom tramp-smb-program "smbclient" "\
Name of SMB client to run." :group 'tramp :type 'string)

(defcustom tramp-smb-acl-program "smbcacls" "\
Name of SMB acls to run." :group 'tramp :type 'string :version "24.4")

(defcustom tramp-smb-conf "/dev/null" "\
Path of the smb.conf file.
If it is nil, no smb.conf will be added to the `tramp-smb-program'
call, letting the SMB client use the default one." :group 'tramp :type '(choice (const nil) (file :must-match t)))

(defcustom tramp-smb-winexe-program "winexe" "\
Name of winexe client to run.
If it isn't found in the local $PATH, the absolute path of winexe
shall be given.  This is needed for remote processes." :group 'tramp :type 'string :version "24.3")

(defcustom tramp-smb-winexe-shell-command "powershell.exe" "\
Shell to be used for processes on remote machines.
This must be Powershell V2 compatible." :group 'tramp :type 'string :version "24.3")

(defcustom tramp-smb-winexe-shell-command-switch "-file -" "\
Command switch used together with `tramp-smb-winexe-shell-command'.
This can be used to disable echo etc." :group 'tramp :type 'string :version "24.3")

;;;***

;;;### (autoloads (tramp-completion-reread-directory-timeout tramp-connection-min-time-diff tramp-connection-timeout tramp-process-connection-type tramp-chunksize tramp-syntax tramp-process-alive-regexp tramp-copy-failed-regexp tramp-operation-not-permitted-regexp tramp-terminal-prompt-regexp tramp-yn-prompt-regexp tramp-yesno-prompt-regexp tramp-wrong-passwd-regexp tramp-password-prompt-regexp tramp-shell-prompt-pattern tramp-login-prompt-regexp tramp-rsh-end-of-line tramp-local-end-of-line tramp-restricted-shell-hosts-alist tramp-save-ad-hoc-proxies tramp-default-proxies-alist tramp-default-host-alist tramp-default-host tramp-default-user-alist tramp-default-user tramp-default-method-alist tramp-default-method tramp-encoding-command-interactive tramp-encoding-command-switch tramp-encoding-shell tramp-auto-save-directory tramp-verbose tramp-mode tramp) "tramp" "lisp/tramp.el")
(defconst custom-define-current-source-file "tramp.el")

(defgroup tramp nil "Edit remote files with a combination of ssh, scp, etc." :group 'files :group 'comm :link '(custom-manual "(tramp)Top") :version "22.1")

(defcustom tramp-mode t "\
Whether Tramp is enabled.
If it is set to nil, all remote file names are used literally." :group 'tramp :type 'boolean)

(defcustom tramp-verbose 3 "\
Verbosity level for Tramp messages.
Any level x includes messages for all levels 1 .. x-1.  The levels are

 0  silent (no tramp messages at all)
 1  errors
 2  warnings
 3  connection to remote hosts (default level)
 4  activities
 5  internal
 6  sent and received strings
 7  file caching
 8  connection properties
 9  test commands
10  traces (huge)." :group 'tramp :type 'integer)

(defcustom tramp-auto-save-directory nil "\
Put auto-save files in this directory, if set.
The idea is to use a local directory so that auto-saving is faster.
This setting has precedence over `auto-save-file-name-transforms'." :group 'tramp :type '(choice (const :tag "Use default" nil) (directory :tag "Auto save directory name")))

(defcustom tramp-encoding-shell (if (memq system-type '(windows-nt)) (getenv "COMSPEC") "/bin/sh") "\
Use this program for encoding and decoding commands on the local host.
This shell is used to execute the encoding and decoding command on the
local host, so if you want to use `~' in those commands, you should
choose a shell here which groks tilde expansion.  `/bin/sh' normally
does not understand tilde expansion.

For encoding and decoding, commands like the following are executed:

    /bin/sh -c COMMAND < INPUT > OUTPUT

This variable can be used to change the \"/bin/sh\" part.  See the
variable `tramp-encoding-command-switch' for the \"-c\" part.

If the shell must be forced to be interactive, see
`tramp-encoding-command-interactive'.

Note that this variable is not used for remote commands.  There are
mechanisms in tramp.el which automatically determine the right shell to
use for the remote host." :group 'tramp :type '(file :must-match t))

(defcustom tramp-encoding-command-switch (if (string-match "cmd\\.exe" tramp-encoding-shell) "/c" "-c") "\
Use this switch together with `tramp-encoding-shell' for local commands.
See the variable `tramp-encoding-shell' for more information." :group 'tramp :type 'string)

(defcustom tramp-encoding-command-interactive (unless (string-match "cmd\\.exe" tramp-encoding-shell) "-i") "\
Use this switch together with `tramp-encoding-shell' for interactive shells.
See the variable `tramp-encoding-shell' for more information." :version "24.1" :group 'tramp :type '(choice (const nil) string))

(defcustom tramp-default-method (cond ((and (eq system-type 'windows-nt) (executable-find "pscp")) (if (or (fboundp 'password-read) (fboundp 'auth-source-user-or-password) (fboundp 'auth-source-search) (tramp-compat-process-running-p "Pageant")) "pscp" "plink")) ((executable-find "scp") (if (or (fboundp 'password-read) (fboundp 'auth-source-user-or-password) (fboundp 'auth-source-search) (getenv "SSH_AUTH_SOCK") (getenv "SSH_AGENT_PID")) "scp" "ssh")) (t "ftp")) "\
Default method to use for transferring files.
See `tramp-methods' for possibilities.
Also see `tramp-default-method-alist'." :group 'tramp :type 'string)

(defcustom tramp-default-method-alist nil "\
Default method to use for specific host/user pairs.
This is an alist of items (HOST USER METHOD).  The first matching item
specifies the method to use for a file name which does not specify a
method.  HOST and USER are regular expressions or nil, which is
interpreted as a regular expression which always matches.  If no entry
matches, the variable `tramp-default-method' takes effect.

If the file name does not specify the user, lookup is done using the
empty string for the user name.

See `tramp-methods' for a list of possibilities for METHOD." :group 'tramp :type '(repeat (list (choice :tag "Host regexp" regexp sexp) (choice :tag "User regexp" regexp sexp) (choice :tag "Method name" string (const nil)))))

(defcustom tramp-default-user nil "\
Default user to use for transferring files.
It is nil by default; otherwise settings in configuration files like
\"~/.ssh/config\" would be overwritten.  Also see `tramp-default-user-alist'.

This variable is regarded as obsolete, and will be removed soon." :group 'tramp :type '(choice (const nil) string))

(defcustom tramp-default-user-alist nil "\
Default user to use for specific method/host pairs.
This is an alist of items (METHOD HOST USER).  The first matching item
specifies the user to use for a file name which does not specify a
user.  METHOD and USER are regular expressions or nil, which is
interpreted as a regular expression which always matches.  If no entry
matches, the variable `tramp-default-user' takes effect.

If the file name does not specify the method, lookup is done using the
empty string for the method name." :group 'tramp :type '(repeat (list (choice :tag "Method regexp" regexp sexp) (choice :tag "  Host regexp" regexp sexp) (choice :tag "    User name" string (const nil)))))

(defcustom tramp-default-host (system-name) "\
Default host to use for transferring files.
Useful for su and sudo methods mostly." :group 'tramp :type 'string)

(defcustom tramp-default-host-alist nil "\
Default host to use for specific method/user pairs.
This is an alist of items (METHOD USER HOST).  The first matching item
specifies the host to use for a file name which does not specify a
host.  METHOD and HOST are regular expressions or nil, which is
interpreted as a regular expression which always matches.  If no entry
matches, the variable `tramp-default-host' takes effect.

If the file name does not specify the method, lookup is done using the
empty string for the method name." :group 'tramp :version "24.4" :type '(repeat (list (choice :tag "Method regexp" regexp sexp) (choice :tag "  User regexp" regexp sexp) (choice :tag "    Host name" string (const nil)))))

(defcustom tramp-default-proxies-alist nil "\
Route to be followed for specific host/user pairs.
This is an alist of items (HOST USER PROXY).  The first matching
item specifies the proxy to be passed for a file name located on
a remote target matching USER@HOST.  HOST and USER are regular
expressions.  PROXY must be a Tramp filename without a localname
part.  Method and user name on PROXY are optional, which is
interpreted with the default values.  PROXY can contain the
patterns %h and %u, which are replaced by the strings matching
HOST or USER, respectively.

HOST, USER or PROXY could also be Lisp forms, which will be
evaluated.  The result must be a string or nil, which is
interpreted as a regular expression which always matches." :group 'tramp :type '(repeat (list (choice :tag "Host regexp" regexp sexp) (choice :tag "User regexp" regexp sexp) (choice :tag " Proxy name" string (const nil)))))

(defcustom tramp-save-ad-hoc-proxies nil "\
Whether to save ad-hoc proxies persistently." :group 'tramp :version "24.3" :type 'boolean)

(defcustom tramp-restricted-shell-hosts-alist (when (memq system-type '(windows-nt)) (list (concat "\\`" (regexp-quote (system-name)) "\\'"))) "\
List of hosts, which run a restricted shell.
This is a list of regular expressions, which denote hosts running
a registered shell like \"rbash\".  Those hosts can be used as
proxies only, see `tramp-default-proxies-alist'.  If the local
host runs a registered shell, it shall be added to this list, too." :version "24.3" :group 'tramp :type '(repeat (regexp :tag "Host regexp")))

(defcustom tramp-local-end-of-line (if (memq system-type '(windows-nt)) "
\n" "\n") "\
String used for end of line in local processes." :version "24.1" :group 'tramp :type 'string)

(defcustom tramp-rsh-end-of-line "\n" "\
String used for end of line in rsh connections.
I don't think this ever needs to be changed, so please tell me about it
if you need to change this." :group 'tramp :type 'string)

(defcustom tramp-login-prompt-regexp ".*\\(user\\|login\\)\\( .*\\)?: *" "\
Regexp matching login-like prompts.
The regexp should match at end of buffer.

Sometimes the prompt is reported to look like \"login as:\"." :group 'tramp :type 'regexp)

(defcustom tramp-shell-prompt-pattern (concat (if (featurep 'xemacs) "" "\\(?:^\\|
\\)") "[^]#$%>\n]*#?[]#$%>] *\\(\\[[0-9;]*[a-zA-Z] *\\)*") "\
Regexp to match prompts from remote shell.
Normally, Tramp expects you to configure `shell-prompt-pattern'
correctly, but sometimes it happens that you are connecting to a
remote host which sends a different kind of shell prompt.  Therefore,
Tramp recognizes things matched by `shell-prompt-pattern' as prompt,
and also things matched by this variable.  The default value of this
variable is similar to the default value of `shell-prompt-pattern',
which should work well in many cases.

This regexp must match both `tramp-initial-end-of-output' and
`tramp-end-of-output'." :group 'tramp :type 'regexp)

(defcustom tramp-password-prompt-regexp (format "^.*\\(%s\\).*: ? *" (if (boundp 'password-word-equivalents) (regexp-opt (symbol-value 'password-word-equivalents)) "password\\|passphrase")) "\
Regexp matching password-like prompts.
The regexp should match at end of buffer.

The `sudo' program appears to insert a `^@' character into the prompt." :version "24.4" :group 'tramp :type 'regexp)

(defcustom tramp-wrong-passwd-regexp (concat "^.*" (regexp-opt '("Permission denied" "Login incorrect" "Login Incorrect" "Connection refused" "Connection closed" "Timeout, server not responding." "Sorry, try again." "Name or service not known" "Host key verification failed." "No supported authentication methods left to try!") t) ".*" "\\|" "^.*\\(" "Received signal [0-9]+" "\\).*") "\
Regexp matching a `login failed' message.
The regexp should match at end of buffer." :group 'tramp :type 'regexp)

(defcustom tramp-yesno-prompt-regexp (concat (regexp-opt '("Are you sure you want to continue connecting (yes/no)?") t) "\\s-*") "\
Regular expression matching all yes/no queries which need to be confirmed.
The confirmation should be done with yes or no.
The regexp should match at end of buffer.
See also `tramp-yn-prompt-regexp'." :group 'tramp :type 'regexp)

(defcustom tramp-yn-prompt-regexp (concat (regexp-opt '("Store key in cache? (y/n)" "Update cached key? (y/n, Return cancels connection)") t) "\\s-*") "\
Regular expression matching all y/n queries which need to be confirmed.
The confirmation should be done with y or n.
The regexp should match at end of buffer.
See also `tramp-yesno-prompt-regexp'." :group 'tramp :type 'regexp)

(defcustom tramp-terminal-prompt-regexp (concat "\\(" "TERM = (.*)" "\\|" "Terminal type\\? \\[.*\\]" "\\)\\s-*") "\
Regular expression matching all terminal setting prompts.
The regexp should match at end of buffer.
The answer will be provided by `tramp-action-terminal', which see." :group 'tramp :type 'regexp)

(defcustom tramp-operation-not-permitted-regexp (concat "\\(" "preserving times.*" "\\|" "set mode" "\\)" ":\\s-*" (regexp-opt '("Operation not permitted") t)) "\
Regular expression matching keep-date problems in (s)cp operations.
Copying has been performed successfully already, so this message can
be ignored safely." :group 'tramp :type 'regexp)

(defcustom tramp-copy-failed-regexp (concat "\\(.+: " (regexp-opt '("Permission denied" "not a regular file" "is a directory" "No such file or directory") t) "\\)\\s-*") "\
Regular expression matching copy problems in (s)cp operations." :group 'tramp :type 'regexp)

(defcustom tramp-process-alive-regexp "" "\
Regular expression indicating a process has finished.
In fact this expression is empty by intention, it will be used only to
check regularly the status of the associated process.
The answer will be provided by `tramp-action-process-alive',
`tramp-action-out-of-band', which see." :group 'tramp :type 'regexp)

(defcustom tramp-syntax (if (featurep 'xemacs) 'sep 'ftp) "\
Tramp filename syntax to be used.

It can have the following values:

  `ftp' -- Ange-FTP respective EFS like syntax (GNU Emacs default)
  `sep' -- Syntax as defined for XEmacs." :group 'tramp :version "24.4" :type (backquote (choice (const :tag (\, (if (featurep 'xemacs) "EFS" "Ange-FTP")) ftp) (const :tag "XEmacs" sep))))

(defcustom tramp-chunksize (when (and (not (featurep 'xemacs)) (memq system-type '(hpux))) 500) "\
If non-nil, chunksize for sending input to local process.
It is necessary only on systems which have a buggy `process-send-string'
implementation.  The necessity, whether this variable must be set, can be
checked via the following code:

  (with-temp-buffer
    (let* ((user \"xxx\") (host \"yyy\")
           (init 0) (step 50)
           (sent init) (received init))
      (while (= sent received)
        (setq sent (+ sent step))
        (erase-buffer)
        (let ((proc (start-process (buffer-name) (current-buffer)
                                   \"ssh\" \"-l\" user host \"wc\" \"-c\")))
          (when (memq (process-status proc) \\='(run open))
            (process-send-string proc (make-string sent ?\\ ))
            (process-send-eof proc)
            (process-send-eof proc))
          (while (not (progn (goto-char (point-min))
                             (re-search-forward \"\\\\w+\" (point-max) t)))
            (accept-process-output proc 1))
          (when (memq (process-status proc) \\='(run open))
            (setq received (string-to-number (match-string 0)))
            (delete-process proc)
            (message \"Bytes sent: %s\\tBytes received: %s\" sent received)
            (sit-for 0))))
      (if (> sent (+ init step))
          (message \"You should set `tramp-chunksize' to a maximum of %s\"
                   (- sent step))
        (message \"Test does not work\")
        (display-buffer (current-buffer))
        (sit-for 30))))

In the Emacs normally running Tramp, evaluate the above code
\(replace \"xxx\" and \"yyy\" by the remote user and host name,
respectively).  You can do this, for example, by pasting it into
the `*scratch*' buffer and then hitting C-j with the cursor after the
last closing parenthesis.  Note that it works only if you have configured
\"ssh\" to run without password query, see ssh-agent(1).

You will see the number of bytes sent successfully to the remote host.
If that number exceeds 1000, you can stop the execution by hitting
C-g, because your Emacs is likely clean.

When it is necessary to set `tramp-chunksize', you might consider to
use an out-of-the-band method (like \"scp\") instead of an internal one
\(like \"ssh\"), because setting `tramp-chunksize' to non-nil decreases
performance.

If your Emacs is buggy, the code stops and gives you an indication
about the value `tramp-chunksize' should be set.  Maybe you could just
experiment a bit, e.g. changing the values of `init' and `step'
in the third line of the code.

Please raise a bug report via \"M-x tramp-bug\" if your system needs
this variable to be set as well." :group 'tramp :type '(choice (const nil) integer))

(defcustom tramp-process-connection-type t "\
Overrides `process-connection-type' for connections from Tramp.
Tramp binds `process-connection-type' to the value given here before
opening a connection to a remote host." :group 'tramp :type '(choice (const nil) (const t) (const pty)))

(defcustom tramp-connection-timeout 60 "\
Defines the max time to wait for establishing a connection (in seconds).
This can be overwritten for different connection types in `tramp-methods'.

The timeout does not include the time reading a password." :group 'tramp :version "24.4" :type 'integer)

(defcustom tramp-connection-min-time-diff 5 "\
Defines seconds between two consecutive connection attempts.
This is necessary as self defense mechanism, in order to avoid
yo-yo connection attempts when the remote host is unavailable.

A value of 0 or nil suppresses this check.  This might be
necessary, when several out-of-order copy operations are
performed, or when several asynchronous processes will be started
in a short time frame.  In those cases it is recommended to
let-bind this variable." :group 'tramp :version "24.4" :type '(choice (const nil) integer))

(defcustom tramp-completion-reread-directory-timeout 10 "\
Defines seconds since last remote command before rereading a directory.
A remote directory might have changed its contents.  In order to
make it visible during file name completion in the minibuffer,
Tramp flushes its cache and rereads the directory contents when
more than `tramp-completion-reread-directory-timeout' seconds
have been gone since last remote command execution.  A value of t
would require an immediate reread during filename completion, nil
means to use always cached values for the directory contents." :group 'tramp :type '(choice (const nil) (const t) integer))

;;;***

(provide 'tramp-custom-defines)
