// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package abi

import (
	"math/big"
	"strings"

	ethereum "energi.world/core/gen3"
	"energi.world/core/gen3/accounts/abi"
	"energi.world/core/gen3/accounts/abi/bind"
	"energi.world/core/gen3/common"
	"energi.world/core/gen3/core/types"
	"energi.world/core/gen3/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = abi.U256
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// CheckpointRegistryV3ABI is the input ABI used to generate the binding from.
const CheckpointRegistryV3ABI = "[{\"inputs\":[{\"internalType\":\"address\",\"name\":\"_proxy\",\"type\":\"address\"},{\"internalType\":\"contractIGovernedProxy\",\"name\":\"_mnregistry_proxy\",\"type\":\"address\"},{\"internalType\":\"address\",\"name\":\"_cpp_signer\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"constructor\"},{\"anonymous\":false,\"inputs\":[{\"indexed\":true,\"internalType\":\"uint256\",\"name\":\"number\",\"type\":\"uint256\"},{\"indexed\":false,\"internalType\":\"bytes32\",\"name\":\"hash\",\"type\":\"bytes32\"},{\"indexed\":false,\"internalType\":\"contractICheckpoint\",\"name\":\"checkpoint\",\"type\":\"address\"}],\"name\":\"Checkpoint\",\"type\":\"event\"},{\"payable\":true,\"stateMutability\":\"payable\",\"type\":\"fallback\"},{\"constant\":true,\"inputs\":[],\"name\":\"CPP_signer\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"checkpoints\",\"outputs\":[{\"internalType\":\"contractICheckpoint[]\",\"name\":\"\",\"type\":\"address[]\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_newImpl\",\"type\":\"address\"}],\"name\":\"destroy\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractIGovernedContract\",\"name\":\"_oldImpl\",\"type\":\"address\"}],\"name\":\"migrate\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"mnregistry_proxy\",\"outputs\":[{\"internalType\":\"contractIGovernedProxy\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"number\",\"type\":\"uint256\"},{\"internalType\":\"bytes32\",\"name\":\"hash\",\"type\":\"bytes32\"},{\"internalType\":\"bytes\",\"name\":\"signature\",\"type\":\"bytes\"}],\"name\":\"propose\",\"outputs\":[{\"internalType\":\"contractICheckpoint\",\"name\":\"checkpoint\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"proxy\",\"outputs\":[{\"internalType\":\"address\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"number\",\"type\":\"uint256\"},{\"internalType\":\"bytes32\",\"name\":\"hash\",\"type\":\"bytes32\"},{\"internalType\":\"bytes\",\"name\":\"signature\",\"type\":\"bytes\"}],\"name\":\"remove\",\"outputs\":[{\"internalType\":\"bool\",\"name\":\"deleted\",\"type\":\"bool\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"internalType\":\"contractICheckpoint\",\"name\":\"checkpoint\",\"type\":\"address\"},{\"internalType\":\"bytes\",\"name\":\"signature\",\"type\":\"bytes\"}],\"name\":\"sign\",\"outputs\":[],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"internalType\":\"uint256\",\"name\":\"number\",\"type\":\"uint256\"},{\"internalType\":\"bytes32\",\"name\":\"hash\",\"type\":\"bytes32\"}],\"name\":\"signatureBase\",\"outputs\":[{\"internalType\":\"bytes32\",\"name\":\"sigbase\",\"type\":\"bytes32\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"v2storage\",\"outputs\":[{\"internalType\":\"contractStorageCheckpointRegistryV2\",\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"}]"

// CheckpointRegistryV3Bin is the compiled bytecode used for deploying new contracts.
const CheckpointRegistryV3Bin = `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`

// DeployCheckpointRegistryV3 deploys a new Ethereum contract, binding an instance of CheckpointRegistryV3 to it.
func DeployCheckpointRegistryV3(auth *bind.TransactOpts, backend bind.ContractBackend, _proxy common.Address, _mnregistry_proxy common.Address, _cpp_signer common.Address) (common.Address, *types.Transaction, *CheckpointRegistryV3, error) {
	parsed, err := abi.JSON(strings.NewReader(CheckpointRegistryV3ABI))
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	address, tx, contract, err := bind.DeployContract(auth, parsed, common.FromHex(CheckpointRegistryV3Bin), backend, _proxy, _mnregistry_proxy, _cpp_signer)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &CheckpointRegistryV3{CheckpointRegistryV3Caller: CheckpointRegistryV3Caller{contract: contract}, CheckpointRegistryV3Transactor: CheckpointRegistryV3Transactor{contract: contract}, CheckpointRegistryV3Filterer: CheckpointRegistryV3Filterer{contract: contract}}, nil
}

// CheckpointRegistryV3Bin is the compiled bytecode of contract after deployment.
const CheckpointRegistryV3RuntimeBin = `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`

// CheckpointRegistryV3 is an auto generated Go binding around an Ethereum contract.
type CheckpointRegistryV3 struct {
	CheckpointRegistryV3Caller     // Read-only binding to the contract
	CheckpointRegistryV3Transactor // Write-only binding to the contract
	CheckpointRegistryV3Filterer   // Log filterer for contract events
}

// CheckpointRegistryV3Caller is an auto generated read-only Go binding around an Ethereum contract.
type CheckpointRegistryV3Caller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// CheckpointRegistryV3Transactor is an auto generated write-only Go binding around an Ethereum contract.
type CheckpointRegistryV3Transactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// CheckpointRegistryV3Filterer is an auto generated log filtering Go binding around an Ethereum contract events.
type CheckpointRegistryV3Filterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// CheckpointRegistryV3Session is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type CheckpointRegistryV3Session struct {
	Contract     *CheckpointRegistryV3 // Generic contract binding to set the session for
	CallOpts     bind.CallOpts         // Call options to use throughout this session
	TransactOpts bind.TransactOpts     // Transaction auth options to use throughout this session
}

// CheckpointRegistryV3CallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type CheckpointRegistryV3CallerSession struct {
	Contract *CheckpointRegistryV3Caller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts               // Call options to use throughout this session
}

// CheckpointRegistryV3TransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type CheckpointRegistryV3TransactorSession struct {
	Contract     *CheckpointRegistryV3Transactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts               // Transaction auth options to use throughout this session
}

// CheckpointRegistryV3Raw is an auto generated low-level Go binding around an Ethereum contract.
type CheckpointRegistryV3Raw struct {
	Contract *CheckpointRegistryV3 // Generic contract binding to access the raw methods on
}

// CheckpointRegistryV3CallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type CheckpointRegistryV3CallerRaw struct {
	Contract *CheckpointRegistryV3Caller // Generic read-only contract binding to access the raw methods on
}

// CheckpointRegistryV3TransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type CheckpointRegistryV3TransactorRaw struct {
	Contract *CheckpointRegistryV3Transactor // Generic write-only contract binding to access the raw methods on
}

// NewCheckpointRegistryV3 creates a new instance of CheckpointRegistryV3, bound to a specific deployed contract.
func NewCheckpointRegistryV3(address common.Address, backend bind.ContractBackend) (*CheckpointRegistryV3, error) {
	contract, err := bindCheckpointRegistryV3(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &CheckpointRegistryV3{CheckpointRegistryV3Caller: CheckpointRegistryV3Caller{contract: contract}, CheckpointRegistryV3Transactor: CheckpointRegistryV3Transactor{contract: contract}, CheckpointRegistryV3Filterer: CheckpointRegistryV3Filterer{contract: contract}}, nil
}

// NewCheckpointRegistryV3Caller creates a new read-only instance of CheckpointRegistryV3, bound to a specific deployed contract.
func NewCheckpointRegistryV3Caller(address common.Address, caller bind.ContractCaller) (*CheckpointRegistryV3Caller, error) {
	contract, err := bindCheckpointRegistryV3(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &CheckpointRegistryV3Caller{contract: contract}, nil
}

// NewCheckpointRegistryV3Transactor creates a new write-only instance of CheckpointRegistryV3, bound to a specific deployed contract.
func NewCheckpointRegistryV3Transactor(address common.Address, transactor bind.ContractTransactor) (*CheckpointRegistryV3Transactor, error) {
	contract, err := bindCheckpointRegistryV3(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &CheckpointRegistryV3Transactor{contract: contract}, nil
}

// NewCheckpointRegistryV3Filterer creates a new log filterer instance of CheckpointRegistryV3, bound to a specific deployed contract.
func NewCheckpointRegistryV3Filterer(address common.Address, filterer bind.ContractFilterer) (*CheckpointRegistryV3Filterer, error) {
	contract, err := bindCheckpointRegistryV3(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &CheckpointRegistryV3Filterer{contract: contract}, nil
}

// bindCheckpointRegistryV3 binds a generic wrapper to an already deployed contract.
func bindCheckpointRegistryV3(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(CheckpointRegistryV3ABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_CheckpointRegistryV3 *CheckpointRegistryV3Raw) Call(opts *bind.CallOpts, result interface{}, method string, params ...interface{}) error {
	return _CheckpointRegistryV3.Contract.CheckpointRegistryV3Caller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_CheckpointRegistryV3 *CheckpointRegistryV3Raw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.CheckpointRegistryV3Transactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_CheckpointRegistryV3 *CheckpointRegistryV3Raw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.CheckpointRegistryV3Transactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_CheckpointRegistryV3 *CheckpointRegistryV3CallerRaw) Call(opts *bind.CallOpts, result interface{}, method string, params ...interface{}) error {
	return _CheckpointRegistryV3.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_CheckpointRegistryV3 *CheckpointRegistryV3TransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_CheckpointRegistryV3 *CheckpointRegistryV3TransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.contract.Transact(opts, method, params...)
}

// CPPSigner is a free data retrieval call binding the contract method 0xd59f1758.
//
// Solidity: function CPP_signer() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Caller) CPPSigner(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _CheckpointRegistryV3.contract.Call(opts, out, "CPP_signer")
	return *ret0, err
}

// CPPSigner is a free data retrieval call binding the contract method 0xd59f1758.
//
// Solidity: function CPP_signer() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) CPPSigner() (common.Address, error) {
	return _CheckpointRegistryV3.Contract.CPPSigner(&_CheckpointRegistryV3.CallOpts)
}

// CPPSigner is a free data retrieval call binding the contract method 0xd59f1758.
//
// Solidity: function CPP_signer() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3CallerSession) CPPSigner() (common.Address, error) {
	return _CheckpointRegistryV3.Contract.CPPSigner(&_CheckpointRegistryV3.CallOpts)
}

// Checkpoints is a free data retrieval call binding the contract method 0x5a48c0b0.
//
// Solidity: function checkpoints() constant returns(address[])
func (_CheckpointRegistryV3 *CheckpointRegistryV3Caller) Checkpoints(opts *bind.CallOpts) ([]common.Address, error) {
	var (
		ret0 = new([]common.Address)
	)
	out := ret0
	err := _CheckpointRegistryV3.contract.Call(opts, out, "checkpoints")
	return *ret0, err
}

// Checkpoints is a free data retrieval call binding the contract method 0x5a48c0b0.
//
// Solidity: function checkpoints() constant returns(address[])
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) Checkpoints() ([]common.Address, error) {
	return _CheckpointRegistryV3.Contract.Checkpoints(&_CheckpointRegistryV3.CallOpts)
}

// Checkpoints is a free data retrieval call binding the contract method 0x5a48c0b0.
//
// Solidity: function checkpoints() constant returns(address[])
func (_CheckpointRegistryV3 *CheckpointRegistryV3CallerSession) Checkpoints() ([]common.Address, error) {
	return _CheckpointRegistryV3.Contract.Checkpoints(&_CheckpointRegistryV3.CallOpts)
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Caller) MnregistryProxy(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _CheckpointRegistryV3.contract.Call(opts, out, "mnregistry_proxy")
	return *ret0, err
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) MnregistryProxy() (common.Address, error) {
	return _CheckpointRegistryV3.Contract.MnregistryProxy(&_CheckpointRegistryV3.CallOpts)
}

// MnregistryProxy is a free data retrieval call binding the contract method 0xfe7334e8.
//
// Solidity: function mnregistry_proxy() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3CallerSession) MnregistryProxy() (common.Address, error) {
	return _CheckpointRegistryV3.Contract.MnregistryProxy(&_CheckpointRegistryV3.CallOpts)
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Caller) Proxy(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _CheckpointRegistryV3.contract.Call(opts, out, "proxy")
	return *ret0, err
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) Proxy() (common.Address, error) {
	return _CheckpointRegistryV3.Contract.Proxy(&_CheckpointRegistryV3.CallOpts)
}

// Proxy is a free data retrieval call binding the contract method 0xec556889.
//
// Solidity: function proxy() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3CallerSession) Proxy() (common.Address, error) {
	return _CheckpointRegistryV3.Contract.Proxy(&_CheckpointRegistryV3.CallOpts)
}

// SignatureBase is a free data retrieval call binding the contract method 0x851f2209.
//
// Solidity: function signatureBase(uint256 number, bytes32 hash) constant returns(bytes32 sigbase)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Caller) SignatureBase(opts *bind.CallOpts, number *big.Int, hash [32]byte) ([32]byte, error) {
	var (
		ret0 = new([32]byte)
	)
	out := ret0
	err := _CheckpointRegistryV3.contract.Call(opts, out, "signatureBase", number, hash)
	return *ret0, err
}

// SignatureBase is a free data retrieval call binding the contract method 0x851f2209.
//
// Solidity: function signatureBase(uint256 number, bytes32 hash) constant returns(bytes32 sigbase)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) SignatureBase(number *big.Int, hash [32]byte) ([32]byte, error) {
	return _CheckpointRegistryV3.Contract.SignatureBase(&_CheckpointRegistryV3.CallOpts, number, hash)
}

// SignatureBase is a free data retrieval call binding the contract method 0x851f2209.
//
// Solidity: function signatureBase(uint256 number, bytes32 hash) constant returns(bytes32 sigbase)
func (_CheckpointRegistryV3 *CheckpointRegistryV3CallerSession) SignatureBase(number *big.Int, hash [32]byte) ([32]byte, error) {
	return _CheckpointRegistryV3.Contract.SignatureBase(&_CheckpointRegistryV3.CallOpts, number, hash)
}

// V2storage is a free data retrieval call binding the contract method 0x78d0970f.
//
// Solidity: function v2storage() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Caller) V2storage(opts *bind.CallOpts) (common.Address, error) {
	var (
		ret0 = new(common.Address)
	)
	out := ret0
	err := _CheckpointRegistryV3.contract.Call(opts, out, "v2storage")
	return *ret0, err
}

// V2storage is a free data retrieval call binding the contract method 0x78d0970f.
//
// Solidity: function v2storage() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) V2storage() (common.Address, error) {
	return _CheckpointRegistryV3.Contract.V2storage(&_CheckpointRegistryV3.CallOpts)
}

// V2storage is a free data retrieval call binding the contract method 0x78d0970f.
//
// Solidity: function v2storage() constant returns(address)
func (_CheckpointRegistryV3 *CheckpointRegistryV3CallerSession) V2storage() (common.Address, error) {
	return _CheckpointRegistryV3.Contract.V2storage(&_CheckpointRegistryV3.CallOpts)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_CheckpointRegistryV3 *CheckpointRegistryV3Transactor) Destroy(opts *bind.TransactOpts, _newImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV3.contract.Transact(opts, "destroy", _newImpl)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) Destroy(_newImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.Destroy(&_CheckpointRegistryV3.TransactOpts, _newImpl)
}

// Destroy is a paid mutator transaction binding the contract method 0x00f55d9d.
//
// Solidity: function destroy(address _newImpl) returns()
func (_CheckpointRegistryV3 *CheckpointRegistryV3TransactorSession) Destroy(_newImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.Destroy(&_CheckpointRegistryV3.TransactOpts, _newImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_CheckpointRegistryV3 *CheckpointRegistryV3Transactor) Migrate(opts *bind.TransactOpts, _oldImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV3.contract.Transact(opts, "migrate", _oldImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) Migrate(_oldImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.Migrate(&_CheckpointRegistryV3.TransactOpts, _oldImpl)
}

// Migrate is a paid mutator transaction binding the contract method 0xce5494bb.
//
// Solidity: function migrate(address _oldImpl) returns()
func (_CheckpointRegistryV3 *CheckpointRegistryV3TransactorSession) Migrate(_oldImpl common.Address) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.Migrate(&_CheckpointRegistryV3.TransactOpts, _oldImpl)
}

// Propose is a paid mutator transaction binding the contract method 0xc20fa2ee.
//
// Solidity: function propose(uint256 number, bytes32 hash, bytes signature) returns(address checkpoint)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Transactor) Propose(opts *bind.TransactOpts, number *big.Int, hash [32]byte, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV3.contract.Transact(opts, "propose", number, hash, signature)
}

// Propose is a paid mutator transaction binding the contract method 0xc20fa2ee.
//
// Solidity: function propose(uint256 number, bytes32 hash, bytes signature) returns(address checkpoint)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) Propose(number *big.Int, hash [32]byte, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.Propose(&_CheckpointRegistryV3.TransactOpts, number, hash, signature)
}

// Propose is a paid mutator transaction binding the contract method 0xc20fa2ee.
//
// Solidity: function propose(uint256 number, bytes32 hash, bytes signature) returns(address checkpoint)
func (_CheckpointRegistryV3 *CheckpointRegistryV3TransactorSession) Propose(number *big.Int, hash [32]byte, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.Propose(&_CheckpointRegistryV3.TransactOpts, number, hash, signature)
}

// Remove is a paid mutator transaction binding the contract method 0x082e0c9c.
//
// Solidity: function remove(uint256 number, bytes32 hash, bytes signature) returns(bool deleted)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Transactor) Remove(opts *bind.TransactOpts, number *big.Int, hash [32]byte, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV3.contract.Transact(opts, "remove", number, hash, signature)
}

// Remove is a paid mutator transaction binding the contract method 0x082e0c9c.
//
// Solidity: function remove(uint256 number, bytes32 hash, bytes signature) returns(bool deleted)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) Remove(number *big.Int, hash [32]byte, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.Remove(&_CheckpointRegistryV3.TransactOpts, number, hash, signature)
}

// Remove is a paid mutator transaction binding the contract method 0x082e0c9c.
//
// Solidity: function remove(uint256 number, bytes32 hash, bytes signature) returns(bool deleted)
func (_CheckpointRegistryV3 *CheckpointRegistryV3TransactorSession) Remove(number *big.Int, hash [32]byte, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.Remove(&_CheckpointRegistryV3.TransactOpts, number, hash, signature)
}

// Sign is a paid mutator transaction binding the contract method 0x51fae959.
//
// Solidity: function sign(address checkpoint, bytes signature) returns()
func (_CheckpointRegistryV3 *CheckpointRegistryV3Transactor) Sign(opts *bind.TransactOpts, checkpoint common.Address, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV3.contract.Transact(opts, "sign", checkpoint, signature)
}

// Sign is a paid mutator transaction binding the contract method 0x51fae959.
//
// Solidity: function sign(address checkpoint, bytes signature) returns()
func (_CheckpointRegistryV3 *CheckpointRegistryV3Session) Sign(checkpoint common.Address, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.Sign(&_CheckpointRegistryV3.TransactOpts, checkpoint, signature)
}

// Sign is a paid mutator transaction binding the contract method 0x51fae959.
//
// Solidity: function sign(address checkpoint, bytes signature) returns()
func (_CheckpointRegistryV3 *CheckpointRegistryV3TransactorSession) Sign(checkpoint common.Address, signature []byte) (*types.Transaction, error) {
	return _CheckpointRegistryV3.Contract.Sign(&_CheckpointRegistryV3.TransactOpts, checkpoint, signature)
}

// CheckpointRegistryV3CheckpointIterator is returned from FilterCheckpoint and is used to iterate over the raw logs and unpacked data for Checkpoint events raised by the CheckpointRegistryV3 contract.
type CheckpointRegistryV3CheckpointIterator struct {
	Event *CheckpointRegistryV3Checkpoint // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *CheckpointRegistryV3CheckpointIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(CheckpointRegistryV3Checkpoint)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(CheckpointRegistryV3Checkpoint)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *CheckpointRegistryV3CheckpointIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *CheckpointRegistryV3CheckpointIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// CheckpointRegistryV3Checkpoint represents a Checkpoint event raised by the CheckpointRegistryV3 contract.
type CheckpointRegistryV3Checkpoint struct {
	Number     *big.Int
	Hash       [32]byte
	Checkpoint common.Address
	Raw        types.Log // Blockchain specific contextual infos
}

// FilterCheckpoint is a free log retrieval operation binding the contract event 0x7f582e7a234c68b135245365b0c69d608f9235392a1ef801b46f04ca5d6cdad4.
//
// Solidity: event Checkpoint(uint256 indexed number, bytes32 hash, address checkpoint)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Filterer) FilterCheckpoint(opts *bind.FilterOpts, number []*big.Int) (*CheckpointRegistryV3CheckpointIterator, error) {

	var numberRule []interface{}
	for _, numberItem := range number {
		numberRule = append(numberRule, numberItem)
	}

	logs, sub, err := _CheckpointRegistryV3.contract.FilterLogs(opts, "Checkpoint", numberRule)
	if err != nil {
		return nil, err
	}
	return &CheckpointRegistryV3CheckpointIterator{contract: _CheckpointRegistryV3.contract, event: "Checkpoint", logs: logs, sub: sub}, nil
}

// WatchCheckpoint is a free log subscription operation binding the contract event 0x7f582e7a234c68b135245365b0c69d608f9235392a1ef801b46f04ca5d6cdad4.
//
// Solidity: event Checkpoint(uint256 indexed number, bytes32 hash, address checkpoint)
func (_CheckpointRegistryV3 *CheckpointRegistryV3Filterer) WatchCheckpoint(opts *bind.WatchOpts, sink chan<- *CheckpointRegistryV3Checkpoint, number []*big.Int) (event.Subscription, error) {

	var numberRule []interface{}
	for _, numberItem := range number {
		numberRule = append(numberRule, numberItem)
	}

	logs, sub, err := _CheckpointRegistryV3.contract.WatchLogs(opts, "Checkpoint", numberRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(CheckpointRegistryV3Checkpoint)
				if err := _CheckpointRegistryV3.contract.UnpackLog(event, "Checkpoint", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}
