//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilecoordinatorreadingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFileCoordinatorReadingOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSFileCoordinatorReadingOptions: NSUInteger {
        #[doc(alias = "NSFileCoordinatorReadingWithoutChanges")]
        const WithoutChanges = 1<<0;
        #[doc(alias = "NSFileCoordinatorReadingResolvesSymbolicLink")]
        const ResolvesSymbolicLink = 1<<1;
        #[doc(alias = "NSFileCoordinatorReadingImmediatelyAvailableMetadataOnly")]
        const ImmediatelyAvailableMetadataOnly = 1<<2;
        #[doc(alias = "NSFileCoordinatorReadingForUploading")]
        const ForUploading = 1<<3;
    }
}

unsafe impl Encode for NSFileCoordinatorReadingOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFileCoordinatorReadingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilecoordinatorwritingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFileCoordinatorWritingOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSFileCoordinatorWritingOptions: NSUInteger {
        #[doc(alias = "NSFileCoordinatorWritingForDeleting")]
        const ForDeleting = 1<<0;
        #[doc(alias = "NSFileCoordinatorWritingForMoving")]
        const ForMoving = 1<<1;
        #[doc(alias = "NSFileCoordinatorWritingForMerging")]
        const ForMerging = 1<<2;
        #[doc(alias = "NSFileCoordinatorWritingForReplacing")]
        const ForReplacing = 1<<3;
        #[doc(alias = "NSFileCoordinatorWritingContentIndependentMetadataOnly")]
        const ContentIndependentMetadataOnly = 1<<4;
    }
}

unsafe impl Encode for NSFileCoordinatorWritingOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFileCoordinatorWritingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileaccessintent?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSFileAccessIntent;
);

unsafe impl Send for NSFileAccessIntent {}

unsafe impl Sync for NSFileAccessIntent {}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSFileAccessIntent {}
);

impl NSFileAccessIntent {
    extern_methods!(
        #[cfg(feature = "NSURL")]
        #[unsafe(method(readingIntentWithURL:options:))]
        #[unsafe(method_family = none)]
        pub fn readingIntentWithURL_options(
            url: &NSURL,
            options: NSFileCoordinatorReadingOptions,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(writingIntentWithURL:options:))]
        #[unsafe(method_family = none)]
        pub fn writingIntentWithURL_options(
            url: &NSURL,
            options: NSFileCoordinatorWritingOptions,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(URL))]
        #[unsafe(method_family = none)]
        pub fn URL(&self) -> Retained<NSURL>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSFileAccessIntent {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSFileAccessIntent {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilecoordinator?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSFileCoordinator;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSFileCoordinator {}
);

impl NSFileCoordinator {
    extern_methods!(
        #[cfg(feature = "NSFilePresenter")]
        #[unsafe(method(addFilePresenter:))]
        #[unsafe(method_family = none)]
        pub fn addFilePresenter(file_presenter: &ProtocolObject<dyn NSFilePresenter>);

        #[cfg(feature = "NSFilePresenter")]
        #[unsafe(method(removeFilePresenter:))]
        #[unsafe(method_family = none)]
        pub fn removeFilePresenter(file_presenter: &ProtocolObject<dyn NSFilePresenter>);

        #[cfg(all(feature = "NSArray", feature = "NSFilePresenter"))]
        #[unsafe(method(filePresenters))]
        #[unsafe(method_family = none)]
        pub fn filePresenters() -> Retained<NSArray<ProtocolObject<dyn NSFilePresenter>>>;

        #[cfg(feature = "NSFilePresenter")]
        #[unsafe(method(initWithFilePresenter:))]
        #[unsafe(method_family = init)]
        pub fn initWithFilePresenter(
            this: Allocated<Self>,
            file_presenter_or_nil: Option<&ProtocolObject<dyn NSFilePresenter>>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(purposeIdentifier))]
        #[unsafe(method_family = none)]
        pub fn purposeIdentifier(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        /// Setter for [`purposeIdentifier`][Self::purposeIdentifier].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setPurposeIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn setPurposeIdentifier(&self, purpose_identifier: &NSString);

        #[cfg(all(
            feature = "NSArray",
            feature = "NSError",
            feature = "NSOperation",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// - `queue` possibly has additional threading requirements.
        /// - `accessor` block must be sendable.
        #[unsafe(method(coordinateAccessWithIntents:queue:byAccessor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn coordinateAccessWithIntents_queue_byAccessor(
            &self,
            intents: &NSArray<NSFileAccessIntent>,
            queue: &NSOperationQueue,
            accessor: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "NSError", feature = "NSURL", feature = "block2"))]
        #[unsafe(method(coordinateReadingItemAtURL:options:error:byAccessor:))]
        #[unsafe(method_family = none)]
        pub fn coordinateReadingItemAtURL_options_error_byAccessor(
            &self,
            url: &NSURL,
            options: NSFileCoordinatorReadingOptions,
            out_error: Option<&mut Option<Retained<NSError>>>,
            reader: &block2::DynBlock<dyn Fn(NonNull<NSURL>) + '_>,
        );

        #[cfg(all(feature = "NSError", feature = "NSURL", feature = "block2"))]
        #[unsafe(method(coordinateWritingItemAtURL:options:error:byAccessor:))]
        #[unsafe(method_family = none)]
        pub fn coordinateWritingItemAtURL_options_error_byAccessor(
            &self,
            url: &NSURL,
            options: NSFileCoordinatorWritingOptions,
            out_error: Option<&mut Option<Retained<NSError>>>,
            writer: &block2::DynBlock<dyn Fn(NonNull<NSURL>) + '_>,
        );

        #[cfg(all(feature = "NSError", feature = "NSURL", feature = "block2"))]
        #[unsafe(method(coordinateReadingItemAtURL:options:writingItemAtURL:options:error:byAccessor:))]
        #[unsafe(method_family = none)]
        pub fn coordinateReadingItemAtURL_options_writingItemAtURL_options_error_byAccessor(
            &self,
            reading_url: &NSURL,
            reading_options: NSFileCoordinatorReadingOptions,
            writing_url: &NSURL,
            writing_options: NSFileCoordinatorWritingOptions,
            out_error: Option<&mut Option<Retained<NSError>>>,
            reader_writer: &block2::DynBlock<dyn Fn(NonNull<NSURL>, NonNull<NSURL>) + '_>,
        );

        #[cfg(all(feature = "NSError", feature = "NSURL", feature = "block2"))]
        #[unsafe(method(coordinateWritingItemAtURL:options:writingItemAtURL:options:error:byAccessor:))]
        #[unsafe(method_family = none)]
        pub fn coordinateWritingItemAtURL_options_writingItemAtURL_options_error_byAccessor(
            &self,
            url1: &NSURL,
            options1: NSFileCoordinatorWritingOptions,
            url2: &NSURL,
            options2: NSFileCoordinatorWritingOptions,
            out_error: Option<&mut Option<Retained<NSError>>>,
            writer: &block2::DynBlock<dyn Fn(NonNull<NSURL>, NonNull<NSURL>) + '_>,
        );

        #[cfg(all(
            feature = "NSArray",
            feature = "NSError",
            feature = "NSURL",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `batch_accessor` block's argument block must be sendable.
        #[unsafe(method(prepareForReadingItemsAtURLs:options:writingItemsAtURLs:options:error:byAccessor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn prepareForReadingItemsAtURLs_options_writingItemsAtURLs_options_error_byAccessor(
            &self,
            reading_ur_ls: &NSArray<NSURL>,
            reading_options: NSFileCoordinatorReadingOptions,
            writing_ur_ls: &NSArray<NSURL>,
            writing_options: NSFileCoordinatorWritingOptions,
            out_error: Option<&mut Option<Retained<NSError>>>,
            batch_accessor: &block2::DynBlock<dyn Fn(NonNull<block2::DynBlock<dyn Fn()>>) + '_>,
        );

        #[cfg(feature = "NSURL")]
        #[unsafe(method(itemAtURL:willMoveToURL:))]
        #[unsafe(method_family = none)]
        pub fn itemAtURL_willMoveToURL(&self, old_url: &NSURL, new_url: &NSURL);

        #[cfg(feature = "NSURL")]
        #[unsafe(method(itemAtURL:didMoveToURL:))]
        #[unsafe(method_family = none)]
        pub fn itemAtURL_didMoveToURL(&self, old_url: &NSURL, new_url: &NSURL);

        #[cfg(all(feature = "NSSet", feature = "NSString", feature = "NSURL"))]
        #[unsafe(method(itemAtURL:didChangeUbiquityAttributes:))]
        #[unsafe(method_family = none)]
        pub fn itemAtURL_didChangeUbiquityAttributes(
            &self,
            url: &NSURL,
            attributes: &NSSet<NSURLResourceKey>,
        );

        #[unsafe(method(cancel))]
        #[unsafe(method_family = none)]
        pub fn cancel(&self);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSFileCoordinator {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSFileCoordinator {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}
