// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package fcgi_app

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetFCGIAppsOKCode is the HTTP code returned for type GetFCGIAppsOK
const GetFCGIAppsOKCode int = 200

/*
GetFCGIAppsOK Successful operation

swagger:response getFcgiAppsOK
*/
type GetFCGIAppsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.FCGIApps `json:"body,omitempty"`
}

// NewGetFCGIAppsOK creates GetFCGIAppsOK with default headers values
func NewGetFCGIAppsOK() *GetFCGIAppsOK {

	return &GetFCGIAppsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Fcgi apps o k response
func (o *GetFCGIAppsOK) WithConfigurationVersion(configurationVersion string) *GetFCGIAppsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Fcgi apps o k response
func (o *GetFCGIAppsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Fcgi apps o k response
func (o *GetFCGIAppsOK) WithPayload(payload models.FCGIApps) *GetFCGIAppsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Fcgi apps o k response
func (o *GetFCGIAppsOK) SetPayload(payload models.FCGIApps) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFCGIAppsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.FCGIApps{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetFCGIAppsDefault General Error

swagger:response getFcgiAppsDefault
*/
type GetFCGIAppsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetFCGIAppsDefault creates GetFCGIAppsDefault with default headers values
func NewGetFCGIAppsDefault(code int) *GetFCGIAppsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetFCGIAppsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get FCGI apps default response
func (o *GetFCGIAppsDefault) WithStatusCode(code int) *GetFCGIAppsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get FCGI apps default response
func (o *GetFCGIAppsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get FCGI apps default response
func (o *GetFCGIAppsDefault) WithConfigurationVersion(configurationVersion string) *GetFCGIAppsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get FCGI apps default response
func (o *GetFCGIAppsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get FCGI apps default response
func (o *GetFCGIAppsDefault) WithPayload(payload *models.Error) *GetFCGIAppsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get FCGI apps default response
func (o *GetFCGIAppsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFCGIAppsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
