package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNodeGroup invokes the linkwan.GetNodeGroup API synchronously
func (client *Client) GetNodeGroup(request *GetNodeGroupRequest) (response *GetNodeGroupResponse, err error) {
	response = CreateGetNodeGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetNodeGroupWithChan invokes the linkwan.GetNodeGroup API asynchronously
func (client *Client) GetNodeGroupWithChan(request *GetNodeGroupRequest) (<-chan *GetNodeGroupResponse, <-chan error) {
	responseChan := make(chan *GetNodeGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNodeGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNodeGroupWithCallback invokes the linkwan.GetNodeGroup API asynchronously
func (client *Client) GetNodeGroupWithCallback(request *GetNodeGroupRequest, callback func(response *GetNodeGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNodeGroupResponse
		var err error
		defer close(result)
		response, err = client.GetNodeGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNodeGroupRequest is the request struct for api GetNodeGroup
type GetNodeGroupRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	NodeGroupId   string `position:"Query" name:"NodeGroupId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// GetNodeGroupResponse is the response struct for api GetNodeGroup
type GetNodeGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetNodeGroupRequest creates a request to invoke GetNodeGroup API
func CreateGetNodeGroupRequest() (request *GetNodeGroupRequest) {
	request = &GetNodeGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetNodeGroup", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNodeGroupResponse creates a response to parse from GetNodeGroup response
func CreateGetNodeGroupResponse() (response *GetNodeGroupResponse) {
	response = &GetNodeGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
