package imagerecog

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeImageStyle invokes the imagerecog.RecognizeImageStyle API synchronously
func (client *Client) RecognizeImageStyle(request *RecognizeImageStyleRequest) (response *RecognizeImageStyleResponse, err error) {
	response = CreateRecognizeImageStyleResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeImageStyleWithChan invokes the imagerecog.RecognizeImageStyle API asynchronously
func (client *Client) RecognizeImageStyleWithChan(request *RecognizeImageStyleRequest) (<-chan *RecognizeImageStyleResponse, <-chan error) {
	responseChan := make(chan *RecognizeImageStyleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeImageStyle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeImageStyleWithCallback invokes the imagerecog.RecognizeImageStyle API asynchronously
func (client *Client) RecognizeImageStyleWithCallback(request *RecognizeImageStyleRequest, callback func(response *RecognizeImageStyleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeImageStyleResponse
		var err error
		defer close(result)
		response, err = client.RecognizeImageStyle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeImageStyleRequest is the request struct for api RecognizeImageStyle
type RecognizeImageStyleRequest struct {
	*requests.RpcRequest
	Url string `position:"Body" name:"Url"`
}

// RecognizeImageStyleResponse is the response struct for api RecognizeImageStyle
type RecognizeImageStyleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeImageStyleRequest creates a request to invoke RecognizeImageStyle API
func CreateRecognizeImageStyleRequest() (request *RecognizeImageStyleRequest) {
	request = &RecognizeImageStyleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imagerecog", "2019-09-30", "RecognizeImageStyle", "imagerecog", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeImageStyleResponse creates a response to parse from RecognizeImageStyle response
func CreateRecognizeImageStyleResponse() (response *RecognizeImageStyleResponse) {
	response = &RecognizeImageStyleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
