package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogBackups invokes the gpdb.DescribeLogBackups API synchronously
func (client *Client) DescribeLogBackups(request *DescribeLogBackupsRequest) (response *DescribeLogBackupsResponse, err error) {
	response = CreateDescribeLogBackupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogBackupsWithChan invokes the gpdb.DescribeLogBackups API asynchronously
func (client *Client) DescribeLogBackupsWithChan(request *DescribeLogBackupsRequest) (<-chan *DescribeLogBackupsResponse, <-chan error) {
	responseChan := make(chan *DescribeLogBackupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogBackups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogBackupsWithCallback invokes the gpdb.DescribeLogBackups API asynchronously
func (client *Client) DescribeLogBackupsWithCallback(request *DescribeLogBackupsRequest, callback func(response *DescribeLogBackupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogBackupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogBackups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogBackupsRequest is the request struct for api DescribeLogBackups
type DescribeLogBackupsRequest struct {
	*requests.RpcRequest
	StartTime    string           `position:"Query" name:"StartTime"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	EndTime      string           `position:"Query" name:"EndTime"`
}

// DescribeLogBackupsResponse is the response struct for api DescribeLogBackups
type DescribeLogBackupsResponse struct {
	*responses.BaseResponse
	TotalLogSize int64    `json:"TotalLogSize" xml:"TotalLogSize"`
	PageSize     int      `json:"PageSize" xml:"PageSize"`
	PageNumber   int      `json:"PageNumber" xml:"PageNumber"`
	RequestId    string   `json:"RequestId" xml:"RequestId"`
	TotalCount   int      `json:"TotalCount" xml:"TotalCount"`
	Items        []Backup `json:"Items" xml:"Items"`
}

// CreateDescribeLogBackupsRequest creates a request to invoke DescribeLogBackups API
func CreateDescribeLogBackupsRequest() (request *DescribeLogBackupsRequest) {
	request = &DescribeLogBackupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeLogBackups", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeLogBackupsResponse creates a response to parse from DescribeLogBackups response
func CreateDescribeLogBackupsResponse() (response *DescribeLogBackupsResponse) {
	response = &DescribeLogBackupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
