/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef URTREE_H
#define URTREE_H

#include <iostream>
#include <fstream>

#include "ali.h"
#include "innd.h"
#include "inndarr.h"
#include "exndarr.h"
#include "brarr.h"
#include "opturtree.h"
#include "outstream.h"
#include "cluster.h"
#include "clusterarr.h"
#include "model.h"
#include "seqpair.h"

using namespace std;

//this class is a description of urooted tree structure
class UrTree {
public :
	//construction function
	UrTree ();

	//-----------------------------------------------------------
	//all things are inited here
	void doConstructor ();

	//-----------------------------------------------------------
	typedef Br<double> DBr;

	
	/**
		 find the nearest external nodes only for this branch, only for rooted tree
	*/
	void findNeaExNd (Br<double> &parBr, Vec<int> &neaExNdNoLs, int maxNNeaExNd);

	/**
		get the children branches of parBr
	*/
	void getChiBr (Br<double> &parBr, Br<double> &lChiBr, Br<double> &rChiBr);

	/**
		find k represetatives from 2 representatives set of 2 subtrees
		INPUT exNdArr0 external nodes array, 
			heiArr0 height array of these nodes
		INPUT exNdArr1 external nodes array, 
			heiArr1 height array of these nodes
		OUTPUT exNdArr external nodes array, 
			heiArr height array of these nodes
	*/
	void mixNeaExNd (int *exNdArr0, int *heiArr0, int *exNdArr1, int *heiArr1, int *exNdArr, int *heiArr);

	/**
	     find the nearest external nodes, using the isSmall direction, for unrooted tree,
		 store information for all subtrees, including this node
		 use to find k representatives
	*/
	void cmpNeaExNd (int brNo, int isSma, int *neaExNdArr, int *neaHeiArr);


	/**
	     find the nearest external nodes, using the isSmall direction, for unrooted tree,
		 store information for all subtrees except this nodes
		 use to find k representatives
	*/
	void cmpNeaExNd ();

	/**
		return the correct quartet for 4 sequences in the tree
		OUTPUT w0, w1, w2: one of 3 will be 1, the other 2 will be 0 
	*/
	void cmpWei4Point (int seqNo0, int seqNo1, int seqNo2, int seqNo3, char &w0, char &w1, char &w2);

	
	/**
		compute the 3 weights of 3 branches for the ndNo, order 0,1,2 from parBr
	*/
	void cmpWei (Br<double> &parBr, int ndNo, int *weiArr);


	/**
		set the bonus of the branch
	*/
	void setBonus (Br<double> &br, int bonusVal);

	/**
	 	what the hell is that ?
	*/
	void doBonus (int inNdNo, int ndNo);

	/**
	 	what the hell is that ?
	*/
	int cmpSmaBonus (Br<double> *br);
	
	//==============================
	/**
	 	what the hell is that ?
	*/
	int cmpGreBonus (Br<double> *br);

	int findBr (int ndNo);


	void insertNd (int ndNo, int nRep);

	//**************************************************************************************************
	//**************************************************************************************************
	//**************************************************************************************************
	//**************************************************************************************************
	//**************************************************************************************************
	//create topological distance vector for this tree topology with respect to seqNo
	void cmpTopDis (int startSeqNo, Vec<int> &topDisArr);

	//**************************************************************************************************
	//create distance between startSeqNo and other sequences according to the tree
	void cmpTreeDis (int startSeqNo, Vec<double> &treeDisArr);

	//**************************************************************************************************
	//create topological distance matrix for this tree topology
	void createTopDis (Mat<int> &topDisMat);

	//**************************************************************************************************
	//create distance between sequences according to the tree, not genetic distance
	void createTreeDis (Mat<double> &treeDisMat);

	//**************************************************************************************************
	//create nSeq_ / 2 independent paths for specific-site substitution rate
	void createApproximateIndSeqPair (Mat<int> &topDisMat, Vec<SeqPair> &indSeqPairArr);

	//**************************************************************************************************
	//create nSeq_ / 2 independent paths for specific-site substitution rate
	void swap4PointCondition (Mat<int> &topDisMat, Vec<SeqPair> &indSeqPairArr);

	void createAllSeqPair(Vec<SeqPair> &indSeqPairArr);


	//**************************************************************************************************
	//create nSeq_ / 2 independent paths for specific-site substitution rate
	void createIndSeqPair (Vec<SeqPair> &indSeqPairArr);

	//**************************************************************************************************
	//-----------------------------------------------------------
	//clean all the contents of this tree
	void clean ();

	int isEqual (ClusterArr &bestClusterArr);

	int cmpDis (ClusterArr &ca2);

	//-----------------------------------------------------------
	//cmp the topological distance between two trees
	int cmpDis (UrTree &tree2);

	void writeNewickForm (const char *fileName, int isApp, double progTime);

	void writeNewickForm (std::ostream &out);

	void writeTop (const char *fileName, int isApp);

	//-----------------------------------------------------------
	//put the first br into this tree
	void setFirstBr (Br<double> &br);

	//-----------------------------------------------------------
	//insert a nd into an existing br of the unroot tree
	void insertNdBr (int ndNo, int brNo);

	//-----------------------------------------------------------
	/*
	      internal Node
	      *       *
	   *            *
	neiExNd          exNdNo
	 
	 
	 
	 
	*/

	//return the neighbor external node of input external node
	int getNeiExNd (int exNdNo);

	//-----------------------------------------------------------

	/*
	 
	del one external node from this tree
	    exNdNo
	           *
	            *
	             inNd * * * neiNdNo2
	            *
	          *
	  neiNdNo1
	*/

	void delExNd (const int exNdNo);

	//-----------------------------------------------------------
	//forward all information of this tree into the opimial unrooted tree
	void createOptUrTree ();

	void createCluster (Br<double> &br, Cluster &cluster);

	void createCluster (ClusterArr &clusterArr);

	double getExBrLen (int exNdNo);

	void cmpBrLen (UrTree &bestTree, ClusterArr &bestClusterArr);

	//-----------------------------------------------------------
	//assign all diferrent information of this OptUrTree into this tree
	void getOptUrTree ();

	//return the log likelihood of this tree
	double getLogLi ();

	// do continuous optimization
	double doConOpt (int NNI, bool &topo_changed, int nIt = MAX_IT_UR_BR);

	void getTree();


	//-----------------------------------------------------------

	//this function optimize this tree and return the likelihood of this tree


	double cmpLogLi (OPT_STATUS status, int NNI, int nIt = MAX_IT_UR_BR);

	/**
		return TRUE if the topology changed
	*/
	bool createLocalTree ();

	/**
		return TRUE if the topology changed
	*/
	bool createLocalTree (ClusterArr &bestClusterArr);

	//-----------------------------------------------------------
	//this function optimize this tree and return the likelihood of this tree
	double cmpLogLi (OPT_STATUS status, UrTree &bestTree, ClusterArr &bestClusterArr,int NNI, int nIt = MAX_IT_UR_BR);

	//-----------------------------------------------------------
	//this function reOptimize this tree and return the likelihood of this tree
	double reCmpLogLi (OPT_STATUS status, int NNI, int nIt = MAX_IT_UR_BR);

	//-----------------------------------------------------------
	//this function reOptimize this tree and return the likelihood of this tree

	double reCmpLogLi (OPT_STATUS status, UrTree &bestTree, ClusterArr &bestClusterArr, int NNI, int nIt = MAX_IT_UR_BR);

	//-----------------------------------------------------------
	//return the inNdArr_
	InNdArr &getInNd ();

	//-----------------------------------------------------------
	//return the exNdArr_
	ExNdArr &getExNd ();

	//-----------------------------------------------------------
	//return the brArr_
	BrArr<double> &getBr ();

	//-----------------------------------------------------------
	//return the ourGrpNdNo of this unrooted tree
	int getOutGrpNd ();

	//-----------------------------------------------------------

	//return isRootedTree_
	int isRootedTree ();

	//-----------------------------------------------------------
	//returen isOpted_
	int isOpted ();

	//-----------------------------------------------------------
	//returen artificial internal root no
	int getArtInRoot ();

	/** clone from another tree */
	void clone (UrTree *urTree);
	
	/** clone from another tree */
	void clone (UrTree &urTree);
	
	//-----------------------------------------------------------
	//overload operator =
	void operator = (UrTree &urTree);

	//-----------------------------------------------------------
	//check whether or not the input urTree is equal to this tree
	int operator == (UrTree &tree2);

	//-----------------------------------------------------------
	//write all information about this tree into file
	void write (std::ofstream &out);

	//-----------------------------------------------------------

	//write all information about this tree into screen
	void write ();

	//--------------------------------------------------------------------
	//find an existed external node for being the out group node of this tree
	int findOutGrpNd ();

	//--------------------------------------------------------------------
	//reCreate the tree to be the rooted tree
	void reCreateRootedTree (int outGrpNdNo);

	void createNdOrder (int parNdNo, int inNdNo);

	void createBrDir (Br<double> &parBr);

	//--------------------------------------------------------------------
	//this will turn this unrooted tree into a rooted tree
	void createRootedTree (int outGrpNdNo);

	//--------------------------------------------------------------------------
	//release all memory of this class
	void release ();

	//==================================================================
	void createRan (int nSeq, double minBrLen, double maxBrLen);

	void createNeuwickForm (int ndNo, Vec<char> &tree, bool seq_name = true);

	void createNeuwickForm (Vec<char> &neuwickForm, bool seq_name = true);

	void writeNewickForm (const char *fileName);

	void draw (DRAW_TREE_TYPE drawTreeType, int outGrpNdNo, const char *fileName);

	void draw (DRAW_TREE_TYPE drawTreeType, int outGrpNdNo);

	void createImage (DRAW_TREE_TYPE drawTreeType, int outGrpNdNo, Mat<char> &image);


	/**
		convert the branch length from the number of nucleotide substitution per nucleotide site
		to number of nucleotide substitution per codon site.
	*/
	void convertBrLenToCodon();
	
	//-----------------------------------------------------------
	//destruction function
	virtual ~UrTree ();


	/******************************************************************************************************************************************************
	******************************************************************************************************************************************************/
protected :


	double quartetTime_;
	int nRep_;


	//the list of all in nds of this UrTree
	InNdArr inNdArr_;


	//the list of all ex nds of this UrTree

	ExNdArr exNdArr_;

	//the list of all bres of this UrTree
	BrArr<double> brArr_;

	/*
	the number of active sequences in the alignment.
	It is also the max number of external nodes of this unrooted tree
	*/

	int maxNExNd_;

	//it is the max number of internal nodes of this unrooted tree
	int maxNInNd_;



	//the maximum number of nodes of this unrooted tree
	int maxNNd_;

	//it is the max number of branches of this unrooted tree
	int maxNBr_;



	//the log of likelihood of this urTree
	double logLi_;

	//the out group node node
	int outGrpNdNo_;

	//the artificial root no of this tree
	int artInRootNo_;

	//check if this unrooted has been rooted
	int isRootedTree_;

	//check whether or not this tree was optimized
	int isOpted_;

	int *bonusBrArr_;//[MAX_NUM_SEQ * 2];
	
	
	//-----------------------------------------------------------
	/*
	insert the third nd into the first br
	        the third nd
	 
	             |
	             | 2
	             |
	          0       1
	smallnd *---inNd-----* greatNd
	*/

	void insertNdFirstBr (int ndNo, int brNo);

	//-----------------------------------------------------------
	/*insert a nd into an ex br
	smallNd
	  *
	 
	 
	   * brNo
	    *       newBrNo2_
	     **************** newExNd
	      *
	        *newBrNo1_
	 
	          *
	 
	        inNdNo_ (great br)
	*/
	void insertNdExBr (int ndNo, int brNo);

	//-----------------------------------------------------------
	/*
	                               ndNo
	 
	                                 *
	                                 *
	                                 *newBrNo2_
	 
	                                 *
	 
	                          brNo   *      newBrNo1_
	(internal node )smallNo---------inNdNo------------greatNo (internal node)
	*/
	//insert a nd into an internal br
	void insertNdInBr (int ndNo, int brNo);

	//-----------------------------------------------------------

	//check whether or not this node is an external node
	int isExNd (const int ndNo);

	//-----------------------------------------------------------
	//check whether or not this node is an internal node
	int isInNd (const int ndNo);


	//==================================================================================
	//==================================================================================
	//==================================================================================
	//--------------------------------------------------------------------------
	//-----------------------------------------------------------
	//create the abstract brach len for this urtree
	void createAbstractBrLen (Vec<int> &abstractBrLenArr);

	//-----------------------------------------------------------
	//create the row order of for all nodes of this tree
	int createNdRowOrder (int ndNo, int &rowOrder, Vec<int> &ndRowOrderArr);

	//-----------------------------------------------------------
	//create the abstract height for all nodes of this tree.

	void createAbstractNdHei (int ndNo, int abstractNdHei,
	                          Vec<int> &abstractBrLenArr, Vec<int> &abstractNdHeiArr);

	//------------------------------------------------------------------------------
	//it serves for createImage
	void createRowImage (int row, int startCol, int endCol, char ch, Mat<char> &image);

	//------------------------------------------------------------------------------
	//it serves for createImage
	void createColImage (int col, int startRow, int endRow, char ch, Mat<char> &image);

	//------------------------------------------------------------------------------

	//it serves for createImage
	void createRowImage (int row, int startCol, int endCol, Vec<char> &name, Mat<char> &image);
	//------------------------------------------------------------------------------
	//it serves for createImage


	void createRowImage (int row, int startCol, Vec<char> &name, Mat<char> &image);

	//------------------------------------------------------------------------------
	//draw the internal node into the image
	void createImage (Vec<int> &abstractBrLenArr, Vec<int> &ndRowOrderArr, Vec<int> &abstractNdHeiArr, Mat<char> &image);

	//------------------------------------------------------------------------------
	int cmpNImageRow (Vec<int> &ndRowOrderArr);

	//------------------------------------------------------------------------------
	int cmpNImageCol (Vec<int> &abstractNdHeiArr);
}
; //end of one of the most important class, class unrooted tree


#endif
