/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


/***************************************************************************
                          sequence.cpp  -  description
                             -------------------
    begin                : Thu Feb 20 2003
    copyright            : (C) 2003 by Vinh Le Sy and Arndt von Haeseler
    email                : vinh@cs.uni-duesseldorf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <string.h>
#include <string>
#include <ctype.h>
#include <iostream>
#include "seq.h"
#include "utl.h"
#include "constant.h"


extern int nto [NUM_CHAR];

//everything is inited here
void Seq::init () {}

//--------------------------------------------------------------------
//the constructor
Seq::Seq () {
	id_ = -1;
}

//--------------------------------------------------------------------
//set identification for this sequence
void Seq::setId (const int id) {
	id_ = id;
}

//--------------------------------------------------------------------
//get the identification of this sequence
int Seq::getId () {
	return id_;
}

//--------------------------------------------------------------------
//get the name of this sequences from the line in the input file
int Seq::getName (const char *aLine, Vec<char> &name) {
	int pos_ = 0;
	while (Utl::isControlChar (aLine [pos_]) == 1)
		pos_ ++;
	name.clean ();

	int isHardPhyFormat_ = 1; //incase name length = 10, content continues right after without any blank
	int tmpPos_ = pos_;
	while (aLine[tmpPos_] != '\0') {
		if (Utl::isControlChar (aLine[tmpPos_]) == 1) {
			isHardPhyFormat_ = 0;
			break;
		}
		tmpPos_ ++;
	}

	if (isHardPhyFormat_ == 1) {
		for (pos_ = 0; pos_ < 10; pos_ ++) {
			char ch = aLine[pos_];
			name += ch;
		}
		return pos_;
	}

	while (Utl::isControlChar (aLine[pos_]) == 0) {
		char ch = aLine[pos_];
		name += ch;
		pos_ ++;
	}


	return pos_;
}


//--------------------------------------------------------------------
//get the content of this sequences from the line in the input file
int Seq::getContent (const char *aLine, int pos) {
	while (Utl::isControlChar (aLine [pos]) == 1 && aLine [pos]  != '\0')
		pos ++;

	int nNu_ = 0;

	while (aLine [pos] !=  '\0') {
		if (Utl::isControlChar (aLine[pos]) == 0) {

			char ch = toupper (aLine[pos]);
			if (ch == 'U')
				ch = 'T';
			// if (nto [ static_cast<int> (aLine[pos]) ] == BS_UNKNOWN)
			if (! isalpha(ch))
				ch = '?';

			add (ch);
			nNu_ ++;
		}

		pos ++;
	}

	return nNu_;
}

//--------------------------------------------------------------------
//read information of this sequence from text file
int Seq::readInput (std::ifstream &in, int nSite_, int isFirstRead) {
	string aLine_;
	getline(in, aLine_);

	if (Utl::isBlankLine (aLine_.c_str()) == 1) {
		if (in.eof () == 1) {
			if (isMasterProc()) cout << "ERROR: Unexpected end of file" << endl;
			return 0;
		}
		else
			readInput (in, nSite_, isFirstRead);
	}

	int nNu_;
	if (isFirstRead == 1) {
		set (nSite_, 0);
		int pos_ = getName (aLine_.c_str(), name_);
		nNu_ = getContent (aLine_.c_str(), pos_);
	} else
		nNu_ = getContent (aLine_.c_str(), 0);

	return nNu_;
}


//--------------------------------------------------------------------
//return the nuber sites of this sequence
int Seq::getNSite () {
	return size_;
}

//--------------------------------------------------------------------
//copy the input sequence into this one
void Seq::operator = (Seq &seq) {
	//check, change the limit of this if the limit of this is smaller than the limit of vec
	if (&seq != this) {
		this->id_ = seq.getId ();

		if (limit_ < seq.getLimit ())
			setLimit(seq.getLimit () );


		size_= seq.getSize ();
		for (int count_ = 0; count_ < size_; count_ ++)
			this->items_[count_] = seq[count_];

		this->name_ = seq.getName ();
	}
}


//--------------------------------------------------------------------------
//return the name of this sequence
Vec<char> &Seq::getName () {
	return name_;
}

//--------------------------------------------------------------------------
//release all memory of this class
void Seq::release () {
	baseFrqArr_.release ();
	name_.release ();
}

//--------------------------------------------------------------------
//destructor
Seq::~Seq () {
	//std::cout << "the destructor of seq " << endl;
}

