/***************************************************************************
 *                                                                         *
 *   hky85m.h       (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef HKY85M_H
#define HKY85M_H


#include "basem.h"
/**
Hasegawa et al. (HKY1985) takes into account of both the different equilibrium frequencies of bases
( the frequence of A # the frequence of C # the frequence of G # the frequence of T  )
and the common observation that transitions and transversions occur at different rates.
 transition transvertion ratio = transition rate / transversition rate

When ( the frequence of A = the frequence of C = the frequence of G = the frequence of T  )
the HYK85 model becomes the Kimura 1980 model,
When the transition tranverstion ratio = 1, the HYK85 model becomes the EqualInputModel (F81) model,

THE NUMBER OF FREE VARIABLES IS 4
the Hasegawa 1985 model is A brLen-REVERSIBLE MODEL
...Being specified more
*/
class HKY85M : public BaseM {
public :

	//the constructor function
	HKY85M ();

	//compute the substitution rate of this model
	double cmpSubRate ();

	//compute the substitution rate of this model
	void reCmpSubRate ();


	//all things are inited here
	virtual void init ();

	/*
	cmp the probability of changing from nucleotide baseNo1 into nucleotide baseNo2
	after a period of brLen  / subRate_
	*/
	virtual double cmpProbChange (const int baseNo1, const int baseNo2, const double brLen);


	/*
	cmp the array of probability of changing from
	one nucleotide into one nucleotide after a period of brLen / subRate_
	*/
	virtual void cmpProbChange (const double brLen, DMat20 &probMat);
	

	
	virtual void cmpProbChangeDerivatives (const double brLen, DMat20 &probMat, DMat20 &derv1, DMat20 &derv2);
	
	virtual bool optPam ();

	/*compute the log likelihood when given tsTvRatio,
	this function is used to optimize the tsTvRatio of this model
	*/
	virtual double cmpNegLogLi (double tsTvRatio);

	//release all memmory for this class
	void release ();

	//the destructor function
	virtual ~HKY85M ();

private:
	double sub_rate_base;
	double sub_rate_coefficent;
	double coefficient1[4], coefficient2[4], coefficient3[4];
	
}
; //end of hky85 model class

#endif
