/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.Range;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.HashMap;

public final class PrimitiveType
extends Type<PrimitiveType>
implements NodeWithAnnotations<PrimitiveType> {
    public static final PrimitiveType BYTE_TYPE = new PrimitiveType(Primitive.Byte);
    public static final PrimitiveType SHORT_TYPE = new PrimitiveType(Primitive.Short);
    public static final PrimitiveType INT_TYPE = new PrimitiveType(Primitive.Int);
    public static final PrimitiveType LONG_TYPE = new PrimitiveType(Primitive.Long);
    public static final PrimitiveType FLOAT_TYPE = new PrimitiveType(Primitive.Float);
    public static final PrimitiveType DOUBLE_TYPE = new PrimitiveType(Primitive.Double);
    public static final PrimitiveType BOOLEAN_TYPE = new PrimitiveType(Primitive.Boolean);
    public static final PrimitiveType CHAR_TYPE = new PrimitiveType(Primitive.Char);
    static final HashMap<String, Primitive> unboxMap = new HashMap();
    private Primitive type;

    public PrimitiveType() {
    }

    public PrimitiveType(Primitive type) {
        this.type = type;
    }

    public PrimitiveType(Range range, Primitive type) {
        super(range);
        this.type = type;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Primitive getType() {
        return this.type;
    }

    public ClassOrInterfaceType toBoxedType() {
        return this.type.toBoxedType();
    }

    public void setType(Primitive type) {
        this.type = type;
    }

    static {
        for (Primitive unboxedType : Primitive.values()) {
            unboxMap.put(unboxedType.nameOfBoxedType, unboxedType);
        }
    }

    public static enum Primitive {
        Boolean("Boolean"),
        Char("Character"),
        Byte("Byte"),
        Short("Short"),
        Int("Integer"),
        Long("Long"),
        Float("Float"),
        Double("Double");

        final String nameOfBoxedType;

        public ClassOrInterfaceType toBoxedType() {
            return new ClassOrInterfaceType(this.nameOfBoxedType);
        }

        private Primitive(String nameOfBoxedType) {
            this.nameOfBoxedType = nameOfBoxedType;
        }
    }
}

