/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.Collections;
import javaslang.collection.HashMap;
import javaslang.collection.Iterator;
import javaslang.collection.Map;
import javaslang.control.Option;

abstract class AbstractMap<K, V, M extends AbstractMap<K, V, M>>
implements Map<K, V> {
    private static final long serialVersionUID = 1L;

    AbstractMap() {
    }

    abstract M createFromEntries(Iterable<? extends Tuple2<? extends K, ? extends V>> var1);

    abstract M emptyInstance();

    public M put(Tuple2<? extends K, ? extends V> entry) {
        Objects.requireNonNull(entry, "entry is null");
        return (M)((AbstractMap)this.put(entry._1, entry._2));
    }

    public M distinct() {
        return (M)this;
    }

    public M distinctBy(Comparator<? super Tuple2<K, V>> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return this.createFromEntries(this.iterator().distinctBy(comparator));
    }

    public <U> M distinctBy(Function<? super Tuple2<K, V>, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        return this.createFromEntries(this.iterator().distinctBy(keyExtractor));
    }

    public M drop(long n) {
        if (n <= 0L) {
            return (M)this;
        }
        if (n >= (long)this.length()) {
            return this.emptyInstance();
        }
        return this.createFromEntries(this.iterator().drop(n));
    }

    public M dropRight(long n) {
        if (n <= 0L) {
            return (M)this;
        }
        if (n >= (long)this.length()) {
            return this.emptyInstance();
        }
        return this.createFromEntries(this.iterator().dropRight(n));
    }

    public M dropUntil(Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return (M)this.dropWhile((Predicate)predicate.negate());
    }

    public M dropWhile(Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.createFromEntries(this.iterator().dropWhile(predicate));
    }

    public M filter(Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.createFromEntries(this.iterator().filter(predicate));
    }

    @Override
    public <C> Map<C, M> groupBy(Function<? super Tuple2<K, V>, ? extends C> classifier) {
        Objects.requireNonNull(classifier, "classifier is null");
        return this.foldLeft(HashMap.empty(), (map, entry) -> {
            Object key = classifier.apply((Tuple2<K, V>)entry);
            Map values = (Map)map.get(key).map((T entries) -> entries.put(entry._1, entry._2)).getOrElse(this.createFromEntries(Iterator.of(entry)));
            return map.put(key, (AbstractMap)values);
        });
    }

    @Override
    public Iterator<M> grouped(long size) {
        return this.sliding(size, size);
    }

    @Override
    public Option<M> initOption() {
        return this.isEmpty() ? Option.none() : Option.some((AbstractMap)this.init());
    }

    @Override
    public Option<M> tailOption() {
        if (this.isEmpty()) {
            return Option.none();
        }
        return Option.some((AbstractMap)this.tail());
    }

    public M take(long n) {
        if ((long)this.size() <= n) {
            return (M)this;
        }
        return this.createFromEntries(this.iterator().take(n));
    }

    public M takeRight(long n) {
        if ((long)this.size() <= n) {
            return (M)this;
        }
        return this.createFromEntries(this.iterator().takeRight(n));
    }

    public M takeUntil(Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return (M)this.takeWhile((Predicate)predicate.negate());
    }

    public M takeWhile(Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        M taken = this.createFromEntries(this.iterator().takeWhile(predicate));
        return (M)(taken.length() == this.length() ? this : taken);
    }

    public M merge(Map<? extends K, ? extends V> that) {
        Objects.requireNonNull(that, "that is null");
        if (this.isEmpty()) {
            return this.createFromEntries(that);
        }
        if (that.isEmpty()) {
            return (M)this;
        }
        return (M)that.foldLeft(this, (map, entry) -> !map.containsKey(entry._1) ? map.put((Tuple2)entry) : map);
    }

    public <U extends V> M merge(Map<? extends K, U> that, BiFunction<? super V, ? super U, ? extends V> collisionResolution) {
        Objects.requireNonNull(that, "that is null");
        Objects.requireNonNull(collisionResolution, "collisionResolution is null");
        if (this.isEmpty()) {
            return this.createFromEntries(that);
        }
        if (that.isEmpty()) {
            return (M)this;
        }
        return (M)that.foldLeft(this, (map, entry) -> {
            Object key = entry._1;
            Object value = entry._2;
            Object newValue = map.get(key).map((T v) -> collisionResolution.apply((Object)v, (Object)value)).getOrElse(value);
            return (AbstractMap)map.put(key, newValue);
        });
    }

    @Override
    public Tuple2<M, M> partition(Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Tuple2<Iterator<? super Tuple2<K, V>>, Iterator<? super Tuple2<K, V>>> p = this.iterator().partition(predicate);
        return Tuple.of(this.createFromEntries((Iterable)p._1), this.createFromEntries((Iterable)p._2));
    }

    public M peek(Consumer<? super Tuple2<K, V>> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.isEmpty()) {
            action.accept((Tuple2<K, V>)this.head());
        }
        return (M)this;
    }

    public M replace(Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        Objects.requireNonNull(currentElement, "currentElement is null");
        Objects.requireNonNull(newElement, "newElement is null");
        return (M)(this.containsKey(currentElement._1) ? (AbstractMap)this.remove(currentElement._1).put(newElement) : this);
    }

    public M replaceAll(Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        return (M)this.replace((Tuple2)currentElement, (Tuple2)newElement);
    }

    public M scan(Tuple2<K, V> zero, BiFunction<? super Tuple2<K, V>, ? super Tuple2<K, V>, ? extends Tuple2<K, V>> operation) {
        Objects.requireNonNull(operation, "operation is null");
        return (M)((AbstractMap)Collections.scanLeft(this, zero, operation, this.emptyInstance(), (m, e) -> m.put((Tuple2)e), Function.identity()));
    }

    @Override
    public Iterator<M> sliding(long size) {
        return this.sliding(size, 1L);
    }

    @Override
    public Iterator<M> sliding(long size, long step) {
        return this.iterator().sliding(size, step).map(this::createFromEntries);
    }

    @Override
    public Tuple2<M, M> span(Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Tuple2<Iterator<? super Tuple2<K, V>>, Iterator<? super Tuple2<K, V>>> t = this.iterator().span(predicate);
        return Tuple.of(this.createFromEntries((Iterable)t._1), this.createFromEntries((Iterable)t._2));
    }
}

