// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateFleet = "AssociateFleet"

// AssociateFleetRequest generates a "aws/request.Request" representing the
// client's request for the AssociateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateFleet for more information on using the AssociateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateFleetRequest method.
//    req, resp := client.AssociateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet
func (c *AppStream) AssociateFleetRequest(input *AssociateFleetInput) (req *request.Request, output *AssociateFleetOutput) {
	op := &request.Operation{
		Name:       opAssociateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateFleetInput{}
	}

	output = &AssociateFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateFleet API operation for Amazon AppStream.
//
// Associates the specified fleet with the specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation AssociateFleet for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
//   * IncompatibleImageException
//   The image does not support storage connectors.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet
func (c *AppStream) AssociateFleet(input *AssociateFleetInput) (*AssociateFleetOutput, error) {
	req, out := c.AssociateFleetRequest(input)
	return out, req.Send()
}

// AssociateFleetWithContext is the same as AssociateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) AssociateFleetWithContext(ctx aws.Context, input *AssociateFleetInput, opts ...request.Option) (*AssociateFleetOutput, error) {
	req, out := c.AssociateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchAssociateUserStack = "BatchAssociateUserStack"

// BatchAssociateUserStackRequest generates a "aws/request.Request" representing the
// client's request for the BatchAssociateUserStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchAssociateUserStack for more information on using the BatchAssociateUserStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchAssociateUserStackRequest method.
//    req, resp := client.BatchAssociateUserStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchAssociateUserStack
func (c *AppStream) BatchAssociateUserStackRequest(input *BatchAssociateUserStackInput) (req *request.Request, output *BatchAssociateUserStackOutput) {
	op := &request.Operation{
		Name:       opBatchAssociateUserStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchAssociateUserStackInput{}
	}

	output = &BatchAssociateUserStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchAssociateUserStack API operation for Amazon AppStream.
//
// Associates the specified users with the specified stacks. Users in a user
// pool cannot be assigned to stacks with fleets that are joined to an Active
// Directory domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation BatchAssociateUserStack for usage and error information.
//
// Returned Error Types:
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchAssociateUserStack
func (c *AppStream) BatchAssociateUserStack(input *BatchAssociateUserStackInput) (*BatchAssociateUserStackOutput, error) {
	req, out := c.BatchAssociateUserStackRequest(input)
	return out, req.Send()
}

// BatchAssociateUserStackWithContext is the same as BatchAssociateUserStack with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAssociateUserStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) BatchAssociateUserStackWithContext(ctx aws.Context, input *BatchAssociateUserStackInput, opts ...request.Option) (*BatchAssociateUserStackOutput, error) {
	req, out := c.BatchAssociateUserStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisassociateUserStack = "BatchDisassociateUserStack"

// BatchDisassociateUserStackRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisassociateUserStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisassociateUserStack for more information on using the BatchDisassociateUserStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDisassociateUserStackRequest method.
//    req, resp := client.BatchDisassociateUserStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchDisassociateUserStack
func (c *AppStream) BatchDisassociateUserStackRequest(input *BatchDisassociateUserStackInput) (req *request.Request, output *BatchDisassociateUserStackOutput) {
	op := &request.Operation{
		Name:       opBatchDisassociateUserStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDisassociateUserStackInput{}
	}

	output = &BatchDisassociateUserStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisassociateUserStack API operation for Amazon AppStream.
//
// Disassociates the specified users from the specified stacks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation BatchDisassociateUserStack for usage and error information.
//
// Returned Error Types:
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchDisassociateUserStack
func (c *AppStream) BatchDisassociateUserStack(input *BatchDisassociateUserStackInput) (*BatchDisassociateUserStackOutput, error) {
	req, out := c.BatchDisassociateUserStackRequest(input)
	return out, req.Send()
}

// BatchDisassociateUserStackWithContext is the same as BatchDisassociateUserStack with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisassociateUserStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) BatchDisassociateUserStackWithContext(ctx aws.Context, input *BatchDisassociateUserStackInput, opts ...request.Option) (*BatchDisassociateUserStackOutput, error) {
	req, out := c.BatchDisassociateUserStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyImage = "CopyImage"

// CopyImageRequest generates a "aws/request.Request" representing the
// client's request for the CopyImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyImage for more information on using the CopyImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyImageRequest method.
//    req, resp := client.CopyImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CopyImage
func (c *AppStream) CopyImageRequest(input *CopyImageInput) (req *request.Request, output *CopyImageOutput) {
	op := &request.Operation{
		Name:       opCopyImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyImageInput{}
	}

	output = &CopyImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyImage API operation for Amazon AppStream.
//
// Copies the image within the same region or to a new region within the same
// AWS account. Note that any tags you added to the image will not be copied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CopyImage for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * IncompatibleImageException
//   The image does not support storage connectors.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CopyImage
func (c *AppStream) CopyImage(input *CopyImageInput) (*CopyImageOutput, error) {
	req, out := c.CopyImageRequest(input)
	return out, req.Send()
}

// CopyImageWithContext is the same as CopyImage with the addition of
// the ability to pass a context and additional request options.
//
// See CopyImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CopyImageWithContext(ctx aws.Context, input *CopyImageInput, opts ...request.Option) (*CopyImageOutput, error) {
	req, out := c.CopyImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDirectoryConfig = "CreateDirectoryConfig"

// CreateDirectoryConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectoryConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDirectoryConfig for more information on using the CreateDirectoryConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDirectoryConfigRequest method.
//    req, resp := client.CreateDirectoryConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig
func (c *AppStream) CreateDirectoryConfigRequest(input *CreateDirectoryConfigInput) (req *request.Request, output *CreateDirectoryConfigOutput) {
	op := &request.Operation{
		Name:       opCreateDirectoryConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectoryConfigInput{}
	}

	output = &CreateDirectoryConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDirectoryConfig API operation for Amazon AppStream.
//
// Creates a Directory Config object in AppStream 2.0. This object includes
// the configuration information required to join fleets and image builders
// to Microsoft Active Directory domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateDirectoryConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * InvalidRoleException
//   The specified role is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig
func (c *AppStream) CreateDirectoryConfig(input *CreateDirectoryConfigInput) (*CreateDirectoryConfigOutput, error) {
	req, out := c.CreateDirectoryConfigRequest(input)
	return out, req.Send()
}

// CreateDirectoryConfigWithContext is the same as CreateDirectoryConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDirectoryConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateDirectoryConfigWithContext(ctx aws.Context, input *CreateDirectoryConfigInput, opts ...request.Option) (*CreateDirectoryConfigOutput, error) {
	req, out := c.CreateDirectoryConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFleetRequest method.
//    req, resp := client.CreateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet
func (c *AppStream) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for Amazon AppStream.
//
// Creates a fleet. A fleet consists of streaming instances that run a specified
// image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * RequestLimitExceededException
//   AppStream 2.0 can’t process the request right now because the Describe
//   calls from your AWS account are being throttled by Amazon EC2. Try again
//   later.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * InvalidRoleException
//   The specified role is invalid.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * IncompatibleImageException
//   The image does not support storage connectors.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet
func (c *AppStream) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImageBuilder = "CreateImageBuilder"

// CreateImageBuilderRequest generates a "aws/request.Request" representing the
// client's request for the CreateImageBuilder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImageBuilder for more information on using the CreateImageBuilder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImageBuilderRequest method.
//    req, resp := client.CreateImageBuilderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder
func (c *AppStream) CreateImageBuilderRequest(input *CreateImageBuilderInput) (req *request.Request, output *CreateImageBuilderOutput) {
	op := &request.Operation{
		Name:       opCreateImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageBuilderInput{}
	}

	output = &CreateImageBuilderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImageBuilder API operation for Amazon AppStream.
//
// Creates an image builder. An image builder is a virtual machine that is used
// to create an image.
//
// The initial state of the builder is PENDING. When it is ready, the state
// is RUNNING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateImageBuilder for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * RequestLimitExceededException
//   AppStream 2.0 can’t process the request right now because the Describe
//   calls from your AWS account are being throttled by Amazon EC2. Try again
//   later.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidRoleException
//   The specified role is invalid.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * IncompatibleImageException
//   The image does not support storage connectors.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder
func (c *AppStream) CreateImageBuilder(input *CreateImageBuilderInput) (*CreateImageBuilderOutput, error) {
	req, out := c.CreateImageBuilderRequest(input)
	return out, req.Send()
}

// CreateImageBuilderWithContext is the same as CreateImageBuilder with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImageBuilder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateImageBuilderWithContext(ctx aws.Context, input *CreateImageBuilderInput, opts ...request.Option) (*CreateImageBuilderOutput, error) {
	req, out := c.CreateImageBuilderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImageBuilderStreamingURL = "CreateImageBuilderStreamingURL"

// CreateImageBuilderStreamingURLRequest generates a "aws/request.Request" representing the
// client's request for the CreateImageBuilderStreamingURL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImageBuilderStreamingURL for more information on using the CreateImageBuilderStreamingURL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImageBuilderStreamingURLRequest method.
//    req, resp := client.CreateImageBuilderStreamingURLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL
func (c *AppStream) CreateImageBuilderStreamingURLRequest(input *CreateImageBuilderStreamingURLInput) (req *request.Request, output *CreateImageBuilderStreamingURLOutput) {
	op := &request.Operation{
		Name:       opCreateImageBuilderStreamingURL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageBuilderStreamingURLInput{}
	}

	output = &CreateImageBuilderStreamingURLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImageBuilderStreamingURL API operation for Amazon AppStream.
//
// Creates a URL to start an image builder streaming session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateImageBuilderStreamingURL for usage and error information.
//
// Returned Error Types:
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL
func (c *AppStream) CreateImageBuilderStreamingURL(input *CreateImageBuilderStreamingURLInput) (*CreateImageBuilderStreamingURLOutput, error) {
	req, out := c.CreateImageBuilderStreamingURLRequest(input)
	return out, req.Send()
}

// CreateImageBuilderStreamingURLWithContext is the same as CreateImageBuilderStreamingURL with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImageBuilderStreamingURL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateImageBuilderStreamingURLWithContext(ctx aws.Context, input *CreateImageBuilderStreamingURLInput, opts ...request.Option) (*CreateImageBuilderStreamingURLOutput, error) {
	req, out := c.CreateImageBuilderStreamingURLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStack = "CreateStack"

// CreateStackRequest generates a "aws/request.Request" representing the
// client's request for the CreateStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStack for more information on using the CreateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStackRequest method.
//    req, resp := client.CreateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack
func (c *AppStream) CreateStackRequest(input *CreateStackInput) (req *request.Request, output *CreateStackOutput) {
	op := &request.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	output = &CreateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStack API operation for Amazon AppStream.
//
// Creates a stack to start streaming applications to users. A stack consists
// of an associated fleet, user access policies, and storage configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateStack for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
//   * InvalidRoleException
//   The specified role is invalid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack
func (c *AppStream) CreateStack(input *CreateStackInput) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	return out, req.Send()
}

// CreateStackWithContext is the same as CreateStack with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateStackWithContext(ctx aws.Context, input *CreateStackInput, opts ...request.Option) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamingURL = "CreateStreamingURL"

// CreateStreamingURLRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamingURL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamingURL for more information on using the CreateStreamingURL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamingURLRequest method.
//    req, resp := client.CreateStreamingURLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL
func (c *AppStream) CreateStreamingURLRequest(input *CreateStreamingURLInput) (req *request.Request, output *CreateStreamingURLOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingURL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStreamingURLInput{}
	}

	output = &CreateStreamingURLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamingURL API operation for Amazon AppStream.
//
// Creates a temporary URL to start an AppStream 2.0 streaming session for the
// specified user. A streaming URL enables application streaming to be tested
// without user setup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateStreamingURL for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL
func (c *AppStream) CreateStreamingURL(input *CreateStreamingURLInput) (*CreateStreamingURLOutput, error) {
	req, out := c.CreateStreamingURLRequest(input)
	return out, req.Send()
}

// CreateStreamingURLWithContext is the same as CreateStreamingURL with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamingURL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateStreamingURLWithContext(ctx aws.Context, input *CreateStreamingURLInput, opts ...request.Option) (*CreateStreamingURLOutput, error) {
	req, out := c.CreateStreamingURLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUsageReportSubscription = "CreateUsageReportSubscription"

// CreateUsageReportSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateUsageReportSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUsageReportSubscription for more information on using the CreateUsageReportSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUsageReportSubscriptionRequest method.
//    req, resp := client.CreateUsageReportSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUsageReportSubscription
func (c *AppStream) CreateUsageReportSubscriptionRequest(input *CreateUsageReportSubscriptionInput) (req *request.Request, output *CreateUsageReportSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateUsageReportSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUsageReportSubscriptionInput{}
	}

	output = &CreateUsageReportSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUsageReportSubscription API operation for Amazon AppStream.
//
// Creates a usage report subscription. Usage reports are generated daily.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateUsageReportSubscription for usage and error information.
//
// Returned Error Types:
//   * InvalidRoleException
//   The specified role is invalid.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUsageReportSubscription
func (c *AppStream) CreateUsageReportSubscription(input *CreateUsageReportSubscriptionInput) (*CreateUsageReportSubscriptionOutput, error) {
	req, out := c.CreateUsageReportSubscriptionRequest(input)
	return out, req.Send()
}

// CreateUsageReportSubscriptionWithContext is the same as CreateUsageReportSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUsageReportSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateUsageReportSubscriptionWithContext(ctx aws.Context, input *CreateUsageReportSubscriptionInput, opts ...request.Option) (*CreateUsageReportSubscriptionOutput, error) {
	req, out := c.CreateUsageReportSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUser
func (c *AppStream) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateUser API operation for Amazon AppStream.
//
// Creates a new user in the user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUser
func (c *AppStream) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDirectoryConfig = "DeleteDirectoryConfig"

// DeleteDirectoryConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectoryConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDirectoryConfig for more information on using the DeleteDirectoryConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDirectoryConfigRequest method.
//    req, resp := client.DeleteDirectoryConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig
func (c *AppStream) DeleteDirectoryConfigRequest(input *DeleteDirectoryConfigInput) (req *request.Request, output *DeleteDirectoryConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectoryConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectoryConfigInput{}
	}

	output = &DeleteDirectoryConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDirectoryConfig API operation for Amazon AppStream.
//
// Deletes the specified Directory Config object from AppStream 2.0. This object
// includes the information required to join streaming instances to an Active
// Directory domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteDirectoryConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig
func (c *AppStream) DeleteDirectoryConfig(input *DeleteDirectoryConfigInput) (*DeleteDirectoryConfigOutput, error) {
	req, out := c.DeleteDirectoryConfigRequest(input)
	return out, req.Send()
}

// DeleteDirectoryConfigWithContext is the same as DeleteDirectoryConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDirectoryConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteDirectoryConfigWithContext(ctx aws.Context, input *DeleteDirectoryConfigInput, opts ...request.Option) (*DeleteDirectoryConfigOutput, error) {
	req, out := c.DeleteDirectoryConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleet for more information on using the DeleteFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFleetRequest method.
//    req, resp := client.DeleteFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet
func (c *AppStream) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	output = &DeleteFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFleet API operation for Amazon AppStream.
//
// Deletes the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet
func (c *AppStream) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	return out, req.Send()
}

// DeleteFleetWithContext is the same as DeleteFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteFleetWithContext(ctx aws.Context, input *DeleteFleetInput, opts ...request.Option) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImage = "DeleteImage"

// DeleteImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImage for more information on using the DeleteImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteImageRequest method.
//    req, resp := client.DeleteImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage
func (c *AppStream) DeleteImageRequest(input *DeleteImageInput) (req *request.Request, output *DeleteImageOutput) {
	op := &request.Operation{
		Name:       opDeleteImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteImageInput{}
	}

	output = &DeleteImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteImage API operation for Amazon AppStream.
//
// Deletes the specified image. You cannot delete an image when it is in use.
// After you delete an image, you cannot provision new capacity using the image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteImage for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage
func (c *AppStream) DeleteImage(input *DeleteImageInput) (*DeleteImageOutput, error) {
	req, out := c.DeleteImageRequest(input)
	return out, req.Send()
}

// DeleteImageWithContext is the same as DeleteImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteImageWithContext(ctx aws.Context, input *DeleteImageInput, opts ...request.Option) (*DeleteImageOutput, error) {
	req, out := c.DeleteImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImageBuilder = "DeleteImageBuilder"

// DeleteImageBuilderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImageBuilder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImageBuilder for more information on using the DeleteImageBuilder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteImageBuilderRequest method.
//    req, resp := client.DeleteImageBuilderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder
func (c *AppStream) DeleteImageBuilderRequest(input *DeleteImageBuilderInput) (req *request.Request, output *DeleteImageBuilderOutput) {
	op := &request.Operation{
		Name:       opDeleteImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteImageBuilderInput{}
	}

	output = &DeleteImageBuilderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteImageBuilder API operation for Amazon AppStream.
//
// Deletes the specified image builder and releases the capacity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteImageBuilder for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder
func (c *AppStream) DeleteImageBuilder(input *DeleteImageBuilderInput) (*DeleteImageBuilderOutput, error) {
	req, out := c.DeleteImageBuilderRequest(input)
	return out, req.Send()
}

// DeleteImageBuilderWithContext is the same as DeleteImageBuilder with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImageBuilder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteImageBuilderWithContext(ctx aws.Context, input *DeleteImageBuilderInput, opts ...request.Option) (*DeleteImageBuilderOutput, error) {
	req, out := c.DeleteImageBuilderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImagePermissions = "DeleteImagePermissions"

// DeleteImagePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImagePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImagePermissions for more information on using the DeleteImagePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteImagePermissionsRequest method.
//    req, resp := client.DeleteImagePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImagePermissions
func (c *AppStream) DeleteImagePermissionsRequest(input *DeleteImagePermissionsInput) (req *request.Request, output *DeleteImagePermissionsOutput) {
	op := &request.Operation{
		Name:       opDeleteImagePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteImagePermissionsInput{}
	}

	output = &DeleteImagePermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteImagePermissions API operation for Amazon AppStream.
//
// Deletes permissions for the specified private image. After you delete permissions
// for an image, AWS accounts to which you previously granted these permissions
// can no longer use the image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteImagePermissions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImagePermissions
func (c *AppStream) DeleteImagePermissions(input *DeleteImagePermissionsInput) (*DeleteImagePermissionsOutput, error) {
	req, out := c.DeleteImagePermissionsRequest(input)
	return out, req.Send()
}

// DeleteImagePermissionsWithContext is the same as DeleteImagePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImagePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteImagePermissionsWithContext(ctx aws.Context, input *DeleteImagePermissionsInput, opts ...request.Option) (*DeleteImagePermissionsOutput, error) {
	req, out := c.DeleteImagePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStack for more information on using the DeleteStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStackRequest method.
//    req, resp := client.DeleteStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack
func (c *AppStream) DeleteStackRequest(input *DeleteStackInput) (req *request.Request, output *DeleteStackOutput) {
	op := &request.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	output = &DeleteStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStack API operation for Amazon AppStream.
//
// Deletes the specified stack. After the stack is deleted, the application
// streaming environment provided by the stack is no longer available to users.
// Also, any reservations made for application streaming sessions for the stack
// are released.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteStack for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack
func (c *AppStream) DeleteStack(input *DeleteStackInput) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	return out, req.Send()
}

// DeleteStackWithContext is the same as DeleteStack with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteStackWithContext(ctx aws.Context, input *DeleteStackInput, opts ...request.Option) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUsageReportSubscription = "DeleteUsageReportSubscription"

// DeleteUsageReportSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUsageReportSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUsageReportSubscription for more information on using the DeleteUsageReportSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUsageReportSubscriptionRequest method.
//    req, resp := client.DeleteUsageReportSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteUsageReportSubscription
func (c *AppStream) DeleteUsageReportSubscriptionRequest(input *DeleteUsageReportSubscriptionInput) (req *request.Request, output *DeleteUsageReportSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteUsageReportSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUsageReportSubscriptionInput{}
	}

	output = &DeleteUsageReportSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUsageReportSubscription API operation for Amazon AppStream.
//
// Disables usage report generation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteUsageReportSubscription for usage and error information.
//
// Returned Error Types:
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteUsageReportSubscription
func (c *AppStream) DeleteUsageReportSubscription(input *DeleteUsageReportSubscriptionInput) (*DeleteUsageReportSubscriptionOutput, error) {
	req, out := c.DeleteUsageReportSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteUsageReportSubscriptionWithContext is the same as DeleteUsageReportSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUsageReportSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteUsageReportSubscriptionWithContext(ctx aws.Context, input *DeleteUsageReportSubscriptionInput, opts ...request.Option) (*DeleteUsageReportSubscriptionOutput, error) {
	req, out := c.DeleteUsageReportSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteUser
func (c *AppStream) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for Amazon AppStream.
//
// Deletes a user from the user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteUser
func (c *AppStream) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDirectoryConfigs = "DescribeDirectoryConfigs"

// DescribeDirectoryConfigsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectoryConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDirectoryConfigs for more information on using the DescribeDirectoryConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDirectoryConfigsRequest method.
//    req, resp := client.DescribeDirectoryConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs
func (c *AppStream) DescribeDirectoryConfigsRequest(input *DescribeDirectoryConfigsInput) (req *request.Request, output *DescribeDirectoryConfigsOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectoryConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectoryConfigsInput{}
	}

	output = &DescribeDirectoryConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDirectoryConfigs API operation for Amazon AppStream.
//
// Retrieves a list that describes one or more specified Directory Config objects
// for AppStream 2.0, if the names for these objects are provided. Otherwise,
// all Directory Config objects in the account are described. These objects
// include the configuration information required to join fleets and image builders
// to Microsoft Active Directory domains.
//
// Although the response syntax in this topic includes the account password,
// this password is not returned in the actual response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeDirectoryConfigs for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs
func (c *AppStream) DescribeDirectoryConfigs(input *DescribeDirectoryConfigsInput) (*DescribeDirectoryConfigsOutput, error) {
	req, out := c.DescribeDirectoryConfigsRequest(input)
	return out, req.Send()
}

// DescribeDirectoryConfigsWithContext is the same as DescribeDirectoryConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDirectoryConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeDirectoryConfigsWithContext(ctx aws.Context, input *DescribeDirectoryConfigsInput, opts ...request.Option) (*DescribeDirectoryConfigsOutput, error) {
	req, out := c.DescribeDirectoryConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleets = "DescribeFleets"

// DescribeFleetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleets for more information on using the DescribeFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetsRequest method.
//    req, resp := client.DescribeFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets
func (c *AppStream) DescribeFleetsRequest(input *DescribeFleetsInput) (req *request.Request, output *DescribeFleetsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetsInput{}
	}

	output = &DescribeFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleets API operation for Amazon AppStream.
//
// Retrieves a list that describes one or more specified fleets, if the fleet
// names are provided. Otherwise, all fleets in the account are described.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeFleets for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets
func (c *AppStream) DescribeFleets(input *DescribeFleetsInput) (*DescribeFleetsOutput, error) {
	req, out := c.DescribeFleetsRequest(input)
	return out, req.Send()
}

// DescribeFleetsWithContext is the same as DescribeFleets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeFleetsWithContext(ctx aws.Context, input *DescribeFleetsInput, opts ...request.Option) (*DescribeFleetsOutput, error) {
	req, out := c.DescribeFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImageBuilders = "DescribeImageBuilders"

// DescribeImageBuildersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImageBuilders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImageBuilders for more information on using the DescribeImageBuilders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImageBuildersRequest method.
//    req, resp := client.DescribeImageBuildersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders
func (c *AppStream) DescribeImageBuildersRequest(input *DescribeImageBuildersInput) (req *request.Request, output *DescribeImageBuildersOutput) {
	op := &request.Operation{
		Name:       opDescribeImageBuilders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImageBuildersInput{}
	}

	output = &DescribeImageBuildersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImageBuilders API operation for Amazon AppStream.
//
// Retrieves a list that describes one or more specified image builders, if
// the image builder names are provided. Otherwise, all image builders in the
// account are described.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeImageBuilders for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders
func (c *AppStream) DescribeImageBuilders(input *DescribeImageBuildersInput) (*DescribeImageBuildersOutput, error) {
	req, out := c.DescribeImageBuildersRequest(input)
	return out, req.Send()
}

// DescribeImageBuildersWithContext is the same as DescribeImageBuilders with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImageBuilders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeImageBuildersWithContext(ctx aws.Context, input *DescribeImageBuildersInput, opts ...request.Option) (*DescribeImageBuildersOutput, error) {
	req, out := c.DescribeImageBuildersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImagePermissions = "DescribeImagePermissions"

// DescribeImagePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImagePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImagePermissions for more information on using the DescribeImagePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImagePermissionsRequest method.
//    req, resp := client.DescribeImagePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImagePermissions
func (c *AppStream) DescribeImagePermissionsRequest(input *DescribeImagePermissionsInput) (req *request.Request, output *DescribeImagePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeImagePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImagePermissionsInput{}
	}

	output = &DescribeImagePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImagePermissions API operation for Amazon AppStream.
//
// Retrieves a list that describes the permissions for shared AWS account IDs
// on a private image that you own.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeImagePermissions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImagePermissions
func (c *AppStream) DescribeImagePermissions(input *DescribeImagePermissionsInput) (*DescribeImagePermissionsOutput, error) {
	req, out := c.DescribeImagePermissionsRequest(input)
	return out, req.Send()
}

// DescribeImagePermissionsWithContext is the same as DescribeImagePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImagePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeImagePermissionsWithContext(ctx aws.Context, input *DescribeImagePermissionsInput, opts ...request.Option) (*DescribeImagePermissionsOutput, error) {
	req, out := c.DescribeImagePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeImagePermissionsPages iterates over the pages of a DescribeImagePermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImagePermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeImagePermissions operation.
//    pageNum := 0
//    err := client.DescribeImagePermissionsPages(params,
//        func(page *appstream.DescribeImagePermissionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppStream) DescribeImagePermissionsPages(input *DescribeImagePermissionsInput, fn func(*DescribeImagePermissionsOutput, bool) bool) error {
	return c.DescribeImagePermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeImagePermissionsPagesWithContext same as DescribeImagePermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeImagePermissionsPagesWithContext(ctx aws.Context, input *DescribeImagePermissionsInput, fn func(*DescribeImagePermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeImagePermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImagePermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeImagePermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeImages = "DescribeImages"

// DescribeImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImages for more information on using the DescribeImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImagesRequest method.
//    req, resp := client.DescribeImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages
func (c *AppStream) DescribeImagesRequest(input *DescribeImagesInput) (req *request.Request, output *DescribeImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImagesInput{}
	}

	output = &DescribeImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImages API operation for Amazon AppStream.
//
// Retrieves a list that describes one or more specified images, if the image
// names or image ARNs are provided. Otherwise, all images in the account are
// described.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeImages for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages
func (c *AppStream) DescribeImages(input *DescribeImagesInput) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	return out, req.Send()
}

// DescribeImagesWithContext is the same as DescribeImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeImagesWithContext(ctx aws.Context, input *DescribeImagesInput, opts ...request.Option) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeImagesPages iterates over the pages of a DescribeImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeImages operation.
//    pageNum := 0
//    err := client.DescribeImagesPages(params,
//        func(page *appstream.DescribeImagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppStream) DescribeImagesPages(input *DescribeImagesInput, fn func(*DescribeImagesOutput, bool) bool) error {
	return c.DescribeImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeImagesPagesWithContext same as DescribeImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeImagesPagesWithContext(ctx aws.Context, input *DescribeImagesInput, fn func(*DescribeImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSessions = "DescribeSessions"

// DescribeSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSessions for more information on using the DescribeSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSessionsRequest method.
//    req, resp := client.DescribeSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions
func (c *AppStream) DescribeSessionsRequest(input *DescribeSessionsInput) (req *request.Request, output *DescribeSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribeSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSessionsInput{}
	}

	output = &DescribeSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSessions API operation for Amazon AppStream.
//
// Retrieves a list that describes the streaming sessions for a specified stack
// and fleet. If a UserId is provided for the stack and fleet, only streaming
// sessions for that user are described. If an authentication type is not provided,
// the default is to authenticate users using a streaming URL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeSessions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions
func (c *AppStream) DescribeSessions(input *DescribeSessionsInput) (*DescribeSessionsOutput, error) {
	req, out := c.DescribeSessionsRequest(input)
	return out, req.Send()
}

// DescribeSessionsWithContext is the same as DescribeSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeSessionsWithContext(ctx aws.Context, input *DescribeSessionsInput, opts ...request.Option) (*DescribeSessionsOutput, error) {
	req, out := c.DescribeSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStacks for more information on using the DescribeStacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStacksRequest method.
//    req, resp := client.DescribeStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks
func (c *AppStream) DescribeStacksRequest(input *DescribeStacksInput) (req *request.Request, output *DescribeStacksOutput) {
	op := &request.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	output = &DescribeStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStacks API operation for Amazon AppStream.
//
// Retrieves a list that describes one or more specified stacks, if the stack
// names are provided. Otherwise, all stacks in the account are described.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeStacks for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks
func (c *AppStream) DescribeStacks(input *DescribeStacksInput) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	return out, req.Send()
}

// DescribeStacksWithContext is the same as DescribeStacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeStacksWithContext(ctx aws.Context, input *DescribeStacksInput, opts ...request.Option) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUsageReportSubscriptions = "DescribeUsageReportSubscriptions"

// DescribeUsageReportSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUsageReportSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUsageReportSubscriptions for more information on using the DescribeUsageReportSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUsageReportSubscriptionsRequest method.
//    req, resp := client.DescribeUsageReportSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsageReportSubscriptions
func (c *AppStream) DescribeUsageReportSubscriptionsRequest(input *DescribeUsageReportSubscriptionsInput) (req *request.Request, output *DescribeUsageReportSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeUsageReportSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUsageReportSubscriptionsInput{}
	}

	output = &DescribeUsageReportSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUsageReportSubscriptions API operation for Amazon AppStream.
//
// Retrieves a list that describes one or more usage report subscriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeUsageReportSubscriptions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsageReportSubscriptions
func (c *AppStream) DescribeUsageReportSubscriptions(input *DescribeUsageReportSubscriptionsInput) (*DescribeUsageReportSubscriptionsOutput, error) {
	req, out := c.DescribeUsageReportSubscriptionsRequest(input)
	return out, req.Send()
}

// DescribeUsageReportSubscriptionsWithContext is the same as DescribeUsageReportSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUsageReportSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeUsageReportSubscriptionsWithContext(ctx aws.Context, input *DescribeUsageReportSubscriptionsInput, opts ...request.Option) (*DescribeUsageReportSubscriptionsOutput, error) {
	req, out := c.DescribeUsageReportSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserStackAssociations = "DescribeUserStackAssociations"

// DescribeUserStackAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserStackAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserStackAssociations for more information on using the DescribeUserStackAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserStackAssociationsRequest method.
//    req, resp := client.DescribeUserStackAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUserStackAssociations
func (c *AppStream) DescribeUserStackAssociationsRequest(input *DescribeUserStackAssociationsInput) (req *request.Request, output *DescribeUserStackAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeUserStackAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserStackAssociationsInput{}
	}

	output = &DescribeUserStackAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserStackAssociations API operation for Amazon AppStream.
//
// Retrieves a list that describes the UserStackAssociation objects. You must
// specify either or both of the following:
//
//    * The stack name
//
//    * The user name (email address of the user associated with the stack)
//    and the authentication type for the user
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeUserStackAssociations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUserStackAssociations
func (c *AppStream) DescribeUserStackAssociations(input *DescribeUserStackAssociationsInput) (*DescribeUserStackAssociationsOutput, error) {
	req, out := c.DescribeUserStackAssociationsRequest(input)
	return out, req.Send()
}

// DescribeUserStackAssociationsWithContext is the same as DescribeUserStackAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserStackAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeUserStackAssociationsWithContext(ctx aws.Context, input *DescribeUserStackAssociationsInput, opts ...request.Option) (*DescribeUserStackAssociationsOutput, error) {
	req, out := c.DescribeUserStackAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUsers = "DescribeUsers"

// DescribeUsersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUsers for more information on using the DescribeUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUsersRequest method.
//    req, resp := client.DescribeUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsers
func (c *AppStream) DescribeUsersRequest(input *DescribeUsersInput) (req *request.Request, output *DescribeUsersOutput) {
	op := &request.Operation{
		Name:       opDescribeUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUsersInput{}
	}

	output = &DescribeUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUsers API operation for Amazon AppStream.
//
// Retrieves a list that describes one or more specified users in the user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeUsers for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsers
func (c *AppStream) DescribeUsers(input *DescribeUsersInput) (*DescribeUsersOutput, error) {
	req, out := c.DescribeUsersRequest(input)
	return out, req.Send()
}

// DescribeUsersWithContext is the same as DescribeUsers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeUsersWithContext(ctx aws.Context, input *DescribeUsersInput, opts ...request.Option) (*DescribeUsersOutput, error) {
	req, out := c.DescribeUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableUser = "DisableUser"

// DisableUserRequest generates a "aws/request.Request" representing the
// client's request for the DisableUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableUser for more information on using the DisableUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableUserRequest method.
//    req, resp := client.DisableUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisableUser
func (c *AppStream) DisableUserRequest(input *DisableUserInput) (req *request.Request, output *DisableUserOutput) {
	op := &request.Operation{
		Name:       opDisableUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableUserInput{}
	}

	output = &DisableUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableUser API operation for Amazon AppStream.
//
// Disables the specified user in the user pool. Users can't sign in to AppStream
// 2.0 until they are re-enabled. This action does not delete the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DisableUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisableUser
func (c *AppStream) DisableUser(input *DisableUserInput) (*DisableUserOutput, error) {
	req, out := c.DisableUserRequest(input)
	return out, req.Send()
}

// DisableUserWithContext is the same as DisableUser with the addition of
// the ability to pass a context and additional request options.
//
// See DisableUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DisableUserWithContext(ctx aws.Context, input *DisableUserInput, opts ...request.Option) (*DisableUserOutput, error) {
	req, out := c.DisableUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFleet = "DisassociateFleet"

// DisassociateFleetRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFleet for more information on using the DisassociateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateFleetRequest method.
//    req, resp := client.DisassociateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet
func (c *AppStream) DisassociateFleetRequest(input *DisassociateFleetInput) (req *request.Request, output *DisassociateFleetOutput) {
	op := &request.Operation{
		Name:       opDisassociateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateFleetInput{}
	}

	output = &DisassociateFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateFleet API operation for Amazon AppStream.
//
// Disassociates the specified fleet from the specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DisassociateFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet
func (c *AppStream) DisassociateFleet(input *DisassociateFleetInput) (*DisassociateFleetOutput, error) {
	req, out := c.DisassociateFleetRequest(input)
	return out, req.Send()
}

// DisassociateFleetWithContext is the same as DisassociateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DisassociateFleetWithContext(ctx aws.Context, input *DisassociateFleetInput, opts ...request.Option) (*DisassociateFleetOutput, error) {
	req, out := c.DisassociateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableUser = "EnableUser"

// EnableUserRequest generates a "aws/request.Request" representing the
// client's request for the EnableUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableUser for more information on using the EnableUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableUserRequest method.
//    req, resp := client.EnableUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/EnableUser
func (c *AppStream) EnableUserRequest(input *EnableUserInput) (req *request.Request, output *EnableUserOutput) {
	op := &request.Operation{
		Name:       opEnableUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableUserInput{}
	}

	output = &EnableUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableUser API operation for Amazon AppStream.
//
// Enables a user in the user pool. After being enabled, users can sign in to
// AppStream 2.0 and open applications from the stacks to which they are assigned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation EnableUser for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/EnableUser
func (c *AppStream) EnableUser(input *EnableUserInput) (*EnableUserOutput, error) {
	req, out := c.EnableUserRequest(input)
	return out, req.Send()
}

// EnableUserWithContext is the same as EnableUser with the addition of
// the ability to pass a context and additional request options.
//
// See EnableUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) EnableUserWithContext(ctx aws.Context, input *EnableUserInput, opts ...request.Option) (*EnableUserOutput, error) {
	req, out := c.EnableUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExpireSession = "ExpireSession"

// ExpireSessionRequest generates a "aws/request.Request" representing the
// client's request for the ExpireSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExpireSession for more information on using the ExpireSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExpireSessionRequest method.
//    req, resp := client.ExpireSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession
func (c *AppStream) ExpireSessionRequest(input *ExpireSessionInput) (req *request.Request, output *ExpireSessionOutput) {
	op := &request.Operation{
		Name:       opExpireSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExpireSessionInput{}
	}

	output = &ExpireSessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ExpireSession API operation for Amazon AppStream.
//
// Immediately stops the specified streaming session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ExpireSession for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession
func (c *AppStream) ExpireSession(input *ExpireSessionInput) (*ExpireSessionOutput, error) {
	req, out := c.ExpireSessionRequest(input)
	return out, req.Send()
}

// ExpireSessionWithContext is the same as ExpireSession with the addition of
// the ability to pass a context and additional request options.
//
// See ExpireSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) ExpireSessionWithContext(ctx aws.Context, input *ExpireSessionInput, opts ...request.Option) (*ExpireSessionOutput, error) {
	req, out := c.ExpireSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssociatedFleets = "ListAssociatedFleets"

// ListAssociatedFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociatedFleets for more information on using the ListAssociatedFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociatedFleetsRequest method.
//    req, resp := client.ListAssociatedFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets
func (c *AppStream) ListAssociatedFleetsRequest(input *ListAssociatedFleetsInput) (req *request.Request, output *ListAssociatedFleetsOutput) {
	op := &request.Operation{
		Name:       opListAssociatedFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociatedFleetsInput{}
	}

	output = &ListAssociatedFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociatedFleets API operation for Amazon AppStream.
//
// Retrieves the name of the fleet that is associated with the specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ListAssociatedFleets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets
func (c *AppStream) ListAssociatedFleets(input *ListAssociatedFleetsInput) (*ListAssociatedFleetsOutput, error) {
	req, out := c.ListAssociatedFleetsRequest(input)
	return out, req.Send()
}

// ListAssociatedFleetsWithContext is the same as ListAssociatedFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociatedFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) ListAssociatedFleetsWithContext(ctx aws.Context, input *ListAssociatedFleetsInput, opts ...request.Option) (*ListAssociatedFleetsOutput, error) {
	req, out := c.ListAssociatedFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssociatedStacks = "ListAssociatedStacks"

// ListAssociatedStacksRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedStacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociatedStacks for more information on using the ListAssociatedStacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociatedStacksRequest method.
//    req, resp := client.ListAssociatedStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks
func (c *AppStream) ListAssociatedStacksRequest(input *ListAssociatedStacksInput) (req *request.Request, output *ListAssociatedStacksOutput) {
	op := &request.Operation{
		Name:       opListAssociatedStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociatedStacksInput{}
	}

	output = &ListAssociatedStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociatedStacks API operation for Amazon AppStream.
//
// Retrieves the name of the stack with which the specified fleet is associated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ListAssociatedStacks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks
func (c *AppStream) ListAssociatedStacks(input *ListAssociatedStacksInput) (*ListAssociatedStacksOutput, error) {
	req, out := c.ListAssociatedStacksRequest(input)
	return out, req.Send()
}

// ListAssociatedStacksWithContext is the same as ListAssociatedStacks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociatedStacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) ListAssociatedStacksWithContext(ctx aws.Context, input *ListAssociatedStacksInput, opts ...request.Option) (*ListAssociatedStacksOutput, error) {
	req, out := c.ListAssociatedStacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListTagsForResource
func (c *AppStream) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon AppStream.
//
// Retrieves a list of all tags for the specified AppStream 2.0 resource. You
// can tag AppStream 2.0 image builders, images, fleets, and stacks.
//
// For more information about tags, see Tagging Your Resources (https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
// in the Amazon AppStream 2.0 Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListTagsForResource
func (c *AppStream) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFleet = "StartFleet"

// StartFleetRequest generates a "aws/request.Request" representing the
// client's request for the StartFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFleet for more information on using the StartFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartFleetRequest method.
//    req, resp := client.StartFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet
func (c *AppStream) StartFleetRequest(input *StartFleetInput) (req *request.Request, output *StartFleetOutput) {
	op := &request.Operation{
		Name:       opStartFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFleetInput{}
	}

	output = &StartFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartFleet API operation for Amazon AppStream.
//
// Starts the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation StartFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * RequestLimitExceededException
//   AppStream 2.0 can’t process the request right now because the Describe
//   calls from your AWS account are being throttled by Amazon EC2. Try again
//   later.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * InvalidRoleException
//   The specified role is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet
func (c *AppStream) StartFleet(input *StartFleetInput) (*StartFleetOutput, error) {
	req, out := c.StartFleetRequest(input)
	return out, req.Send()
}

// StartFleetWithContext is the same as StartFleet with the addition of
// the ability to pass a context and additional request options.
//
// See StartFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) StartFleetWithContext(ctx aws.Context, input *StartFleetInput, opts ...request.Option) (*StartFleetOutput, error) {
	req, out := c.StartFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartImageBuilder = "StartImageBuilder"

// StartImageBuilderRequest generates a "aws/request.Request" representing the
// client's request for the StartImageBuilder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartImageBuilder for more information on using the StartImageBuilder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartImageBuilderRequest method.
//    req, resp := client.StartImageBuilderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder
func (c *AppStream) StartImageBuilderRequest(input *StartImageBuilderInput) (req *request.Request, output *StartImageBuilderOutput) {
	op := &request.Operation{
		Name:       opStartImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartImageBuilderInput{}
	}

	output = &StartImageBuilderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartImageBuilder API operation for Amazon AppStream.
//
// Starts the specified image builder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation StartImageBuilder for usage and error information.
//
// Returned Error Types:
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * IncompatibleImageException
//   The image does not support storage connectors.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder
func (c *AppStream) StartImageBuilder(input *StartImageBuilderInput) (*StartImageBuilderOutput, error) {
	req, out := c.StartImageBuilderRequest(input)
	return out, req.Send()
}

// StartImageBuilderWithContext is the same as StartImageBuilder with the addition of
// the ability to pass a context and additional request options.
//
// See StartImageBuilder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) StartImageBuilderWithContext(ctx aws.Context, input *StartImageBuilderInput, opts ...request.Option) (*StartImageBuilderOutput, error) {
	req, out := c.StartImageBuilderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopFleet = "StopFleet"

// StopFleetRequest generates a "aws/request.Request" representing the
// client's request for the StopFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopFleet for more information on using the StopFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopFleetRequest method.
//    req, resp := client.StopFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet
func (c *AppStream) StopFleetRequest(input *StopFleetInput) (req *request.Request, output *StopFleetOutput) {
	op := &request.Operation{
		Name:       opStopFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopFleetInput{}
	}

	output = &StopFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopFleet API operation for Amazon AppStream.
//
// Stops the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation StopFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet
func (c *AppStream) StopFleet(input *StopFleetInput) (*StopFleetOutput, error) {
	req, out := c.StopFleetRequest(input)
	return out, req.Send()
}

// StopFleetWithContext is the same as StopFleet with the addition of
// the ability to pass a context and additional request options.
//
// See StopFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) StopFleetWithContext(ctx aws.Context, input *StopFleetInput, opts ...request.Option) (*StopFleetOutput, error) {
	req, out := c.StopFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopImageBuilder = "StopImageBuilder"

// StopImageBuilderRequest generates a "aws/request.Request" representing the
// client's request for the StopImageBuilder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopImageBuilder for more information on using the StopImageBuilder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopImageBuilderRequest method.
//    req, resp := client.StopImageBuilderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder
func (c *AppStream) StopImageBuilderRequest(input *StopImageBuilderInput) (req *request.Request, output *StopImageBuilderOutput) {
	op := &request.Operation{
		Name:       opStopImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopImageBuilderInput{}
	}

	output = &StopImageBuilderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopImageBuilder API operation for Amazon AppStream.
//
// Stops the specified image builder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation StopImageBuilder for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder
func (c *AppStream) StopImageBuilder(input *StopImageBuilderInput) (*StopImageBuilderOutput, error) {
	req, out := c.StopImageBuilderRequest(input)
	return out, req.Send()
}

// StopImageBuilderWithContext is the same as StopImageBuilder with the addition of
// the ability to pass a context and additional request options.
//
// See StopImageBuilder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) StopImageBuilderWithContext(ctx aws.Context, input *StopImageBuilderInput, opts ...request.Option) (*StopImageBuilderOutput, error) {
	req, out := c.StopImageBuilderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/TagResource
func (c *AppStream) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon AppStream.
//
// Adds or overwrites one or more tags for the specified AppStream 2.0 resource.
// You can tag AppStream 2.0 image builders, images, fleets, and stacks.
//
// Each tag consists of a key and an optional value. If a resource already has
// a tag with the same key, this operation updates its value.
//
// To list the current tags for your resources, use ListTagsForResource. To
// disassociate tags from your resources, use UntagResource.
//
// For more information about tags, see Tagging Your Resources (https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
// in the Amazon AppStream 2.0 Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/TagResource
func (c *AppStream) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UntagResource
func (c *AppStream) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon AppStream.
//
// Disassociates one or more specified tags from the specified AppStream 2.0
// resource.
//
// To list the current tags for your resources, use ListTagsForResource.
//
// For more information about tags, see Tagging Your Resources (https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
// in the Amazon AppStream 2.0 Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UntagResource
func (c *AppStream) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDirectoryConfig = "UpdateDirectoryConfig"

// UpdateDirectoryConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDirectoryConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDirectoryConfig for more information on using the UpdateDirectoryConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDirectoryConfigRequest method.
//    req, resp := client.UpdateDirectoryConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig
func (c *AppStream) UpdateDirectoryConfigRequest(input *UpdateDirectoryConfigInput) (req *request.Request, output *UpdateDirectoryConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateDirectoryConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDirectoryConfigInput{}
	}

	output = &UpdateDirectoryConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDirectoryConfig API operation for Amazon AppStream.
//
// Updates the specified Directory Config object in AppStream 2.0. This object
// includes the configuration information required to join fleets and image
// builders to Microsoft Active Directory domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UpdateDirectoryConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * InvalidRoleException
//   The specified role is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig
func (c *AppStream) UpdateDirectoryConfig(input *UpdateDirectoryConfigInput) (*UpdateDirectoryConfigOutput, error) {
	req, out := c.UpdateDirectoryConfigRequest(input)
	return out, req.Send()
}

// UpdateDirectoryConfigWithContext is the same as UpdateDirectoryConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDirectoryConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) UpdateDirectoryConfigWithContext(ctx aws.Context, input *UpdateDirectoryConfigInput, opts ...request.Option) (*UpdateDirectoryConfigOutput, error) {
	req, out := c.UpdateDirectoryConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleet = "UpdateFleet"

// UpdateFleetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleet for more information on using the UpdateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFleetRequest method.
//    req, resp := client.UpdateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet
func (c *AppStream) UpdateFleetRequest(input *UpdateFleetInput) (req *request.Request, output *UpdateFleetOutput) {
	op := &request.Operation{
		Name:       opUpdateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetInput{}
	}

	output = &UpdateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleet API operation for Amazon AppStream.
//
// Updates the specified fleet.
//
// If the fleet is in the STOPPED state, you can update any attribute except
// the fleet name. If the fleet is in the RUNNING state, you can update the
// DisplayName, ComputeCapacity, ImageARN, ImageName, IdleDisconnectTimeoutInSeconds,
// and DisconnectTimeoutInSeconds attributes. If the fleet is in the STARTING
// or STOPPING state, you can't update it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UpdateFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * RequestLimitExceededException
//   AppStream 2.0 can’t process the request right now because the Describe
//   calls from your AWS account are being throttled by Amazon EC2. Try again
//   later.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * InvalidRoleException
//   The specified role is invalid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
//   * IncompatibleImageException
//   The image does not support storage connectors.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet
func (c *AppStream) UpdateFleet(input *UpdateFleetInput) (*UpdateFleetOutput, error) {
	req, out := c.UpdateFleetRequest(input)
	return out, req.Send()
}

// UpdateFleetWithContext is the same as UpdateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) UpdateFleetWithContext(ctx aws.Context, input *UpdateFleetInput, opts ...request.Option) (*UpdateFleetOutput, error) {
	req, out := c.UpdateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateImagePermissions = "UpdateImagePermissions"

// UpdateImagePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateImagePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateImagePermissions for more information on using the UpdateImagePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateImagePermissionsRequest method.
//    req, resp := client.UpdateImagePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateImagePermissions
func (c *AppStream) UpdateImagePermissionsRequest(input *UpdateImagePermissionsInput) (req *request.Request, output *UpdateImagePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateImagePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateImagePermissionsInput{}
	}

	output = &UpdateImagePermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateImagePermissions API operation for Amazon AppStream.
//
// Adds or updates permissions for the specified private image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UpdateImagePermissions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateImagePermissions
func (c *AppStream) UpdateImagePermissions(input *UpdateImagePermissionsInput) (*UpdateImagePermissionsOutput, error) {
	req, out := c.UpdateImagePermissionsRequest(input)
	return out, req.Send()
}

// UpdateImagePermissionsWithContext is the same as UpdateImagePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateImagePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) UpdateImagePermissionsWithContext(ctx aws.Context, input *UpdateImagePermissionsInput, opts ...request.Option) (*UpdateImagePermissionsOutput, error) {
	req, out := c.UpdateImagePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStack for more information on using the UpdateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStackRequest method.
//    req, resp := client.UpdateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack
func (c *AppStream) UpdateStackRequest(input *UpdateStackInput) (req *request.Request, output *UpdateStackOutput) {
	op := &request.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	output = &UpdateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStack API operation for Amazon AppStream.
//
// Updates the specified fields for the specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UpdateStack for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * InvalidRoleException
//   The specified role is invalid.
//
//   * InvalidParameterCombinationException
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * InvalidAccountStatusException
//   The resource cannot be created because your AWS account is suspended. For
//   assistance, contact AWS Support.
//
//   * IncompatibleImageException
//   The image does not support storage connectors.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
//   * ConcurrentModificationException
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack
func (c *AppStream) UpdateStack(input *UpdateStackInput) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	return out, req.Send()
}

// UpdateStackWithContext is the same as UpdateStack with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) UpdateStackWithContext(ctx aws.Context, input *UpdateStackInput, opts ...request.Option) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes an interface VPC endpoint (interface endpoint) that lets you create
// a private connection between the virtual private cloud (VPC) that you specify
// and AppStream 2.0. When you specify an interface endpoint for a stack, users
// of the stack can connect to AppStream 2.0 only through that endpoint. When
// you specify an interface endpoint for an image builder, administrators can
// connect to the image builder only through that endpoint.
type AccessEndpoint struct {
	_ struct{} `type:"structure"`

	// The type of interface endpoint.
	//
	// EndpointType is a required field
	EndpointType *string `type:"string" required:"true" enum:"AccessEndpointType"`

	// The identifier (ID) of the VPC in which the interface endpoint is used.
	VpceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AccessEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessEndpoint) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessEndpoint) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessEndpoint"}
	if s.EndpointType == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointType"))
	}
	if s.VpceId != nil && len(*s.VpceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointType sets the EndpointType field's value.
func (s *AccessEndpoint) SetEndpointType(v string) *AccessEndpoint {
	s.EndpointType = &v
	return s
}

// SetVpceId sets the VpceId field's value.
func (s *AccessEndpoint) SetVpceId(v string) *AccessEndpoint {
	s.VpceId = &v
	return s
}

// Describes an application in the application catalog.
type Application struct {
	_ struct{} `type:"structure"`

	// The application name to display.
	DisplayName *string `min:"1" type:"string"`

	// If there is a problem, the application can be disabled after image creation.
	Enabled *bool `type:"boolean"`

	// The URL for the application icon. This URL might be time-limited.
	IconURL *string `min:"1" type:"string"`

	// The arguments that are passed to the application at launch.
	LaunchParameters *string `min:"1" type:"string"`

	// The path to the application executable in the instance.
	LaunchPath *string `min:"1" type:"string"`

	// Additional attributes that describe the application.
	Metadata map[string]*string `type:"map"`

	// The name of the application.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Application) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *Application) SetDisplayName(v string) *Application {
	s.DisplayName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *Application) SetEnabled(v bool) *Application {
	s.Enabled = &v
	return s
}

// SetIconURL sets the IconURL field's value.
func (s *Application) SetIconURL(v string) *Application {
	s.IconURL = &v
	return s
}

// SetLaunchParameters sets the LaunchParameters field's value.
func (s *Application) SetLaunchParameters(v string) *Application {
	s.LaunchParameters = &v
	return s
}

// SetLaunchPath sets the LaunchPath field's value.
func (s *Application) SetLaunchPath(v string) *Application {
	s.LaunchPath = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *Application) SetMetadata(v map[string]*string) *Application {
	s.Metadata = v
	return s
}

// SetName sets the Name field's value.
func (s *Application) SetName(v string) *Application {
	s.Name = &v
	return s
}

// The persistent application settings for users of a stack.
type ApplicationSettings struct {
	_ struct{} `type:"structure"`

	// Enables or disables persistent application settings for users during their
	// streaming sessions.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The path prefix for the S3 bucket where users’ persistent application settings
	// are stored. You can allow the same persistent application settings to be
	// used across multiple stacks by specifying the same settings group for each
	// stack.
	SettingsGroup *string `type:"string"`
}

// String returns the string representation
func (s ApplicationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationSettings"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ApplicationSettings) SetEnabled(v bool) *ApplicationSettings {
	s.Enabled = &v
	return s
}

// SetSettingsGroup sets the SettingsGroup field's value.
func (s *ApplicationSettings) SetSettingsGroup(v string) *ApplicationSettings {
	s.SettingsGroup = &v
	return s
}

// Describes the persistent application settings for users of a stack.
type ApplicationSettingsResponse struct {
	_ struct{} `type:"structure"`

	// Specifies whether persistent application settings are enabled for users during
	// their streaming sessions.
	Enabled *bool `type:"boolean"`

	// The S3 bucket where users’ persistent application settings are stored.
	// When persistent application settings are enabled for the first time for an
	// account in an AWS Region, an S3 bucket is created. The bucket is unique to
	// the AWS account and the Region.
	S3BucketName *string `min:"1" type:"string"`

	// The path prefix for the S3 bucket where users’ persistent application settings
	// are stored.
	SettingsGroup *string `type:"string"`
}

// String returns the string representation
func (s ApplicationSettingsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationSettingsResponse) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *ApplicationSettingsResponse) SetEnabled(v bool) *ApplicationSettingsResponse {
	s.Enabled = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *ApplicationSettingsResponse) SetS3BucketName(v string) *ApplicationSettingsResponse {
	s.S3BucketName = &v
	return s
}

// SetSettingsGroup sets the SettingsGroup field's value.
func (s *ApplicationSettingsResponse) SetSettingsGroup(v string) *ApplicationSettingsResponse {
	s.SettingsGroup = &v
	return s
}

type AssociateFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The name of the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateFleetInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetName sets the FleetName field's value.
func (s *AssociateFleetInput) SetFleetName(v string) *AssociateFleetInput {
	s.FleetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *AssociateFleetInput) SetStackName(v string) *AssociateFleetInput {
	s.StackName = &v
	return s
}

type AssociateFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateFleetOutput) GoString() string {
	return s.String()
}

type BatchAssociateUserStackInput struct {
	_ struct{} `type:"structure"`

	// The list of UserStackAssociation objects.
	//
	// UserStackAssociations is a required field
	UserStackAssociations []*UserStackAssociation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchAssociateUserStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAssociateUserStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateUserStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAssociateUserStackInput"}
	if s.UserStackAssociations == nil {
		invalidParams.Add(request.NewErrParamRequired("UserStackAssociations"))
	}
	if s.UserStackAssociations != nil && len(s.UserStackAssociations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserStackAssociations", 1))
	}
	if s.UserStackAssociations != nil {
		for i, v := range s.UserStackAssociations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserStackAssociations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserStackAssociations sets the UserStackAssociations field's value.
func (s *BatchAssociateUserStackInput) SetUserStackAssociations(v []*UserStackAssociation) *BatchAssociateUserStackInput {
	s.UserStackAssociations = v
	return s
}

type BatchAssociateUserStackOutput struct {
	_ struct{} `type:"structure"`

	// The list of UserStackAssociationError objects.
	Errors []*UserStackAssociationError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchAssociateUserStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAssociateUserStackOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchAssociateUserStackOutput) SetErrors(v []*UserStackAssociationError) *BatchAssociateUserStackOutput {
	s.Errors = v
	return s
}

type BatchDisassociateUserStackInput struct {
	_ struct{} `type:"structure"`

	// The list of UserStackAssociation objects.
	//
	// UserStackAssociations is a required field
	UserStackAssociations []*UserStackAssociation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDisassociateUserStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisassociateUserStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisassociateUserStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisassociateUserStackInput"}
	if s.UserStackAssociations == nil {
		invalidParams.Add(request.NewErrParamRequired("UserStackAssociations"))
	}
	if s.UserStackAssociations != nil && len(s.UserStackAssociations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserStackAssociations", 1))
	}
	if s.UserStackAssociations != nil {
		for i, v := range s.UserStackAssociations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserStackAssociations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserStackAssociations sets the UserStackAssociations field's value.
func (s *BatchDisassociateUserStackInput) SetUserStackAssociations(v []*UserStackAssociation) *BatchDisassociateUserStackInput {
	s.UserStackAssociations = v
	return s
}

type BatchDisassociateUserStackOutput struct {
	_ struct{} `type:"structure"`

	// The list of UserStackAssociationError objects.
	Errors []*UserStackAssociationError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchDisassociateUserStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDisassociateUserStackOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDisassociateUserStackOutput) SetErrors(v []*UserStackAssociationError) *BatchDisassociateUserStackOutput {
	s.Errors = v
	return s
}

// Describes the capacity for a fleet.
type ComputeCapacity struct {
	_ struct{} `type:"structure"`

	// The desired number of streaming instances.
	//
	// DesiredInstances is a required field
	DesiredInstances *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ComputeCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeCapacity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeCapacity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComputeCapacity"}
	if s.DesiredInstances == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredInstances"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredInstances sets the DesiredInstances field's value.
func (s *ComputeCapacity) SetDesiredInstances(v int64) *ComputeCapacity {
	s.DesiredInstances = &v
	return s
}

// Describes the capacity status for a fleet.
type ComputeCapacityStatus struct {
	_ struct{} `type:"structure"`

	// The number of currently available instances that can be used to stream sessions.
	Available *int64 `type:"integer"`

	// The desired number of streaming instances.
	//
	// Desired is a required field
	Desired *int64 `type:"integer" required:"true"`

	// The number of instances in use for streaming.
	InUse *int64 `type:"integer"`

	// The total number of simultaneous streaming instances that are running.
	Running *int64 `type:"integer"`
}

// String returns the string representation
func (s ComputeCapacityStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeCapacityStatus) GoString() string {
	return s.String()
}

// SetAvailable sets the Available field's value.
func (s *ComputeCapacityStatus) SetAvailable(v int64) *ComputeCapacityStatus {
	s.Available = &v
	return s
}

// SetDesired sets the Desired field's value.
func (s *ComputeCapacityStatus) SetDesired(v int64) *ComputeCapacityStatus {
	s.Desired = &v
	return s
}

// SetInUse sets the InUse field's value.
func (s *ComputeCapacityStatus) SetInUse(v int64) *ComputeCapacityStatus {
	s.InUse = &v
	return s
}

// SetRunning sets the Running field's value.
func (s *ComputeCapacityStatus) SetRunning(v int64) *ComputeCapacityStatus {
	s.Running = &v
	return s
}

// An API error occurred. Wait a few minutes and try again.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CopyImageInput struct {
	_ struct{} `type:"structure"`

	// The description that the image will have when it is copied to the destination.
	DestinationImageDescription *string `type:"string"`

	// The name that the image will have when it is copied to the destination.
	//
	// DestinationImageName is a required field
	DestinationImageName *string `type:"string" required:"true"`

	// The destination region to which the image will be copied. This parameter
	// is required, even if you are copying an image within the same region.
	//
	// DestinationRegion is a required field
	DestinationRegion *string `min:"1" type:"string" required:"true"`

	// The name of the image to copy.
	//
	// SourceImageName is a required field
	SourceImageName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyImageInput"}
	if s.DestinationImageName == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationImageName"))
	}
	if s.DestinationRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationRegion"))
	}
	if s.DestinationRegion != nil && len(*s.DestinationRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationRegion", 1))
	}
	if s.SourceImageName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImageName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationImageDescription sets the DestinationImageDescription field's value.
func (s *CopyImageInput) SetDestinationImageDescription(v string) *CopyImageInput {
	s.DestinationImageDescription = &v
	return s
}

// SetDestinationImageName sets the DestinationImageName field's value.
func (s *CopyImageInput) SetDestinationImageName(v string) *CopyImageInput {
	s.DestinationImageName = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CopyImageInput) SetDestinationRegion(v string) *CopyImageInput {
	s.DestinationRegion = &v
	return s
}

// SetSourceImageName sets the SourceImageName field's value.
func (s *CopyImageInput) SetSourceImageName(v string) *CopyImageInput {
	s.SourceImageName = &v
	return s
}

type CopyImageOutput struct {
	_ struct{} `type:"structure"`

	// The name of the destination image.
	DestinationImageName *string `type:"string"`
}

// String returns the string representation
func (s CopyImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyImageOutput) GoString() string {
	return s.String()
}

// SetDestinationImageName sets the DestinationImageName field's value.
func (s *CopyImageOutput) SetDestinationImageName(v string) *CopyImageOutput {
	s.DestinationImageName = &v
	return s
}

type CreateDirectoryConfigInput struct {
	_ struct{} `type:"structure"`

	// The fully qualified name of the directory (for example, corp.example.com).
	//
	// DirectoryName is a required field
	DirectoryName *string `type:"string" required:"true"`

	// The distinguished names of the organizational units for computer accounts.
	//
	// OrganizationalUnitDistinguishedNames is a required field
	OrganizationalUnitDistinguishedNames []*string `type:"list" required:"true"`

	// The credentials for the service account used by the fleet or image builder
	// to connect to the directory.
	ServiceAccountCredentials *ServiceAccountCredentials `type:"structure"`
}

// String returns the string representation
func (s CreateDirectoryConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectoryConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectoryConfigInput"}
	if s.DirectoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryName"))
	}
	if s.OrganizationalUnitDistinguishedNames == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationalUnitDistinguishedNames"))
	}
	if s.ServiceAccountCredentials != nil {
		if err := s.ServiceAccountCredentials.Validate(); err != nil {
			invalidParams.AddNested("ServiceAccountCredentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *CreateDirectoryConfigInput) SetDirectoryName(v string) *CreateDirectoryConfigInput {
	s.DirectoryName = &v
	return s
}

// SetOrganizationalUnitDistinguishedNames sets the OrganizationalUnitDistinguishedNames field's value.
func (s *CreateDirectoryConfigInput) SetOrganizationalUnitDistinguishedNames(v []*string) *CreateDirectoryConfigInput {
	s.OrganizationalUnitDistinguishedNames = v
	return s
}

// SetServiceAccountCredentials sets the ServiceAccountCredentials field's value.
func (s *CreateDirectoryConfigInput) SetServiceAccountCredentials(v *ServiceAccountCredentials) *CreateDirectoryConfigInput {
	s.ServiceAccountCredentials = v
	return s
}

type CreateDirectoryConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the directory configuration.
	DirectoryConfig *DirectoryConfig `type:"structure"`
}

// String returns the string representation
func (s CreateDirectoryConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryConfigOutput) GoString() string {
	return s.String()
}

// SetDirectoryConfig sets the DirectoryConfig field's value.
func (s *CreateDirectoryConfigOutput) SetDirectoryConfig(v *DirectoryConfig) *CreateDirectoryConfigOutput {
	s.DirectoryConfig = v
	return s
}

type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// The desired capacity for the fleet.
	//
	// ComputeCapacity is a required field
	ComputeCapacity *ComputeCapacity `type:"structure" required:"true"`

	// The description to display.
	Description *string `type:"string"`

	// The amount of time that a streaming session remains active after users disconnect.
	// If users try to reconnect to the streaming session after a disconnection
	// or network interruption within this time interval, they are connected to
	// their previous session. Otherwise, they are connected to a new session with
	// a new streaming instance.
	//
	// Specify a value between 60 and 360000.
	DisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The fleet name to display.
	DisplayName *string `type:"string"`

	// The name of the directory and organizational unit (OU) to use to join the
	// fleet to a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Enables or disables default internet access for the fleet.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The fleet type.
	//
	// ALWAYS_ON
	//
	// Provides users with instant-on access to their apps. You are charged for
	// all running instances in your fleet, even if no users are streaming apps.
	//
	// ON_DEMAND
	//
	// Provide users with access to applications after they connect, which takes
	// one to two minutes. You are charged for instance streaming when users are
	// connected and a small hourly fee for instances that are not streaming apps.
	FleetType *string `type:"string" enum:"FleetType"`

	// The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To
	// assume a role, a fleet instance calls the AWS Security Token Service (STS)
	// AssumeRole API operation and passes the ARN of the role to use. The operation
	// creates a new session with temporary credentials. AppStream 2.0 retrieves
	// the temporary credentials and creates the appstream_machine_role credential
	// profile on the instance.
	//
	// For more information, see Using an IAM Role to Grant Permissions to Applications
	// and Scripts Running on AppStream 2.0 Streaming Instances (https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	IamRoleArn *string `type:"string"`

	// The amount of time that users can be idle (inactive) before they are disconnected
	// from their streaming session and the DisconnectTimeoutInSeconds time interval
	// begins. Users are notified before they are disconnected due to inactivity.
	// If they try to reconnect to the streaming session before the time interval
	// specified in DisconnectTimeoutInSeconds elapses, they are connected to their
	// previous session. Users are considered idle when they stop providing keyboard
	// or mouse input during their streaming session. File uploads and downloads,
	// audio in, audio out, and pixels changing do not qualify as user activity.
	// If users continue to be idle after the time interval in IdleDisconnectTimeoutInSeconds
	// elapses, they are disconnected.
	//
	// To prevent users from being disconnected due to inactivity, specify a value
	// of 0. Otherwise, specify a value between 60 and 3600. The default value is
	// 0.
	//
	// If you enable this feature, we recommend that you specify a value that corresponds
	// exactly to a whole number of minutes (for example, 60, 120, and 180). If
	// you don't do this, the value is rounded to the nearest minute. For example,
	// if you specify a value of 70, users are disconnected after 1 minute of inactivity.
	// If you specify a value that is at the midpoint between two different minutes,
	// the value is rounded up. For example, if you specify a value of 90, users
	// are disconnected after 2 minutes of inactivity.
	IdleDisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The ARN of the public, private, or shared image to use.
	ImageArn *string `type:"string"`

	// The name of the image used to create the fleet.
	ImageName *string `min:"1" type:"string"`

	// The instance type to use when launching fleet instances. The following instance
	// types are available:
	//
	//    * stream.standard.small
	//
	//    * stream.standard.medium
	//
	//    * stream.standard.large
	//
	//    * stream.compute.large
	//
	//    * stream.compute.xlarge
	//
	//    * stream.compute.2xlarge
	//
	//    * stream.compute.4xlarge
	//
	//    * stream.compute.8xlarge
	//
	//    * stream.memory.large
	//
	//    * stream.memory.xlarge
	//
	//    * stream.memory.2xlarge
	//
	//    * stream.memory.4xlarge
	//
	//    * stream.memory.8xlarge
	//
	//    * stream.memory.z1d.large
	//
	//    * stream.memory.z1d.xlarge
	//
	//    * stream.memory.z1d.2xlarge
	//
	//    * stream.memory.z1d.3xlarge
	//
	//    * stream.memory.z1d.6xlarge
	//
	//    * stream.memory.z1d.12xlarge
	//
	//    * stream.graphics-design.large
	//
	//    * stream.graphics-design.xlarge
	//
	//    * stream.graphics-design.2xlarge
	//
	//    * stream.graphics-design.4xlarge
	//
	//    * stream.graphics-desktop.2xlarge
	//
	//    * stream.graphics.g4dn.xlarge
	//
	//    * stream.graphics.g4dn.2xlarge
	//
	//    * stream.graphics.g4dn.4xlarge
	//
	//    * stream.graphics.g4dn.8xlarge
	//
	//    * stream.graphics.g4dn.12xlarge
	//
	//    * stream.graphics.g4dn.16xlarge
	//
	//    * stream.graphics-pro.4xlarge
	//
	//    * stream.graphics-pro.8xlarge
	//
	//    * stream.graphics-pro.16xlarge
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The maximum amount of time that a streaming session can remain active, in
	// seconds. If users are still connected to a streaming instance five minutes
	// before this limit is reached, they are prompted to save any open documents
	// before being disconnected. After this time elapses, the instance is terminated
	// and replaced by a new instance.
	//
	// Specify a value between 600 and 360000.
	MaxUserDurationInSeconds *int64 `type:"integer"`

	// A unique name for the fleet.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The AppStream 2.0 view that is displayed to your users when they stream from
	// the fleet. When APP is specified, only the windows of applications opened
	// by users display. When DESKTOP is specified, the standard desktop that is
	// provided by the operating system displays.
	//
	// The default value is APP.
	StreamView *string `type:"string" enum:"StreamView"`

	// The tags to associate with the fleet. A tag is a key-value pair, and the
	// value is optional. For example, Environment=Test. If you do not specify a
	// value, Environment=.
	//
	// If you do not specify a value, the value is set to an empty string.
	//
	// Generally allowed characters are: letters, numbers, and spaces representable
	// in UTF-8, and the following special characters:
	//
	// _ . : / = + \ - @
	//
	// For more information, see Tagging Your Resources (https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	Tags map[string]*string `min:"1" type:"map"`

	// The VPC configuration for the fleet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetInput"}
	if s.ComputeCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeCapacity"))
	}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ComputeCapacity != nil {
		if err := s.ComputeCapacity.Validate(); err != nil {
			invalidParams.AddNested("ComputeCapacity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeCapacity sets the ComputeCapacity field's value.
func (s *CreateFleetInput) SetComputeCapacity(v *ComputeCapacity) *CreateFleetInput {
	s.ComputeCapacity = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFleetInput) SetDescription(v string) *CreateFleetInput {
	s.Description = &v
	return s
}

// SetDisconnectTimeoutInSeconds sets the DisconnectTimeoutInSeconds field's value.
func (s *CreateFleetInput) SetDisconnectTimeoutInSeconds(v int64) *CreateFleetInput {
	s.DisconnectTimeoutInSeconds = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateFleetInput) SetDisplayName(v string) *CreateFleetInput {
	s.DisplayName = &v
	return s
}

// SetDomainJoinInfo sets the DomainJoinInfo field's value.
func (s *CreateFleetInput) SetDomainJoinInfo(v *DomainJoinInfo) *CreateFleetInput {
	s.DomainJoinInfo = v
	return s
}

// SetEnableDefaultInternetAccess sets the EnableDefaultInternetAccess field's value.
func (s *CreateFleetInput) SetEnableDefaultInternetAccess(v bool) *CreateFleetInput {
	s.EnableDefaultInternetAccess = &v
	return s
}

// SetFleetType sets the FleetType field's value.
func (s *CreateFleetInput) SetFleetType(v string) *CreateFleetInput {
	s.FleetType = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CreateFleetInput) SetIamRoleArn(v string) *CreateFleetInput {
	s.IamRoleArn = &v
	return s
}

// SetIdleDisconnectTimeoutInSeconds sets the IdleDisconnectTimeoutInSeconds field's value.
func (s *CreateFleetInput) SetIdleDisconnectTimeoutInSeconds(v int64) *CreateFleetInput {
	s.IdleDisconnectTimeoutInSeconds = &v
	return s
}

// SetImageArn sets the ImageArn field's value.
func (s *CreateFleetInput) SetImageArn(v string) *CreateFleetInput {
	s.ImageArn = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *CreateFleetInput) SetImageName(v string) *CreateFleetInput {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateFleetInput) SetInstanceType(v string) *CreateFleetInput {
	s.InstanceType = &v
	return s
}

// SetMaxUserDurationInSeconds sets the MaxUserDurationInSeconds field's value.
func (s *CreateFleetInput) SetMaxUserDurationInSeconds(v int64) *CreateFleetInput {
	s.MaxUserDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFleetInput) SetName(v string) *CreateFleetInput {
	s.Name = &v
	return s
}

// SetStreamView sets the StreamView field's value.
func (s *CreateFleetInput) SetStreamView(v string) *CreateFleetInput {
	s.StreamView = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFleetInput) SetTags(v map[string]*string) *CreateFleetInput {
	s.Tags = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateFleetInput) SetVpcConfig(v *VpcConfig) *CreateFleetInput {
	s.VpcConfig = v
	return s
}

type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the fleet.
	Fleet *Fleet `type:"structure"`
}

// String returns the string representation
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// SetFleet sets the Fleet field's value.
func (s *CreateFleetOutput) SetFleet(v *Fleet) *CreateFleetOutput {
	s.Fleet = v
	return s
}

type CreateImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The list of interface VPC endpoint (interface endpoint) objects. Administrators
	// can connect to the image builder only through the specified endpoints.
	AccessEndpoints []*AccessEndpoint `min:"1" type:"list"`

	// The version of the AppStream 2.0 agent to use for this image builder. To
	// use the latest version of the AppStream 2.0 agent, specify [LATEST].
	AppstreamAgentVersion *string `min:"1" type:"string"`

	// The description to display.
	Description *string `type:"string"`

	// The image builder name to display.
	DisplayName *string `type:"string"`

	// The name of the directory and organizational unit (OU) to use to join the
	// image builder to a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Enables or disables default internet access for the image builder.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role to apply to the image builder.
	// To assume a role, the image builder calls the AWS Security Token Service
	// (STS) AssumeRole API operation and passes the ARN of the role to use. The
	// operation creates a new session with temporary credentials. AppStream 2.0
	// retrieves the temporary credentials and creates the appstream_machine_role
	// credential profile on the instance.
	//
	// For more information, see Using an IAM Role to Grant Permissions to Applications
	// and Scripts Running on AppStream 2.0 Streaming Instances (https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	IamRoleArn *string `type:"string"`

	// The ARN of the public, private, or shared image to use.
	ImageArn *string `type:"string"`

	// The name of the image used to create the image builder.
	ImageName *string `min:"1" type:"string"`

	// The instance type to use when launching the image builder. The following
	// instance types are available:
	//
	//    * stream.standard.small
	//
	//    * stream.standard.medium
	//
	//    * stream.standard.large
	//
	//    * stream.compute.large
	//
	//    * stream.compute.xlarge
	//
	//    * stream.compute.2xlarge
	//
	//    * stream.compute.4xlarge
	//
	//    * stream.compute.8xlarge
	//
	//    * stream.memory.large
	//
	//    * stream.memory.xlarge
	//
	//    * stream.memory.2xlarge
	//
	//    * stream.memory.4xlarge
	//
	//    * stream.memory.8xlarge
	//
	//    * stream.memory.z1d.large
	//
	//    * stream.memory.z1d.xlarge
	//
	//    * stream.memory.z1d.2xlarge
	//
	//    * stream.memory.z1d.3xlarge
	//
	//    * stream.memory.z1d.6xlarge
	//
	//    * stream.memory.z1d.12xlarge
	//
	//    * stream.graphics-design.large
	//
	//    * stream.graphics-design.xlarge
	//
	//    * stream.graphics-design.2xlarge
	//
	//    * stream.graphics-design.4xlarge
	//
	//    * stream.graphics-desktop.2xlarge
	//
	//    * stream.graphics.g4dn.xlarge
	//
	//    * stream.graphics.g4dn.2xlarge
	//
	//    * stream.graphics.g4dn.4xlarge
	//
	//    * stream.graphics.g4dn.8xlarge
	//
	//    * stream.graphics.g4dn.12xlarge
	//
	//    * stream.graphics.g4dn.16xlarge
	//
	//    * stream.graphics-pro.4xlarge
	//
	//    * stream.graphics-pro.8xlarge
	//
	//    * stream.graphics-pro.16xlarge
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// A unique name for the image builder.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The tags to associate with the image builder. A tag is a key-value pair,
	// and the value is optional. For example, Environment=Test. If you do not specify
	// a value, Environment=.
	//
	// Generally allowed characters are: letters, numbers, and spaces representable
	// in UTF-8, and the following special characters:
	//
	// _ . : / = + \ - @
	//
	// If you do not specify a value, the value is set to an empty string.
	//
	// For more information about tags, see Tagging Your Resources (https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	Tags map[string]*string `min:"1" type:"map"`

	// The VPC configuration for the image builder. You can specify only one subnet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageBuilderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImageBuilderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImageBuilderInput"}
	if s.AccessEndpoints != nil && len(s.AccessEndpoints) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessEndpoints", 1))
	}
	if s.AppstreamAgentVersion != nil && len(*s.AppstreamAgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppstreamAgentVersion", 1))
	}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.AccessEndpoints != nil {
		for i, v := range s.AccessEndpoints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessEndpoints", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessEndpoints sets the AccessEndpoints field's value.
func (s *CreateImageBuilderInput) SetAccessEndpoints(v []*AccessEndpoint) *CreateImageBuilderInput {
	s.AccessEndpoints = v
	return s
}

// SetAppstreamAgentVersion sets the AppstreamAgentVersion field's value.
func (s *CreateImageBuilderInput) SetAppstreamAgentVersion(v string) *CreateImageBuilderInput {
	s.AppstreamAgentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateImageBuilderInput) SetDescription(v string) *CreateImageBuilderInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateImageBuilderInput) SetDisplayName(v string) *CreateImageBuilderInput {
	s.DisplayName = &v
	return s
}

// SetDomainJoinInfo sets the DomainJoinInfo field's value.
func (s *CreateImageBuilderInput) SetDomainJoinInfo(v *DomainJoinInfo) *CreateImageBuilderInput {
	s.DomainJoinInfo = v
	return s
}

// SetEnableDefaultInternetAccess sets the EnableDefaultInternetAccess field's value.
func (s *CreateImageBuilderInput) SetEnableDefaultInternetAccess(v bool) *CreateImageBuilderInput {
	s.EnableDefaultInternetAccess = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CreateImageBuilderInput) SetIamRoleArn(v string) *CreateImageBuilderInput {
	s.IamRoleArn = &v
	return s
}

// SetImageArn sets the ImageArn field's value.
func (s *CreateImageBuilderInput) SetImageArn(v string) *CreateImageBuilderInput {
	s.ImageArn = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *CreateImageBuilderInput) SetImageName(v string) *CreateImageBuilderInput {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateImageBuilderInput) SetInstanceType(v string) *CreateImageBuilderInput {
	s.InstanceType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateImageBuilderInput) SetName(v string) *CreateImageBuilderInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateImageBuilderInput) SetTags(v map[string]*string) *CreateImageBuilderInput {
	s.Tags = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateImageBuilderInput) SetVpcConfig(v *VpcConfig) *CreateImageBuilderInput {
	s.VpcConfig = v
	return s
}

type CreateImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s CreateImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageBuilderOutput) GoString() string {
	return s.String()
}

// SetImageBuilder sets the ImageBuilder field's value.
func (s *CreateImageBuilderOutput) SetImageBuilder(v *ImageBuilder) *CreateImageBuilderOutput {
	s.ImageBuilder = v
	return s
}

type CreateImageBuilderStreamingURLInput struct {
	_ struct{} `type:"structure"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The time that the streaming URL will be valid, in seconds. Specify a value
	// between 1 and 604800 seconds. The default is 3600 seconds.
	Validity *int64 `type:"long"`
}

// String returns the string representation
func (s CreateImageBuilderStreamingURLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageBuilderStreamingURLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImageBuilderStreamingURLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImageBuilderStreamingURLInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateImageBuilderStreamingURLInput) SetName(v string) *CreateImageBuilderStreamingURLInput {
	s.Name = &v
	return s
}

// SetValidity sets the Validity field's value.
func (s *CreateImageBuilderStreamingURLInput) SetValidity(v int64) *CreateImageBuilderStreamingURLInput {
	s.Validity = &v
	return s
}

type CreateImageBuilderStreamingURLOutput struct {
	_ struct{} `type:"structure"`

	// The elapsed time, in seconds after the Unix epoch, when this URL expires.
	Expires *time.Time `type:"timestamp"`

	// The URL to start the AppStream 2.0 streaming session.
	StreamingURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateImageBuilderStreamingURLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageBuilderStreamingURLOutput) GoString() string {
	return s.String()
}

// SetExpires sets the Expires field's value.
func (s *CreateImageBuilderStreamingURLOutput) SetExpires(v time.Time) *CreateImageBuilderStreamingURLOutput {
	s.Expires = &v
	return s
}

// SetStreamingURL sets the StreamingURL field's value.
func (s *CreateImageBuilderStreamingURLOutput) SetStreamingURL(v string) *CreateImageBuilderStreamingURLOutput {
	s.StreamingURL = &v
	return s
}

type CreateStackInput struct {
	_ struct{} `type:"structure"`

	// The list of interface VPC endpoint (interface endpoint) objects. Users of
	// the stack can connect to AppStream 2.0 only through the specified endpoints.
	AccessEndpoints []*AccessEndpoint `min:"1" type:"list"`

	// The persistent application settings for users of a stack. When these settings
	// are enabled, changes that users make to applications and Windows settings
	// are automatically saved after each session and applied to the next session.
	ApplicationSettings *ApplicationSettings `type:"structure"`

	// The description to display.
	Description *string `type:"string"`

	// The stack name to display.
	DisplayName *string `type:"string"`

	// The domains where AppStream 2.0 streaming sessions can be embedded in an
	// iframe. You must approve the domains that you want to host embedded AppStream
	// 2.0 streaming sessions.
	EmbedHostDomains []*string `min:"1" type:"list"`

	// The URL that users are redirected to after they click the Send Feedback link.
	// If no URL is specified, no Send Feedback link is displayed.
	FeedbackURL *string `type:"string"`

	// The name of the stack.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The URL that users are redirected to after their streaming session ends.
	RedirectURL *string `type:"string"`

	// The storage connectors to enable.
	StorageConnectors []*StorageConnector `type:"list"`

	// The tags to associate with the stack. A tag is a key-value pair, and the
	// value is optional. For example, Environment=Test. If you do not specify a
	// value, Environment=.
	//
	// If you do not specify a value, the value is set to an empty string.
	//
	// Generally allowed characters are: letters, numbers, and spaces representable
	// in UTF-8, and the following special characters:
	//
	// _ . : / = + \ - @
	//
	// For more information about tags, see Tagging Your Resources (https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	Tags map[string]*string `min:"1" type:"map"`

	// The actions that are enabled or disabled for users during their streaming
	// sessions. By default, these actions are enabled.
	UserSettings []*UserSetting `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackInput"}
	if s.AccessEndpoints != nil && len(s.AccessEndpoints) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessEndpoints", 1))
	}
	if s.EmbedHostDomains != nil && len(s.EmbedHostDomains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmbedHostDomains", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.UserSettings != nil && len(s.UserSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserSettings", 1))
	}
	if s.AccessEndpoints != nil {
		for i, v := range s.AccessEndpoints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessEndpoints", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ApplicationSettings != nil {
		if err := s.ApplicationSettings.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.StorageConnectors != nil {
		for i, v := range s.StorageConnectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StorageConnectors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserSettings != nil {
		for i, v := range s.UserSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessEndpoints sets the AccessEndpoints field's value.
func (s *CreateStackInput) SetAccessEndpoints(v []*AccessEndpoint) *CreateStackInput {
	s.AccessEndpoints = v
	return s
}

// SetApplicationSettings sets the ApplicationSettings field's value.
func (s *CreateStackInput) SetApplicationSettings(v *ApplicationSettings) *CreateStackInput {
	s.ApplicationSettings = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateStackInput) SetDescription(v string) *CreateStackInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateStackInput) SetDisplayName(v string) *CreateStackInput {
	s.DisplayName = &v
	return s
}

// SetEmbedHostDomains sets the EmbedHostDomains field's value.
func (s *CreateStackInput) SetEmbedHostDomains(v []*string) *CreateStackInput {
	s.EmbedHostDomains = v
	return s
}

// SetFeedbackURL sets the FeedbackURL field's value.
func (s *CreateStackInput) SetFeedbackURL(v string) *CreateStackInput {
	s.FeedbackURL = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStackInput) SetName(v string) *CreateStackInput {
	s.Name = &v
	return s
}

// SetRedirectURL sets the RedirectURL field's value.
func (s *CreateStackInput) SetRedirectURL(v string) *CreateStackInput {
	s.RedirectURL = &v
	return s
}

// SetStorageConnectors sets the StorageConnectors field's value.
func (s *CreateStackInput) SetStorageConnectors(v []*StorageConnector) *CreateStackInput {
	s.StorageConnectors = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStackInput) SetTags(v map[string]*string) *CreateStackInput {
	s.Tags = v
	return s
}

// SetUserSettings sets the UserSettings field's value.
func (s *CreateStackInput) SetUserSettings(v []*UserSetting) *CreateStackInput {
	s.UserSettings = v
	return s
}

type CreateStackOutput struct {
	_ struct{} `type:"structure"`

	// Information about the stack.
	Stack *Stack `type:"structure"`
}

// String returns the string representation
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackOutput) GoString() string {
	return s.String()
}

// SetStack sets the Stack field's value.
func (s *CreateStackOutput) SetStack(v *Stack) *CreateStackOutput {
	s.Stack = v
	return s
}

type CreateStreamingURLInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to launch after the session starts. This is the
	// name that you specified as Name in the Image Assistant. If your fleet is
	// enabled for the Desktop stream view, you can also choose to launch directly
	// to the operating system desktop. To do so, specify Desktop.
	ApplicationId *string `min:"1" type:"string"`

	// The name of the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The session context. For more information, see Session Context (https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters)
	// in the Amazon AppStream 2.0 Administration Guide.
	SessionContext *string `min:"1" type:"string"`

	// The name of the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The identifier of the user.
	//
	// UserId is a required field
	UserId *string `min:"2" type:"string" required:"true"`

	// The time that the streaming URL will be valid, in seconds. Specify a value
	// between 1 and 604800 seconds. The default is 60 seconds.
	Validity *int64 `type:"long"`
}

// String returns the string representation
func (s CreateStreamingURLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingURLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingURLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamingURLInput"}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.SessionContext != nil && len(*s.SessionContext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionContext", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateStreamingURLInput) SetApplicationId(v string) *CreateStreamingURLInput {
	s.ApplicationId = &v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *CreateStreamingURLInput) SetFleetName(v string) *CreateStreamingURLInput {
	s.FleetName = &v
	return s
}

// SetSessionContext sets the SessionContext field's value.
func (s *CreateStreamingURLInput) SetSessionContext(v string) *CreateStreamingURLInput {
	s.SessionContext = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateStreamingURLInput) SetStackName(v string) *CreateStreamingURLInput {
	s.StackName = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateStreamingURLInput) SetUserId(v string) *CreateStreamingURLInput {
	s.UserId = &v
	return s
}

// SetValidity sets the Validity field's value.
func (s *CreateStreamingURLInput) SetValidity(v int64) *CreateStreamingURLInput {
	s.Validity = &v
	return s
}

type CreateStreamingURLOutput struct {
	_ struct{} `type:"structure"`

	// The elapsed time, in seconds after the Unix epoch, when this URL expires.
	Expires *time.Time `type:"timestamp"`

	// The URL to start the AppStream 2.0 streaming session.
	StreamingURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateStreamingURLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingURLOutput) GoString() string {
	return s.String()
}

// SetExpires sets the Expires field's value.
func (s *CreateStreamingURLOutput) SetExpires(v time.Time) *CreateStreamingURLOutput {
	s.Expires = &v
	return s
}

// SetStreamingURL sets the StreamingURL field's value.
func (s *CreateStreamingURLOutput) SetStreamingURL(v string) *CreateStreamingURLOutput {
	s.StreamingURL = &v
	return s
}

type CreateUsageReportSubscriptionInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateUsageReportSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUsageReportSubscriptionInput) GoString() string {
	return s.String()
}

type CreateUsageReportSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket where generated reports are stored.
	//
	// If you enabled on-instance session scripts and Amazon S3 logging for your
	// session script configuration, AppStream 2.0 created an S3 bucket to store
	// the script output. The bucket is unique to your account and Region. When
	// you enable usage reporting in this case, AppStream 2.0 uses the same bucket
	// to store your usage reports. If you haven't already enabled on-instance session
	// scripts, when you enable usage reports, AppStream 2.0 creates a new S3 bucket.
	S3BucketName *string `min:"1" type:"string"`

	// The schedule for generating usage reports.
	Schedule *string `type:"string" enum:"UsageReportSchedule"`
}

// String returns the string representation
func (s CreateUsageReportSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUsageReportSubscriptionOutput) GoString() string {
	return s.String()
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateUsageReportSubscriptionOutput) SetS3BucketName(v string) *CreateUsageReportSubscriptionOutput {
	s.S3BucketName = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateUsageReportSubscriptionOutput) SetSchedule(v string) *CreateUsageReportSubscriptionOutput {
	s.Schedule = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The authentication type for the user. You must specify USERPOOL.
	//
	// AuthenticationType is a required field
	AuthenticationType *string `type:"string" required:"true" enum:"AuthenticationType"`

	// The first name, or given name, of the user.
	FirstName *string `type:"string" sensitive:"true"`

	// The last name, or surname, of the user.
	LastName *string `type:"string" sensitive:"true"`

	// The action to take for the welcome email that is sent to a user after the
	// user is created in the user pool. If you specify SUPPRESS, no email is sent.
	// If you specify RESEND, do not specify the first name or last name of the
	// user. If the value is null, the email is sent.
	//
	// The temporary password in the welcome email is valid for only 7 days. If
	// users don’t set their passwords within 7 days, you must send them a new
	// welcome email.
	MessageAction *string `type:"string" enum:"MessageAction"`

	// The email address of the user.
	//
	// Users' email addresses are case-sensitive. During login, if they specify
	// an email address that doesn't use the same capitalization as the email address
	// specified when their user pool account was created, a "user does not exist"
	// error message displays.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.AuthenticationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationType"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *CreateUserInput) SetAuthenticationType(v string) *CreateUserInput {
	s.AuthenticationType = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *CreateUserInput) SetFirstName(v string) *CreateUserInput {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *CreateUserInput) SetLastName(v string) *CreateUserInput {
	s.LastName = &v
	return s
}

// SetMessageAction sets the MessageAction field's value.
func (s *CreateUserInput) SetMessageAction(v string) *CreateUserInput {
	s.MessageAction = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserInput) SetUserName(v string) *CreateUserInput {
	s.UserName = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

type DeleteDirectoryConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the directory configuration.
	//
	// DirectoryName is a required field
	DirectoryName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectoryConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectoryConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDirectoryConfigInput"}
	if s.DirectoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *DeleteDirectoryConfigInput) SetDirectoryName(v string) *DeleteDirectoryConfigInput {
	s.DirectoryName = &v
	return s
}

type DeleteDirectoryConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDirectoryConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryConfigOutput) GoString() string {
	return s.String()
}

type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteFleetInput) SetName(v string) *DeleteFleetInput {
	s.Name = &v
	return s
}

type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

type DeleteImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImageBuilderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImageBuilderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImageBuilderInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteImageBuilderInput) SetName(v string) *DeleteImageBuilderInput {
	s.Name = &v
	return s
}

type DeleteImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s DeleteImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImageBuilderOutput) GoString() string {
	return s.String()
}

// SetImageBuilder sets the ImageBuilder field's value.
func (s *DeleteImageBuilderOutput) SetImageBuilder(v *ImageBuilder) *DeleteImageBuilderOutput {
	s.ImageBuilder = v
	return s
}

type DeleteImageInput struct {
	_ struct{} `type:"structure"`

	// The name of the image.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImageInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteImageInput) SetName(v string) *DeleteImageInput {
	s.Name = &v
	return s
}

type DeleteImageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image.
	Image *Image `type:"structure"`
}

// String returns the string representation
func (s DeleteImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImageOutput) GoString() string {
	return s.String()
}

// SetImage sets the Image field's value.
func (s *DeleteImageOutput) SetImage(v *Image) *DeleteImageOutput {
	s.Image = v
	return s
}

type DeleteImagePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the private image.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The 12-digit identifier of the AWS account for which to delete image permissions.
	//
	// SharedAccountId is a required field
	SharedAccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteImagePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImagePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImagePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImagePermissionsInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SharedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteImagePermissionsInput) SetName(v string) *DeleteImagePermissionsInput {
	s.Name = &v
	return s
}

// SetSharedAccountId sets the SharedAccountId field's value.
func (s *DeleteImagePermissionsInput) SetSharedAccountId(v string) *DeleteImagePermissionsInput {
	s.SharedAccountId = &v
	return s
}

type DeleteImagePermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteImagePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImagePermissionsOutput) GoString() string {
	return s.String()
}

type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// The name of the stack.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteStackInput) SetName(v string) *DeleteStackInput {
	s.Name = &v
	return s
}

type DeleteStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

type DeleteUsageReportSubscriptionInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUsageReportSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUsageReportSubscriptionInput) GoString() string {
	return s.String()
}

type DeleteUsageReportSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUsageReportSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUsageReportSubscriptionOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The authentication type for the user. You must specify USERPOOL.
	//
	// AuthenticationType is a required field
	AuthenticationType *string `type:"string" required:"true" enum:"AuthenticationType"`

	// The email address of the user.
	//
	// Users' email addresses are case-sensitive.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.AuthenticationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationType"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *DeleteUserInput) SetAuthenticationType(v string) *DeleteUserInput {
	s.AuthenticationType = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteUserInput) SetUserName(v string) *DeleteUserInput {
	s.UserName = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DescribeDirectoryConfigsInput struct {
	_ struct{} `type:"structure"`

	// The directory names.
	DirectoryNames []*string `type:"list"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDirectoryConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectoryConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDirectoryConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDirectoryConfigsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryNames sets the DirectoryNames field's value.
func (s *DescribeDirectoryConfigsInput) SetDirectoryNames(v []*string) *DescribeDirectoryConfigsInput {
	s.DirectoryNames = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDirectoryConfigsInput) SetMaxResults(v int64) *DescribeDirectoryConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectoryConfigsInput) SetNextToken(v string) *DescribeDirectoryConfigsInput {
	s.NextToken = &v
	return s
}

type DescribeDirectoryConfigsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the directory configurations. Note that although the response
	// syntax in this topic includes the account password, this password is not
	// returned in the actual response.
	DirectoryConfigs []*DirectoryConfig `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDirectoryConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectoryConfigsOutput) GoString() string {
	return s.String()
}

// SetDirectoryConfigs sets the DirectoryConfigs field's value.
func (s *DescribeDirectoryConfigsOutput) SetDirectoryConfigs(v []*DirectoryConfig) *DescribeDirectoryConfigsOutput {
	s.DirectoryConfigs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectoryConfigsOutput) SetNextToken(v string) *DescribeDirectoryConfigsOutput {
	s.NextToken = &v
	return s
}

type DescribeFleetsInput struct {
	_ struct{} `type:"structure"`

	// The names of the fleets to describe.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *DescribeFleetsInput) SetNames(v []*string) *DescribeFleetsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetsInput) SetNextToken(v string) *DescribeFleetsInput {
	s.NextToken = &v
	return s
}

type DescribeFleetsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the fleets.
	Fleets []*Fleet `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetsOutput) GoString() string {
	return s.String()
}

// SetFleets sets the Fleets field's value.
func (s *DescribeFleetsOutput) SetFleets(v []*Fleet) *DescribeFleetsOutput {
	s.Fleets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetsOutput) SetNextToken(v string) *DescribeFleetsOutput {
	s.NextToken = &v
	return s
}

type DescribeImageBuildersInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The names of the image builders to describe.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeImageBuildersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImageBuildersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImageBuildersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImageBuildersInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeImageBuildersInput) SetMaxResults(v int64) *DescribeImageBuildersInput {
	s.MaxResults = &v
	return s
}

// SetNames sets the Names field's value.
func (s *DescribeImageBuildersInput) SetNames(v []*string) *DescribeImageBuildersInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImageBuildersInput) SetNextToken(v string) *DescribeImageBuildersInput {
	s.NextToken = &v
	return s
}

type DescribeImageBuildersOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builders.
	ImageBuilders []*ImageBuilder `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeImageBuildersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImageBuildersOutput) GoString() string {
	return s.String()
}

// SetImageBuilders sets the ImageBuilders field's value.
func (s *DescribeImageBuildersOutput) SetImageBuilders(v []*ImageBuilder) *DescribeImageBuildersOutput {
	s.ImageBuilders = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImageBuildersOutput) SetNextToken(v string) *DescribeImageBuildersOutput {
	s.NextToken = &v
	return s
}

type DescribeImagePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The name of the private image for which to describe permissions. The image
	// must be one that you own.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The 12-digit identifier of one or more AWS accounts with which the image
	// is shared.
	SharedAwsAccountIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeImagePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImagePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImagePermissionsInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SharedAwsAccountIds != nil && len(s.SharedAwsAccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SharedAwsAccountIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeImagePermissionsInput) SetMaxResults(v int64) *DescribeImagePermissionsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeImagePermissionsInput) SetName(v string) *DescribeImagePermissionsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImagePermissionsInput) SetNextToken(v string) *DescribeImagePermissionsInput {
	s.NextToken = &v
	return s
}

// SetSharedAwsAccountIds sets the SharedAwsAccountIds field's value.
func (s *DescribeImagePermissionsInput) SetSharedAwsAccountIds(v []*string) *DescribeImagePermissionsInput {
	s.SharedAwsAccountIds = v
	return s
}

type DescribeImagePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The name of the private image.
	Name *string `type:"string"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// The permissions for a private image that you own.
	SharedImagePermissionsList []*SharedImagePermissions `type:"list"`
}

// String returns the string representation
func (s DescribeImagePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagePermissionsOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DescribeImagePermissionsOutput) SetName(v string) *DescribeImagePermissionsOutput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImagePermissionsOutput) SetNextToken(v string) *DescribeImagePermissionsOutput {
	s.NextToken = &v
	return s
}

// SetSharedImagePermissionsList sets the SharedImagePermissionsList field's value.
func (s *DescribeImagePermissionsOutput) SetSharedImagePermissionsList(v []*SharedImagePermissions) *DescribeImagePermissionsOutput {
	s.SharedImagePermissionsList = v
	return s
}

type DescribeImagesInput struct {
	_ struct{} `type:"structure"`

	// The ARNs of the public, private, and shared images to describe.
	Arns []*string `type:"list"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The names of the public or private images to describe.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The type of image (public, private, or shared) to describe.
	Type *string `type:"string" enum:"VisibilityType"`
}

// String returns the string representation
func (s DescribeImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImagesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArns sets the Arns field's value.
func (s *DescribeImagesInput) SetArns(v []*string) *DescribeImagesInput {
	s.Arns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeImagesInput) SetMaxResults(v int64) *DescribeImagesInput {
	s.MaxResults = &v
	return s
}

// SetNames sets the Names field's value.
func (s *DescribeImagesInput) SetNames(v []*string) *DescribeImagesInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImagesInput) SetNextToken(v string) *DescribeImagesInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeImagesInput) SetType(v string) *DescribeImagesInput {
	s.Type = &v
	return s
}

type DescribeImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the images.
	Images []*Image `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesOutput) GoString() string {
	return s.String()
}

// SetImages sets the Images field's value.
func (s *DescribeImagesOutput) SetImages(v []*Image) *DescribeImagesOutput {
	s.Images = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImagesOutput) SetNextToken(v string) *DescribeImagesOutput {
	s.NextToken = &v
	return s
}

type DescribeSessionsInput struct {
	_ struct{} `type:"structure"`

	// The authentication method. Specify API for a user authenticated using a streaming
	// URL or SAML for a SAML federated user. The default is to authenticate users
	// using a streaming URL.
	AuthenticationType *string `type:"string" enum:"AuthenticationType"`

	// The name of the fleet. This value is case-sensitive.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The size of each page of results. The default value is 20 and the maximum
	// value is 50.
	Limit *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack. This value is case-sensitive.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The user identifier (ID). If you specify a user ID, you must also specify
	// the authentication type.
	UserId *string `min:"2" type:"string"`
}

// String returns the string representation
func (s DescribeSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSessionsInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *DescribeSessionsInput) SetAuthenticationType(v string) *DescribeSessionsInput {
	s.AuthenticationType = &v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *DescribeSessionsInput) SetFleetName(v string) *DescribeSessionsInput {
	s.FleetName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeSessionsInput) SetLimit(v int64) *DescribeSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSessionsInput) SetNextToken(v string) *DescribeSessionsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeSessionsInput) SetStackName(v string) *DescribeSessionsInput {
	s.StackName = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeSessionsInput) SetUserId(v string) *DescribeSessionsInput {
	s.UserId = &v
	return s
}

type DescribeSessionsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// Information about the streaming sessions.
	Sessions []*Session `type:"list"`
}

// String returns the string representation
func (s DescribeSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSessionsOutput) SetNextToken(v string) *DescribeSessionsOutput {
	s.NextToken = &v
	return s
}

// SetSessions sets the Sessions field's value.
func (s *DescribeSessionsOutput) SetSessions(v []*Session) *DescribeSessionsOutput {
	s.Sessions = v
	return s
}

type DescribeStacksInput struct {
	_ struct{} `type:"structure"`

	// The names of the stacks to describe.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *DescribeStacksInput) SetNames(v []*string) *DescribeStacksInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksInput) SetNextToken(v string) *DescribeStacksInput {
	s.NextToken = &v
	return s
}

type DescribeStacksOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// Information about the stacks.
	Stacks []*Stack `type:"list"`
}

// String returns the string representation
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksOutput) SetNextToken(v string) *DescribeStacksOutput {
	s.NextToken = &v
	return s
}

// SetStacks sets the Stacks field's value.
func (s *DescribeStacksOutput) SetStacks(v []*Stack) *DescribeStacksOutput {
	s.Stacks = v
	return s
}

type DescribeUsageReportSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeUsageReportSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUsageReportSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUsageReportSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUsageReportSubscriptionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeUsageReportSubscriptionsInput) SetMaxResults(v int64) *DescribeUsageReportSubscriptionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeUsageReportSubscriptionsInput) SetNextToken(v string) *DescribeUsageReportSubscriptionsInput {
	s.NextToken = &v
	return s
}

type DescribeUsageReportSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// Information about the usage report subscription.
	UsageReportSubscriptions []*UsageReportSubscription `type:"list"`
}

// String returns the string representation
func (s DescribeUsageReportSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUsageReportSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeUsageReportSubscriptionsOutput) SetNextToken(v string) *DescribeUsageReportSubscriptionsOutput {
	s.NextToken = &v
	return s
}

// SetUsageReportSubscriptions sets the UsageReportSubscriptions field's value.
func (s *DescribeUsageReportSubscriptionsOutput) SetUsageReportSubscriptions(v []*UsageReportSubscription) *DescribeUsageReportSubscriptionsOutput {
	s.UsageReportSubscriptions = v
	return s
}

type DescribeUserStackAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The authentication type for the user who is associated with the stack. You
	// must specify USERPOOL.
	AuthenticationType *string `type:"string" enum:"AuthenticationType"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack that is associated with the user.
	StackName *string `min:"1" type:"string"`

	// The email address of the user who is associated with the stack.
	//
	// Users' email addresses are case-sensitive.
	UserName *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s DescribeUserStackAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserStackAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserStackAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserStackAssociationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *DescribeUserStackAssociationsInput) SetAuthenticationType(v string) *DescribeUserStackAssociationsInput {
	s.AuthenticationType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeUserStackAssociationsInput) SetMaxResults(v int64) *DescribeUserStackAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeUserStackAssociationsInput) SetNextToken(v string) *DescribeUserStackAssociationsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeUserStackAssociationsInput) SetStackName(v string) *DescribeUserStackAssociationsInput {
	s.StackName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeUserStackAssociationsInput) SetUserName(v string) *DescribeUserStackAssociationsInput {
	s.UserName = &v
	return s
}

type DescribeUserStackAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// The UserStackAssociation objects.
	UserStackAssociations []*UserStackAssociation `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeUserStackAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserStackAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeUserStackAssociationsOutput) SetNextToken(v string) *DescribeUserStackAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetUserStackAssociations sets the UserStackAssociations field's value.
func (s *DescribeUserStackAssociationsOutput) SetUserStackAssociations(v []*UserStackAssociation) *DescribeUserStackAssociationsOutput {
	s.UserStackAssociations = v
	return s
}

type DescribeUsersInput struct {
	_ struct{} `type:"structure"`

	// The authentication type for the users in the user pool to describe. You must
	// specify USERPOOL.
	//
	// AuthenticationType is a required field
	AuthenticationType *string `type:"string" required:"true" enum:"AuthenticationType"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUsersInput"}
	if s.AuthenticationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationType"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *DescribeUsersInput) SetAuthenticationType(v string) *DescribeUsersInput {
	s.AuthenticationType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeUsersInput) SetMaxResults(v int64) *DescribeUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeUsersInput) SetNextToken(v string) *DescribeUsersInput {
	s.NextToken = &v
	return s
}

type DescribeUsersOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// Information about users in the user pool.
	Users []*User `type:"list"`
}

// String returns the string representation
func (s DescribeUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeUsersOutput) SetNextToken(v string) *DescribeUsersOutput {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *DescribeUsersOutput) SetUsers(v []*User) *DescribeUsersOutput {
	s.Users = v
	return s
}

// Describes the configuration information required to join fleets and image
// builders to Microsoft Active Directory domains.
type DirectoryConfig struct {
	_ struct{} `type:"structure"`

	// The time the directory configuration was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The fully qualified name of the directory (for example, corp.example.com).
	//
	// DirectoryName is a required field
	DirectoryName *string `type:"string" required:"true"`

	// The distinguished names of the organizational units for computer accounts.
	OrganizationalUnitDistinguishedNames []*string `type:"list"`

	// The credentials for the service account used by the fleet or image builder
	// to connect to the directory.
	ServiceAccountCredentials *ServiceAccountCredentials `type:"structure"`
}

// String returns the string representation
func (s DirectoryConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryConfig) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DirectoryConfig) SetCreatedTime(v time.Time) *DirectoryConfig {
	s.CreatedTime = &v
	return s
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *DirectoryConfig) SetDirectoryName(v string) *DirectoryConfig {
	s.DirectoryName = &v
	return s
}

// SetOrganizationalUnitDistinguishedNames sets the OrganizationalUnitDistinguishedNames field's value.
func (s *DirectoryConfig) SetOrganizationalUnitDistinguishedNames(v []*string) *DirectoryConfig {
	s.OrganizationalUnitDistinguishedNames = v
	return s
}

// SetServiceAccountCredentials sets the ServiceAccountCredentials field's value.
func (s *DirectoryConfig) SetServiceAccountCredentials(v *ServiceAccountCredentials) *DirectoryConfig {
	s.ServiceAccountCredentials = v
	return s
}

type DisableUserInput struct {
	_ struct{} `type:"structure"`

	// The authentication type for the user. You must specify USERPOOL.
	//
	// AuthenticationType is a required field
	AuthenticationType *string `type:"string" required:"true" enum:"AuthenticationType"`

	// The email address of the user.
	//
	// Users' email addresses are case-sensitive.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s DisableUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableUserInput"}
	if s.AuthenticationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationType"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *DisableUserInput) SetAuthenticationType(v string) *DisableUserInput {
	s.AuthenticationType = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DisableUserInput) SetUserName(v string) *DisableUserInput {
	s.UserName = &v
	return s
}

type DisableUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableUserOutput) GoString() string {
	return s.String()
}

type DisassociateFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The name of the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateFleetInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetName sets the FleetName field's value.
func (s *DisassociateFleetInput) SetFleetName(v string) *DisassociateFleetInput {
	s.FleetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DisassociateFleetInput) SetStackName(v string) *DisassociateFleetInput {
	s.StackName = &v
	return s
}

type DisassociateFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFleetOutput) GoString() string {
	return s.String()
}

// Describes the configuration information required to join fleets and image
// builders to Microsoft Active Directory domains.
type DomainJoinInfo struct {
	_ struct{} `type:"structure"`

	// The fully qualified name of the directory (for example, corp.example.com).
	DirectoryName *string `type:"string"`

	// The distinguished name of the organizational unit for computer accounts.
	OrganizationalUnitDistinguishedName *string `type:"string"`
}

// String returns the string representation
func (s DomainJoinInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainJoinInfo) GoString() string {
	return s.String()
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *DomainJoinInfo) SetDirectoryName(v string) *DomainJoinInfo {
	s.DirectoryName = &v
	return s
}

// SetOrganizationalUnitDistinguishedName sets the OrganizationalUnitDistinguishedName field's value.
func (s *DomainJoinInfo) SetOrganizationalUnitDistinguishedName(v string) *DomainJoinInfo {
	s.OrganizationalUnitDistinguishedName = &v
	return s
}

type EnableUserInput struct {
	_ struct{} `type:"structure"`

	// The authentication type for the user. You must specify USERPOOL.
	//
	// AuthenticationType is a required field
	AuthenticationType *string `type:"string" required:"true" enum:"AuthenticationType"`

	// The email address of the user.
	//
	// Users' email addresses are case-sensitive. During login, if they specify
	// an email address that doesn't use the same capitalization as the email address
	// specified when their user pool account was created, a "user does not exist"
	// error message displays.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s EnableUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableUserInput"}
	if s.AuthenticationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationType"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *EnableUserInput) SetAuthenticationType(v string) *EnableUserInput {
	s.AuthenticationType = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *EnableUserInput) SetUserName(v string) *EnableUserInput {
	s.UserName = &v
	return s
}

type EnableUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableUserOutput) GoString() string {
	return s.String()
}

type ExpireSessionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the streaming session.
	//
	// SessionId is a required field
	SessionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExpireSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpireSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExpireSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExpireSessionInput"}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSessionId sets the SessionId field's value.
func (s *ExpireSessionInput) SetSessionId(v string) *ExpireSessionInput {
	s.SessionId = &v
	return s
}

type ExpireSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExpireSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpireSessionOutput) GoString() string {
	return s.String()
}

// Describes a fleet.
type Fleet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the fleet.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The capacity status for the fleet.
	//
	// ComputeCapacityStatus is a required field
	ComputeCapacityStatus *ComputeCapacityStatus `type:"structure" required:"true"`

	// The time the fleet was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The description to display.
	Description *string `min:"1" type:"string"`

	// The amount of time that a streaming session remains active after users disconnect.
	// If they try to reconnect to the streaming session after a disconnection or
	// network interruption within this time interval, they are connected to their
	// previous session. Otherwise, they are connected to a new session with a new
	// streaming instance.
	//
	// Specify a value between 60 and 360000.
	DisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The fleet name to display.
	DisplayName *string `min:"1" type:"string"`

	// The name of the directory and organizational unit (OU) to use to join the
	// fleet to a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Indicates whether default internet access is enabled for the fleet.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The fleet errors.
	FleetErrors []*FleetError `type:"list"`

	// The fleet type.
	//
	// ALWAYS_ON
	//
	// Provides users with instant-on access to their apps. You are charged for
	// all running instances in your fleet, even if no users are streaming apps.
	//
	// ON_DEMAND
	//
	// Provide users with access to applications after they connect, which takes
	// one to two minutes. You are charged for instance streaming when users are
	// connected and a small hourly fee for instances that are not streaming apps.
	FleetType *string `type:"string" enum:"FleetType"`

	// The ARN of the IAM role that is applied to the fleet. To assume a role, the
	// fleet instance calls the AWS Security Token Service (STS) AssumeRole API
	// operation and passes the ARN of the role to use. The operation creates a
	// new session with temporary credentials. AppStream 2.0 retrieves the temporary
	// credentials and creates the appstream_machine_role credential profile on
	// the instance.
	//
	// For more information, see Using an IAM Role to Grant Permissions to Applications
	// and Scripts Running on AppStream 2.0 Streaming Instances (https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	IamRoleArn *string `type:"string"`

	// The amount of time that users can be idle (inactive) before they are disconnected
	// from their streaming session and the DisconnectTimeoutInSeconds time interval
	// begins. Users are notified before they are disconnected due to inactivity.
	// If users try to reconnect to the streaming session before the time interval
	// specified in DisconnectTimeoutInSeconds elapses, they are connected to their
	// previous session. Users are considered idle when they stop providing keyboard
	// or mouse input during their streaming session. File uploads and downloads,
	// audio in, audio out, and pixels changing do not qualify as user activity.
	// If users continue to be idle after the time interval in IdleDisconnectTimeoutInSeconds
	// elapses, they are disconnected.
	//
	// To prevent users from being disconnected due to inactivity, specify a value
	// of 0. Otherwise, specify a value between 60 and 3600. The default value is
	// 0.
	//
	// If you enable this feature, we recommend that you specify a value that corresponds
	// exactly to a whole number of minutes (for example, 60, 120, and 180). If
	// you don't do this, the value is rounded to the nearest minute. For example,
	// if you specify a value of 70, users are disconnected after 1 minute of inactivity.
	// If you specify a value that is at the midpoint between two different minutes,
	// the value is rounded up. For example, if you specify a value of 90, users
	// are disconnected after 2 minutes of inactivity.
	IdleDisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The ARN for the public, private, or shared image.
	ImageArn *string `type:"string"`

	// The name of the image used to create the fleet.
	ImageName *string `min:"1" type:"string"`

	// The instance type to use when launching fleet instances. The following instance
	// types are available:
	//
	//    * stream.standard.small
	//
	//    * stream.standard.medium
	//
	//    * stream.standard.large
	//
	//    * stream.compute.large
	//
	//    * stream.compute.xlarge
	//
	//    * stream.compute.2xlarge
	//
	//    * stream.compute.4xlarge
	//
	//    * stream.compute.8xlarge
	//
	//    * stream.memory.large
	//
	//    * stream.memory.xlarge
	//
	//    * stream.memory.2xlarge
	//
	//    * stream.memory.4xlarge
	//
	//    * stream.memory.8xlarge
	//
	//    * stream.memory.z1d.large
	//
	//    * stream.memory.z1d.xlarge
	//
	//    * stream.memory.z1d.2xlarge
	//
	//    * stream.memory.z1d.3xlarge
	//
	//    * stream.memory.z1d.6xlarge
	//
	//    * stream.memory.z1d.12xlarge
	//
	//    * stream.graphics-design.large
	//
	//    * stream.graphics-design.xlarge
	//
	//    * stream.graphics-design.2xlarge
	//
	//    * stream.graphics-design.4xlarge
	//
	//    * stream.graphics-desktop.2xlarge
	//
	//    * stream.graphics.g4dn.xlarge
	//
	//    * stream.graphics.g4dn.2xlarge
	//
	//    * stream.graphics.g4dn.4xlarge
	//
	//    * stream.graphics.g4dn.8xlarge
	//
	//    * stream.graphics.g4dn.12xlarge
	//
	//    * stream.graphics.g4dn.16xlarge
	//
	//    * stream.graphics-pro.4xlarge
	//
	//    * stream.graphics-pro.8xlarge
	//
	//    * stream.graphics-pro.16xlarge
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The maximum amount of time that a streaming session can remain active, in
	// seconds. If users are still connected to a streaming instance five minutes
	// before this limit is reached, they are prompted to save any open documents
	// before being disconnected. After this time elapses, the instance is terminated
	// and replaced by a new instance.
	//
	// Specify a value between 600 and 360000.
	MaxUserDurationInSeconds *int64 `type:"integer"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The current state for the fleet.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"FleetState"`

	// The AppStream 2.0 view that is displayed to your users when they stream from
	// the fleet. When APP is specified, only the windows of applications opened
	// by users display. When DESKTOP is specified, the standard desktop that is
	// provided by the operating system displays.
	//
	// The default value is APP.
	StreamView *string `type:"string" enum:"StreamView"`

	// The VPC configuration for the fleet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s Fleet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Fleet) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Fleet) SetArn(v string) *Fleet {
	s.Arn = &v
	return s
}

// SetComputeCapacityStatus sets the ComputeCapacityStatus field's value.
func (s *Fleet) SetComputeCapacityStatus(v *ComputeCapacityStatus) *Fleet {
	s.ComputeCapacityStatus = v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Fleet) SetCreatedTime(v time.Time) *Fleet {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Fleet) SetDescription(v string) *Fleet {
	s.Description = &v
	return s
}

// SetDisconnectTimeoutInSeconds sets the DisconnectTimeoutInSeconds field's value.
func (s *Fleet) SetDisconnectTimeoutInSeconds(v int64) *Fleet {
	s.DisconnectTimeoutInSeconds = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Fleet) SetDisplayName(v string) *Fleet {
	s.DisplayName = &v
	return s
}

// SetDomainJoinInfo sets the DomainJoinInfo field's value.
func (s *Fleet) SetDomainJoinInfo(v *DomainJoinInfo) *Fleet {
	s.DomainJoinInfo = v
	return s
}

// SetEnableDefaultInternetAccess sets the EnableDefaultInternetAccess field's value.
func (s *Fleet) SetEnableDefaultInternetAccess(v bool) *Fleet {
	s.EnableDefaultInternetAccess = &v
	return s
}

// SetFleetErrors sets the FleetErrors field's value.
func (s *Fleet) SetFleetErrors(v []*FleetError) *Fleet {
	s.FleetErrors = v
	return s
}

// SetFleetType sets the FleetType field's value.
func (s *Fleet) SetFleetType(v string) *Fleet {
	s.FleetType = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *Fleet) SetIamRoleArn(v string) *Fleet {
	s.IamRoleArn = &v
	return s
}

// SetIdleDisconnectTimeoutInSeconds sets the IdleDisconnectTimeoutInSeconds field's value.
func (s *Fleet) SetIdleDisconnectTimeoutInSeconds(v int64) *Fleet {
	s.IdleDisconnectTimeoutInSeconds = &v
	return s
}

// SetImageArn sets the ImageArn field's value.
func (s *Fleet) SetImageArn(v string) *Fleet {
	s.ImageArn = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *Fleet) SetImageName(v string) *Fleet {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Fleet) SetInstanceType(v string) *Fleet {
	s.InstanceType = &v
	return s
}

// SetMaxUserDurationInSeconds sets the MaxUserDurationInSeconds field's value.
func (s *Fleet) SetMaxUserDurationInSeconds(v int64) *Fleet {
	s.MaxUserDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *Fleet) SetName(v string) *Fleet {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Fleet) SetState(v string) *Fleet {
	s.State = &v
	return s
}

// SetStreamView sets the StreamView field's value.
func (s *Fleet) SetStreamView(v string) *Fleet {
	s.StreamView = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *Fleet) SetVpcConfig(v *VpcConfig) *Fleet {
	s.VpcConfig = v
	return s
}

// Describes a fleet error.
type FleetError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"FleetErrorCode"`

	// The error message.
	ErrorMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FleetError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FleetError) SetErrorCode(v string) *FleetError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FleetError) SetErrorMessage(v string) *FleetError {
	s.ErrorMessage = &v
	return s
}

// Describes an image.
type Image struct {
	_ struct{} `type:"structure"`

	// The applications associated with the image.
	Applications []*Application `type:"list"`

	// The version of the AppStream 2.0 agent to use for instances that are launched
	// from this image.
	AppstreamAgentVersion *string `min:"1" type:"string"`

	// The ARN of the image.
	Arn *string `type:"string"`

	// The ARN of the image from which this image was created.
	BaseImageArn *string `type:"string"`

	// The time the image was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The description to display.
	Description *string `min:"1" type:"string"`

	// The image name to display.
	DisplayName *string `min:"1" type:"string"`

	// The name of the image builder that was used to create the private image.
	// If the image is shared, this value is null.
	ImageBuilderName *string `min:"1" type:"string"`

	// Indicates whether an image builder can be launched from this image.
	ImageBuilderSupported *bool `type:"boolean"`

	// The permissions to provide to the destination AWS account for the specified
	// image.
	ImagePermissions *ImagePermissions `type:"structure"`

	// The name of the image.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The operating system platform of the image.
	Platform *string `type:"string" enum:"PlatformType"`

	// The release date of the public base image. For private images, this date
	// is the release date of the base image from which the image was created.
	PublicBaseImageReleasedDate *time.Time `type:"timestamp"`

	// The image starts in the PENDING state. If image creation succeeds, the state
	// is AVAILABLE. If image creation fails, the state is FAILED.
	State *string `type:"string" enum:"ImageState"`

	// The reason why the last state change occurred.
	StateChangeReason *ImageStateChangeReason `type:"structure"`

	// Indicates whether the image is public or private.
	Visibility *string `type:"string" enum:"VisibilityType"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Image) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *Image) SetApplications(v []*Application) *Image {
	s.Applications = v
	return s
}

// SetAppstreamAgentVersion sets the AppstreamAgentVersion field's value.
func (s *Image) SetAppstreamAgentVersion(v string) *Image {
	s.AppstreamAgentVersion = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Image) SetArn(v string) *Image {
	s.Arn = &v
	return s
}

// SetBaseImageArn sets the BaseImageArn field's value.
func (s *Image) SetBaseImageArn(v string) *Image {
	s.BaseImageArn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Image) SetCreatedTime(v time.Time) *Image {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Image) SetDescription(v string) *Image {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Image) SetDisplayName(v string) *Image {
	s.DisplayName = &v
	return s
}

// SetImageBuilderName sets the ImageBuilderName field's value.
func (s *Image) SetImageBuilderName(v string) *Image {
	s.ImageBuilderName = &v
	return s
}

// SetImageBuilderSupported sets the ImageBuilderSupported field's value.
func (s *Image) SetImageBuilderSupported(v bool) *Image {
	s.ImageBuilderSupported = &v
	return s
}

// SetImagePermissions sets the ImagePermissions field's value.
func (s *Image) SetImagePermissions(v *ImagePermissions) *Image {
	s.ImagePermissions = v
	return s
}

// SetName sets the Name field's value.
func (s *Image) SetName(v string) *Image {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Image) SetPlatform(v string) *Image {
	s.Platform = &v
	return s
}

// SetPublicBaseImageReleasedDate sets the PublicBaseImageReleasedDate field's value.
func (s *Image) SetPublicBaseImageReleasedDate(v time.Time) *Image {
	s.PublicBaseImageReleasedDate = &v
	return s
}

// SetState sets the State field's value.
func (s *Image) SetState(v string) *Image {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *Image) SetStateChangeReason(v *ImageStateChangeReason) *Image {
	s.StateChangeReason = v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *Image) SetVisibility(v string) *Image {
	s.Visibility = &v
	return s
}

// Describes a virtual machine that is used to create an image.
type ImageBuilder struct {
	_ struct{} `type:"structure"`

	// The list of virtual private cloud (VPC) interface endpoint objects. Administrators
	// can connect to the image builder only through the specified endpoints.
	AccessEndpoints []*AccessEndpoint `min:"1" type:"list"`

	// The version of the AppStream 2.0 agent that is currently being used by the
	// image builder.
	AppstreamAgentVersion *string `min:"1" type:"string"`

	// The ARN for the image builder.
	Arn *string `type:"string"`

	// The time stamp when the image builder was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The description to display.
	Description *string `min:"1" type:"string"`

	// The image builder name to display.
	DisplayName *string `min:"1" type:"string"`

	// The name of the directory and organizational unit (OU) to use to join the
	// image builder to a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Enables or disables default internet access for the image builder.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The ARN of the IAM role that is applied to the image builder. To assume a
	// role, the image builder calls the AWS Security Token Service (STS) AssumeRole
	// API operation and passes the ARN of the role to use. The operation creates
	// a new session with temporary credentials. AppStream 2.0 retrieves the temporary
	// credentials and creates the appstream_machine_role credential profile on
	// the instance.
	//
	// For more information, see Using an IAM Role to Grant Permissions to Applications
	// and Scripts Running on AppStream 2.0 Streaming Instances (https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	IamRoleArn *string `type:"string"`

	// The ARN of the image from which this builder was created.
	ImageArn *string `type:"string"`

	// The image builder errors.
	ImageBuilderErrors []*ResourceError `type:"list"`

	// The instance type for the image builder. The following instance types are
	// available:
	//
	//    * stream.standard.small
	//
	//    * stream.standard.medium
	//
	//    * stream.standard.large
	//
	//    * stream.compute.large
	//
	//    * stream.compute.xlarge
	//
	//    * stream.compute.2xlarge
	//
	//    * stream.compute.4xlarge
	//
	//    * stream.compute.8xlarge
	//
	//    * stream.memory.large
	//
	//    * stream.memory.xlarge
	//
	//    * stream.memory.2xlarge
	//
	//    * stream.memory.4xlarge
	//
	//    * stream.memory.8xlarge
	//
	//    * stream.memory.z1d.large
	//
	//    * stream.memory.z1d.xlarge
	//
	//    * stream.memory.z1d.2xlarge
	//
	//    * stream.memory.z1d.3xlarge
	//
	//    * stream.memory.z1d.6xlarge
	//
	//    * stream.memory.z1d.12xlarge
	//
	//    * stream.graphics-design.large
	//
	//    * stream.graphics-design.xlarge
	//
	//    * stream.graphics-design.2xlarge
	//
	//    * stream.graphics-design.4xlarge
	//
	//    * stream.graphics-desktop.2xlarge
	//
	//    * stream.graphics.g4dn.xlarge
	//
	//    * stream.graphics.g4dn.2xlarge
	//
	//    * stream.graphics.g4dn.4xlarge
	//
	//    * stream.graphics.g4dn.8xlarge
	//
	//    * stream.graphics.g4dn.12xlarge
	//
	//    * stream.graphics.g4dn.16xlarge
	//
	//    * stream.graphics-pro.4xlarge
	//
	//    * stream.graphics-pro.8xlarge
	//
	//    * stream.graphics-pro.16xlarge
	InstanceType *string `min:"1" type:"string"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Describes the network details of the fleet or image builder instance.
	NetworkAccessConfiguration *NetworkAccessConfiguration `type:"structure"`

	// The operating system platform of the image builder.
	Platform *string `type:"string" enum:"PlatformType"`

	// The state of the image builder.
	State *string `type:"string" enum:"ImageBuilderState"`

	// The reason why the last state change occurred.
	StateChangeReason *ImageBuilderStateChangeReason `type:"structure"`

	// The VPC configuration of the image builder.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s ImageBuilder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageBuilder) GoString() string {
	return s.String()
}

// SetAccessEndpoints sets the AccessEndpoints field's value.
func (s *ImageBuilder) SetAccessEndpoints(v []*AccessEndpoint) *ImageBuilder {
	s.AccessEndpoints = v
	return s
}

// SetAppstreamAgentVersion sets the AppstreamAgentVersion field's value.
func (s *ImageBuilder) SetAppstreamAgentVersion(v string) *ImageBuilder {
	s.AppstreamAgentVersion = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ImageBuilder) SetArn(v string) *ImageBuilder {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ImageBuilder) SetCreatedTime(v time.Time) *ImageBuilder {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ImageBuilder) SetDescription(v string) *ImageBuilder {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ImageBuilder) SetDisplayName(v string) *ImageBuilder {
	s.DisplayName = &v
	return s
}

// SetDomainJoinInfo sets the DomainJoinInfo field's value.
func (s *ImageBuilder) SetDomainJoinInfo(v *DomainJoinInfo) *ImageBuilder {
	s.DomainJoinInfo = v
	return s
}

// SetEnableDefaultInternetAccess sets the EnableDefaultInternetAccess field's value.
func (s *ImageBuilder) SetEnableDefaultInternetAccess(v bool) *ImageBuilder {
	s.EnableDefaultInternetAccess = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *ImageBuilder) SetIamRoleArn(v string) *ImageBuilder {
	s.IamRoleArn = &v
	return s
}

// SetImageArn sets the ImageArn field's value.
func (s *ImageBuilder) SetImageArn(v string) *ImageBuilder {
	s.ImageArn = &v
	return s
}

// SetImageBuilderErrors sets the ImageBuilderErrors field's value.
func (s *ImageBuilder) SetImageBuilderErrors(v []*ResourceError) *ImageBuilder {
	s.ImageBuilderErrors = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ImageBuilder) SetInstanceType(v string) *ImageBuilder {
	s.InstanceType = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImageBuilder) SetName(v string) *ImageBuilder {
	s.Name = &v
	return s
}

// SetNetworkAccessConfiguration sets the NetworkAccessConfiguration field's value.
func (s *ImageBuilder) SetNetworkAccessConfiguration(v *NetworkAccessConfiguration) *ImageBuilder {
	s.NetworkAccessConfiguration = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ImageBuilder) SetPlatform(v string) *ImageBuilder {
	s.Platform = &v
	return s
}

// SetState sets the State field's value.
func (s *ImageBuilder) SetState(v string) *ImageBuilder {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *ImageBuilder) SetStateChangeReason(v *ImageBuilderStateChangeReason) *ImageBuilder {
	s.StateChangeReason = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *ImageBuilder) SetVpcConfig(v *VpcConfig) *ImageBuilder {
	s.VpcConfig = v
	return s
}

// Describes the reason why the last image builder state change occurred.
type ImageBuilderStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The state change reason code.
	Code *string `type:"string" enum:"ImageBuilderStateChangeReasonCode"`

	// The state change reason message.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ImageBuilderStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageBuilderStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ImageBuilderStateChangeReason) SetCode(v string) *ImageBuilderStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ImageBuilderStateChangeReason) SetMessage(v string) *ImageBuilderStateChangeReason {
	s.Message = &v
	return s
}

// Describes the permissions for an image.
type ImagePermissions struct {
	_ struct{} `type:"structure"`

	// Indicates whether the image can be used for a fleet.
	AllowFleet *bool `locationName:"allowFleet" type:"boolean"`

	// Indicates whether the image can be used for an image builder.
	AllowImageBuilder *bool `locationName:"allowImageBuilder" type:"boolean"`
}

// String returns the string representation
func (s ImagePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImagePermissions) GoString() string {
	return s.String()
}

// SetAllowFleet sets the AllowFleet field's value.
func (s *ImagePermissions) SetAllowFleet(v bool) *ImagePermissions {
	s.AllowFleet = &v
	return s
}

// SetAllowImageBuilder sets the AllowImageBuilder field's value.
func (s *ImagePermissions) SetAllowImageBuilder(v bool) *ImagePermissions {
	s.AllowImageBuilder = &v
	return s
}

// Describes the reason why the last image state change occurred.
type ImageStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The state change reason code.
	Code *string `type:"string" enum:"ImageStateChangeReasonCode"`

	// The state change reason message.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ImageStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ImageStateChangeReason) SetCode(v string) *ImageStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ImageStateChangeReason) SetMessage(v string) *ImageStateChangeReason {
	s.Message = &v
	return s
}

// The image does not support storage connectors.
type IncompatibleImageException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s IncompatibleImageException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncompatibleImageException) GoString() string {
	return s.String()
}

func newErrorIncompatibleImageException(v protocol.ResponseMetadata) error {
	return &IncompatibleImageException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IncompatibleImageException) Code() string {
	return "IncompatibleImageException"
}

// Message returns the exception's message.
func (s *IncompatibleImageException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IncompatibleImageException) OrigErr() error {
	return nil
}

func (s *IncompatibleImageException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IncompatibleImageException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IncompatibleImageException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource cannot be created because your AWS account is suspended. For
// assistance, contact AWS Support.
type InvalidAccountStatusException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidAccountStatusException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidAccountStatusException) GoString() string {
	return s.String()
}

func newErrorInvalidAccountStatusException(v protocol.ResponseMetadata) error {
	return &InvalidAccountStatusException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidAccountStatusException) Code() string {
	return "InvalidAccountStatusException"
}

// Message returns the exception's message.
func (s *InvalidAccountStatusException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidAccountStatusException) OrigErr() error {
	return nil
}

func (s *InvalidAccountStatusException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidAccountStatusException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidAccountStatusException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates an incorrect combination of parameters, or a missing parameter.
type InvalidParameterCombinationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterCombinationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterCombinationException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterCombinationException(v protocol.ResponseMetadata) error {
	return &InvalidParameterCombinationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterCombinationException) Code() string {
	return "InvalidParameterCombinationException"
}

// Message returns the exception's message.
func (s *InvalidParameterCombinationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterCombinationException) OrigErr() error {
	return nil
}

func (s *InvalidParameterCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterCombinationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterCombinationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified role is invalid.
type InvalidRoleException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRoleException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRoleException) GoString() string {
	return s.String()
}

func newErrorInvalidRoleException(v protocol.ResponseMetadata) error {
	return &InvalidRoleException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRoleException) Code() string {
	return "InvalidRoleException"
}

// Message returns the exception's message.
func (s *InvalidRoleException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRoleException) OrigErr() error {
	return nil
}

func (s *InvalidRoleException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRoleException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRoleException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the error that is returned when a usage report can't be generated.
type LastReportGenerationExecutionError struct {
	_ struct{} `type:"structure"`

	// The error code for the error that is returned when a usage report can't be
	// generated.
	ErrorCode *string `type:"string" enum:"UsageReportExecutionErrorCode"`

	// The error message for the error that is returned when a usage report can't
	// be generated.
	ErrorMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LastReportGenerationExecutionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LastReportGenerationExecutionError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *LastReportGenerationExecutionError) SetErrorCode(v string) *LastReportGenerationExecutionError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *LastReportGenerationExecutionError) SetErrorMessage(v string) *LastReportGenerationExecutionError {
	s.ErrorMessage = &v
	return s
}

// The requested limit exceeds the permitted limit for an account.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAssociatedFleetsInput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAssociatedFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedFleetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedFleetsInput) SetNextToken(v string) *ListAssociatedFleetsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ListAssociatedFleetsInput) SetStackName(v string) *ListAssociatedFleetsInput {
	s.StackName = &v
	return s
}

type ListAssociatedFleetsOutput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedFleetsOutput) GoString() string {
	return s.String()
}

// SetNames sets the Names field's value.
func (s *ListAssociatedFleetsOutput) SetNames(v []*string) *ListAssociatedFleetsOutput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedFleetsOutput) SetNextToken(v string) *ListAssociatedFleetsOutput {
	s.NextToken = &v
	return s
}

type ListAssociatedStacksInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedStacksInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetName sets the FleetName field's value.
func (s *ListAssociatedStacksInput) SetFleetName(v string) *ListAssociatedStacksInput {
	s.FleetName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedStacksInput) SetNextToken(v string) *ListAssociatedStacksInput {
	s.NextToken = &v
	return s
}

type ListAssociatedStacksOutput struct {
	_ struct{} `type:"structure"`

	// The name of the stack.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedStacksOutput) GoString() string {
	return s.String()
}

// SetNames sets the Names field's value.
func (s *ListAssociatedStacksOutput) SetNames(v []*string) *ListAssociatedStacksOutput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedStacksOutput) SetNextToken(v string) *ListAssociatedStacksOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The information about the tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Describes the network details of the fleet or image builder instance.
type NetworkAccessConfiguration struct {
	_ struct{} `type:"structure"`

	// The resource identifier of the elastic network interface that is attached
	// to instances in your VPC. All network interfaces have the eni-xxxxxxxx resource
	// identifier.
	EniId *string `min:"1" type:"string"`

	// The private IP address of the elastic network interface that is attached
	// to instances in your VPC.
	EniPrivateIpAddress *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NetworkAccessConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkAccessConfiguration) GoString() string {
	return s.String()
}

// SetEniId sets the EniId field's value.
func (s *NetworkAccessConfiguration) SetEniId(v string) *NetworkAccessConfiguration {
	s.EniId = &v
	return s
}

// SetEniPrivateIpAddress sets the EniPrivateIpAddress field's value.
func (s *NetworkAccessConfiguration) SetEniPrivateIpAddress(v string) *NetworkAccessConfiguration {
	s.EniPrivateIpAddress = &v
	return s
}

// The attempted operation is not permitted.
type OperationNotPermittedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s OperationNotPermittedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationNotPermittedException) GoString() string {
	return s.String()
}

func newErrorOperationNotPermittedException(v protocol.ResponseMetadata) error {
	return &OperationNotPermittedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationNotPermittedException) Code() string {
	return "OperationNotPermittedException"
}

// Message returns the exception's message.
func (s *OperationNotPermittedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationNotPermittedException) OrigErr() error {
	return nil
}

func (s *OperationNotPermittedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationNotPermittedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationNotPermittedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AppStream 2.0 can’t process the request right now because the Describe
// calls from your AWS account are being throttled by Amazon EC2. Try again
// later.
type RequestLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s RequestLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestLimitExceededException) GoString() string {
	return s.String()
}

func newErrorRequestLimitExceededException(v protocol.ResponseMetadata) error {
	return &RequestLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestLimitExceededException) Code() string {
	return "RequestLimitExceededException"
}

// Message returns the exception's message.
func (s *RequestLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestLimitExceededException) OrigErr() error {
	return nil
}

func (s *RequestLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a resource error.
type ResourceError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"FleetErrorCode"`

	// The error message.
	ErrorMessage *string `min:"1" type:"string"`

	// The time the error occurred.
	ErrorTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ResourceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ResourceError) SetErrorCode(v string) *ResourceError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ResourceError) SetErrorMessage(v string) *ResourceError {
	s.ErrorMessage = &v
	return s
}

// SetErrorTimestamp sets the ErrorTimestamp field's value.
func (s *ResourceError) SetErrorTimestamp(v time.Time) *ResourceError {
	s.ErrorTimestamp = &v
	return s
}

// The specified resource is in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource exists and is not in use, but isn't available.
type ResourceNotAvailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotAvailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotAvailableException) GoString() string {
	return s.String()
}

func newErrorResourceNotAvailableException(v protocol.ResponseMetadata) error {
	return &ResourceNotAvailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotAvailableException) Code() string {
	return "ResourceNotAvailableException"
}

// Message returns the exception's message.
func (s *ResourceNotAvailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotAvailableException) OrigErr() error {
	return nil
}

func (s *ResourceNotAvailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotAvailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotAvailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error message in the exception.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the credentials for the service account used by the fleet or image
// builder to connect to the directory.
type ServiceAccountCredentials struct {
	_ struct{} `type:"structure"`

	// The user name of the account. This account must have the following privileges:
	// create computer objects, join computers to the domain, and change/reset the
	// password on descendant computer objects for the organizational units specified.
	//
	// AccountName is a required field
	AccountName *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The password for the account.
	//
	// AccountPassword is a required field
	AccountPassword *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s ServiceAccountCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceAccountCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceAccountCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceAccountCredentials"}
	if s.AccountName == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountName"))
	}
	if s.AccountName != nil && len(*s.AccountName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountName", 1))
	}
	if s.AccountPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountPassword"))
	}
	if s.AccountPassword != nil && len(*s.AccountPassword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountPassword", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountName sets the AccountName field's value.
func (s *ServiceAccountCredentials) SetAccountName(v string) *ServiceAccountCredentials {
	s.AccountName = &v
	return s
}

// SetAccountPassword sets the AccountPassword field's value.
func (s *ServiceAccountCredentials) SetAccountPassword(v string) *ServiceAccountCredentials {
	s.AccountPassword = &v
	return s
}

// Describes a streaming session.
type Session struct {
	_ struct{} `type:"structure"`

	// The authentication method. The user is authenticated using a streaming URL
	// (API) or SAML 2.0 federation (SAML).
	AuthenticationType *string `type:"string" enum:"AuthenticationType"`

	// Specifies whether a user is connected to the streaming session.
	ConnectionState *string `type:"string" enum:"SessionConnectionState"`

	// The name of the fleet for the streaming session.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The identifier of the streaming session.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The time when the streaming session is set to expire. This time is based
	// on the MaxUserDurationinSeconds value, which determines the maximum length
	// of time that a streaming session can run. A streaming session might end earlier
	// than the time specified in SessionMaxExpirationTime, when the DisconnectTimeOutInSeconds
	// elapses or the user chooses to end his or her session. If the DisconnectTimeOutInSeconds
	// elapses, or the user chooses to end his or her session, the streaming instance
	// is terminated and the streaming session ends.
	MaxExpirationTime *time.Time `type:"timestamp"`

	// The network details for the streaming session.
	NetworkAccessConfiguration *NetworkAccessConfiguration `type:"structure"`

	// The name of the stack for the streaming session.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The time when a streaming instance is dedicated for the user.
	StartTime *time.Time `type:"timestamp"`

	// The current state of the streaming session.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"SessionState"`

	// The identifier of the user for whom the session was created.
	//
	// UserId is a required field
	UserId *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s Session) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Session) GoString() string {
	return s.String()
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *Session) SetAuthenticationType(v string) *Session {
	s.AuthenticationType = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *Session) SetConnectionState(v string) *Session {
	s.ConnectionState = &v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *Session) SetFleetName(v string) *Session {
	s.FleetName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Session) SetId(v string) *Session {
	s.Id = &v
	return s
}

// SetMaxExpirationTime sets the MaxExpirationTime field's value.
func (s *Session) SetMaxExpirationTime(v time.Time) *Session {
	s.MaxExpirationTime = &v
	return s
}

// SetNetworkAccessConfiguration sets the NetworkAccessConfiguration field's value.
func (s *Session) SetNetworkAccessConfiguration(v *NetworkAccessConfiguration) *Session {
	s.NetworkAccessConfiguration = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *Session) SetStackName(v string) *Session {
	s.StackName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Session) SetStartTime(v time.Time) *Session {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Session) SetState(v string) *Session {
	s.State = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *Session) SetUserId(v string) *Session {
	s.UserId = &v
	return s
}

// Describes the permissions that are available to the specified AWS account
// for a shared image.
type SharedImagePermissions struct {
	_ struct{} `type:"structure"`

	// Describes the permissions for a shared image.
	//
	// ImagePermissions is a required field
	ImagePermissions *ImagePermissions `locationName:"imagePermissions" type:"structure" required:"true"`

	// The 12-digit identifier of the AWS account with which the image is shared.
	//
	// SharedAccountId is a required field
	SharedAccountId *string `locationName:"sharedAccountId" type:"string" required:"true"`
}

// String returns the string representation
func (s SharedImagePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SharedImagePermissions) GoString() string {
	return s.String()
}

// SetImagePermissions sets the ImagePermissions field's value.
func (s *SharedImagePermissions) SetImagePermissions(v *ImagePermissions) *SharedImagePermissions {
	s.ImagePermissions = v
	return s
}

// SetSharedAccountId sets the SharedAccountId field's value.
func (s *SharedImagePermissions) SetSharedAccountId(v string) *SharedImagePermissions {
	s.SharedAccountId = &v
	return s
}

// Describes a stack.
type Stack struct {
	_ struct{} `type:"structure"`

	// The list of virtual private cloud (VPC) interface endpoint objects. Users
	// of the stack can connect to AppStream 2.0 only through the specified endpoints.
	AccessEndpoints []*AccessEndpoint `min:"1" type:"list"`

	// The persistent application settings for users of the stack.
	ApplicationSettings *ApplicationSettingsResponse `type:"structure"`

	// The ARN of the stack.
	Arn *string `type:"string"`

	// The time the stack was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The description to display.
	Description *string `min:"1" type:"string"`

	// The stack name to display.
	DisplayName *string `min:"1" type:"string"`

	// The domains where AppStream 2.0 streaming sessions can be embedded in an
	// iframe. You must approve the domains that you want to host embedded AppStream
	// 2.0 streaming sessions.
	EmbedHostDomains []*string `min:"1" type:"list"`

	// The URL that users are redirected to after they click the Send Feedback link.
	// If no URL is specified, no Send Feedback link is displayed.
	FeedbackURL *string `type:"string"`

	// The name of the stack.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The URL that users are redirected to after their streaming session ends.
	RedirectURL *string `type:"string"`

	// The errors for the stack.
	StackErrors []*StackError `type:"list"`

	// The storage connectors to enable.
	StorageConnectors []*StorageConnector `type:"list"`

	// The actions that are enabled or disabled for users during their streaming
	// sessions. By default these actions are enabled.
	UserSettings []*UserSetting `min:"1" type:"list"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stack) GoString() string {
	return s.String()
}

// SetAccessEndpoints sets the AccessEndpoints field's value.
func (s *Stack) SetAccessEndpoints(v []*AccessEndpoint) *Stack {
	s.AccessEndpoints = v
	return s
}

// SetApplicationSettings sets the ApplicationSettings field's value.
func (s *Stack) SetApplicationSettings(v *ApplicationSettingsResponse) *Stack {
	s.ApplicationSettings = v
	return s
}

// SetArn sets the Arn field's value.
func (s *Stack) SetArn(v string) *Stack {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Stack) SetCreatedTime(v time.Time) *Stack {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Stack) SetDescription(v string) *Stack {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Stack) SetDisplayName(v string) *Stack {
	s.DisplayName = &v
	return s
}

// SetEmbedHostDomains sets the EmbedHostDomains field's value.
func (s *Stack) SetEmbedHostDomains(v []*string) *Stack {
	s.EmbedHostDomains = v
	return s
}

// SetFeedbackURL sets the FeedbackURL field's value.
func (s *Stack) SetFeedbackURL(v string) *Stack {
	s.FeedbackURL = &v
	return s
}

// SetName sets the Name field's value.
func (s *Stack) SetName(v string) *Stack {
	s.Name = &v
	return s
}

// SetRedirectURL sets the RedirectURL field's value.
func (s *Stack) SetRedirectURL(v string) *Stack {
	s.RedirectURL = &v
	return s
}

// SetStackErrors sets the StackErrors field's value.
func (s *Stack) SetStackErrors(v []*StackError) *Stack {
	s.StackErrors = v
	return s
}

// SetStorageConnectors sets the StorageConnectors field's value.
func (s *Stack) SetStorageConnectors(v []*StorageConnector) *Stack {
	s.StorageConnectors = v
	return s
}

// SetUserSettings sets the UserSettings field's value.
func (s *Stack) SetUserSettings(v []*UserSetting) *Stack {
	s.UserSettings = v
	return s
}

// Describes a stack error.
type StackError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"StackErrorCode"`

	// The error message.
	ErrorMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StackError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *StackError) SetErrorCode(v string) *StackError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *StackError) SetErrorMessage(v string) *StackError {
	s.ErrorMessage = &v
	return s
}

type StartFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFleetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartFleetInput) SetName(v string) *StartFleetInput {
	s.Name = &v
	return s
}

type StartFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFleetOutput) GoString() string {
	return s.String()
}

type StartImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The version of the AppStream 2.0 agent to use for this image builder. To
	// use the latest version of the AppStream 2.0 agent, specify [LATEST].
	AppstreamAgentVersion *string `min:"1" type:"string"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartImageBuilderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartImageBuilderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartImageBuilderInput"}
	if s.AppstreamAgentVersion != nil && len(*s.AppstreamAgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppstreamAgentVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppstreamAgentVersion sets the AppstreamAgentVersion field's value.
func (s *StartImageBuilderInput) SetAppstreamAgentVersion(v string) *StartImageBuilderInput {
	s.AppstreamAgentVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartImageBuilderInput) SetName(v string) *StartImageBuilderInput {
	s.Name = &v
	return s
}

type StartImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s StartImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartImageBuilderOutput) GoString() string {
	return s.String()
}

// SetImageBuilder sets the ImageBuilder field's value.
func (s *StartImageBuilderOutput) SetImageBuilder(v *ImageBuilder) *StartImageBuilderOutput {
	s.ImageBuilder = v
	return s
}

type StopFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopFleetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopFleetInput) SetName(v string) *StopFleetInput {
	s.Name = &v
	return s
}

type StopFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFleetOutput) GoString() string {
	return s.String()
}

type StopImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopImageBuilderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopImageBuilderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopImageBuilderInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopImageBuilderInput) SetName(v string) *StopImageBuilderInput {
	s.Name = &v
	return s
}

type StopImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s StopImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopImageBuilderOutput) GoString() string {
	return s.String()
}

// SetImageBuilder sets the ImageBuilder field's value.
func (s *StopImageBuilderOutput) SetImageBuilder(v *ImageBuilder) *StopImageBuilderOutput {
	s.ImageBuilder = v
	return s
}

// Describes a connector that enables persistent storage for users.
type StorageConnector struct {
	_ struct{} `type:"structure"`

	// The type of storage connector.
	//
	// ConnectorType is a required field
	ConnectorType *string `type:"string" required:"true" enum:"StorageConnectorType"`

	// The names of the domains for the account.
	Domains []*string `type:"list"`

	// The ARN of the storage connector.
	ResourceIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StorageConnector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageConnector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageConnector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageConnector"}
	if s.ConnectorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorType"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorType sets the ConnectorType field's value.
func (s *StorageConnector) SetConnectorType(v string) *StorageConnector {
	s.ConnectorType = &v
	return s
}

// SetDomains sets the Domains field's value.
func (s *StorageConnector) SetDomains(v []*string) *StorageConnector {
	s.Domains = v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *StorageConnector) SetResourceIdentifier(v string) *StorageConnector {
	s.ResourceIdentifier = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tags to associate. A tag is a key-value pair, and the value is optional.
	// For example, Environment=Test. If you do not specify a value, Environment=.
	//
	// If you do not specify a value, the value is set to an empty string.
	//
	// Generally allowed characters are: letters, numbers, and spaces representable
	// in UTF-8, and the following special characters:
	//
	// _ . : / = + \ - @
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tag keys for the tags to disassociate.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDirectoryConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the Directory Config object.
	//
	// DirectoryName is a required field
	DirectoryName *string `type:"string" required:"true"`

	// The distinguished names of the organizational units for computer accounts.
	OrganizationalUnitDistinguishedNames []*string `type:"list"`

	// The credentials for the service account used by the fleet or image builder
	// to connect to the directory.
	ServiceAccountCredentials *ServiceAccountCredentials `type:"structure"`
}

// String returns the string representation
func (s UpdateDirectoryConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDirectoryConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDirectoryConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDirectoryConfigInput"}
	if s.DirectoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryName"))
	}
	if s.ServiceAccountCredentials != nil {
		if err := s.ServiceAccountCredentials.Validate(); err != nil {
			invalidParams.AddNested("ServiceAccountCredentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *UpdateDirectoryConfigInput) SetDirectoryName(v string) *UpdateDirectoryConfigInput {
	s.DirectoryName = &v
	return s
}

// SetOrganizationalUnitDistinguishedNames sets the OrganizationalUnitDistinguishedNames field's value.
func (s *UpdateDirectoryConfigInput) SetOrganizationalUnitDistinguishedNames(v []*string) *UpdateDirectoryConfigInput {
	s.OrganizationalUnitDistinguishedNames = v
	return s
}

// SetServiceAccountCredentials sets the ServiceAccountCredentials field's value.
func (s *UpdateDirectoryConfigInput) SetServiceAccountCredentials(v *ServiceAccountCredentials) *UpdateDirectoryConfigInput {
	s.ServiceAccountCredentials = v
	return s
}

type UpdateDirectoryConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Directory Config object.
	DirectoryConfig *DirectoryConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateDirectoryConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDirectoryConfigOutput) GoString() string {
	return s.String()
}

// SetDirectoryConfig sets the DirectoryConfig field's value.
func (s *UpdateDirectoryConfigOutput) SetDirectoryConfig(v *DirectoryConfig) *UpdateDirectoryConfigOutput {
	s.DirectoryConfig = v
	return s
}

type UpdateFleetInput struct {
	_ struct{} `type:"structure"`

	// The fleet attributes to delete.
	AttributesToDelete []*string `type:"list"`

	// The desired capacity for the fleet.
	ComputeCapacity *ComputeCapacity `type:"structure"`

	// Deletes the VPC association for the specified fleet.
	//
	// Deprecated: DeleteVpcConfig has been deprecated
	DeleteVpcConfig *bool `deprecated:"true" type:"boolean"`

	// The description to display.
	Description *string `type:"string"`

	// The amount of time that a streaming session remains active after users disconnect.
	// If users try to reconnect to the streaming session after a disconnection
	// or network interruption within this time interval, they are connected to
	// their previous session. Otherwise, they are connected to a new session with
	// a new streaming instance.
	//
	// Specify a value between 60 and 360000.
	DisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The fleet name to display.
	DisplayName *string `type:"string"`

	// The name of the directory and organizational unit (OU) to use to join the
	// fleet to a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Enables or disables default internet access for the fleet.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To
	// assume a role, a fleet instance calls the AWS Security Token Service (STS)
	// AssumeRole API operation and passes the ARN of the role to use. The operation
	// creates a new session with temporary credentials. AppStream 2.0 retrieves
	// the temporary credentials and creates the appstream_machine_role credential
	// profile on the instance.
	//
	// For more information, see Using an IAM Role to Grant Permissions to Applications
	// and Scripts Running on AppStream 2.0 Streaming Instances (https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	IamRoleArn *string `type:"string"`

	// The amount of time that users can be idle (inactive) before they are disconnected
	// from their streaming session and the DisconnectTimeoutInSeconds time interval
	// begins. Users are notified before they are disconnected due to inactivity.
	// If users try to reconnect to the streaming session before the time interval
	// specified in DisconnectTimeoutInSeconds elapses, they are connected to their
	// previous session. Users are considered idle when they stop providing keyboard
	// or mouse input during their streaming session. File uploads and downloads,
	// audio in, audio out, and pixels changing do not qualify as user activity.
	// If users continue to be idle after the time interval in IdleDisconnectTimeoutInSeconds
	// elapses, they are disconnected.
	//
	// To prevent users from being disconnected due to inactivity, specify a value
	// of 0. Otherwise, specify a value between 60 and 3600. The default value is
	// 0.
	//
	// If you enable this feature, we recommend that you specify a value that corresponds
	// exactly to a whole number of minutes (for example, 60, 120, and 180). If
	// you don't do this, the value is rounded to the nearest minute. For example,
	// if you specify a value of 70, users are disconnected after 1 minute of inactivity.
	// If you specify a value that is at the midpoint between two different minutes,
	// the value is rounded up. For example, if you specify a value of 90, users
	// are disconnected after 2 minutes of inactivity.
	IdleDisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The ARN of the public, private, or shared image to use.
	ImageArn *string `type:"string"`

	// The name of the image used to create the fleet.
	ImageName *string `min:"1" type:"string"`

	// The instance type to use when launching fleet instances. The following instance
	// types are available:
	//
	//    * stream.standard.small
	//
	//    * stream.standard.medium
	//
	//    * stream.standard.large
	//
	//    * stream.compute.large
	//
	//    * stream.compute.xlarge
	//
	//    * stream.compute.2xlarge
	//
	//    * stream.compute.4xlarge
	//
	//    * stream.compute.8xlarge
	//
	//    * stream.memory.large
	//
	//    * stream.memory.xlarge
	//
	//    * stream.memory.2xlarge
	//
	//    * stream.memory.4xlarge
	//
	//    * stream.memory.8xlarge
	//
	//    * stream.memory.z1d.large
	//
	//    * stream.memory.z1d.xlarge
	//
	//    * stream.memory.z1d.2xlarge
	//
	//    * stream.memory.z1d.3xlarge
	//
	//    * stream.memory.z1d.6xlarge
	//
	//    * stream.memory.z1d.12xlarge
	//
	//    * stream.graphics-design.large
	//
	//    * stream.graphics-design.xlarge
	//
	//    * stream.graphics-design.2xlarge
	//
	//    * stream.graphics-design.4xlarge
	//
	//    * stream.graphics-desktop.2xlarge
	//
	//    * stream.graphics.g4dn.xlarge
	//
	//    * stream.graphics.g4dn.2xlarge
	//
	//    * stream.graphics.g4dn.4xlarge
	//
	//    * stream.graphics.g4dn.8xlarge
	//
	//    * stream.graphics.g4dn.12xlarge
	//
	//    * stream.graphics.g4dn.16xlarge
	//
	//    * stream.graphics-pro.4xlarge
	//
	//    * stream.graphics-pro.8xlarge
	//
	//    * stream.graphics-pro.16xlarge
	InstanceType *string `min:"1" type:"string"`

	// The maximum amount of time that a streaming session can remain active, in
	// seconds. If users are still connected to a streaming instance five minutes
	// before this limit is reached, they are prompted to save any open documents
	// before being disconnected. After this time elapses, the instance is terminated
	// and replaced by a new instance.
	//
	// Specify a value between 600 and 360000.
	MaxUserDurationInSeconds *int64 `type:"integer"`

	// A unique name for the fleet.
	Name *string `min:"1" type:"string"`

	// The AppStream 2.0 view that is displayed to your users when they stream from
	// the fleet. When APP is specified, only the windows of applications opened
	// by users display. When DESKTOP is specified, the standard desktop that is
	// provided by the operating system displays.
	//
	// The default value is APP.
	StreamView *string `type:"string" enum:"StreamView"`

	// The VPC configuration for the fleet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetInput"}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ComputeCapacity != nil {
		if err := s.ComputeCapacity.Validate(); err != nil {
			invalidParams.AddNested("ComputeCapacity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToDelete sets the AttributesToDelete field's value.
func (s *UpdateFleetInput) SetAttributesToDelete(v []*string) *UpdateFleetInput {
	s.AttributesToDelete = v
	return s
}

// SetComputeCapacity sets the ComputeCapacity field's value.
func (s *UpdateFleetInput) SetComputeCapacity(v *ComputeCapacity) *UpdateFleetInput {
	s.ComputeCapacity = v
	return s
}

// SetDeleteVpcConfig sets the DeleteVpcConfig field's value.
func (s *UpdateFleetInput) SetDeleteVpcConfig(v bool) *UpdateFleetInput {
	s.DeleteVpcConfig = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFleetInput) SetDescription(v string) *UpdateFleetInput {
	s.Description = &v
	return s
}

// SetDisconnectTimeoutInSeconds sets the DisconnectTimeoutInSeconds field's value.
func (s *UpdateFleetInput) SetDisconnectTimeoutInSeconds(v int64) *UpdateFleetInput {
	s.DisconnectTimeoutInSeconds = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateFleetInput) SetDisplayName(v string) *UpdateFleetInput {
	s.DisplayName = &v
	return s
}

// SetDomainJoinInfo sets the DomainJoinInfo field's value.
func (s *UpdateFleetInput) SetDomainJoinInfo(v *DomainJoinInfo) *UpdateFleetInput {
	s.DomainJoinInfo = v
	return s
}

// SetEnableDefaultInternetAccess sets the EnableDefaultInternetAccess field's value.
func (s *UpdateFleetInput) SetEnableDefaultInternetAccess(v bool) *UpdateFleetInput {
	s.EnableDefaultInternetAccess = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *UpdateFleetInput) SetIamRoleArn(v string) *UpdateFleetInput {
	s.IamRoleArn = &v
	return s
}

// SetIdleDisconnectTimeoutInSeconds sets the IdleDisconnectTimeoutInSeconds field's value.
func (s *UpdateFleetInput) SetIdleDisconnectTimeoutInSeconds(v int64) *UpdateFleetInput {
	s.IdleDisconnectTimeoutInSeconds = &v
	return s
}

// SetImageArn sets the ImageArn field's value.
func (s *UpdateFleetInput) SetImageArn(v string) *UpdateFleetInput {
	s.ImageArn = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *UpdateFleetInput) SetImageName(v string) *UpdateFleetInput {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *UpdateFleetInput) SetInstanceType(v string) *UpdateFleetInput {
	s.InstanceType = &v
	return s
}

// SetMaxUserDurationInSeconds sets the MaxUserDurationInSeconds field's value.
func (s *UpdateFleetInput) SetMaxUserDurationInSeconds(v int64) *UpdateFleetInput {
	s.MaxUserDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFleetInput) SetName(v string) *UpdateFleetInput {
	s.Name = &v
	return s
}

// SetStreamView sets the StreamView field's value.
func (s *UpdateFleetInput) SetStreamView(v string) *UpdateFleetInput {
	s.StreamView = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *UpdateFleetInput) SetVpcConfig(v *VpcConfig) *UpdateFleetInput {
	s.VpcConfig = v
	return s
}

type UpdateFleetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the fleet.
	Fleet *Fleet `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetOutput) GoString() string {
	return s.String()
}

// SetFleet sets the Fleet field's value.
func (s *UpdateFleetOutput) SetFleet(v *Fleet) *UpdateFleetOutput {
	s.Fleet = v
	return s
}

type UpdateImagePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The permissions for the image.
	//
	// ImagePermissions is a required field
	ImagePermissions *ImagePermissions `type:"structure" required:"true"`

	// The name of the private image.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The 12-digit identifier of the AWS account for which you want add or update
	// image permissions.
	//
	// SharedAccountId is a required field
	SharedAccountId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateImagePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateImagePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateImagePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateImagePermissionsInput"}
	if s.ImagePermissions == nil {
		invalidParams.Add(request.NewErrParamRequired("ImagePermissions"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SharedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImagePermissions sets the ImagePermissions field's value.
func (s *UpdateImagePermissionsInput) SetImagePermissions(v *ImagePermissions) *UpdateImagePermissionsInput {
	s.ImagePermissions = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateImagePermissionsInput) SetName(v string) *UpdateImagePermissionsInput {
	s.Name = &v
	return s
}

// SetSharedAccountId sets the SharedAccountId field's value.
func (s *UpdateImagePermissionsInput) SetSharedAccountId(v string) *UpdateImagePermissionsInput {
	s.SharedAccountId = &v
	return s
}

type UpdateImagePermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateImagePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateImagePermissionsOutput) GoString() string {
	return s.String()
}

type UpdateStackInput struct {
	_ struct{} `type:"structure"`

	// The list of interface VPC endpoint (interface endpoint) objects. Users of
	// the stack can connect to AppStream 2.0 only through the specified endpoints.
	AccessEndpoints []*AccessEndpoint `min:"1" type:"list"`

	// The persistent application settings for users of a stack. When these settings
	// are enabled, changes that users make to applications and Windows settings
	// are automatically saved after each session and applied to the next session.
	ApplicationSettings *ApplicationSettings `type:"structure"`

	// The stack attributes to delete.
	AttributesToDelete []*string `type:"list"`

	// Deletes the storage connectors currently enabled for the stack.
	//
	// Deprecated: DeleteStorageConnectors has been deprecated
	DeleteStorageConnectors *bool `deprecated:"true" type:"boolean"`

	// The description to display.
	Description *string `type:"string"`

	// The stack name to display.
	DisplayName *string `type:"string"`

	// The domains where AppStream 2.0 streaming sessions can be embedded in an
	// iframe. You must approve the domains that you want to host embedded AppStream
	// 2.0 streaming sessions.
	EmbedHostDomains []*string `min:"1" type:"list"`

	// The URL that users are redirected to after they choose the Send Feedback
	// link. If no URL is specified, no Send Feedback link is displayed.
	FeedbackURL *string `type:"string"`

	// The name of the stack.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The URL that users are redirected to after their streaming session ends.
	RedirectURL *string `type:"string"`

	// The storage connectors to enable.
	StorageConnectors []*StorageConnector `type:"list"`

	// The actions that are enabled or disabled for users during their streaming
	// sessions. By default, these actions are enabled.
	UserSettings []*UserSetting `min:"1" type:"list"`
}

// String returns the string representation
func (s UpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStackInput"}
	if s.AccessEndpoints != nil && len(s.AccessEndpoints) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessEndpoints", 1))
	}
	if s.EmbedHostDomains != nil && len(s.EmbedHostDomains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmbedHostDomains", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.UserSettings != nil && len(s.UserSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserSettings", 1))
	}
	if s.AccessEndpoints != nil {
		for i, v := range s.AccessEndpoints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessEndpoints", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ApplicationSettings != nil {
		if err := s.ApplicationSettings.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.StorageConnectors != nil {
		for i, v := range s.StorageConnectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StorageConnectors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserSettings != nil {
		for i, v := range s.UserSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessEndpoints sets the AccessEndpoints field's value.
func (s *UpdateStackInput) SetAccessEndpoints(v []*AccessEndpoint) *UpdateStackInput {
	s.AccessEndpoints = v
	return s
}

// SetApplicationSettings sets the ApplicationSettings field's value.
func (s *UpdateStackInput) SetApplicationSettings(v *ApplicationSettings) *UpdateStackInput {
	s.ApplicationSettings = v
	return s
}

// SetAttributesToDelete sets the AttributesToDelete field's value.
func (s *UpdateStackInput) SetAttributesToDelete(v []*string) *UpdateStackInput {
	s.AttributesToDelete = v
	return s
}

// SetDeleteStorageConnectors sets the DeleteStorageConnectors field's value.
func (s *UpdateStackInput) SetDeleteStorageConnectors(v bool) *UpdateStackInput {
	s.DeleteStorageConnectors = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateStackInput) SetDescription(v string) *UpdateStackInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateStackInput) SetDisplayName(v string) *UpdateStackInput {
	s.DisplayName = &v
	return s
}

// SetEmbedHostDomains sets the EmbedHostDomains field's value.
func (s *UpdateStackInput) SetEmbedHostDomains(v []*string) *UpdateStackInput {
	s.EmbedHostDomains = v
	return s
}

// SetFeedbackURL sets the FeedbackURL field's value.
func (s *UpdateStackInput) SetFeedbackURL(v string) *UpdateStackInput {
	s.FeedbackURL = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStackInput) SetName(v string) *UpdateStackInput {
	s.Name = &v
	return s
}

// SetRedirectURL sets the RedirectURL field's value.
func (s *UpdateStackInput) SetRedirectURL(v string) *UpdateStackInput {
	s.RedirectURL = &v
	return s
}

// SetStorageConnectors sets the StorageConnectors field's value.
func (s *UpdateStackInput) SetStorageConnectors(v []*StorageConnector) *UpdateStackInput {
	s.StorageConnectors = v
	return s
}

// SetUserSettings sets the UserSettings field's value.
func (s *UpdateStackInput) SetUserSettings(v []*UserSetting) *UpdateStackInput {
	s.UserSettings = v
	return s
}

type UpdateStackOutput struct {
	_ struct{} `type:"structure"`

	// Information about the stack.
	Stack *Stack `type:"structure"`
}

// String returns the string representation
func (s UpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackOutput) GoString() string {
	return s.String()
}

// SetStack sets the Stack field's value.
func (s *UpdateStackOutput) SetStack(v *Stack) *UpdateStackOutput {
	s.Stack = v
	return s
}

// Describes information about the usage report subscription.
type UsageReportSubscription struct {
	_ struct{} `type:"structure"`

	// The time when the last usage report was generated.
	LastGeneratedReportDate *time.Time `type:"timestamp"`

	// The Amazon S3 bucket where generated reports are stored.
	//
	// If you enabled on-instance session scripts and Amazon S3 logging for your
	// session script configuration, AppStream 2.0 created an S3 bucket to store
	// the script output. The bucket is unique to your account and Region. When
	// you enable usage reporting in this case, AppStream 2.0 uses the same bucket
	// to store your usage reports. If you haven't already enabled on-instance session
	// scripts, when you enable usage reports, AppStream 2.0 creates a new S3 bucket.
	S3BucketName *string `min:"1" type:"string"`

	// The schedule for generating usage reports.
	Schedule *string `type:"string" enum:"UsageReportSchedule"`

	// The errors that were returned if usage reports couldn't be generated.
	SubscriptionErrors []*LastReportGenerationExecutionError `type:"list"`
}

// String returns the string representation
func (s UsageReportSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UsageReportSubscription) GoString() string {
	return s.String()
}

// SetLastGeneratedReportDate sets the LastGeneratedReportDate field's value.
func (s *UsageReportSubscription) SetLastGeneratedReportDate(v time.Time) *UsageReportSubscription {
	s.LastGeneratedReportDate = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *UsageReportSubscription) SetS3BucketName(v string) *UsageReportSubscription {
	s.S3BucketName = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UsageReportSubscription) SetSchedule(v string) *UsageReportSubscription {
	s.Schedule = &v
	return s
}

// SetSubscriptionErrors sets the SubscriptionErrors field's value.
func (s *UsageReportSubscription) SetSubscriptionErrors(v []*LastReportGenerationExecutionError) *UsageReportSubscription {
	s.SubscriptionErrors = v
	return s
}

// Describes a user in the user pool.
type User struct {
	_ struct{} `type:"structure"`

	// The ARN of the user.
	Arn *string `type:"string"`

	// The authentication type for the user.
	//
	// AuthenticationType is a required field
	AuthenticationType *string `type:"string" required:"true" enum:"AuthenticationType"`

	// The date and time the user was created in the user pool.
	CreatedTime *time.Time `type:"timestamp"`

	// Specifies whether the user in the user pool is enabled.
	Enabled *bool `type:"boolean"`

	// The first name, or given name, of the user.
	FirstName *string `type:"string" sensitive:"true"`

	// The last name, or surname, of the user.
	LastName *string `type:"string" sensitive:"true"`

	// The status of the user in the user pool. The status can be one of the following:
	//
	//    * UNCONFIRMED – The user is created but not confirmed.
	//
	//    * CONFIRMED – The user is confirmed.
	//
	//    * ARCHIVED – The user is no longer active.
	//
	//    * COMPROMISED – The user is disabled because of a potential security
	//    threat.
	//
	//    * UNKNOWN – The user status is not known.
	Status *string `min:"1" type:"string"`

	// The email address of the user.
	//
	// Users' email addresses are case-sensitive.
	UserName *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *User) SetArn(v string) *User {
	s.Arn = &v
	return s
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *User) SetAuthenticationType(v string) *User {
	s.AuthenticationType = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *User) SetCreatedTime(v time.Time) *User {
	s.CreatedTime = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *User) SetEnabled(v bool) *User {
	s.Enabled = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *User) SetFirstName(v string) *User {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *User) SetLastName(v string) *User {
	s.LastName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *User) SetStatus(v string) *User {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *User) SetUserName(v string) *User {
	s.UserName = &v
	return s
}

// Describes an action and whether the action is enabled or disabled for users
// during their streaming sessions.
type UserSetting struct {
	_ struct{} `type:"structure"`

	// The action that is enabled or disabled.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"Action"`

	// Indicates whether the action is enabled or disabled.
	//
	// Permission is a required field
	Permission *string `type:"string" required:"true" enum:"Permission"`
}

// String returns the string representation
func (s UserSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserSetting"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Permission == nil {
		invalidParams.Add(request.NewErrParamRequired("Permission"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UserSetting) SetAction(v string) *UserSetting {
	s.Action = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *UserSetting) SetPermission(v string) *UserSetting {
	s.Permission = &v
	return s
}

// Describes a user in the user pool and the associated stack.
type UserStackAssociation struct {
	_ struct{} `type:"structure"`

	// The authentication type for the user.
	//
	// AuthenticationType is a required field
	AuthenticationType *string `type:"string" required:"true" enum:"AuthenticationType"`

	// Specifies whether a welcome email is sent to a user after the user is created
	// in the user pool.
	SendEmailNotification *bool `type:"boolean"`

	// The name of the stack that is associated with the user.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The email address of the user who is associated with the stack.
	//
	// Users' email addresses are case-sensitive.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s UserStackAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserStackAssociation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserStackAssociation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserStackAssociation"}
	if s.AuthenticationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationType"))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *UserStackAssociation) SetAuthenticationType(v string) *UserStackAssociation {
	s.AuthenticationType = &v
	return s
}

// SetSendEmailNotification sets the SendEmailNotification field's value.
func (s *UserStackAssociation) SetSendEmailNotification(v bool) *UserStackAssociation {
	s.SendEmailNotification = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *UserStackAssociation) SetStackName(v string) *UserStackAssociation {
	s.StackName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UserStackAssociation) SetUserName(v string) *UserStackAssociation {
	s.UserName = &v
	return s
}

// Describes the error that is returned when a user can’t be associated with
// or disassociated from a stack.
type UserStackAssociationError struct {
	_ struct{} `type:"structure"`

	// The error code for the error that is returned when a user can’t be associated
	// with or disassociated from a stack.
	ErrorCode *string `type:"string" enum:"UserStackAssociationErrorCode"`

	// The error message for the error that is returned when a user can’t be associated
	// with or disassociated from a stack.
	ErrorMessage *string `min:"1" type:"string"`

	// Information about the user and associated stack.
	UserStackAssociation *UserStackAssociation `type:"structure"`
}

// String returns the string representation
func (s UserStackAssociationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserStackAssociationError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UserStackAssociationError) SetErrorCode(v string) *UserStackAssociationError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UserStackAssociationError) SetErrorMessage(v string) *UserStackAssociationError {
	s.ErrorMessage = &v
	return s
}

// SetUserStackAssociation sets the UserStackAssociation field's value.
func (s *UserStackAssociationError) SetUserStackAssociation(v *UserStackAssociation) *UserStackAssociationError {
	s.UserStackAssociation = v
	return s
}

// Describes VPC configuration information for fleets and image builders.
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// The identifiers of the security groups for the fleet or image builder.
	SecurityGroupIds []*string `type:"list"`

	// The identifiers of the subnets to which a network interface is attached from
	// the fleet instance or image builder instance. Fleet instances use one or
	// more subnets. Image builder instances use one subnet.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfig) SetSecurityGroupIds(v []*string) *VpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfig) SetSubnetIds(v []*string) *VpcConfig {
	s.SubnetIds = v
	return s
}

const (
	// AccessEndpointTypeStreaming is a AccessEndpointType enum value
	AccessEndpointTypeStreaming = "STREAMING"
)

// AccessEndpointType_Values returns all elements of the AccessEndpointType enum
func AccessEndpointType_Values() []string {
	return []string{
		AccessEndpointTypeStreaming,
	}
}

const (
	// ActionClipboardCopyFromLocalDevice is a Action enum value
	ActionClipboardCopyFromLocalDevice = "CLIPBOARD_COPY_FROM_LOCAL_DEVICE"

	// ActionClipboardCopyToLocalDevice is a Action enum value
	ActionClipboardCopyToLocalDevice = "CLIPBOARD_COPY_TO_LOCAL_DEVICE"

	// ActionFileUpload is a Action enum value
	ActionFileUpload = "FILE_UPLOAD"

	// ActionFileDownload is a Action enum value
	ActionFileDownload = "FILE_DOWNLOAD"

	// ActionPrintingToLocalDevice is a Action enum value
	ActionPrintingToLocalDevice = "PRINTING_TO_LOCAL_DEVICE"

	// ActionDomainPasswordSignin is a Action enum value
	ActionDomainPasswordSignin = "DOMAIN_PASSWORD_SIGNIN"

	// ActionDomainSmartCardSignin is a Action enum value
	ActionDomainSmartCardSignin = "DOMAIN_SMART_CARD_SIGNIN"
)

// Action_Values returns all elements of the Action enum
func Action_Values() []string {
	return []string{
		ActionClipboardCopyFromLocalDevice,
		ActionClipboardCopyToLocalDevice,
		ActionFileUpload,
		ActionFileDownload,
		ActionPrintingToLocalDevice,
		ActionDomainPasswordSignin,
		ActionDomainSmartCardSignin,
	}
}

const (
	// AuthenticationTypeApi is a AuthenticationType enum value
	AuthenticationTypeApi = "API"

	// AuthenticationTypeSaml is a AuthenticationType enum value
	AuthenticationTypeSaml = "SAML"

	// AuthenticationTypeUserpool is a AuthenticationType enum value
	AuthenticationTypeUserpool = "USERPOOL"
)

// AuthenticationType_Values returns all elements of the AuthenticationType enum
func AuthenticationType_Values() []string {
	return []string{
		AuthenticationTypeApi,
		AuthenticationTypeSaml,
		AuthenticationTypeUserpool,
	}
}

// The fleet attribute.
const (
	// FleetAttributeVpcConfiguration is a FleetAttribute enum value
	FleetAttributeVpcConfiguration = "VPC_CONFIGURATION"

	// FleetAttributeVpcConfigurationSecurityGroupIds is a FleetAttribute enum value
	FleetAttributeVpcConfigurationSecurityGroupIds = "VPC_CONFIGURATION_SECURITY_GROUP_IDS"

	// FleetAttributeDomainJoinInfo is a FleetAttribute enum value
	FleetAttributeDomainJoinInfo = "DOMAIN_JOIN_INFO"

	// FleetAttributeIamRoleArn is a FleetAttribute enum value
	FleetAttributeIamRoleArn = "IAM_ROLE_ARN"
)

// FleetAttribute_Values returns all elements of the FleetAttribute enum
func FleetAttribute_Values() []string {
	return []string{
		FleetAttributeVpcConfiguration,
		FleetAttributeVpcConfigurationSecurityGroupIds,
		FleetAttributeDomainJoinInfo,
		FleetAttributeIamRoleArn,
	}
}

const (
	// FleetErrorCodeIamServiceRoleMissingEniDescribeAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingEniDescribeAction = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"

	// FleetErrorCodeIamServiceRoleMissingEniCreateAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingEniCreateAction = "IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"

	// FleetErrorCodeIamServiceRoleMissingEniDeleteAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingEniDeleteAction = "IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"

	// FleetErrorCodeNetworkInterfaceLimitExceeded is a FleetErrorCode enum value
	FleetErrorCodeNetworkInterfaceLimitExceeded = "NETWORK_INTERFACE_LIMIT_EXCEEDED"

	// FleetErrorCodeInternalServiceError is a FleetErrorCode enum value
	FleetErrorCodeInternalServiceError = "INTERNAL_SERVICE_ERROR"

	// FleetErrorCodeIamServiceRoleIsMissing is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleIsMissing = "IAM_SERVICE_ROLE_IS_MISSING"

	// FleetErrorCodeMachineRoleIsMissing is a FleetErrorCode enum value
	FleetErrorCodeMachineRoleIsMissing = "MACHINE_ROLE_IS_MISSING"

	// FleetErrorCodeStsDisabledInRegion is a FleetErrorCode enum value
	FleetErrorCodeStsDisabledInRegion = "STS_DISABLED_IN_REGION"

	// FleetErrorCodeSubnetHasInsufficientIpAddresses is a FleetErrorCode enum value
	FleetErrorCodeSubnetHasInsufficientIpAddresses = "SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"

	// FleetErrorCodeIamServiceRoleMissingDescribeSubnetAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingDescribeSubnetAction = "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"

	// FleetErrorCodeSubnetNotFound is a FleetErrorCode enum value
	FleetErrorCodeSubnetNotFound = "SUBNET_NOT_FOUND"

	// FleetErrorCodeImageNotFound is a FleetErrorCode enum value
	FleetErrorCodeImageNotFound = "IMAGE_NOT_FOUND"

	// FleetErrorCodeInvalidSubnetConfiguration is a FleetErrorCode enum value
	FleetErrorCodeInvalidSubnetConfiguration = "INVALID_SUBNET_CONFIGURATION"

	// FleetErrorCodeSecurityGroupsNotFound is a FleetErrorCode enum value
	FleetErrorCodeSecurityGroupsNotFound = "SECURITY_GROUPS_NOT_FOUND"

	// FleetErrorCodeIgwNotAttached is a FleetErrorCode enum value
	FleetErrorCodeIgwNotAttached = "IGW_NOT_ATTACHED"

	// FleetErrorCodeIamServiceRoleMissingDescribeSecurityGroupsAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingDescribeSecurityGroupsAction = "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"

	// FleetErrorCodeFleetStopped is a FleetErrorCode enum value
	FleetErrorCodeFleetStopped = "FLEET_STOPPED"

	// FleetErrorCodeFleetInstanceProvisioningFailure is a FleetErrorCode enum value
	FleetErrorCodeFleetInstanceProvisioningFailure = "FLEET_INSTANCE_PROVISIONING_FAILURE"

	// FleetErrorCodeDomainJoinErrorFileNotFound is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorFileNotFound = "DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"

	// FleetErrorCodeDomainJoinErrorAccessDenied is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorAccessDenied = "DOMAIN_JOIN_ERROR_ACCESS_DENIED"

	// FleetErrorCodeDomainJoinErrorLogonFailure is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorLogonFailure = "DOMAIN_JOIN_ERROR_LOGON_FAILURE"

	// FleetErrorCodeDomainJoinErrorInvalidParameter is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorInvalidParameter = "DOMAIN_JOIN_ERROR_INVALID_PARAMETER"

	// FleetErrorCodeDomainJoinErrorMoreData is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorMoreData = "DOMAIN_JOIN_ERROR_MORE_DATA"

	// FleetErrorCodeDomainJoinErrorNoSuchDomain is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorNoSuchDomain = "DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"

	// FleetErrorCodeDomainJoinErrorNotSupported is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorNotSupported = "DOMAIN_JOIN_ERROR_NOT_SUPPORTED"

	// FleetErrorCodeDomainJoinNerrInvalidWorkgroupName is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinNerrInvalidWorkgroupName = "DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"

	// FleetErrorCodeDomainJoinNerrWorkstationNotStarted is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinNerrWorkstationNotStarted = "DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"

	// FleetErrorCodeDomainJoinErrorDsMachineAccountQuotaExceeded is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorDsMachineAccountQuotaExceeded = "DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"

	// FleetErrorCodeDomainJoinNerrPasswordExpired is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinNerrPasswordExpired = "DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"

	// FleetErrorCodeDomainJoinInternalServiceError is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinInternalServiceError = "DOMAIN_JOIN_INTERNAL_SERVICE_ERROR"
)

// FleetErrorCode_Values returns all elements of the FleetErrorCode enum
func FleetErrorCode_Values() []string {
	return []string{
		FleetErrorCodeIamServiceRoleMissingEniDescribeAction,
		FleetErrorCodeIamServiceRoleMissingEniCreateAction,
		FleetErrorCodeIamServiceRoleMissingEniDeleteAction,
		FleetErrorCodeNetworkInterfaceLimitExceeded,
		FleetErrorCodeInternalServiceError,
		FleetErrorCodeIamServiceRoleIsMissing,
		FleetErrorCodeMachineRoleIsMissing,
		FleetErrorCodeStsDisabledInRegion,
		FleetErrorCodeSubnetHasInsufficientIpAddresses,
		FleetErrorCodeIamServiceRoleMissingDescribeSubnetAction,
		FleetErrorCodeSubnetNotFound,
		FleetErrorCodeImageNotFound,
		FleetErrorCodeInvalidSubnetConfiguration,
		FleetErrorCodeSecurityGroupsNotFound,
		FleetErrorCodeIgwNotAttached,
		FleetErrorCodeIamServiceRoleMissingDescribeSecurityGroupsAction,
		FleetErrorCodeFleetStopped,
		FleetErrorCodeFleetInstanceProvisioningFailure,
		FleetErrorCodeDomainJoinErrorFileNotFound,
		FleetErrorCodeDomainJoinErrorAccessDenied,
		FleetErrorCodeDomainJoinErrorLogonFailure,
		FleetErrorCodeDomainJoinErrorInvalidParameter,
		FleetErrorCodeDomainJoinErrorMoreData,
		FleetErrorCodeDomainJoinErrorNoSuchDomain,
		FleetErrorCodeDomainJoinErrorNotSupported,
		FleetErrorCodeDomainJoinNerrInvalidWorkgroupName,
		FleetErrorCodeDomainJoinNerrWorkstationNotStarted,
		FleetErrorCodeDomainJoinErrorDsMachineAccountQuotaExceeded,
		FleetErrorCodeDomainJoinNerrPasswordExpired,
		FleetErrorCodeDomainJoinInternalServiceError,
	}
}

const (
	// FleetStateStarting is a FleetState enum value
	FleetStateStarting = "STARTING"

	// FleetStateRunning is a FleetState enum value
	FleetStateRunning = "RUNNING"

	// FleetStateStopping is a FleetState enum value
	FleetStateStopping = "STOPPING"

	// FleetStateStopped is a FleetState enum value
	FleetStateStopped = "STOPPED"
)

// FleetState_Values returns all elements of the FleetState enum
func FleetState_Values() []string {
	return []string{
		FleetStateStarting,
		FleetStateRunning,
		FleetStateStopping,
		FleetStateStopped,
	}
}

const (
	// FleetTypeAlwaysOn is a FleetType enum value
	FleetTypeAlwaysOn = "ALWAYS_ON"

	// FleetTypeOnDemand is a FleetType enum value
	FleetTypeOnDemand = "ON_DEMAND"
)

// FleetType_Values returns all elements of the FleetType enum
func FleetType_Values() []string {
	return []string{
		FleetTypeAlwaysOn,
		FleetTypeOnDemand,
	}
}

const (
	// ImageBuilderStatePending is a ImageBuilderState enum value
	ImageBuilderStatePending = "PENDING"

	// ImageBuilderStateUpdatingAgent is a ImageBuilderState enum value
	ImageBuilderStateUpdatingAgent = "UPDATING_AGENT"

	// ImageBuilderStateRunning is a ImageBuilderState enum value
	ImageBuilderStateRunning = "RUNNING"

	// ImageBuilderStateStopping is a ImageBuilderState enum value
	ImageBuilderStateStopping = "STOPPING"

	// ImageBuilderStateStopped is a ImageBuilderState enum value
	ImageBuilderStateStopped = "STOPPED"

	// ImageBuilderStateRebooting is a ImageBuilderState enum value
	ImageBuilderStateRebooting = "REBOOTING"

	// ImageBuilderStateSnapshotting is a ImageBuilderState enum value
	ImageBuilderStateSnapshotting = "SNAPSHOTTING"

	// ImageBuilderStateDeleting is a ImageBuilderState enum value
	ImageBuilderStateDeleting = "DELETING"

	// ImageBuilderStateFailed is a ImageBuilderState enum value
	ImageBuilderStateFailed = "FAILED"
)

// ImageBuilderState_Values returns all elements of the ImageBuilderState enum
func ImageBuilderState_Values() []string {
	return []string{
		ImageBuilderStatePending,
		ImageBuilderStateUpdatingAgent,
		ImageBuilderStateRunning,
		ImageBuilderStateStopping,
		ImageBuilderStateStopped,
		ImageBuilderStateRebooting,
		ImageBuilderStateSnapshotting,
		ImageBuilderStateDeleting,
		ImageBuilderStateFailed,
	}
}

const (
	// ImageBuilderStateChangeReasonCodeInternalError is a ImageBuilderStateChangeReasonCode enum value
	ImageBuilderStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// ImageBuilderStateChangeReasonCodeImageUnavailable is a ImageBuilderStateChangeReasonCode enum value
	ImageBuilderStateChangeReasonCodeImageUnavailable = "IMAGE_UNAVAILABLE"
)

// ImageBuilderStateChangeReasonCode_Values returns all elements of the ImageBuilderStateChangeReasonCode enum
func ImageBuilderStateChangeReasonCode_Values() []string {
	return []string{
		ImageBuilderStateChangeReasonCodeInternalError,
		ImageBuilderStateChangeReasonCodeImageUnavailable,
	}
}

const (
	// ImageStatePending is a ImageState enum value
	ImageStatePending = "PENDING"

	// ImageStateAvailable is a ImageState enum value
	ImageStateAvailable = "AVAILABLE"

	// ImageStateFailed is a ImageState enum value
	ImageStateFailed = "FAILED"

	// ImageStateCopying is a ImageState enum value
	ImageStateCopying = "COPYING"

	// ImageStateDeleting is a ImageState enum value
	ImageStateDeleting = "DELETING"

	// ImageStateCreating is a ImageState enum value
	ImageStateCreating = "CREATING"

	// ImageStateImporting is a ImageState enum value
	ImageStateImporting = "IMPORTING"
)

// ImageState_Values returns all elements of the ImageState enum
func ImageState_Values() []string {
	return []string{
		ImageStatePending,
		ImageStateAvailable,
		ImageStateFailed,
		ImageStateCopying,
		ImageStateDeleting,
		ImageStateCreating,
		ImageStateImporting,
	}
}

const (
	// ImageStateChangeReasonCodeInternalError is a ImageStateChangeReasonCode enum value
	ImageStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// ImageStateChangeReasonCodeImageBuilderNotAvailable is a ImageStateChangeReasonCode enum value
	ImageStateChangeReasonCodeImageBuilderNotAvailable = "IMAGE_BUILDER_NOT_AVAILABLE"

	// ImageStateChangeReasonCodeImageCopyFailure is a ImageStateChangeReasonCode enum value
	ImageStateChangeReasonCodeImageCopyFailure = "IMAGE_COPY_FAILURE"
)

// ImageStateChangeReasonCode_Values returns all elements of the ImageStateChangeReasonCode enum
func ImageStateChangeReasonCode_Values() []string {
	return []string{
		ImageStateChangeReasonCodeInternalError,
		ImageStateChangeReasonCodeImageBuilderNotAvailable,
		ImageStateChangeReasonCodeImageCopyFailure,
	}
}

const (
	// MessageActionSuppress is a MessageAction enum value
	MessageActionSuppress = "SUPPRESS"

	// MessageActionResend is a MessageAction enum value
	MessageActionResend = "RESEND"
)

// MessageAction_Values returns all elements of the MessageAction enum
func MessageAction_Values() []string {
	return []string{
		MessageActionSuppress,
		MessageActionResend,
	}
}

const (
	// PermissionEnabled is a Permission enum value
	PermissionEnabled = "ENABLED"

	// PermissionDisabled is a Permission enum value
	PermissionDisabled = "DISABLED"
)

// Permission_Values returns all elements of the Permission enum
func Permission_Values() []string {
	return []string{
		PermissionEnabled,
		PermissionDisabled,
	}
}

const (
	// PlatformTypeWindows is a PlatformType enum value
	PlatformTypeWindows = "WINDOWS"

	// PlatformTypeWindowsServer2016 is a PlatformType enum value
	PlatformTypeWindowsServer2016 = "WINDOWS_SERVER_2016"

	// PlatformTypeWindowsServer2019 is a PlatformType enum value
	PlatformTypeWindowsServer2019 = "WINDOWS_SERVER_2019"
)

// PlatformType_Values returns all elements of the PlatformType enum
func PlatformType_Values() []string {
	return []string{
		PlatformTypeWindows,
		PlatformTypeWindowsServer2016,
		PlatformTypeWindowsServer2019,
	}
}

const (
	// SessionConnectionStateConnected is a SessionConnectionState enum value
	SessionConnectionStateConnected = "CONNECTED"

	// SessionConnectionStateNotConnected is a SessionConnectionState enum value
	SessionConnectionStateNotConnected = "NOT_CONNECTED"
)

// SessionConnectionState_Values returns all elements of the SessionConnectionState enum
func SessionConnectionState_Values() []string {
	return []string{
		SessionConnectionStateConnected,
		SessionConnectionStateNotConnected,
	}
}

// Possible values for the state of a streaming session.
const (
	// SessionStateActive is a SessionState enum value
	SessionStateActive = "ACTIVE"

	// SessionStatePending is a SessionState enum value
	SessionStatePending = "PENDING"

	// SessionStateExpired is a SessionState enum value
	SessionStateExpired = "EXPIRED"
)

// SessionState_Values returns all elements of the SessionState enum
func SessionState_Values() []string {
	return []string{
		SessionStateActive,
		SessionStatePending,
		SessionStateExpired,
	}
}

const (
	// StackAttributeStorageConnectors is a StackAttribute enum value
	StackAttributeStorageConnectors = "STORAGE_CONNECTORS"

	// StackAttributeStorageConnectorHomefolders is a StackAttribute enum value
	StackAttributeStorageConnectorHomefolders = "STORAGE_CONNECTOR_HOMEFOLDERS"

	// StackAttributeStorageConnectorGoogleDrive is a StackAttribute enum value
	StackAttributeStorageConnectorGoogleDrive = "STORAGE_CONNECTOR_GOOGLE_DRIVE"

	// StackAttributeStorageConnectorOneDrive is a StackAttribute enum value
	StackAttributeStorageConnectorOneDrive = "STORAGE_CONNECTOR_ONE_DRIVE"

	// StackAttributeRedirectUrl is a StackAttribute enum value
	StackAttributeRedirectUrl = "REDIRECT_URL"

	// StackAttributeFeedbackUrl is a StackAttribute enum value
	StackAttributeFeedbackUrl = "FEEDBACK_URL"

	// StackAttributeThemeName is a StackAttribute enum value
	StackAttributeThemeName = "THEME_NAME"

	// StackAttributeUserSettings is a StackAttribute enum value
	StackAttributeUserSettings = "USER_SETTINGS"

	// StackAttributeEmbedHostDomains is a StackAttribute enum value
	StackAttributeEmbedHostDomains = "EMBED_HOST_DOMAINS"

	// StackAttributeIamRoleArn is a StackAttribute enum value
	StackAttributeIamRoleArn = "IAM_ROLE_ARN"

	// StackAttributeAccessEndpoints is a StackAttribute enum value
	StackAttributeAccessEndpoints = "ACCESS_ENDPOINTS"
)

// StackAttribute_Values returns all elements of the StackAttribute enum
func StackAttribute_Values() []string {
	return []string{
		StackAttributeStorageConnectors,
		StackAttributeStorageConnectorHomefolders,
		StackAttributeStorageConnectorGoogleDrive,
		StackAttributeStorageConnectorOneDrive,
		StackAttributeRedirectUrl,
		StackAttributeFeedbackUrl,
		StackAttributeThemeName,
		StackAttributeUserSettings,
		StackAttributeEmbedHostDomains,
		StackAttributeIamRoleArn,
		StackAttributeAccessEndpoints,
	}
}

const (
	// StackErrorCodeStorageConnectorError is a StackErrorCode enum value
	StackErrorCodeStorageConnectorError = "STORAGE_CONNECTOR_ERROR"

	// StackErrorCodeInternalServiceError is a StackErrorCode enum value
	StackErrorCodeInternalServiceError = "INTERNAL_SERVICE_ERROR"
)

// StackErrorCode_Values returns all elements of the StackErrorCode enum
func StackErrorCode_Values() []string {
	return []string{
		StackErrorCodeStorageConnectorError,
		StackErrorCodeInternalServiceError,
	}
}

// The type of storage connector.
const (
	// StorageConnectorTypeHomefolders is a StorageConnectorType enum value
	StorageConnectorTypeHomefolders = "HOMEFOLDERS"

	// StorageConnectorTypeGoogleDrive is a StorageConnectorType enum value
	StorageConnectorTypeGoogleDrive = "GOOGLE_DRIVE"

	// StorageConnectorTypeOneDrive is a StorageConnectorType enum value
	StorageConnectorTypeOneDrive = "ONE_DRIVE"
)

// StorageConnectorType_Values returns all elements of the StorageConnectorType enum
func StorageConnectorType_Values() []string {
	return []string{
		StorageConnectorTypeHomefolders,
		StorageConnectorTypeGoogleDrive,
		StorageConnectorTypeOneDrive,
	}
}

const (
	// StreamViewApp is a StreamView enum value
	StreamViewApp = "APP"

	// StreamViewDesktop is a StreamView enum value
	StreamViewDesktop = "DESKTOP"
)

// StreamView_Values returns all elements of the StreamView enum
func StreamView_Values() []string {
	return []string{
		StreamViewApp,
		StreamViewDesktop,
	}
}

const (
	// UsageReportExecutionErrorCodeResourceNotFound is a UsageReportExecutionErrorCode enum value
	UsageReportExecutionErrorCodeResourceNotFound = "RESOURCE_NOT_FOUND"

	// UsageReportExecutionErrorCodeAccessDenied is a UsageReportExecutionErrorCode enum value
	UsageReportExecutionErrorCodeAccessDenied = "ACCESS_DENIED"

	// UsageReportExecutionErrorCodeInternalServiceError is a UsageReportExecutionErrorCode enum value
	UsageReportExecutionErrorCodeInternalServiceError = "INTERNAL_SERVICE_ERROR"
)

// UsageReportExecutionErrorCode_Values returns all elements of the UsageReportExecutionErrorCode enum
func UsageReportExecutionErrorCode_Values() []string {
	return []string{
		UsageReportExecutionErrorCodeResourceNotFound,
		UsageReportExecutionErrorCodeAccessDenied,
		UsageReportExecutionErrorCodeInternalServiceError,
	}
}

const (
	// UsageReportScheduleDaily is a UsageReportSchedule enum value
	UsageReportScheduleDaily = "DAILY"
)

// UsageReportSchedule_Values returns all elements of the UsageReportSchedule enum
func UsageReportSchedule_Values() []string {
	return []string{
		UsageReportScheduleDaily,
	}
}

const (
	// UserStackAssociationErrorCodeStackNotFound is a UserStackAssociationErrorCode enum value
	UserStackAssociationErrorCodeStackNotFound = "STACK_NOT_FOUND"

	// UserStackAssociationErrorCodeUserNameNotFound is a UserStackAssociationErrorCode enum value
	UserStackAssociationErrorCodeUserNameNotFound = "USER_NAME_NOT_FOUND"

	// UserStackAssociationErrorCodeDirectoryNotFound is a UserStackAssociationErrorCode enum value
	UserStackAssociationErrorCodeDirectoryNotFound = "DIRECTORY_NOT_FOUND"

	// UserStackAssociationErrorCodeInternalError is a UserStackAssociationErrorCode enum value
	UserStackAssociationErrorCodeInternalError = "INTERNAL_ERROR"
)

// UserStackAssociationErrorCode_Values returns all elements of the UserStackAssociationErrorCode enum
func UserStackAssociationErrorCode_Values() []string {
	return []string{
		UserStackAssociationErrorCodeStackNotFound,
		UserStackAssociationErrorCodeUserNameNotFound,
		UserStackAssociationErrorCodeDirectoryNotFound,
		UserStackAssociationErrorCodeInternalError,
	}
}

const (
	// VisibilityTypePublic is a VisibilityType enum value
	VisibilityTypePublic = "PUBLIC"

	// VisibilityTypePrivate is a VisibilityType enum value
	VisibilityTypePrivate = "PRIVATE"

	// VisibilityTypeShared is a VisibilityType enum value
	VisibilityTypeShared = "SHARED"
)

// VisibilityType_Values returns all elements of the VisibilityType enum
func VisibilityType_Values() []string {
	return []string{
		VisibilityTypePublic,
		VisibilityTypePrivate,
		VisibilityTypeShared,
	}
}
