#include "proof/proof-type.h"

Tproof_type_desc ps_type_desc[PS_TYPE_MAX + 2] = {
	{ NULL, NULL, 0, 0 },
	{ "assume", "{asserted formula}", 0, 0 },
	{ "true", "valid: {true}", 0, 0 },
	{ "false", "valid: {(not false)}", 0, 0 },
	{ "not_not", "valid: {(not not not a) a}", 0, 0 },
	{ "and_pos", "valid: {(not (and a_1 ... a_n)) a_i}", 0, 1 },
	{ "and_neg", "valid: {(and a_1 ... a_n) (not a_1) ... (not a_n)}", 0, 0 },
	{ "or_pos", "valid: {(not (or a_1 ... a_n)) a_1 ... a_n}", 0, 0 },
	{ "or_neg", "valid: {(or a_1 ... a_n) (not a_i)}", 0, 1 },
	{ "xor_pos1", "valid: {(not (xor a b)) a b}", 0, 0 },
	{ "xor_pos2", "valid: {(not (xor a b)) (not a) (not b)}", 0, 0 },
	{ "xor_neg1", "valid: {(xor a b) a (not b)}", 0, 0 },
	{ "xor_neg2", "valid: {(xor a b) (not a) b}", 0, 0 },
	{ "implies_pos", "valid: {(not (implies a b)) (not a) b}", 0, 0 },
	{ "implies_neg1", "valid: {(implies a b) a}", 0, 0 },
	{ "implies_neg2", "valid: {(implies a b) (not b)}", 0, 0 },
	{ "equiv_pos1", "valid: {(not (iff a b)) a (not b)}", 0, 0 },
	{ "equiv_pos2", "valid: {(not (iff a b)) (not a) b}", 0, 0 },
	{ "equiv_neg1", "valid: {(iff a b) (not a) (not b)}", 0, 0 },
	{ "equiv_neg2", "valid: {(iff a b) a b}", 0, 0 },
	{ "ite_pos1", "valid: {(not (if_then_else a b c)) a c}", 0, 0 },
	{ "ite_pos2", "valid: {(not (if_then_else a b c)) (not a) b}", 0, 0 },
	{ "ite_neg1", "valid: {(if_then_else a b c) a (not c)}", 0, 0 },
	{ "ite_neg2", "valid: {(if_then_else a b c) (not a) (not b)}", 0, 0 },
	{ "eq_reflexive", "valid: {(= x x)}", 0, 0 },
	{ "eq_transitive",
		"valid: {(not (= x_1 x_2)) ... (not (= x_{n-1} x_n)) (= x_1 x_n)}", 0, 0 },
	{ "eq_congruent",
		"valid: {(not (= x_1 y_1)) ... (not (= x_n y_n)) (= (f x_1 ... x_n) (f y_1 ... y_n))}",
		0, 0 },
	{ "eq_congruent_pred",
		"valid: {(not (= x_1 y_1)) ... (not (= x_n y_n)) (not (p x_1 ... x_n)) (p y_1 ... y_n)}",
		0, 0 },
	{ "distinct_elim", "valid: {(= (distinct ...) ... neq ...)}", 0, 0 },
	{ "la_rw_eq", "valid: {(= (a = b) (and (a <= b) (b <= a))}", 0, 0 },
	{ "la_generic", "valid: not yet defined", 0, 0 },
	{ "lia_generic", "valid: not yet defined", 0, 0 },
	{ "la_disequality", "valid {(or (= a b) (not (<= a b)) (not (<= b a)))}", 0, 0 },
	{ "la_totality", "valid: {(le t1 t2) (le t2 t1)}", 0, 0 },
	{ "la_tautology", "valid: linear arithmetic tautology without variable", 0,
		0 },
	{ "forall_inst", "valid: {(implies (forall X (A X)) (A {X \\ t}))}", 0, 0 },
	{ "qnt_join", "valid: {(equiv (Q x (Q y (F x y))) (Q x y (F x y)))}", 0, 0 },
	{ "qnt_rm_unused", "valid: {(equiv (Q x y (F x))) (Q x (F x)))}", 0, 0 },
	{ "th_resolution", "resolution of 2 or more clauses from theory reasoner", -1,
		0 },
	{ "resolution", "resolution of 2 or more clauses from SAT solver", -1, 0 },
	{ "refl", "", -1, 0 },
	{ "trans", "", -1, 0 },
	{ "cong", "replacement of 2 or more subformulas for their equivalents", -1,
		0 },
	{ "and", "{(and a_1 ... a_n)} --> {a_i}", 1, 1 },
	{ "tautology", "{(a_1 ... a_i ... (not a_i) ... a_n)} --> {True}", 1, 0},
	{ "not_or", "{(not (or a_1 ... a_n))} --> {(not a_i)}", 1, 1 },
	{ "or", "{(or a_1 ... a_n)} --> {a_1 ... a_n}", 1, 0 },
	{ "not_and", "{(not (and a_1 ... a_n))} --> {(not a_1) ... (not a_n)}", 1,
		0 },
	{ "xor1", "{(xor a b)} --> {a b}", 1, 0 },
	{ "xor2", "{(xor a b)} --> {(not a) (not b)}", 1, 0 },
	{ "not_xor1", "{(not (xor a b))} --> {a (not b)}", 1, 0 },
	{ "not_xor2", "{(not (xor a b))} --> {(not a) b}", 1, 0 },
	{ "implies", "{(implies a b)} --> {(not a) b}", 1, 0 },
	{ "not_implies1", "{(not (implies a b))} --> {a}", 1, 0 },
	{ "not_implies2", "{(not (implies a b))} --> {(not b)}", 1, 0 },
	{ "equiv1", "{(iff a b)} --> {(not a) b}", 1, 0 },
	{ "equiv2", "{(iff a b)} --> {a (not b)}", 1, 0 },
	{ "not_equiv1", "{(not (iff a b))} --> {a b}", 1, 0 },
	{ "not_equiv2", "{(not (iff a b))} --> {(not a) (not b)}", 1, 0 },
	{ "ite1", "{(if_then_else a b c)} --> {a c}", 1, 0 },
	{ "ite2", "{(if_then_else a b c)} --> {(not a) b}", 1, 0 },
	{ "not_ite1", "{(not (if_then_else a b c))} --> {a (not c)}", 1, 0 },
	{ "not_ite2", "{(not (if_then_else a b c))} --> {(not a) (not b)}", 1, 0 },
	{ "ite_intro", "{(equiv formula (and formula (ite_def_1 ... ite_def_n)))}", 0,
		0 },
	{ "contraction", "clause --> clause with duplicated literals removed", 1, 0},
	{ "connective_def", "TODO", -1, 0 },
	{ "ite_simplify", "TODO", -1, 0 },
	{ "eq_simplify", "TODO", -1, 0 },
	{ "and_simplify", "TODO", -1, 0 },
	{ "or_simplify", "TODO", -1, 0 },
	{ "not_simplify", "TODO", -1, 0 },
	{ "implies_simplify", "TODO", -1, 0 },
	{ "equiv_simplify", "TODO", -1, 0 },
	{ "bool_simplify", "TODO", -1, 0 },
	{ "qnt_simplify", "TODO", -1, 0 },
	{ "div_simplify", "TODO", -1, 0 },
	{ "prod_simplify", "TODO", -1, 0 },
	{ "unary_minus_simplify", "TODO", -1, 0 },
	{ "minus_simplify", "TODO", -1, 0 },
	{ "sum_simplify", "TODO", -1, 0 },
	{ "comp_simplify", "TODO", -1, 0 },
	{ "nary_elim", "TODO", -1, 0 },
	{ "ac_simp", "logic equivalence", -1, 0 },
	{ "bfun_elim",
		"{formula} --> {formula where functions with Boolean arguments have been simplified}",
		1, 0 },
	{ "deep_skolemize", "{formula} --> {Skolemized formula}", 1, 0 },
	{ "qnt_cnf", "{(or (not forall x_1...x_n P) forall x_1...x_m P')} m>=n with P' a clause from the CNF of P", 0, 0 },

	/* Proof rules containing subproofs */
	{ "subproof", "", 0, 0 },

	/* Proof rules containing subproofs and might change the context */
	{ "bind", "", 0, 0 },
	{ "let", "valid: {(= (let (... (s_i t_i) ...) t) (t[s_i |-> t_i]))}", -1, 0 },
	{ "onepoint", "valid: to be defined", -1, 0 },
	{ "sko_ex", "", 0, 0 },
	{ "sko_forall", "", 0, 0 },

	{ NULL, NULL, 0, 0 }
};
