// Code generated by Wire. DO NOT EDIT.

//go:generate wire
//+build !wireinject

package main

import (
	"github.com/drone/drone/cmd/drone-server/config"
	"github.com/drone/drone/handler/api"
	"github.com/drone/drone/handler/web"
	"github.com/drone/drone/livelog"
	"github.com/drone/drone/operator/manager"
	"github.com/drone/drone/pubsub"
	"github.com/drone/drone/service/canceler"
	"github.com/drone/drone/service/commit"
	"github.com/drone/drone/service/hook/parser"
	"github.com/drone/drone/service/license"
	"github.com/drone/drone/service/linker"
	"github.com/drone/drone/service/token"
	"github.com/drone/drone/service/transfer"
	"github.com/drone/drone/service/user"
	"github.com/drone/drone/store/card"
	"github.com/drone/drone/store/cron"
	"github.com/drone/drone/store/perm"
	"github.com/drone/drone/store/secret"
	"github.com/drone/drone/store/secret/global"
	"github.com/drone/drone/store/step"
	"github.com/drone/drone/store/template"
	"github.com/drone/drone/trigger"
	cron2 "github.com/drone/drone/trigger/cron"
)

import (
	_ "github.com/go-sql-driver/mysql"
	_ "github.com/lib/pq"
	_ "github.com/mattn/go-sqlite3"
)

// Injectors from wire.go:

func InitializeApplication(config2 config.Config) (application, error) {
	client := provideClient(config2)
	refresher := provideRefresher(config2)
	db, err := provideDatabase(config2)
	if err != nil {
		return application{}, err
	}
	encrypter, err := provideEncrypter(config2)
	if err != nil {
		return application{}, err
	}
	userStore := provideUserStore(db, encrypter, config2)
	renewer := token.Renewer(refresher, userStore)
	commitService := commit.New(client, renewer)
	cronStore := cron.New(db)
	repositoryStore := provideRepoStore(db)
	buildStore := provideBuildStore(db)
	redisDB, err := provideRedisClient(config2)
	if err != nil {
		return application{}, err
	}
	corePubsub := pubsub.New(redisDB)
	stageStore := provideStageStore(db)
	scheduler := provideScheduler(stageStore, redisDB)
	statusService := provideStatusService(client, renewer, config2)
	stepStore := step.New(db)
	system := provideSystem(config2)
	webhookSender := provideWebhookPlugin(config2, system)
	coreCanceler := canceler.New(buildStore, corePubsub, repositoryStore, scheduler, stageStore, statusService, stepStore, userStore, webhookSender)
	fileService := provideContentService(client, renewer)
	configService := provideConfigPlugin(client, fileService, config2)
	templateStore := template.New(db)
	convertService := provideConvertPlugin(client, fileService, config2, templateStore)
	validateService := provideValidatePlugin(config2)
	triggerer := trigger.New(coreCanceler, configService, convertService, commitService, statusService, buildStore, scheduler, repositoryStore, userStore, validateService, webhookSender)
	cronScheduler := cron2.New(commitService, cronStore, repositoryStore, userStore, triggerer)
	reaper := provideReaper(repositoryStore, buildStore, stageStore, coreCanceler, config2)
	coreLicense := provideLicense(client, config2)
	datadog := provideDatadog(userStore, repositoryStore, buildStore, system, coreLicense, config2)
	cardStore := card.New(db)
	logStore := provideLogStore(db, config2)
	logStream := livelog.New(redisDB)
	netrcService := provideNetrcService(client, renewer, config2)
	secretStore := secret.New(db, encrypter)
	globalSecretStore := global.New(db, encrypter)
	buildManager := manager.New(buildStore, cardStore, configService, convertService, corePubsub, logStore, logStream, netrcService, repositoryStore, scheduler, secretStore, globalSecretStore, statusService, stageStore, stepStore, system, userStore, webhookSender)
	secretService := provideSecretPlugin(config2)
	registryService := provideRegistryPlugin(config2)
	runner := provideRunner(buildManager, secretService, registryService, config2)
	hookService := provideHookService(client, renewer, config2)
	licenseService := license.NewService(userStore, repositoryStore, buildStore, coreLicense)
	organizationService := provideOrgService(client, renewer)
	permStore := perm.New(db)
	repositoryService := provideRepositoryService(client, renewer, config2)
	session, err := provideSession(userStore, config2)
	if err != nil {
		return application{}, err
	}
	batcher := provideBatchStore(db, config2)
	syncer := provideSyncer(repositoryService, repositoryStore, userStore, batcher, config2)
	transferer := transfer.New(repositoryStore, permStore)
	userService := user.New(client, renewer)
	server := api.New(buildStore, commitService, cardStore, cronStore, corePubsub, globalSecretStore, hookService, logStore, coreLicense, licenseService, organizationService, permStore, repositoryStore, repositoryService, scheduler, secretStore, stageStore, stepStore, statusService, session, logStream, syncer, system, templateStore, transferer, triggerer, userStore, userService, webhookSender)
	admissionService := provideAdmissionPlugin(client, organizationService, userService, config2)
	hookParser := parser.New(client)
	coreLinker := linker.New(client)
	middleware := provideLogin(config2)
	options := provideServerOptions(config2)
	webServer := web.New(admissionService, buildStore, client, hookParser, coreLicense, licenseService, coreLinker, middleware, repositoryStore, session, syncer, triggerer, userStore, userService, webhookSender, options, system)
	mainRpcHandlerV1 := provideRPC(buildManager, config2)
	mainRpcHandlerV2 := provideRPC2(buildManager, config2)
	mainHealthzHandler := provideHealthz()
	metricServer := provideMetric(session, config2)
	mainPprofHandler := providePprof(config2)
	mux := provideRouter(server, webServer, mainRpcHandlerV1, mainRpcHandlerV2, mainHealthzHandler, metricServer, mainPprofHandler)
	serverServer := provideServer(mux, config2)
	mainApplication := newApplication(cronScheduler, reaper, datadog, runner, serverServer, userStore)
	return mainApplication, nil
}
