/* gkrellm-bluez - A BlueZ monitor plug-in for GKrellM2
 *
 * Copyright (C) 2006 Ludovic Cintrat <lcintrat@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __GKRELLM_BLUEZ_H__
#define __GKRELLM_BLUEZ_H__


#include <gkrellm2/gkrellm.h>

#define GKRELLM_BLUEZ_PLUGIN_NAME    "gkrellm-bluez"            /*  messages            */
#define GKRELLM_BLUEZ_PLUGIN_KEYWORD GKRELLM_BLUEZ_PLUGIN_NAME  /*  configuration file  */

/* Units */
#define KILO                 1024
#define MEGA                (1024*1024)
#define GIGA                (1024*1024*1024)

#define MAX_BITRATE         (64*KILO) /* per second */

typedef struct {
  GkrellmChart       *chart;
  GkrellmChartconfig *config;
  GkrellmChartdata   *rx_data;
  GkrellmChartdata   *tx_data;

  GkrellmDecal	     *rxled, *txled;

  GkrellmKrell       *krell;

  GkrellmLauncher     launcher;
  GtkWidget          *command_entry;
  GtkWidget          *tooltip_entry;

  GkrellmAlert       *alert;
  GtkWidget          *alert_button;

  gboolean            enabled; /* user wants to show interface */
  GtkWidget          *enable_button;

  gboolean            forced;
  GtkWidget          *force_button;

  gboolean            hide_text;

  gboolean            present; /* interface is present */
  gboolean            updated; /* data from interface are successfully updated */

  gchar              *interface; /* e.g "hci0" */
  gint16              devid;

  guint32             rx_bytes, rx_bytes_old;
  guint32             tx_bytes, tx_bytes_old;

  gint16              connections;

} GkrellmBlueZMonitor;


extern GkrellmMonitor *gkrellm_bluez;
extern gint            gkrellm_bluez_style_id;

extern gchar          *gkrellm_bluez_format_string;

extern GList          *gkrellm_bluez_monitor_list;

#endif  /*  __GKRELLM_BLUEZ_H__  */
